/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.os.Build;
import android.os.Bundle;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidWallpaperListener;
import com.badlogic.gdx.utils.GdxNativesLoader;

@BA.Hide
public abstract class AndroidLiveWallpaperService
extends WallpaperService {
    public static boolean DEBUG;
    public static volatile AndroidLiveWallpaper app;
    protected SurfaceHolder.Callback view = null;
    protected int viewFormat;
    protected int viewWidth;
    protected int viewHeight;
    protected int engines = 0;
    protected int visibleEngines = 0;
    protected volatile AndroidWallpaperEngine linkedEngine = null;
    protected volatile boolean isPreviewNotified = false;
    protected volatile boolean notifiedPreviewState = false;
    volatile int[] d = new int[0];
    private boolean a = false;

    static {
        GdxNativesLoader.load();
        DEBUG = false;
        app = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLinkedEngine(AndroidWallpaperEngine linkedEngine) {
        int[] nArray = this.d;
        synchronized (this.d) {
            this.linkedEngine = linkedEngine;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void onCreate() {
        String string;
        if (DEBUG) {
            string = " > AndroidLiveWallpaperService - onCreate() " + ((Object)((Object)this)).hashCode();
            Log.d((String)"WallpaperService", (String)string);
            BA.Log((String)string);
        }
        string = "service created";
        Log.i((String)"WallpaperService", (String)string);
        BA.Log((String)string);
        super.onCreate();
    }

    public WallpaperService.Engine onCreateEngine() {
        String string;
        if (DEBUG) {
            string = " > AndroidLiveWallpaperService - onCreateEngine()";
            Log.d((String)"WallpaperService", (String)string);
            BA.Log((String)string);
        }
        string = "engine created";
        Log.i((String)"WallpaperService", (String)string);
        BA.Log((String)string);
        return new AndroidWallpaperEngine(this);
    }

    public void onCreateApplication() {
        if (DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaperService - onCreateApplication()");
            BA.Log((String)" > AndroidLiveWallpaperService - onCreateApplication()");
        }
    }

    public void initialize(BA ba, ApplicationListener listener) {
        AndroidApplicationConfiguration androidApplicationConfiguration = new AndroidApplicationConfiguration();
        this.initialize(ba, listener, androidApplicationConfiguration);
    }

    public void initialize(BA ba, ApplicationListener listener, AndroidApplicationConfiguration config) {
        if (DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaperService - initialize()");
            BA.Log((String)" > AndroidLiveWallpaperService - initialize()");
        }
        app.initialize(ba, listener, config);
        if (config.getTouchEventsForLiveWallpaper && Integer.parseInt(Build.VERSION.SDK) >= 7) {
            this.a = true;
            this.linkedEngine.setTouchEventsEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceHolder getSurfaceHolder() {
        if (DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaperService - getSurfaceHolder()");
            BA.Log((String)" > AndroidLiveWallpaperService - getSurfaceHolder()");
        }
        int[] nArray = this.d;
        synchronized (this.d) {
            block5: {
                if (this.linkedEngine != null) break block5;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.linkedEngine.getSurfaceHolder();
        }
    }

    public void onDeepPauseApplication() {
        if (DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaperService - onDeepPauseApplication()");
            BA.Log((String)" > AndroidLiveWallpaperService - onDeepPauseApplication()");
        }
        if (app != null) {
            AndroidLiveWallpaperService.app.graphics.clearManagedCaches();
        }
    }

    public void onDestroy() {
        String string;
        if (DEBUG) {
            string = " > AndroidLiveWallpaperService - onDestroy() " + ((Object)((Object)this)).hashCode();
            Log.d((String)"WallpaperService", (String)string);
            BA.Log((String)string);
        }
        string = "service destroyed";
        Log.i((String)"WallpaperService", (String)string);
        BA.Log((String)string);
        super.onDestroy();
        if (app != null) {
            app.onDestroy();
            app = null;
            this.view = null;
        }
    }

    protected void finalize() throws Throwable {
        Log.i((String)"WallpaperService", (String)"service finalized");
        BA.Log((String)"service finalized");
        super.finalize();
    }

    public AndroidLiveWallpaper getLiveWallpaper() {
        return app;
    }

    public WindowManager getWindowManager() {
        return (WindowManager)this.getSystemService("window");
    }

    @BA.Hide
    public class AndroidWallpaperEngine
    extends WallpaperService.Engine {
        protected boolean engineIsVisible;
        protected int engineFormat;
        protected int engineWidth;
        protected int engineHeight;
        private boolean g;
        float a;
        float b;
        float c;
        float d;
        int e;
        int f;
        private /* synthetic */ AndroidLiveWallpaperService h;

        public AndroidWallpaperEngine(AndroidLiveWallpaperService androidLiveWallpaperService) {
            this.h = androidLiveWallpaperService;
            super((WallpaperService)androidLiveWallpaperService);
            this.engineIsVisible = false;
            this.g = true;
            this.a = 0.0f;
            this.b = 0.0f;
            this.c = 0.0f;
            this.d = 0.0f;
            this.e = 0;
            this.f = 0;
            if (DEBUG) {
                String string = " > AndroidWallpaperEngine() " + ((Object)((Object)this)).hashCode();
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            if (DEBUG) {
                String string = " > AndroidWallpaperEngine - onCreate() " + ((Object)((Object)this)).hashCode() + " running: " + this.h.engines + ", linked: " + (this.h.linkedEngine == this) + ", thread: " + Thread.currentThread().toString();
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            super.onCreate(surfaceHolder);
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            String string;
            ++this.h.engines;
            this.h.setLinkedEngine(this);
            if (DEBUG) {
                string = " > AndroidWallpaperEngine - onSurfaceCreated() " + ((Object)((Object)this)).hashCode() + ", running: " + this.h.engines + ", linked: " + (this.h.linkedEngine == this);
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            string = "engine surface created";
            Log.i((String)"WallpaperService", (String)string);
            BA.Log((String)string);
            super.onSurfaceCreated(holder);
            if (this.h.engines == 1) {
                this.h.visibleEngines = 0;
            }
            if (this.h.engines == 1 && app == null) {
                this.h.viewFormat = 0;
                this.h.viewWidth = 0;
                this.h.viewHeight = 0;
                app = new AndroidLiveWallpaper(this.h);
                this.h.onCreateApplication();
                if (AndroidLiveWallpaperService.app.graphics == null) {
                    throw new Error("You must override 'AndroidLiveWallpaperService.onCreateApplication' method and call 'initialize' from its body.");
                }
            }
            this.h.view = (SurfaceHolder.Callback)AndroidLiveWallpaperService.app.graphics.b;
            this.getSurfaceHolder().removeCallback(this.h.view);
            this.engineFormat = this.h.viewFormat;
            this.engineWidth = this.h.viewWidth;
            this.engineHeight = this.h.viewHeight;
            if (this.h.engines == 1) {
                this.h.view.surfaceCreated(holder);
            } else {
                this.h.view.surfaceDestroyed(holder);
                AndroidWallpaperEngine androidWallpaperEngine = this;
                androidWallpaperEngine.a(androidWallpaperEngine.engineFormat, this.engineWidth, this.engineHeight, false);
                this.h.view.surfaceCreated(holder);
            }
            this.notifyPreviewState();
            this.notifyOffsetsChanged();
            if (!Gdx.graphics.isContinuousRendering()) {
                Gdx.graphics.requestRendering();
            }
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            String string;
            if (DEBUG) {
                string = " > AndroidWallpaperEngine - onSurfaceChanged() isPreview: " + this.isPreview() + ", " + ((Object)((Object)this)).hashCode() + ", running: " + this.h.engines + ", linked: " + (this.h.linkedEngine == this) + ", sufcace valid: " + this.getSurfaceHolder().getSurface().isValid();
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            string = "engine surface changed";
            Log.i((String)"WallpaperService", (String)string);
            BA.Log((String)string);
            super.onSurfaceChanged(holder, format, width, height);
            this.a(format, width, height, true);
        }

        private void a(int n, int n2, int n3, boolean bl) {
            if (!bl && n == this.h.viewFormat && n2 == this.h.viewWidth && n3 == this.h.viewHeight) {
                if (DEBUG) {
                    Log.d((String)"WallpaperService", (String)" > surface is current, skipping surfaceChanged event");
                    BA.Log((String)" > surface is current, skipping surfaceChanged event");
                    return;
                }
            } else {
                this.engineFormat = n;
                this.engineWidth = n2;
                this.engineHeight = n3;
                if (this.h.linkedEngine == this) {
                    this.h.viewFormat = this.engineFormat;
                    this.h.viewWidth = this.engineWidth;
                    this.h.viewHeight = this.engineHeight;
                    this.h.view.surfaceChanged(this.getSurfaceHolder(), this.h.viewFormat, this.h.viewWidth, this.h.viewHeight);
                    return;
                }
                if (DEBUG) {
                    Log.d((String)"WallpaperService", (String)" > engine is not active, skipping surfaceChanged event");
                    BA.Log((String)" > engine is not active, skipping surfaceChanged event");
                }
            }
        }

        public void onVisibilityChanged(boolean visible) {
            boolean bl = this.isVisible();
            if (DEBUG) {
                String string = " > AndroidWallpaperEngine - onVisibilityChanged(paramVisible: " + visible + " reportedVisible: " + bl + ") " + ((Object)((Object)this)).hashCode() + ", sufcace valid: " + this.getSurfaceHolder().getSurface().isValid();
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            super.onVisibilityChanged(visible);
            if (!bl && visible) {
                if (DEBUG) {
                    Log.d((String)"WallpaperService", (String)" > fake visibilityChanged event! Android WallpaperService likes do that!");
                    BA.Log((String)" > fake visibilityChanged event! Android WallpaperService likes do that!");
                }
                return;
            }
            AndroidWallpaperEngine androidWallpaperEngine = this;
            if (androidWallpaperEngine.engineIsVisible != visible) {
                androidWallpaperEngine.engineIsVisible = visible;
                if (androidWallpaperEngine.engineIsVisible) {
                    androidWallpaperEngine.onResume();
                    return;
                }
                androidWallpaperEngine.onPause();
                return;
            }
            if (DEBUG) {
                Log.d((String)"WallpaperService", (String)" > visible state is current, skipping visibilityChanged event!");
                BA.Log((String)" > visible state is current, skipping visibilityChanged event!");
            }
        }

        public void onResume() {
            String string;
            ++this.h.visibleEngines;
            if (DEBUG) {
                string = " > AndroidWallpaperEngine - onResume() " + ((Object)((Object)this)).hashCode() + ", running: " + this.h.engines + ", linked: " + (this.h.linkedEngine == this) + ", visible: " + this.h.visibleEngines;
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            string = "engine resumed";
            Log.i((String)"WallpaperService", (String)string);
            BA.Log((String)string);
            if (this.h.linkedEngine != null) {
                if (this.h.linkedEngine != this) {
                    this.h.setLinkedEngine(this);
                    this.h.view.surfaceDestroyed(this.getSurfaceHolder());
                    AndroidWallpaperEngine androidWallpaperEngine = this;
                    androidWallpaperEngine.a(androidWallpaperEngine.engineFormat, this.engineWidth, this.engineHeight, false);
                    this.h.view.surfaceCreated(this.getSurfaceHolder());
                } else {
                    AndroidWallpaperEngine androidWallpaperEngine = this;
                    androidWallpaperEngine.a(androidWallpaperEngine.engineFormat, this.engineWidth, this.engineHeight, false);
                }
                if (this.h.visibleEngines == 1) {
                    app.onResume();
                }
                this.notifyPreviewState();
                this.notifyOffsetsChanged();
                if (!Gdx.graphics.isContinuousRendering()) {
                    Gdx.graphics.requestRendering();
                }
            }
        }

        public void onPause() {
            String string;
            --this.h.visibleEngines;
            if (DEBUG) {
                string = " > AndroidWallpaperEngine - onPause() " + ((Object)((Object)this)).hashCode() + ", running: " + this.h.engines + ", linked: " + (this.h.linkedEngine == this) + ", visible: " + this.h.visibleEngines;
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            string = "engine paused";
            Log.i((String)"WallpaperService", (String)string);
            BA.Log((String)string);
            if (this.h.visibleEngines >= this.h.engines) {
                string = "wallpaper lifecycle error, counted too many visible engines! repairing...";
                Log.e((String)"WallpaperService", (String)string);
                BA.Log((String)string);
                this.h.visibleEngines = Math.max(this.h.engines - 1, 0);
            }
            if (this.h.linkedEngine != null && this.h.visibleEngines == 0) {
                app.onPause();
            }
            if (DEBUG) {
                string = " > AndroidWallpaperEngine - onPause() done!";
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            String string;
            --this.h.engines;
            if (DEBUG) {
                string = " > AndroidWallpaperEngine - onSurfaceDestroyed() " + ((Object)((Object)this)).hashCode() + ", running: " + this.h.engines + " ,linked: " + (this.h.linkedEngine == this) + ", isVisible: " + this.engineIsVisible;
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            string = "engine surface destroyed";
            Log.i((String)"WallpaperService", (String)string);
            BA.Log((String)string);
            if (this.h.engines == 0) {
                this.h.onDeepPauseApplication();
            }
            if (this.h.linkedEngine == this && this.h.view != null) {
                this.h.view.surfaceDestroyed(holder);
            }
            this.engineFormat = 0;
            this.engineWidth = 0;
            this.engineHeight = 0;
            if (this.h.engines == 0) {
                this.h.linkedEngine = null;
            }
            super.onSurfaceDestroyed(holder);
        }

        public void onDestroy() {
            super.onDestroy();
        }

        public Bundle onCommand(String pAction, int pX, int pY, int pZ, Bundle pExtras, boolean pResultRequested) {
            if (DEBUG) {
                String string = " > AndroidWallpaperEngine - onCommand(" + pAction + " " + pX + " " + pY + " " + pZ + " " + pExtras + " " + pResultRequested + "), linked: " + (this.h.linkedEngine == this);
                Log.d((String)"WallpaperService", (String)string);
                BA.Log((String)string);
            }
            return super.onCommand(pAction, pX, pY, pZ, pExtras, pResultRequested);
        }

        public void onTouchEvent(MotionEvent event) {
            if (this.h.linkedEngine == this && this.h.a) {
                AndroidLiveWallpaperService.app.input.onTouch(null, event);
            }
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
            this.g = false;
            this.a = xOffset;
            this.b = yOffset;
            this.c = xOffsetStep;
            this.d = yOffsetStep;
            this.e = xPixelOffset;
            this.f = yPixelOffset;
            this.notifyOffsetsChanged();
            if (!Gdx.graphics.isContinuousRendering()) {
                Gdx.graphics.requestRendering();
            }
            super.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixelOffset, yPixelOffset);
        }

        protected void notifyOffsetsChanged() {
            if (this.h.linkedEngine == this && AndroidLiveWallpaperService.app.listener instanceof AndroidWallpaperListener && !this.g) {
                this.g = true;
                app.postRunnable(new Runnable(this){
                    private /* synthetic */ AndroidWallpaperEngine a;
                    {
                        this.a = androidWallpaperEngine;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public final void run() {
                        int[] nArray = ((AndroidWallpaperEngine)this.a).h.d;
                        synchronized (((AndroidWallpaperEngine)this.a).h.d) {
                            boolean bl = ((AndroidWallpaperEngine)this.a).h.linkedEngine == this.a;
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            if (bl) {
                                ((AndroidWallpaperListener)((Object)AndroidLiveWallpaperService.app.listener)).offsetChange(this.a.a, this.a.b, this.a.c, this.a.d, this.a.e, this.a.f);
                            }
                            return;
                        }
                    }
                });
            }
        }

        protected void notifyPreviewState() {
            if (this.h.linkedEngine == this && AndroidLiveWallpaperService.app.listener instanceof AndroidWallpaperListener) {
                boolean bl = this.h.linkedEngine.isPreview();
                app.postRunnable(new Runnable(this, bl){
                    private /* synthetic */ AndroidWallpaperEngine a;
                    private final /* synthetic */ boolean b;
                    {
                        this.a = androidWallpaperEngine;
                        this.b = bl;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public final void run() {
                        boolean bl = false;
                        Object object = ((AndroidWallpaperEngine)this.a).h.d;
                        synchronized (((AndroidWallpaperEngine)this.a).h.d) {
                            if (!((AndroidWallpaperEngine)this.a).h.isPreviewNotified || ((AndroidWallpaperEngine)this.a).h.notifiedPreviewState != this.b) {
                                ((AndroidWallpaperEngine)this.a).h.notifiedPreviewState = this.b;
                                ((AndroidWallpaperEngine)this.a).h.isPreviewNotified = true;
                                bl = true;
                            }
                            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                            if (bl) {
                                AndroidLiveWallpaper androidLiveWallpaper = app;
                                object = androidLiveWallpaper;
                                if (androidLiveWallpaper != null) {
                                    ((AndroidWallpaperListener)((Object)object.listener)).previewStateChange(this.b);
                                }
                            }
                            return;
                        }
                    }
                });
            }
        }
    }
}

