/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.AudioManager;
import android.media.SoundPool;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.IntArray;

@BA.Hide
public class AndroidSound
implements Sound {
    private SoundPool a;
    private AudioManager b;
    private int c;
    private IntArray d = new IntArray(8);

    AndroidSound(SoundPool pool, AudioManager manager, int soundId) {
        this.a = pool;
        this.b = manager;
        this.c = soundId;
    }

    @Override
    public void dispose() {
        this.a.unload(this.c);
    }

    @Override
    public long play() {
        return this.play(1.0f);
    }

    @Override
    public long play(float volume) {
        if (this.d.size == 8) {
            this.d.pop();
        }
        float f = volume;
        int n = this.a.play(this.c, f, f, 1, 0, 1.0f);
        if (n == 0) {
            return -1L;
        }
        this.d.insert(0, n);
        return n;
    }

    @Override
    public void stop() {
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            this.a.stop(this.d.get(n));
            ++n;
        }
    }

    @Override
    public void stop(long soundId) {
        this.a.stop((int)soundId);
    }

    @Override
    public void pause() {
        this.a.autoPause();
    }

    @Override
    public void pause(long soundId) {
        this.a.pause((int)soundId);
    }

    @Override
    public void resume() {
        this.a.autoResume();
    }

    @Override
    public void resume(long soundId) {
        this.a.resume((int)soundId);
    }

    @Override
    public void setPitch(long soundId, float pitch) {
        this.a.setRate((int)soundId, pitch);
    }

    @Override
    public void setVolume(long soundId, float volume) {
        float f = volume;
        this.a.setVolume((int)soundId, f, f);
    }

    @Override
    public long loop() {
        return this.loop(1.0f);
    }

    @Override
    public long loop(float volume) {
        if (this.d.size == 8) {
            this.d.pop();
        }
        float f = volume;
        int n = this.a.play(this.c, f, f, 1, -1, 1.0f);
        if (n == 0) {
            return -1L;
        }
        this.d.insert(0, n);
        return n;
    }

    @Override
    public void setLooping(long soundId, boolean looping) {
        this.a.setLoop((int)soundId, looping ? -1 : 0);
    }

    @Override
    public void setPan(long soundId, float pan, float volume) {
        float f = volume;
        float f2 = volume;
        if (pan < 0.0f) {
            f2 = volume * (1.0f - Math.abs(pan));
        } else if (pan > 0.0f) {
            f = volume * (1.0f - Math.abs(pan));
        }
        this.a.setVolume((int)soundId, f, f2);
    }

    @Override
    public long play(float volume, float pitch, float pan) {
        if (this.d.size == 8) {
            this.d.pop();
        }
        float f = volume;
        float f2 = volume;
        if (pan < 0.0f) {
            f2 = volume * (1.0f - Math.abs(pan));
        } else if (pan > 0.0f) {
            f = volume * (1.0f - Math.abs(pan));
        }
        int n = this.a.play(this.c, f, f2, 1, 0, pitch);
        if (n == 0) {
            return -1L;
        }
        this.d.insert(0, n);
        return n;
    }

    @Override
    public long loop(float volume, float pitch, float pan) {
        if (this.d.size == 8) {
            this.d.pop();
        }
        float f = volume;
        float f2 = volume;
        if (pan < 0.0f) {
            f2 = volume * (1.0f - Math.abs(pan));
        } else if (pan > 0.0f) {
            f = volume * (1.0f - Math.abs(pan));
        }
        int n = this.a.play(this.c, f, f2, 1, -1, pitch);
        if (n == 0) {
            return -1L;
        }
        this.d.insert(0, n);
        return n;
    }

    @Override
    public void setPriority(long soundId, int priority) {
        this.a.setPriority((int)soundId, priority);
    }
}

