/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.ZipResourceFile;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

@BA.Hide
public class AndroidZipFileHandle
extends AndroidFileHandle {
    private AssetFileDescriptor a;
    private ZipResourceFile b;
    private String c;

    public AndroidZipFileHandle(String fileName) {
        super(null, fileName, Files.FileType.Internal);
        this.a();
    }

    public AndroidZipFileHandle(File file, Files.FileType type) {
        super(null, file, type);
        this.a();
    }

    private void a() {
        this.c = this.file.getPath().replace('\\', '/');
        this.b = ((AndroidFiles)Gdx.files).getExpansionFile();
        this.a = this.b.getAssetFileDescriptor(this.c);
        if (this.isDirectory()) {
            this.c = String.valueOf(this.c) + "/";
        }
    }

    @Override
    public AssetFileDescriptor getAssetFileDescriptor() throws IOException {
        return this.a;
    }

    @Override
    public InputStream read() {
        InputStream inputStream;
        try {
            inputStream = this.b.getInputStream(this.c);
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error reading file: " + this.file + " (ZipResourceFile)", iOException);
        }
        return inputStream;
    }

    @Override
    public FileHandle child(String name) {
        if (this.file.getPath().length() == 0) {
            return new AndroidZipFileHandle(new File(name), this.type);
        }
        return new AndroidZipFileHandle(new File(this.file, name), this.type);
    }

    @Override
    public FileHandle sibling(String name) {
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return Gdx.files.getFileHandle(new File(this.file.getParent(), name).getPath(), this.type);
    }

    @Override
    public FileHandle parent() {
        File file = this.file.getParentFile();
        if (file == null) {
            file = new File("");
        }
        return new AndroidZipFileHandle(file.getPath());
    }

    @Override
    public FileHandle[] list() {
        ZipResourceFile.ZipEntryRO[] zipEntryROArray = this.b.a(this.c);
        FileHandle[] fileHandleArray = new FileHandle[zipEntryROArray.length];
        int n = 0;
        int n2 = fileHandleArray.length;
        while (n < n2) {
            fileHandleArray[n] = new AndroidZipFileHandle(zipEntryROArray[n].mFileName);
            ++n;
        }
        return fileHandleArray;
    }

    @Override
    public FileHandle[] list(String suffix) {
        ZipResourceFile.ZipEntryRO[] zipEntryROArray = this.b.a(this.c);
        FileHandle[] fileHandleArray = new FileHandle[zipEntryROArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = fileHandleArray.length;
        while (n2 < n3) {
            String string = zipEntryROArray[n2].mFileName;
            if (string.endsWith(suffix)) {
                fileHandleArray[n] = new AndroidZipFileHandle(string);
                ++n;
            }
            ++n2;
        }
        if (n < zipEntryROArray.length) {
            FileHandle[] fileHandleArray2 = new FileHandle[n];
            System.arraycopy(fileHandleArray, 0, fileHandleArray2, 0, n);
            fileHandleArray = fileHandleArray2;
        }
        return fileHandleArray;
    }

    @Override
    public boolean isDirectory() {
        return this.a == null;
    }

    @Override
    public long length() {
        if (this.a != null) {
            return this.a.getLength();
        }
        return 0L;
    }

    @Override
    public boolean exists() {
        return this.a != null || this.b.a(this.c).length != 0;
    }
}

