/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import anywheresoftware.b4a.BA;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@BA.ShortName(value="lgZipResourceFile")
public class ZipResourceFile {
    private HashMap<String, ZipEntryRO> a = new HashMap();
    private HashMap<File, ZipFile> b = new HashMap();
    private ByteBuffer c = ByteBuffer.allocate(4);

    public ZipResourceFile(String zipFileName) throws IOException {
        this.b(zipFileName);
    }

    final ZipEntryRO[] a(String string) {
        Vector<ZipEntryRO> vector = new Vector<ZipEntryRO>();
        Collection<ZipEntryRO> collection = this.a.values();
        if (string == null) {
            string = "";
        }
        int n = string.length();
        for (ZipEntryRO object2 : collection) {
            if (!object2.mFileName.startsWith(string) || -1 != object2.mFileName.indexOf(47, n)) continue;
            vector.add(object2);
        }
        ZipEntryRO[] zipEntryROArray = new ZipEntryRO[vector.size()];
        return vector.toArray(zipEntryROArray);
    }

    public ZipEntryRO[] getAllEntries() {
        Collection<ZipEntryRO> collection = this.a.values();
        return collection.toArray(new ZipEntryRO[collection.size()]);
    }

    @BA.Hide
    public AssetFileDescriptor getAssetFileDescriptor(String assetPath) {
        ZipEntryRO zipEntryRO = this.a.get(assetPath);
        if (zipEntryRO != null) {
            return zipEntryRO.getAssetFileDescriptor();
        }
        return null;
    }

    public InputStream getInputStream(String assetPath) throws IOException {
        ZipEntryRO zipEntryRO = this.a.get(assetPath);
        if (zipEntryRO != null) {
            ZipEntry zipEntry;
            if (zipEntryRO.isUncompressed()) {
                return zipEntryRO.getAssetFileDescriptor().createInputStream();
            }
            ZipFile zipFile = this.b.get(zipEntryRO.a);
            if (zipFile == null) {
                zipFile = new ZipFile(zipEntryRO.a, 1);
                this.b.put(zipEntryRO.a, zipFile);
            }
            if ((zipEntry = zipFile.getEntry(assetPath)) != null) {
                return zipFile.getInputStream(zipEntry);
            }
        }
        return null;
    }

    private static int a(RandomAccessFile randomAccessFile) throws EOFException, IOException {
        int n = randomAccessFile.readInt();
        return ((n & 0xFF) << 24) + ((n & 0xFF00) << 8) + ((n & 0xFF0000) >>> 8) + (n >>> 24 & 0xFF);
    }

    final void b(String string) throws IOException {
        File file = new File(string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long l = randomAccessFile.length();
        if (l < 22L) {
            randomAccessFile.close();
            throw new IOException();
        }
        long l2 = 65557L;
        if (65557L > l) {
            l2 = l;
        }
        randomAccessFile.seek(0L);
        int n = ZipResourceFile.a(randomAccessFile);
        if (n == 101010256) {
            Log.i((String)"B4A", (String)"Found Zip archive, but it looks empty");
            throw new IOException();
        }
        if (n != 67324752) {
            Log.v((String)"B4A", (String)"Not a Zip archive");
            throw new IOException();
        }
        long l3 = l - l2;
        randomAccessFile.seek(l3);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l2);
        byte[] byArray = byteBuffer.array();
        randomAccessFile.readFully(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = byArray.length - 22;
        while (n2 >= 0) {
            if (byArray[n2] == 80 && byteBuffer.getInt(n2) == 101010256) break;
            --n2;
        }
        if (n2 < 0) {
            Log.d((String)"B4A", (String)("Zip: EOCD not found, " + string + " is not zip"));
        }
        int n3 = byteBuffer.getShort(n2 + 8);
        long l4 = (long)byteBuffer.getInt(n2 + 12) & 0xFFFFFFFFL;
        long l5 = (long)byteBuffer.getInt(n2 + 16) & 0xFFFFFFFFL;
        if (l5 + l4 > l) {
            Log.w((String)"B4A", (String)("bad offsets (dir " + l5 + ", size " + l4 + ", eocd " + n2 + ")"));
            throw new IOException();
        }
        if (n3 == 0) {
            Log.w((String)"B4A", (String)"empty archive?");
            throw new IOException();
        }
        MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, l5, l4);
        mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray2 = new byte[65535];
        int n4 = 0;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(30);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        int n5 = 0;
        while (n5 < n3) {
            if (mappedByteBuffer.getInt(n4) != 33639248) {
                Log.w((String)"B4A", (String)("Missed a central dir sig (at " + n4 + ")"));
                throw new IOException();
            }
            int n6 = mappedByteBuffer.getShort(n4 + 28) & 0xFFFF;
            int n7 = mappedByteBuffer.getShort(n4 + 30) & 0xFFFF;
            int n8 = mappedByteBuffer.getShort(n4 + 32) & 0xFFFF;
            mappedByteBuffer.position(n4 + 46);
            mappedByteBuffer.get(byArray2, 0, n6);
            mappedByteBuffer.position(0);
            String string2 = new String(byArray2, 0, n6);
            ZipEntryRO zipEntryRO = new ZipEntryRO(string, file, string2);
            new ZipEntryRO(string, file, string2).mMethod = mappedByteBuffer.getShort(n4 + 10) & 0xFFFF;
            zipEntryRO.mWhenModified = (long)mappedByteBuffer.getInt(n4 + 12) & 0xFFFFFFFFL;
            zipEntryRO.mCRC32 = mappedByteBuffer.getLong(n4 + 16) & 0xFFFFFFFFL;
            zipEntryRO.mCompressedLength = mappedByteBuffer.getLong(n4 + 20) & 0xFFFFFFFFL;
            zipEntryRO.mUncompressedLength = mappedByteBuffer.getLong(n4 + 24) & 0xFFFFFFFFL;
            zipEntryRO.b = (long)mappedByteBuffer.getInt(n4 + 42) & 0xFFFFFFFFL;
            byteBuffer2.clear();
            zipEntryRO.a(randomAccessFile, byteBuffer2);
            this.a.put(string2, zipEntryRO);
            n4 += 46 + n6 + n7 + n8;
            ++n5;
        }
    }

    @BA.ShortName(value="lgZipEntry")
    public static final class ZipEntryRO {
        final File a;
        public final String mFileName;
        private String c;
        long b;
        public int mMethod;
        public long mWhenModified;
        public long mCRC32;
        public long mCompressedLength;
        public long mUncompressedLength;
        private long d = -1L;

        public ZipEntryRO(String zipFileName, File file, String fileName) {
            this.mFileName = fileName;
            this.c = zipFileName;
            this.a = file;
        }

        final void a(RandomAccessFile randomAccessFile, ByteBuffer byteBuffer) throws IOException {
            long l = this.b;
            try {
                randomAccessFile.seek(l);
                randomAccessFile.readFully(byteBuffer.array());
                if (byteBuffer.getInt(0) != 67324752) {
                    Log.w((String)"B4A", (String)"didn't find signature at start of lfh");
                    throw new IOException();
                }
                int n = byteBuffer.getShort(26) & 0xFFFF;
                int n2 = byteBuffer.getShort(28) & 0xFFFF;
                this.d = l + 30L + (long)n + (long)n2;
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }

        public final long getOffset() {
            return this.d;
        }

        public final boolean isUncompressed() {
            return this.mMethod == 0;
        }

        @BA.Hide
        public final AssetFileDescriptor getAssetFileDescriptor() {
            if (this.mMethod == 0) {
                try {
                    ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)this.a, (int)0x10000000);
                    return new AssetFileDescriptor(parcelFileDescriptor, this.getOffset(), this.mUncompressedLength);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            return null;
        }

        public final String getZipFileName() {
            return this.c;
        }
    }
}

