/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.files;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

@BA.ShortName(value="lgFileHandle")
public class FileHandle {
    protected File file;
    protected Files.FileType type;
    private static /* synthetic */ int[] a;

    protected FileHandle() {
    }

    public FileHandle(String fileName) {
        this.file = new File(fileName);
        this.type = Files.FileType.Absolute;
    }

    public FileHandle(File file) {
        this.file = file;
        this.type = Files.FileType.Absolute;
    }

    protected FileHandle(String fileName, Files.FileType type) {
        this.type = type;
        this.file = new File(fileName);
    }

    protected FileHandle(File file, Files.FileType type) {
        this.file = file;
        this.type = type;
    }

    public String path() {
        return this.file.getPath().replace('\\', '/');
    }

    public String name() {
        return this.file.getName();
    }

    public String extension() {
        String string = this.file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public String nameWithoutExtension() {
        String string = this.file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String pathWithoutExtension() {
        String string = this.file.getPath().replace('\\', '/');
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public Files.FileType type() {
        return this.type;
    }

    @BA.Hide
    public File file() {
        if (this.type == Files.FileType.External) {
            return new File(Gdx.files.getExternalStoragePath(), this.file.getPath());
        }
        return this.file;
    }

    @BA.Hide
    public InputStream read() {
        if (this.type == Files.FileType.Classpath || this.type == Files.FileType.Internal && !this.file().exists() || this.type == Files.FileType.Local && !this.file().exists()) {
            InputStream inputStream = FileHandle.class.getResourceAsStream("/" + this.file.getPath().replace('\\', '/'));
            if (inputStream == null) {
                throw new GdxRuntimeException("File not found: " + this.file + " (" + (Object)((Object)this.type) + ")");
            }
            return inputStream;
        }
        try {
            return new FileInputStream(this.file());
        }
        catch (Exception exception) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
            }
            throw new GdxRuntimeException("Error reading file: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
        }
    }

    @BA.Hide
    public BufferedInputStream read(int bufferSize) {
        return new BufferedInputStream(this.read(), bufferSize);
    }

    @BA.Hide
    public Reader reader() {
        return new InputStreamReader(this.read());
    }

    @BA.Hide
    public Reader reader(String charset) {
        InputStream inputStream = this.read();
        try {
            return new InputStreamReader(inputStream, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StreamUtils.closeQuietly(inputStream);
            throw new GdxRuntimeException("Error reading file: ".concat(String.valueOf(this)), unsupportedEncodingException);
        }
    }

    @BA.Hide
    public BufferedReader reader(int bufferSize) {
        return new BufferedReader(new InputStreamReader(this.read()), bufferSize);
    }

    @BA.Hide
    public BufferedReader reader(int bufferSize, String charset) {
        try {
            return new BufferedReader(new InputStreamReader(this.read(), charset), bufferSize);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GdxRuntimeException("Error reading file: ".concat(String.valueOf(this)), unsupportedEncodingException);
        }
    }

    public String readString() {
        return this.readString2(null);
    }

    public String readString2(String charset) {
        StringBuilder stringBuilder = new StringBuilder(this.a());
        InputStreamReader inputStreamReader = null;
        try {
            try {
                int n;
                inputStreamReader = charset == null ? new InputStreamReader(this.read()) : new InputStreamReader(this.read(), charset);
                char[] cArray = new char[256];
                while ((n = inputStreamReader.read(cArray)) != -1) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error reading layout file: ".concat(String.valueOf(this)), iOException);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        StreamUtils.closeQuietly(inputStreamReader);
        return stringBuilder.toString();
    }

    public byte[] readBytes() {
        InputStream inputStream = this.read();
        try {
            byte[] byArray = StreamUtils.copyStreamToByteArray(inputStream, this.a());
            return byArray;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error reading file: ".concat(String.valueOf(this)), iOException);
        }
        finally {
            StreamUtils.closeQuietly(inputStream);
        }
    }

    private int a() {
        int n = (int)this.length();
        if (n != 0) {
            return n;
        }
        return 512;
    }

    public int readBytes(byte[] bytes, int offset, int size) {
        InputStream inputStream = this.read();
        int n = 0;
        try {
            try {
                int n2;
                while ((n2 = inputStream.read(bytes, offset + n, size - n)) > 0) {
                    n += n2;
                }
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error reading file: ".concat(String.valueOf(this)), iOException);
            }
        }
        finally {
            StreamUtils.closeQuietly(inputStream);
        }
        return n - offset;
    }

    @BA.Hide
    public OutputStream write(boolean append) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            return new FileOutputStream(this.file(), append);
        }
        catch (Exception exception) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
            }
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
        }
    }

    @BA.Hide
    public OutputStream write(boolean append, int bufferSize) {
        return new BufferedOutputStream(this.write(append), bufferSize);
    }

    @BA.Hide
    public void write(InputStream input, boolean append) {
        OutputStream outputStream = null;
        try {
            try {
                outputStream = this.write(append);
                StreamUtils.copyStream(input, outputStream);
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error stream writing to file: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
            }
        }
        finally {
            StreamUtils.closeQuietly(input);
            StreamUtils.closeQuietly(outputStream);
        }
    }

    @BA.Hide
    public Writer writer(boolean append) {
        return this.writer(append, null);
    }

    @BA.Hide
    public Writer writer(boolean append, String charset) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file(), append);
            if (charset == null) {
                return new OutputStreamWriter(fileOutputStream);
            }
            return new OutputStreamWriter((OutputStream)fileOutputStream, charset);
        }
        catch (IOException iOException) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", iOException);
            }
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", iOException);
        }
    }

    public void writeString(String string, boolean append) {
        this.writeString2(string, append, null);
    }

    public void writeString2(String string, boolean append, String charset) {
        Writer writer = null;
        try {
            try {
                writer = this.writer(append, charset);
                writer.write(string);
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(writer);
            throw throwable;
        }
        StreamUtils.closeQuietly(writer);
    }

    public void writeBytes(byte[] bytes, boolean append) {
        OutputStream outputStream = this.write(append);
        try {
            try {
                outputStream.write(bytes);
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", iOException);
            }
        }
        finally {
            StreamUtils.closeQuietly(outputStream);
        }
    }

    public void writeBytes(byte[] bytes, int offset, int length, boolean append) {
        OutputStream outputStream = this.write(append);
        try {
            try {
                outputStream.write(bytes, offset, length);
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", iOException);
            }
        }
        finally {
            StreamUtils.closeQuietly(outputStream);
        }
    }

    @BA.Hide
    public FileHandle[] list() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] stringArray = this.file().list();
        if (stringArray == null) {
            return new FileHandle[0];
        }
        FileHandle[] fileHandleArray = new FileHandle[stringArray.length];
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            fileHandleArray[n] = this.child(stringArray[n]);
            ++n;
        }
        return fileHandleArray;
    }

    @BA.Hide
    public FileHandle[] list(String suffix) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] stringArray = this.file().list();
        if (stringArray == null) {
            return new FileHandle[0];
        }
        FileHandle[] fileHandleArray = new FileHandle[stringArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            String string = stringArray[n2];
            if (string.endsWith(suffix)) {
                fileHandleArray[n] = this.child(string);
                ++n;
            }
            ++n2;
        }
        if (n < stringArray.length) {
            FileHandle[] fileHandleArray2 = new FileHandle[n];
            System.arraycopy(fileHandleArray, 0, fileHandleArray2, 0, n);
            fileHandleArray = fileHandleArray2;
        }
        return fileHandleArray;
    }

    public boolean isDirectory() {
        if (this.type == Files.FileType.Classpath) {
            return false;
        }
        return this.file().isDirectory();
    }

    public FileHandle child(String name) {
        if (this.file.getPath().length() == 0) {
            return new FileHandle(new File(name), this.type);
        }
        return new FileHandle(new File(this.file, name), this.type);
    }

    public FileHandle sibling(String name) {
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return new FileHandle(new File(this.file.getParent(), name), this.type);
    }

    public FileHandle parent() {
        File file = this.file.getParentFile();
        if (file == null) {
            file = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new FileHandle(file, this.type);
    }

    public void mkdirs() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot mkdirs with a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot mkdirs with an internal file: " + this.file);
        }
        this.file().mkdirs();
    }

    public boolean exists() {
        switch (FileHandle.b()[this.type.ordinal()]) {
            case 2: {
                if (this.file().exists()) {
                    return true;
                }
            }
            case 1: {
                return FileHandle.class.getResource("/" + this.file.getPath().replace('\\', '/')) != null;
            }
        }
        return this.file().exists();
    }

    public boolean delete() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot delete an internal file: " + this.file);
        }
        return this.file().delete();
    }

    public boolean deleteDirectory() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot delete an internal file: " + this.file);
        }
        return FileHandle.a(this.file());
    }

    public void emptyDirectory() {
        this.emptyDirectory(false);
    }

    public void emptyDirectory(boolean preserveTree) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot delete an internal file: " + this.file);
        }
        FileHandle.a(this.file(), preserveTree);
    }

    public void copyTo(FileHandle dest) {
        boolean bl = this.isDirectory();
        if (!bl) {
            if (dest.isDirectory()) {
                dest = dest.child(this.name());
            }
            FileHandle.a(this, dest);
            return;
        }
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                throw new GdxRuntimeException("Destination exists but is not a directory: ".concat(String.valueOf(dest)));
            }
        } else {
            dest.mkdirs();
            if (!dest.isDirectory()) {
                throw new GdxRuntimeException("Destination directory cannot be created: ".concat(String.valueOf(dest)));
            }
        }
        if (!bl) {
            dest = dest.child(this.name());
        }
        FileHandle.b(this, dest);
    }

    public void moveTo(FileHandle dest) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot move a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot move an internal file: " + this.file);
        }
        this.copyTo(dest);
        this.delete();
        if (this.exists() && this.isDirectory()) {
            this.deleteDirectory();
        }
    }

    public long length() {
        if (this.type == Files.FileType.Classpath || this.type == Files.FileType.Internal && !this.file.exists()) {
            InputStream inputStream = this.read();
            try {
                long l = inputStream.available();
                return l;
            }
            catch (Exception exception) {
            }
            finally {
                StreamUtils.closeQuietly(inputStream);
            }
            return 0L;
        }
        return this.file().length();
    }

    public long lastModified() {
        return this.file().lastModified();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileHandle)) {
            return false;
        }
        FileHandle fileHandle = (FileHandle)obj;
        return this.type == fileHandle.type && this.path().equals(fileHandle.path());
    }

    public int hashCode() {
        return (37 + this.type.hashCode()) * 67 + this.path().hashCode();
    }

    public String toString() {
        return this.file.getPath().replace('\\', '/');
    }

    public static FileHandle tempFile(String prefix) {
        try {
            return new FileHandle(File.createTempFile(prefix, null));
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Unable to create temp file.", iOException);
        }
    }

    public static FileHandle tempDirectory(String prefix) {
        try {
            File file = File.createTempFile(prefix, null);
            if (!file.delete()) {
                throw new IOException("Unable to delete temp file: ".concat(String.valueOf(file)));
            }
            if (!file.mkdir()) {
                throw new IOException("Unable to create temp directory: ".concat(String.valueOf(file)));
            }
            return new FileHandle(file);
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Unable to create temp file.", iOException);
        }
    }

    private static void a(File file, boolean bl) {
        File[] fileArray;
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                if (!fileArray[n].isDirectory()) {
                    fileArray[n].delete();
                } else if (bl) {
                    FileHandle.a(fileArray[n], true);
                } else {
                    FileHandle.a(fileArray[n]);
                }
                ++n;
            }
        }
    }

    private static boolean a(File file) {
        FileHandle.a(file, false);
        return file.delete();
    }

    private static void a(FileHandle fileHandle, FileHandle fileHandle2) {
        try {
            fileHandle2.write(fileHandle.read(), false);
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error copying source file: " + fileHandle.file + " (" + (Object)((Object)fileHandle.type) + ")\nTo destination: " + fileHandle2.file + " (" + (Object)((Object)fileHandle2.type) + ")", exception);
        }
    }

    private static void b(FileHandle fileHandle, FileHandle fileHandle2) {
        fileHandle2.mkdirs();
        FileHandle[] fileHandleArray = fileHandle.list();
        int n = 0;
        int n2 = fileHandleArray.length;
        while (n < n2) {
            FileHandle fileHandle3 = fileHandleArray[n];
            FileHandle fileHandle4 = fileHandle2.child(fileHandle3.name());
            if (fileHandle3.isDirectory()) {
                FileHandle.b(fileHandle3, fileHandle4);
            } else {
                FileHandle.a(fileHandle3, fileHandle4);
            }
            ++n;
        }
    }

    private static /* synthetic */ int[] b() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[Files.FileType.values().length];
        try {
            nArray[Files.FileType.Absolute.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Files.FileType.Classpath.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Files.FileType.External.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Files.FileType.Internal.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Files.FileType.Local.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

