/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.utils.NumberUtils;

@BA.ShortName(value="lgColor")
public class Color {
    public static final Color CLEAR = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color WHITE = new Color(-1);
    public static final Color LIGHT_GRAY = new Color(-1077952513);
    public static final Color GRAY = new Color(0x7F7F7FFF);
    public static final Color DARK_GRAY = new Color(0x3F3F3FFF);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color NAVY = new Color(0.0f, 0.0f, 0.5f, 1.0f);
    public static final Color ROYAL = new Color(1097458175);
    public static final Color SLATE = new Color(1887473919);
    public static final Color SKY = new Color(-2016482305);
    public static final Color CYAN = new Color(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color TEAL = new Color(0.0f, 0.5f, 0.5f, 1.0f);
    public static final Color GREEN = new Color(0xFF00FF);
    public static final Color CHARTREUSE = new Color(0x7FFF00FF);
    public static final Color LIME = new Color(852308735);
    public static final Color FOREST = new Color(579543807);
    public static final Color OLIVE = new Color(1804477439);
    public static final Color YELLOW = new Color(-65281);
    public static final Color GOLD = new Color(-2686721);
    public static final Color GOLDENROD = new Color(-626712321);
    public static final Color ORANGE = new Color(-5963521);
    public static final Color BROWN = new Color(-1958407169);
    public static final Color TAN = new Color(-759919361);
    public static final Color FIREBRICK = new Color(-1306385665);
    public static final Color RED = new Color(-16776961);
    public static final Color SCARLET = new Color(-13361921);
    public static final Color CORAL = new Color(-8433409);
    public static final Color SALMON = new Color(-92245249);
    public static final Color PINK = new Color(-9849601);
    public static final Color MAGENTA = new Color(1.0f, 0.0f, 1.0f, 1.0f);
    public static final Color PURPLE = new Color(-1608453889);
    public static final Color VIOLET = new Color(-293409025);
    public static final Color MAROON = new Color(-1339006721);
    public float r;
    public float g;
    public float b;
    public float a;

    public static void SetNameForColor(String Name, Color Color2) {
        Colors.put(Name, Color2);
    }

    public static Color GetColorByName(String Name) {
        return Colors.get(Name);
    }

    public Color() {
    }

    public Color(int rgba8888) {
        Color.rgba8888ToColor(this, rgba8888);
    }

    public Color(float r, float g, float b2, float a2) {
        this.r = r;
        this.g = g;
        this.b = b2;
        this.a = a2;
        this.clamp();
    }

    public Color(Color color) {
        this.set(color);
    }

    public Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        return this;
    }

    public Color mul(Color color) {
        this.r *= color.r;
        this.g *= color.g;
        this.b *= color.b;
        this.a *= color.a;
        return this.clamp();
    }

    public Color mul(float value) {
        this.r *= value;
        this.g *= value;
        this.b *= value;
        this.a *= value;
        return this.clamp();
    }

    public Color add(Color color) {
        this.r += color.r;
        this.g += color.g;
        this.b += color.b;
        this.a += color.a;
        return this.clamp();
    }

    public Color sub(Color color) {
        this.r -= color.r;
        this.g -= color.g;
        this.b -= color.b;
        this.a -= color.a;
        return this.clamp();
    }

    public Color clamp() {
        if (this.r < 0.0f) {
            this.r = 0.0f;
        } else if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        } else if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        } else if (this.b > 1.0f) {
            this.b = 1.0f;
        }
        if (this.a < 0.0f) {
            this.a = 0.0f;
        } else if (this.a > 1.0f) {
            this.a = 1.0f;
        }
        return this;
    }

    public Color setRGBA(float r, float g, float b2, float a2) {
        return this.set(r, g, b2, a2);
    }

    @BA.Hide
    public Color set(float r, float g, float b2, float a2) {
        this.r = r;
        this.g = g;
        this.b = b2;
        this.a = a2;
        return this.clamp();
    }

    public Color set(int rgba) {
        Color.rgba8888ToColor(this, rgba);
        return this;
    }

    public Color addRGBA(float r, float g, float b2, float a2) {
        return this.add(r, g, b2, a2);
    }

    @BA.Hide
    public Color add(float r, float g, float b2, float a2) {
        this.r += r;
        this.g += g;
        this.b += b2;
        this.a += a2;
        return this.clamp();
    }

    public Color subRGBA(float r, float g, float b2, float a2) {
        return this.sub(r, g, b2, a2);
    }

    @BA.Hide
    public Color sub(float r, float g, float b2, float a2) {
        this.r -= r;
        this.g -= g;
        this.b -= b2;
        this.a -= a2;
        return this.clamp();
    }

    public Color mulRGBA(float r, float g, float b2, float a2) {
        return this.mul(r, g, b2, a2);
    }

    @BA.Hide
    public Color mul(float r, float g, float b2, float a2) {
        this.r *= r;
        this.g *= g;
        this.b *= b2;
        this.a *= a2;
        return this.clamp();
    }

    public Color lerp(Color target, float t) {
        this.r += t * (target.r - this.r);
        this.g += t * (target.g - this.g);
        this.b += t * (target.b - this.b);
        this.a += t * (target.a - this.a);
        return this.clamp();
    }

    public Color lerp(float r, float g, float b2, float a2, float t) {
        this.r += t * (r - this.r);
        this.g += t * (g - this.g);
        this.b += t * (b2 - this.b);
        this.a += t * (a2 - this.a);
        return this.clamp();
    }

    public Color premultiplyAlpha() {
        this.r *= this.a;
        this.g *= this.a;
        this.b *= this.a;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.toIntBits() == color.toIntBits();
    }

    public int hashCode() {
        int n = this.r != 0.0f ? NumberUtils.floatToIntBits(this.r) : 0;
        n = 31 * n + (this.g != 0.0f ? NumberUtils.floatToIntBits(this.g) : 0);
        n = 31 * n + (this.b != 0.0f ? NumberUtils.floatToIntBits(this.b) : 0);
        return 31 * n + (this.a != 0.0f ? NumberUtils.floatToIntBits(this.a) : 0);
    }

    public float toFloatBits() {
        return NumberUtils.intToFloatColor((int)(255.0f * this.a) << 24 | (int)(255.0f * this.b) << 16 | (int)(255.0f * this.g) << 8 | (int)(255.0f * this.r));
    }

    public int toIntBits() {
        return (int)(255.0f * this.a) << 24 | (int)(255.0f * this.b) << 16 | (int)(255.0f * this.g) << 8 | (int)(255.0f * this.r);
    }

    public String toString() {
        String string = Integer.toHexString((int)(255.0f * this.r) << 24 | (int)(255.0f * this.g) << 16 | (int)(255.0f * this.b) << 8 | (int)(255.0f * this.a));
        while (string.length() < 8) {
            string = "0".concat(String.valueOf(string));
        }
        return string;
    }

    public static Color valueOf(String hex) {
        hex = hex.charAt(0) == '#' ? hex.substring(1) : hex;
        int n = Integer.valueOf(hex.substring(0, 2), 16);
        int n2 = Integer.valueOf(hex.substring(2, 4), 16);
        int n3 = Integer.valueOf(hex.substring(4, 6), 16);
        int n4 = hex.length() != 8 ? 255 : Integer.valueOf(hex.substring(6, 8), 16);
        return new Color((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f);
    }

    public static float toFloatBits(int r, int g, int b2, int a2) {
        return NumberUtils.intToFloatColor(a2 << 24 | b2 << 16 | g << 8 | r);
    }

    public static float toFloatBits(float r, float g, float b2, float a2) {
        return NumberUtils.intToFloatColor((int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r));
    }

    public static int toIntBits(int r, int g, int b2, int a2) {
        return a2 << 24 | b2 << 16 | g << 8 | r;
    }

    public Color SetAlpha(float alpha) {
        this.a = alpha;
        return this.clamp();
    }

    public static int to255(float alpha) {
        return (int)(alpha * 255.0f);
    }

    public static int luminanceAlpha(float luminance, float alpha) {
        return (int)(luminance * 255.0f) << 8 | (int)(alpha * 255.0f);
    }

    public static int rgb565(float r, float g, float b2) {
        return (int)(r * 31.0f) << 11 | (int)(g * 63.0f) << 5 | (int)(b2 * 31.0f);
    }

    public static int rgba4444(float r, float g, float b2, float a2) {
        return (int)(r * 15.0f) << 12 | (int)(g * 15.0f) << 8 | (int)(b2 * 15.0f) << 4 | (int)(a2 * 15.0f);
    }

    public static int rgb888(float r, float g, float b2) {
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b2 * 255.0f);
    }

    public static int rgba8888(float r, float g, float b2, float a2) {
        return (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b2 * 255.0f) << 8 | (int)(a2 * 255.0f);
    }

    public static int argb8888(float a2, float r, float g, float b2) {
        return (int)(a2 * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b2 * 255.0f);
    }

    public static int rgb565(Color color) {
        return (int)(color.r * 31.0f) << 11 | (int)(color.g * 63.0f) << 5 | (int)(color.b * 31.0f);
    }

    public static int rgba4444(Color color) {
        return (int)(color.r * 15.0f) << 12 | (int)(color.g * 15.0f) << 8 | (int)(color.b * 15.0f) << 4 | (int)(color.a * 15.0f);
    }

    public static int rgb888(Color color) {
        return (int)(color.r * 255.0f) << 16 | (int)(color.g * 255.0f) << 8 | (int)(color.b * 255.0f);
    }

    public static int rgba8888(Color color) {
        return (int)(color.r * 255.0f) << 24 | (int)(color.g * 255.0f) << 16 | (int)(color.b * 255.0f) << 8 | (int)(color.a * 255.0f);
    }

    public static int argb8888(Color color) {
        return (int)(color.a * 255.0f) << 24 | (int)(color.r * 255.0f) << 16 | (int)(color.g * 255.0f) << 8 | (int)(color.b * 255.0f);
    }

    public static void rgb565ToColor(Color color, int value) {
        color.r = (float)((value & 0xF800) >>> 11) / 31.0f;
        color.g = (float)((value & 0x7E0) >>> 5) / 63.0f;
        color.b = (float)((value & 0x1F) >>> 0) / 31.0f;
    }

    public static void rgba4444ToColor(Color color, int value) {
        color.r = (float)((value & 0xF000) >>> 12) / 15.0f;
        color.g = (float)((value & 0xF00) >>> 8) / 15.0f;
        color.b = (float)((value & 0xF0) >>> 4) / 15.0f;
        color.a = (float)(value & 0xF) / 15.0f;
    }

    public static void rgb888ToColor(Color color, int value) {
        color.r = (float)((value & 0xFF0000) >>> 16) / 255.0f;
        color.g = (float)((value & 0xFF00) >>> 8) / 255.0f;
        color.b = (float)(value & 0xFF) / 255.0f;
    }

    public static void rgba8888ToColor(Color color, int value) {
        color.r = (float)((value & 0xFF000000) >>> 24) / 255.0f;
        color.g = (float)((value & 0xFF0000) >>> 16) / 255.0f;
        color.b = (float)((value & 0xFF00) >>> 8) / 255.0f;
        color.a = (float)(value & 0xFF) / 255.0f;
    }

    public static void argb8888ToColor(Color color, int value) {
        color.a = (float)((value & 0xFF000000) >>> 24) / 255.0f;
        color.r = (float)((value & 0xFF0000) >>> 16) / 255.0f;
        color.g = (float)((value & 0xFF00) >>> 8) / 255.0f;
        color.b = (float)(value & 0xFF) / 255.0f;
    }

    public Color cpy() {
        return new Color(this);
    }
}

