/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgMesh;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.IndexArray;
import com.badlogic.gdx.graphics.glutils.IndexBufferObject;
import com.badlogic.gdx.graphics.glutils.IndexBufferObjectSubData;
import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexArray;
import com.badlogic.gdx.graphics.glutils.VertexBufferObject;
import com.badlogic.gdx.graphics.glutils.VertexBufferObjectSubData;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;

@BA.Hide
public class Mesh
implements Disposable {
    private static Map<Application, Array<Mesh>> a = new HashMap<Application, Array<Mesh>>();
    private VertexData b;
    private IndexData c;
    private boolean d = true;
    private boolean e;
    private final Vector3 f = new Vector3();
    private static /* synthetic */ int[] g;

    protected Mesh(VertexData vertices, IndexData indices, boolean isVertexArray) {
        this.b = vertices;
        this.c = indices;
        this.e = isVertexArray;
        Mesh.a(Gdx.app, this);
    }

    public Mesh(boolean isStatic, int maxVertices, int maxIndices, VertexAttribute ... attributes) {
        this.b = Mesh.a(isStatic, maxVertices, new VertexAttributes(attributes));
        this.c = new IndexBufferObject(isStatic, maxIndices);
        this.e = false;
        Mesh.a(Gdx.app, this);
    }

    public Mesh(boolean isStatic, int maxVertices, int maxIndices, VertexAttributes attributes) {
        this.b = Mesh.a(isStatic, maxVertices, attributes);
        this.c = new IndexBufferObject(isStatic, maxIndices);
        this.e = false;
        Mesh.a(Gdx.app, this);
    }

    public Mesh(boolean staticVertices, boolean staticIndices, int maxVertices, int maxIndices, VertexAttributes attributes) {
        this.b = Mesh.a(staticVertices, maxVertices, attributes);
        this.c = new IndexBufferObject(staticIndices, maxIndices);
        this.e = false;
        Mesh.a(Gdx.app, this);
    }

    private static VertexData a(boolean bl, int n, VertexAttributes vertexAttributes) {
        return new VertexBufferObject(bl, n, vertexAttributes);
    }

    public Mesh(VertexDataType type, boolean isStatic, int maxVertices, int maxIndices, VertexAttribute ... attributes) {
        switch (Mesh.a()[type.ordinal()]) {
            case 2: {
                this.b = new VertexBufferObject(isStatic, maxVertices, attributes);
                this.c = new IndexBufferObject(isStatic, maxIndices);
                this.e = false;
                break;
            }
            case 3: {
                this.b = new VertexBufferObjectSubData(isStatic, maxVertices, attributes);
                this.c = new IndexBufferObjectSubData(isStatic, maxIndices);
                this.e = false;
                break;
            }
            default: {
                this.b = new VertexArray(maxVertices, attributes);
                this.c = new IndexArray(maxIndices);
                this.e = true;
            }
        }
        Mesh.a(Gdx.app, this);
    }

    public static Mesh create(boolean isStatic, lgMesh[] meshes) {
        VertexAttributes vertexAttributes = meshes[0].getVertexAttributes();
        int n = meshes[0].getNumVertices();
        int n2 = meshes[0].getNumIndices();
        int n3 = 1;
        while (n3 < meshes.length) {
            if (!meshes[n3].getVertexAttributes().equals(vertexAttributes)) {
                throw new IllegalArgumentException("Inconsistent VertexAttributes");
            }
            n += meshes[n3].getNumVertices();
            n2 += meshes[n3].getNumIndices();
            ++n3;
        }
        n3 = vertexAttributes.vertexSize / 4;
        float[] fArray = new float[n * n3];
        short[] sArray = new short[n2];
        meshes[0].GetVertices(fArray);
        meshes[0].GetIndices(sArray);
        int n4 = meshes[0].getNumVertices();
        int n5 = meshes[0].getNumIndices();
        int n6 = 1;
        while (n6 < meshes.length) {
            Mesh mesh = meshes[n6].getInternalObject();
            int n7 = mesh.getNumVertices();
            int n8 = mesh.getNumIndices();
            mesh.getVertices(0, n7 * n3, fArray, n4 * n3);
            mesh.getIndices(sArray, n5);
            int n9 = 0;
            while (n9 < n8) {
                sArray[n5 + n9] = (short)(sArray[n5 + n9] + n4);
                ++n9;
            }
            n5 += n8;
            n4 += n7;
            ++n6;
        }
        Mesh mesh = new Mesh(isStatic, fArray.length / n3, sArray.length, vertexAttributes);
        mesh.setVertices(fArray);
        mesh.setIndices(sArray);
        return mesh;
    }

    public Mesh setVertices(float[] vertices) {
        this.b.setVertices(vertices, 0, vertices.length);
        return this;
    }

    public Mesh setVertices(float[] vertices, int offset, int count) {
        this.b.setVertices(vertices, offset, count);
        return this;
    }

    public Mesh updateVertices(int targetOffset, float[] source) {
        return this.updateVertices(targetOffset, source, 0, source.length);
    }

    public Mesh updateVertices(int targetOffset, float[] source, int sourceOffset, int count) {
        this.b.updateVertices(targetOffset, source, sourceOffset, count);
        return this;
    }

    public float[] getVertices(float[] vertices) {
        return this.getVertices(0, -1, vertices);
    }

    public float[] getVertices(int srcOffset, float[] vertices) {
        return this.getVertices(srcOffset, -1, vertices);
    }

    public float[] getVertices(int srcOffset, int count, float[] vertices) {
        return this.getVertices(srcOffset, count, vertices, 0);
    }

    public float[] getVertices(int srcOffset, int count, float[] vertices, int destOffset) {
        int n = this.getNumVertices() * this.getVertexSize() / 4;
        if (count == -1 && (count = n - srcOffset) > vertices.length - destOffset) {
            count = vertices.length - destOffset;
        }
        if (srcOffset < 0 || count <= 0 || srcOffset + count > n || destOffset < 0 || destOffset >= vertices.length) {
            throw new IndexOutOfBoundsException();
        }
        if (vertices.length - destOffset < count) {
            throw new IllegalArgumentException("not enough room in vertices array, has " + vertices.length + " floats, needs " + count);
        }
        int n2 = this.getVerticesBuffer().position();
        this.getVerticesBuffer().position(srcOffset);
        this.getVerticesBuffer().get(vertices, destOffset, count);
        this.getVerticesBuffer().position(n2);
        return vertices;
    }

    public Mesh setIndices(short[] indices) {
        this.c.setIndices(indices, 0, indices.length);
        return this;
    }

    public Mesh setIndices(short[] indices, int offset, int count) {
        this.c.setIndices(indices, offset, count);
        return this;
    }

    public void getIndices(short[] indices) {
        this.getIndices(indices, 0);
    }

    public void getIndices(short[] indices, int destOffset) {
        this.getIndices(0, indices, destOffset);
    }

    public void getIndices(int srcOffset, short[] indices, int destOffset) {
        this.getIndices(srcOffset, -1, indices, destOffset);
    }

    public void getIndices(int srcOffset, int count, short[] indices, int destOffset) {
        int n = this.getNumIndices();
        if (count < 0) {
            count = n - srcOffset;
        }
        if (srcOffset < 0 || srcOffset >= n || srcOffset + count > n) {
            throw new IllegalArgumentException("Invalid range specified, offset: " + srcOffset + ", count: " + count + ", max: " + n);
        }
        if (indices.length - destOffset < count) {
            throw new IllegalArgumentException("not enough room in indices array, has " + indices.length + " shorts, needs " + count);
        }
        int n2 = this.getIndicesBuffer().position();
        this.getIndicesBuffer().position(srcOffset);
        this.getIndicesBuffer().get(indices, destOffset, count);
        this.getIndicesBuffer().position(n2);
    }

    public int getNumIndices() {
        return this.c.getNumIndices();
    }

    public int getNumVertices() {
        return this.b.getNumVertices();
    }

    public int getMaxVertices() {
        return this.b.getNumMaxVertices();
    }

    public int getMaxIndices() {
        return this.c.getNumMaxIndices();
    }

    public int getVertexSize() {
        return this.b.getAttributes().vertexSize;
    }

    public void setAutoBind(boolean autoBind) {
        this.d = autoBind;
    }

    public void bind(ShaderProgram shader) {
        this.bind(shader, null);
    }

    public void bind(ShaderProgram shader, int[] locations) {
        this.b.bind(shader, locations);
        if (this.c.getNumIndices() > 0) {
            this.c.bind();
        }
    }

    public void unbind(ShaderProgram shader) {
        this.unbind(shader, null);
    }

    public void unbind(ShaderProgram shader, int[] locations) {
        this.b.unbind(shader, locations);
        if (this.c.getNumIndices() > 0) {
            this.c.unbind();
        }
    }

    public void render(ShaderProgram shader, int primitiveType) {
        this.render(shader, primitiveType, 0, this.c.getNumMaxIndices() > 0 ? this.getNumIndices() : this.getNumVertices(), this.d);
    }

    public void render(ShaderProgram shader, int primitiveType, int offset, int count) {
        this.render(shader, primitiveType, offset, count, this.d);
    }

    public void render(ShaderProgram shader, int primitiveType, int offset, int count, boolean autoBind) {
        if (count == 0) {
            return;
        }
        if (autoBind) {
            this.bind(shader);
        }
        if (this.e) {
            if (this.c.getNumIndices() > 0) {
                ShortBuffer shortBuffer = this.c.getBuffer();
                int n = shortBuffer.position();
                int n2 = shortBuffer.limit();
                shortBuffer.position(offset);
                shortBuffer.limit(offset + count);
                Gdx.gl20.glDrawElements(primitiveType, count, 5123, shortBuffer);
                shortBuffer.position(n);
                shortBuffer.limit(n2);
            } else {
                Gdx.gl20.glDrawArrays(primitiveType, offset, count);
            }
        } else if (this.c.getNumIndices() > 0) {
            Gdx.gl20.glDrawElements(primitiveType, count, 5123, offset * 2);
        } else {
            Gdx.gl20.glDrawArrays(primitiveType, offset, count);
        }
        if (autoBind) {
            this.unbind(shader);
        }
    }

    @Override
    public void dispose() {
        if (a.get(Gdx.app) != null) {
            a.get(Gdx.app).removeValue(this, true);
        }
        this.b.dispose();
        this.c.dispose();
    }

    public VertexAttribute getVertexAttribute(int usage) {
        VertexAttributes vertexAttributes = this.b.getAttributes();
        int n = vertexAttributes.size();
        int n2 = 0;
        while (n2 < n) {
            if (vertexAttributes.get((int)n2).usage == usage) {
                return vertexAttributes.get(n2);
            }
            ++n2;
        }
        return null;
    }

    public VertexAttributes getVertexAttributes() {
        return this.b.getAttributes();
    }

    public FloatBuffer getVerticesBuffer() {
        return this.b.getBuffer();
    }

    public BoundingBox calculateBoundingBox() {
        BoundingBox boundingBox = new BoundingBox();
        this.calculateBoundingBox(boundingBox);
        return boundingBox;
    }

    public void calculateBoundingBox(BoundingBox bbox) {
        int n = this.getNumVertices();
        if (n == 0) {
            throw new GdxRuntimeException("No vertices defined");
        }
        FloatBuffer floatBuffer = this.b.getBuffer();
        bbox.inf();
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n2 = vertexAttribute.offset / 4;
        int n3 = this.b.getAttributes().vertexSize / 4;
        int n4 = n2;
        switch (vertexAttribute.numComponents) {
            case 1: {
                int n5 = 0;
                while (n5 < n) {
                    bbox.ext4(floatBuffer.get(n4), 0.0f, 0.0f);
                    n4 += n3;
                    ++n5;
                }
                return;
            }
            case 2: {
                int n6 = 0;
                while (n6 < n) {
                    bbox.ext4(floatBuffer.get(n4), floatBuffer.get(n4 + 1), 0.0f);
                    n4 += n3;
                    ++n6;
                }
                return;
            }
            case 3: {
                int n7 = 0;
                while (n7 < n) {
                    bbox.ext4(floatBuffer.get(n4), floatBuffer.get(n4 + 1), floatBuffer.get(n4 + 2));
                    n4 += n3;
                    ++n7;
                }
                break;
            }
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox out, int offset, int count) {
        return this.extendBoundingBox(out.inf(), offset, count);
    }

    public BoundingBox calculateBoundingBox(BoundingBox out, int offset, int count, Matrix4 transform) {
        return this.extendBoundingBox(out.inf(), offset, count, transform);
    }

    public BoundingBox extendBoundingBox(BoundingBox out, int offset, int count) {
        return this.extendBoundingBox(out, offset, count, null);
    }

    public BoundingBox extendBoundingBox(BoundingBox out, int offset, int count, Matrix4 transform) {
        int n;
        int n2 = this.getNumIndices();
        int n3 = this.getNumVertices();
        int n4 = n = n2 == 0 ? n3 : n2;
        if (offset < 0 || count <= 0 || offset + count > n) {
            throw new GdxRuntimeException("Invalid part specified ( offset=" + offset + ", count=" + count + ", max=" + n + " )");
        }
        FloatBuffer floatBuffer = this.b.getBuffer();
        ShortBuffer shortBuffer = this.c.getBuffer();
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n5 = vertexAttribute.offset / 4;
        int n6 = this.b.getAttributes().vertexSize / 4;
        int n7 = offset + count;
        switch (vertexAttribute.numComponents) {
            case 1: {
                if (n2 > 0) {
                    int n8 = offset;
                    while (n8 < n7) {
                        int n9 = shortBuffer.get(n8) * n6 + n5;
                        this.f.set(floatBuffer.get(n9), 0.0f, 0.0f);
                        if (transform != null) {
                            this.f.mul(transform);
                        }
                        out.ext(this.f);
                        ++n8;
                    }
                } else {
                    int n10 = offset;
                    while (n10 < n7) {
                        int n11 = n10 * n6 + n5;
                        this.f.set(floatBuffer.get(n11), 0.0f, 0.0f);
                        if (transform != null) {
                            this.f.mul(transform);
                        }
                        out.ext(this.f);
                        ++n10;
                    }
                }
                break;
            }
            case 2: {
                if (n2 > 0) {
                    int n12 = offset;
                    while (n12 < n7) {
                        int n13 = shortBuffer.get(n12) * n6 + n5;
                        this.f.set(floatBuffer.get(n13), floatBuffer.get(n13 + 1), 0.0f);
                        if (transform != null) {
                            this.f.mul(transform);
                        }
                        out.ext(this.f);
                        ++n12;
                    }
                } else {
                    int n14 = offset;
                    while (n14 < n7) {
                        int n15 = n14 * n6 + n5;
                        this.f.set(floatBuffer.get(n15), floatBuffer.get(n15 + 1), 0.0f);
                        if (transform != null) {
                            this.f.mul(transform);
                        }
                        out.ext(this.f);
                        ++n14;
                    }
                }
                break;
            }
            case 3: {
                if (n2 > 0) {
                    int n16 = offset;
                    while (n16 < n7) {
                        int n17 = shortBuffer.get(n16) * n6 + n5;
                        this.f.set(floatBuffer.get(n17), floatBuffer.get(n17 + 1), floatBuffer.get(n17 + 2));
                        if (transform != null) {
                            this.f.mul(transform);
                        }
                        out.ext(this.f);
                        ++n16;
                    }
                } else {
                    int n18 = offset;
                    while (n18 < n7) {
                        int n19 = n18 * n6 + n5;
                        this.f.set(floatBuffer.get(n19), floatBuffer.get(n19 + 1), floatBuffer.get(n19 + 2));
                        if (transform != null) {
                            this.f.mul(transform);
                        }
                        out.ext(this.f);
                        ++n18;
                    }
                }
                break;
            }
        }
        return out;
    }

    public float calculateRadiusSquared(float centerX, float centerY, float centerZ, int offset, int count, Matrix4 transform) {
        int n = this.getNumIndices();
        if (offset < 0 || count <= 0 || offset + count > n) {
            throw new GdxRuntimeException("Not enough indices");
        }
        FloatBuffer floatBuffer = this.b.getBuffer();
        ShortBuffer shortBuffer = this.c.getBuffer();
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n2 = vertexAttribute.offset / 4;
        int n3 = this.b.getAttributes().vertexSize / 4;
        int n4 = offset + count;
        float f = 0.0f;
        switch (vertexAttribute.numComponents) {
            case 1: {
                int n5 = offset;
                while (n5 < n4) {
                    float f2;
                    int n6 = shortBuffer.get(n5) * n3 + n2;
                    this.f.set(floatBuffer.get(n6), 0.0f, 0.0f);
                    if (transform != null) {
                        this.f.mul(transform);
                    }
                    float f3 = this.f.sub(centerX, centerY, centerZ).len2();
                    if (f2 > f) {
                        f = f3;
                    }
                    ++n5;
                }
                break;
            }
            case 2: {
                int n7 = offset;
                while (n7 < n4) {
                    float f4;
                    int n8 = shortBuffer.get(n7) * n3 + n2;
                    this.f.set(floatBuffer.get(n8), floatBuffer.get(n8 + 1), 0.0f);
                    if (transform != null) {
                        this.f.mul(transform);
                    }
                    float f5 = this.f.sub(centerX, centerY, centerZ).len2();
                    if (f4 > f) {
                        f = f5;
                    }
                    ++n7;
                }
                break;
            }
            case 3: {
                int n9 = offset;
                while (n9 < n4) {
                    float f6;
                    int n10 = shortBuffer.get(n9) * n3 + n2;
                    this.f.set(floatBuffer.get(n10), floatBuffer.get(n10 + 1), floatBuffer.get(n10 + 2));
                    if (transform != null) {
                        this.f.mul(transform);
                    }
                    float f7 = this.f.sub(centerX, centerY, centerZ).len2();
                    if (f6 > f) {
                        f = f7;
                    }
                    ++n9;
                }
                break;
            }
        }
        return f;
    }

    public float calculateRadius(float centerX, float centerY, float centerZ, int offset, int count, Matrix4 transform) {
        return (float)Math.sqrt(this.calculateRadiusSquared(centerX, centerY, centerZ, offset, count, transform));
    }

    public float calculateRadius(Vector3 center, int offset, int count, Matrix4 transform) {
        return this.calculateRadius(center.x, center.y, center.z, offset, count, transform);
    }

    public float calculateRadius(float centerX, float centerY, float centerZ, int offset, int count) {
        return this.calculateRadius(centerX, centerY, centerZ, offset, count, null);
    }

    public float calculateRadius(Vector3 center, int offset, int count) {
        return this.calculateRadius(center.x, center.y, center.z, offset, count, null);
    }

    public float calculateRadius(float centerX, float centerY, float centerZ) {
        return this.calculateRadius(centerX, centerY, centerZ, 0, this.getNumIndices(), null);
    }

    public float calculateRadius(Vector3 center) {
        return this.calculateRadius(center.x, center.y, center.z, 0, this.getNumIndices(), null);
    }

    public ShortBuffer getIndicesBuffer() {
        return this.c.getBuffer();
    }

    private static void a(Application application, Mesh mesh) {
        Array<Mesh> array = a.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(mesh);
        a.put(application, array);
    }

    public static void invalidateAllMeshes(Application app) {
        Array<Mesh> array = a.get(app);
        if (array == null) {
            return;
        }
        int n = 0;
        while (n < array.size) {
            array.get((int)n).b.invalidate();
            array.get((int)n).c.invalidate();
            ++n;
        }
    }

    public static void clearAllMeshes(Application app) {
        a.remove(app);
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed meshes/app: { ");
        for (Application application : a.keySet()) {
            stringBuilder.append(Mesh.a.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n = vertexAttribute.offset / 4;
        int n2 = vertexAttribute.numComponents;
        int n3 = this.getNumVertices();
        int n4 = this.getVertexSize() / 4;
        float[] fArray = new float[n3 * n4];
        this.getVertices(fArray);
        int n5 = n;
        switch (n2) {
            case 1: {
                int n6 = 0;
                while (n6 < n3) {
                    int n7 = n5;
                    fArray[n7] = fArray[n7] * scaleX;
                    n5 += n4;
                    ++n6;
                }
                break;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = n5;
                    fArray[n9] = fArray[n9] * scaleX;
                    int n10 = n5 + 1;
                    fArray[n10] = fArray[n10] * scaleY;
                    n5 += n4;
                    ++n8;
                }
                break;
            }
            case 3: {
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = n5;
                    fArray[n12] = fArray[n12] * scaleX;
                    int n13 = n5 + 1;
                    fArray[n13] = fArray[n13] * scaleY;
                    int n14 = n5 + 2;
                    fArray[n14] = fArray[n14] * scaleZ;
                    n5 += n4;
                    ++n11;
                }
                break;
            }
        }
        this.setVertices(fArray);
    }

    public void transform(Matrix4 matrix) {
        this.transform(matrix, 0, this.getNumVertices());
    }

    public void transform(Matrix4 matrix, int start, int count) {
        VertexAttribute vertexAttribute = this.getVertexAttribute(1);
        int n = vertexAttribute.offset / 4;
        int n2 = this.getVertexSize() / 4;
        int n3 = vertexAttribute.numComponents;
        float[] fArray = new float[count * n2];
        this.getVertices(start * n2, count * n2, fArray);
        Mesh.transform(matrix, fArray, n2, n, n3, 0, count);
        this.updateVertices(start * n2, fArray);
    }

    public static void transform(Matrix4 matrix, float[] vertices, int vertexSize, int offset, int dimensions, int start, int count) {
        if (offset < 0 || dimensions <= 0 || offset + dimensions > vertexSize) {
            throw new IndexOutOfBoundsException();
        }
        if (start < 0 || count <= 0 || (start + count) * vertexSize > vertices.length) {
            throw new IndexOutOfBoundsException("start = " + start + ", count = " + count + ", vertexSize = " + vertexSize + ", length = " + vertices.length);
        }
        Vector3 vector3 = new Vector3();
        int n = offset + start * vertexSize;
        switch (dimensions) {
            case 1: {
                int n2 = 0;
                while (n2 < count) {
                    vector3.set(vertices[n], 0.0f, 0.0f).mul(matrix);
                    vertices[n] = vector3.x;
                    n += vertexSize;
                    ++n2;
                }
                return;
            }
            case 2: {
                int n3 = 0;
                while (n3 < count) {
                    vector3.set(vertices[n], vertices[n + 1], 0.0f).mul(matrix);
                    vertices[n] = vector3.x;
                    vertices[n + 1] = vector3.y;
                    n += vertexSize;
                    ++n3;
                }
                return;
            }
            case 3: {
                int n4 = 0;
                while (n4 < count) {
                    vector3.set(vertices[n], vertices[n + 1], vertices[n + 2]).mul(matrix);
                    vertices[n] = vector3.x;
                    vertices[n + 1] = vector3.y;
                    vertices[n + 2] = vector3.z;
                    n += vertexSize;
                    ++n4;
                }
                break;
            }
        }
    }

    public void transformUV(Matrix3 matrix) {
        this.transformUV(matrix, 0, this.getNumVertices());
    }

    protected void transformUV(Matrix3 matrix, int start, int count) {
        int n = this.getVertexAttribute((int)16).offset / 4;
        int n2 = this.getVertexSize() / 4;
        float[] fArray = new float[this.getNumVertices() * n2];
        this.getVertices(0, fArray.length, fArray);
        Mesh.transformUV(matrix, fArray, n2, n, start, count);
        this.setVertices(fArray, 0, fArray.length);
    }

    public static void transformUV(Matrix3 matrix, float[] vertices, int vertexSize, int offset, int start, int count) {
        if (start < 0 || count <= 0 || (start + count) * vertexSize > vertices.length) {
            throw new IndexOutOfBoundsException("start = " + start + ", count = " + count + ", vertexSize = " + vertexSize + ", length = " + vertices.length);
        }
        Vector2 vector2 = new Vector2();
        int n = offset + start * vertexSize;
        int n2 = 0;
        while (n2 < count) {
            vector2.set(vertices[n], vertices[n + 1]).mul(matrix);
            vertices[n] = vector2.x;
            vertices[n + 1] = vector2.y;
            n += vertexSize;
            ++n2;
        }
    }

    public Mesh copy(boolean isStatic, boolean removeDuplicates, int[] usage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getVertexSize() / 4;
        int n6 = this.getNumVertices();
        float[] fArray = new float[n6 * n5];
        this.getVertices(0, fArray.length, fArray);
        short[] sArray = null;
        VertexAttribute[] vertexAttributeArray = null;
        int n7 = 0;
        if (usage != null) {
            n4 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < usage.length) {
                if (this.getVertexAttribute(usage[n9]) != null) {
                    n4 += this.getVertexAttribute((int)usage[n9]).numComponents;
                    ++n8;
                }
                ++n9;
            }
            if (n4 > 0) {
                vertexAttributeArray = new VertexAttribute[n8];
                sArray = new short[n4];
                n9 = -1;
                n3 = -1;
                n2 = 0;
                while (n2 < usage.length) {
                    VertexAttribute vertexAttribute = this.getVertexAttribute(usage[n2]);
                    if (vertexAttribute != null) {
                        n = 0;
                        while (n < vertexAttribute.numComponents) {
                            sArray[++n9] = (short)(vertexAttribute.offset + n);
                            ++n;
                        }
                        vertexAttributeArray[++n3] = new VertexAttribute(vertexAttribute.usage, vertexAttribute.numComponents, vertexAttribute.alias);
                        n7 += vertexAttribute.numComponents;
                    }
                    ++n2;
                }
            }
        }
        if (sArray == null) {
            sArray = new short[n5];
            n4 = 0;
            while (n4 < n5) {
                int n10 = n4;
                sArray[n10] = n10;
                n4 = (short)(n4 + 1);
            }
            n7 = n5;
        }
        n4 = this.getNumIndices();
        short[] sArray2 = null;
        if (n4 > 0) {
            sArray2 = new short[n4];
            this.getIndices(sArray2);
            if (removeDuplicates || n7 != n5) {
                float[] fArray2 = new float[fArray.length];
                n3 = 0;
                n2 = 0;
                while (n2 < n4) {
                    int n11;
                    int n12;
                    int n13 = sArray2[n2] * n5;
                    n = -1;
                    if (removeDuplicates) {
                        n12 = 0;
                        while (n12 < n3 && n < 0) {
                            n11 = n12 * n7;
                            boolean bl = true;
                            int n14 = 0;
                            while (n14 < sArray.length && bl) {
                                if (fArray2[n11 + n14] != fArray[n13 + sArray[n14]]) {
                                    bl = false;
                                }
                                ++n14;
                            }
                            if (bl) {
                                n = n12;
                            }
                            n12 = (short)(n12 + 1);
                        }
                    }
                    if (n > 0) {
                        sArray2[n2] = n;
                    } else {
                        n12 = n3 * n7;
                        n11 = 0;
                        while (n11 < sArray.length) {
                            fArray2[n12 + n11] = fArray[n13 + sArray[n11]];
                            ++n11;
                        }
                        sArray2[n2] = (short)n3;
                        ++n3;
                    }
                    ++n2;
                }
                fArray = fArray2;
                n6 = n3;
            }
        }
        Mesh mesh = vertexAttributeArray == null ? new Mesh(isStatic, n6, sArray2 == null ? 0 : sArray2.length, this.getVertexAttributes()) : new Mesh(isStatic, n6, sArray2 == null ? 0 : sArray2.length, vertexAttributeArray);
        mesh.setVertices(fArray, 0, n6 * n7);
        mesh.setIndices(sArray2);
        return mesh;
    }

    public Mesh copy(boolean isStatic) {
        return this.copy(isStatic, false, null);
    }

    private static /* synthetic */ int[] a() {
        if (g != null) {
            return g;
        }
        int[] nArray = new int[VertexDataType.values().length];
        try {
            nArray[VertexDataType.VertexArray.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[VertexDataType.VertexBufferObject.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[VertexDataType.VertexBufferObjectSubData.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        g = nArray;
        return nArray;
    }

    @BA.Hide
    public static enum VertexDataType {
        VertexArray,
        VertexBufferObject,
        VertexBufferObjectSubData;

    }
}

