/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Gdx2DPixmap;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;

@BA.Hide
public class Pixmap
implements Disposable {
    private static Blending a = Blending.SourceOver;
    private Gdx2DPixmap b;
    private int c = 0;
    private boolean d;

    public static void setBlending(Blending blending) {
        a = blending;
        Gdx2DPixmap.setBlend(blending == Blending.None ? 0 : 1);
    }

    public static void setFilter(Filter filter) {
        Gdx2DPixmap.setScale(filter == Filter.NearestNeighbour ? 0 : 1);
    }

    public Pixmap(int width, int height, Format format) {
        this.b = new Gdx2DPixmap(width, height, Format.toGdx2DPixmapFormat(format));
        this.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fill();
    }

    public Pixmap(byte[] encodedData, int offset, int len) {
        try {
            this.b = new Gdx2DPixmap(encodedData, offset, len, 0);
            return;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load pixmap from image data", iOException);
        }
    }

    public Pixmap(FileHandle file) {
        try {
            byte[] byArray = file.readBytes();
            this.b = new Gdx2DPixmap(byArray, 0, byArray.length, 0);
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Couldn't load file: ".concat(String.valueOf(file)), exception);
        }
    }

    public Pixmap(Gdx2DPixmap pixmap) {
        this.b = pixmap;
    }

    public void setColor(int color) {
        this.c = color;
    }

    public void setColor(float r, float g, float b2, float a2) {
        this.c = Color.rgba8888(r, g, b2, a2);
    }

    public void setColor(Color color) {
        this.c = Color.rgba8888(color.r, color.g, color.b, color.a);
    }

    public void fill() {
        this.b.clear(this.c);
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.b.drawLine(x, y, x2, y2, this.c);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.b.drawRect(x, y, width, height, this.c);
    }

    public void drawPixmap(Pixmap pixmap, int x, int y) {
        this.drawPixmap(pixmap, x, y, 0, 0, pixmap.getWidth(), pixmap.getHeight());
    }

    public void drawPixmap(Pixmap pixmap, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        this.b.drawPixmap(pixmap.b, srcx, srcy, x, y, srcWidth, srcHeight);
    }

    public void drawPixmap(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        this.b.drawPixmap(pixmap.b, srcx, srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.b.fillRect(x, y, width, height, this.c);
    }

    public void drawCircle(int x, int y, int radius) {
        this.b.drawCircle(x, y, radius, this.c);
    }

    public void fillCircle(int x, int y, int radius) {
        this.b.fillCircle(x, y, radius, this.c);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.b.fillTriangle(x1, y1, x2, y2, x3, y3, this.c);
    }

    public int getPixel(int x, int y) {
        return this.b.getPixel(x, y);
    }

    public int getWidth() {
        return this.b.getWidth();
    }

    public int getHeight() {
        return this.b.getHeight();
    }

    @Override
    public void dispose() {
        if (this.d) {
            throw new GdxRuntimeException("Pixmap already disposed!");
        }
        this.b.dispose();
        this.d = true;
    }

    public void drawPixel(int x, int y) {
        this.b.setPixel(x, y, this.c);
    }

    public void drawPixel(int x, int y, int color) {
        this.b.setPixel(x, y, color);
    }

    public int getGLFormat() {
        return this.b.getGLFormat();
    }

    public int getGLInternalFormat() {
        return this.b.getGLInternalFormat();
    }

    public int getGLType() {
        return this.b.getGLType();
    }

    public ByteBuffer getPixels() {
        if (this.d) {
            throw new GdxRuntimeException("Pixmap already disposed");
        }
        return this.b.getPixels();
    }

    public Format getFormat() {
        return Format.fromGdx2DPixmapFormat(this.b.getFormat());
    }

    public static Blending getBlending() {
        return a;
    }

    @BA.Hide
    public static enum Blending {
        None,
        SourceOver;

    }

    @BA.Hide
    public static enum Filter {
        NearestNeighbour,
        BiLinear;

    }

    @BA.Hide
    public static enum Format {
        Alpha,
        Intensity,
        LuminanceAlpha,
        RGB565,
        RGBA4444,
        RGB888,
        RGBA8888;


        public static int toGdx2DPixmapFormat(Format format) {
            if (format == Alpha) {
                return 1;
            }
            if (format == Intensity) {
                return 1;
            }
            if (format == LuminanceAlpha) {
                return 2;
            }
            if (format == RGB565) {
                return 5;
            }
            if (format == RGBA4444) {
                return 6;
            }
            if (format == RGB888) {
                return 3;
            }
            if (format == RGBA8888) {
                return 4;
            }
            throw new GdxRuntimeException("Unknown Format: ".concat(String.valueOf((Object)format)));
        }

        public static Format fromGdx2DPixmapFormat(int format) {
            if (format == 1) {
                return Alpha;
            }
            if (format == 2) {
                return LuminanceAlpha;
            }
            if (format == 5) {
                return RGB565;
            }
            if (format == 6) {
                return RGBA4444;
            }
            if (format == 3) {
                return RGB888;
            }
            if (format == 4) {
                return RGBA8888;
            }
            throw new GdxRuntimeException("Unknown Gdx2DPixmap Format: ".concat(String.valueOf(format)));
        }

        public static int toGlFormat(Format format) {
            return Gdx2DPixmap.toGlFormat(Format.toGdx2DPixmapFormat(format));
        }

        public static int toGlType(Format format) {
            return Gdx2DPixmap.toGlType(Format.toGdx2DPixmapFormat(format));
        }
    }
}

