/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgPixmap;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.ByteArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

@BA.ShortName(value="lgPixmapIO")
public class PixmapIO {
    public static void WriteCIM(FileHandle File2, lgPixmap Pixmap2) {
        a.a(File2, Pixmap2.getInternalObject());
    }

    @BA.Hide
    public static void writeCIM(FileHandle file, Pixmap pixmap) {
        a.a(file, pixmap);
    }

    public static lgPixmap ReadCIM(FileHandle File2) {
        return new lgPixmap(a.a(File2));
    }

    @BA.Hide
    public static Pixmap readCIM(FileHandle file) {
        return a.a(file);
    }

    public static void WritePNG(FileHandle File2, lgPixmap Pixmap2) {
        PixmapIO.writePNG(File2, Pixmap2.getInternalObject());
    }

    @BA.Hide
    public static void writePNG(FileHandle file, Pixmap pixmap) {
        try {
            PNG pNG = new PNG((int)((float)(pixmap.getWidth() * pixmap.getHeight()) * 1.5f));
            try {
                pNG.setFlipY(false);
                pNG.write(file, pixmap);
            }
            finally {
                pNG.dispose();
            }
            return;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error writing PNG: ".concat(String.valueOf(file)), iOException);
        }
    }

    static final class a {
        private static final byte[] a = new byte[32000];
        private static final byte[] b = new byte[32000];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void a(FileHandle fileHandle, Pixmap pixmap) {
            DataOutputStream dataOutputStream = null;
            try {
                try {
                    DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(fileHandle.write(false));
                    dataOutputStream = new DataOutputStream(deflaterOutputStream);
                    dataOutputStream.writeInt(pixmap.getWidth());
                    dataOutputStream.writeInt(pixmap.getHeight());
                    dataOutputStream.writeInt(Pixmap.Format.toGdx2DPixmapFormat(pixmap.getFormat()));
                    ByteBuffer byteBuffer = pixmap.getPixels();
                    byteBuffer.position(0);
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.limit(byteBuffer2.capacity());
                    int n = byteBuffer.capacity() % 32000;
                    int n2 = byteBuffer.capacity() / 32000;
                    byte[] byArray = a;
                    synchronized (a) {
                        int n3 = 0;
                        while (n3 < n2) {
                            byteBuffer.get(a);
                            dataOutputStream.write(a);
                            ++n3;
                        }
                        byteBuffer.get(a, 0, n);
                        dataOutputStream.write(a, 0, n);
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        byteBuffer.position(0);
                        ByteBuffer byteBuffer3 = byteBuffer;
                        byteBuffer3.limit(byteBuffer3.capacity());
                    }
                }
                catch (Exception exception) {
                    throw new GdxRuntimeException("Couldn't write Pixmap to file '" + fileHandle + "'", exception);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(dataOutputStream);
                throw throwable;
            }
            {
                StreamUtils.closeQuietly(dataOutputStream);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Pixmap a(FileHandle fileHandle) {
            Pixmap pixmap;
            DataInputStream dataInputStream = null;
            try {
                dataInputStream = new DataInputStream(new InflaterInputStream(new BufferedInputStream(fileHandle.read())));
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                Pixmap.Format format = Pixmap.Format.fromGdx2DPixmapFormat(dataInputStream.readInt());
                Pixmap pixmap2 = new Pixmap(n, n2, format);
                ByteBuffer byteBuffer = pixmap2.getPixels();
                byteBuffer.position(0);
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.capacity());
                byte[] byArray = b;
                synchronized (b) {
                    while (true) {
                        int n3;
                        if ((n3 = dataInputStream.read(b)) <= 0) {
                            // ** MonitorExit[var7_8] (shouldn't be in output)
                            break;
                        }
                        byteBuffer.put(b, 0, n3);
                    }
                    byteBuffer.position(0);
                    ByteBuffer byteBuffer3 = byteBuffer;
                    byteBuffer3.limit(byteBuffer3.capacity());
                    pixmap = pixmap2;
                }
            }
            catch (Exception exception) {
                try {
                    throw new GdxRuntimeException("Couldn't read Pixmap from file '" + fileHandle + "'", exception);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(dataInputStream);
                    throw throwable;
                }
            }
            {
                StreamUtils.closeQuietly(dataInputStream);
                return pixmap;
            }
        }
    }

    @BA.Hide
    public static class PNG
    implements Disposable {
        private static final byte[] a = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        private final a b;
        private final Deflater c;
        private ByteArray d;
        private ByteArray e;
        private ByteArray f;
        private boolean g = true;
        private int h;

        public PNG() {
            this(16384);
        }

        public PNG(int initialBufferSize) {
            this.b = new a(initialBufferSize);
            this.c = new Deflater();
        }

        public void setFlipY(boolean flipY) {
            this.g = flipY;
        }

        public void setCompression(int level) {
            this.c.setLevel(level);
        }

        public void write(FileHandle file, Pixmap pixmap) throws IOException {
            OutputStream outputStream = file.write(false);
            try {
                this.write(outputStream, pixmap);
            }
            finally {
                StreamUtils.closeQuietly(outputStream);
            }
        }

        public void write(OutputStream output, Pixmap pixmap) throws IOException {
            int n;
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)this.b, this.c);
            DataOutputStream dataOutputStream = new DataOutputStream(output);
            dataOutputStream.write(a);
            this.b.writeInt(1229472850);
            this.b.writeInt(pixmap.getWidth());
            this.b.writeInt(pixmap.getHeight());
            this.b.writeByte(8);
            this.b.writeByte(6);
            this.b.writeByte(0);
            this.b.writeByte(0);
            this.b.writeByte(0);
            this.b.a(dataOutputStream);
            this.b.writeInt(1229209940);
            this.c.reset();
            int n2 = pixmap.getWidth() * 4;
            if (this.d == null) {
                this.d = new ByteArray(n2);
                byArray3 = this.d.items;
                this.e = new ByteArray(n2);
                byArray2 = this.e.items;
                this.f = new ByteArray(n2);
                byArray = this.f.items;
            } else {
                byArray3 = this.d.ensureCapacity(n2);
                byArray2 = this.e.ensureCapacity(n2);
                byArray = this.f.ensureCapacity(n2);
                int n3 = 0;
                n = this.h;
                while (n3 < n) {
                    byArray[n3] = 0;
                    ++n3;
                }
            }
            this.h = n2;
            ByteBuffer byteBuffer = pixmap.getPixels();
            n = byteBuffer.position();
            boolean bl = pixmap.getFormat() == Pixmap.Format.RGBA8888;
            int n4 = 0;
            int n5 = pixmap.getHeight();
            while (n4 < n5) {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10 = n9 = this.g ? n5 - n4 - 1 : n4;
                if (bl) {
                    byteBuffer.position(n9 * n2);
                    byteBuffer.get(byArray2, 0, n2);
                } else {
                    n8 = 0;
                    n7 = 0;
                    while (n8 < pixmap.getWidth()) {
                        n6 = pixmap.getPixel(n8, n9);
                        byArray2[n7++] = (byte)(n6 >> 24 & 0xFF);
                        byArray2[n7++] = (byte)(n6 >> 16 & 0xFF);
                        byArray2[n7++] = (byte)(n6 >> 8 & 0xFF);
                        byArray2[n7++] = (byte)(n6 & 0xFF);
                        ++n8;
                    }
                }
                byArray3[0] = (byte)(byArray2[0] - byArray[0]);
                byArray3[1] = (byte)(byArray2[1] - byArray[1]);
                byArray3[2] = (byte)(byArray2[2] - byArray[2]);
                byArray3[3] = (byte)(byArray2[3] - byArray[3]);
                n8 = 4;
                while (n8 < n2) {
                    int n11;
                    int n12;
                    n7 = byArray2[n8 - 4] & 0xFF;
                    n6 = byArray[n8] & 0xFF;
                    int n13 = byArray[n8 - 4] & 0xFF;
                    int n14 = n7 + n6 - n13;
                    int n15 = n14 - n7;
                    if (n15 < 0) {
                        n15 = -n15;
                    }
                    if ((n12 = n14 - n6) < 0) {
                        n12 = -n12;
                    }
                    if ((n11 = n14 - n13) < 0) {
                        n11 = -n11;
                    }
                    if (n15 <= n12 && n15 <= n11) {
                        n13 = n7;
                    } else if (n12 <= n11) {
                        n13 = n6;
                    }
                    byArray3[n8] = (byte)(byArray2[n8] - n13);
                    ++n8;
                }
                deflaterOutputStream.write(4);
                deflaterOutputStream.write(byArray3, 0, n2);
                byte[] byArray4 = byArray2;
                byArray2 = byArray;
                byArray = byArray4;
                ++n4;
            }
            byteBuffer.position(n);
            deflaterOutputStream.finish();
            this.b.a(dataOutputStream);
            this.b.writeInt(1229278788);
            this.b.a(dataOutputStream);
            output.flush();
        }

        @Override
        public void dispose() {
            this.c.end();
        }

        static final class a
        extends DataOutputStream {
            private ByteArrayOutputStream a;
            private CRC32 b;

            a(int n) {
                this(new ByteArrayOutputStream(n), new CRC32());
            }

            private a(ByteArrayOutputStream byteArrayOutputStream, CRC32 cRC32) {
                super(new CheckedOutputStream(byteArrayOutputStream, cRC32));
                this.a = byteArrayOutputStream;
                this.b = cRC32;
            }

            public final void a(DataOutputStream dataOutputStream) throws IOException {
                this.flush();
                dataOutputStream.writeInt(this.a.size() - 4);
                this.a.writeTo(dataOutputStream);
                dataOutputStream.writeInt((int)this.b.getValue());
                this.a.reset();
                this.b.reset();
            }
        }
    }
}

