/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

@BA.Hide
public class Texture
extends GLTexture {
    private static AssetManager a;
    private static Map<Application, Array<Texture>> b;
    private TextureData c;

    static {
        b = new HashMap<Application, Array<Texture>>();
    }

    public Texture(String internalPath) {
        this(Gdx.files.internal(internalPath));
    }

    public Texture(FileHandle file) {
        this(file, null, false);
    }

    public Texture(FileHandle file, boolean useMipMaps) {
        this(file, null, useMipMaps);
    }

    public Texture(FileHandle file, Pixmap.Format format, boolean useMipMaps) {
        this(TextureData.Factory.loadFromFile(file, format, useMipMaps));
    }

    public Texture(Pixmap pixmap) {
        this(new PixmapTextureData(pixmap, null, false, false));
    }

    public Texture(Pixmap pixmap, boolean useMipMaps) {
        this(new PixmapTextureData(pixmap, null, useMipMaps, false));
    }

    public Texture(Pixmap pixmap, Pixmap.Format format, boolean useMipMaps) {
        this(new PixmapTextureData(pixmap, format, useMipMaps, false));
    }

    public Texture(int width, int height, Pixmap.Format format) {
        this(new PixmapTextureData(new Pixmap(width, height, format), null, false, true));
    }

    public Texture(TextureData data) {
        this(3553, Gdx.gl.glGenTexture(), data);
    }

    protected Texture(int glTarget, int glHandle, TextureData data) {
        super(glTarget, glHandle);
        this.load(data);
        if (data.isManaged()) {
            Texture texture = this;
            Application application = Gdx.app;
            Array<Texture> array = b.get(application);
            if (array == null) {
                array = new Array();
            }
            array.add(texture);
            b.put(application, array);
        }
    }

    public void load(TextureData data) {
        if (this.c != null && data.isManaged() != this.c.isManaged()) {
            throw new GdxRuntimeException("New data must have the same managed status as the old data");
        }
        this.c = data;
        if (!data.isPrepared()) {
            data.prepare();
        }
        this.bind();
        Texture.uploadImageData(3553, data);
        Texture texture = this;
        texture.setFilter(texture.minFilter, this.magFilter);
        Texture texture2 = this;
        texture2.setWrap(texture2.uWrap, this.vWrap);
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    @Override
    protected void reload() {
        if (!this.isManaged()) {
            throw new GdxRuntimeException("Tried to reload unmanaged Texture");
        }
        this.glHandle = Gdx.gl.glGenTexture();
        Texture texture = this;
        texture.load(texture.c);
    }

    public void draw(Pixmap pixmap, int x, int y) {
        if (this.c.isManaged()) {
            throw new GdxRuntimeException("can't draw to a managed texture");
        }
        this.bind();
        Gdx.gl.glTexSubImage2D(this.glTarget, 0, x, y, pixmap.getWidth(), pixmap.getHeight(), pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
    }

    @Override
    public int getWidth() {
        return this.c.getWidth();
    }

    @Override
    public int getHeight() {
        return this.c.getHeight();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    public TextureData getTextureData() {
        return this.c;
    }

    @Override
    public boolean isManaged() {
        return this.c.isManaged();
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.c.isManaged() && b.get(Gdx.app) != null) {
            b.get(Gdx.app).removeValue(this, true);
        }
    }

    public static void clearAllTextures(Application app) {
        b.remove(app);
    }

    public static void invalidateAllTextures(Application app) {
        Array<Texture> array = b.get(app);
        if (array == null) {
            return;
        }
        if (a == null) {
            int n = 0;
            while (n < array.size) {
                array.get(n).reload();
                ++n;
            }
            return;
        }
        a.finishLoading();
        Array<Texture> array2 = new Array<Texture>(array);
        for (Texture texture : array2) {
            String string = a.getAssetFileName(texture);
            if (string == null) {
                texture.reload();
                continue;
            }
            final int n = a.getReferenceCount(string);
            a.setReferenceCount(string, 0);
            texture.glHandle = 0;
            TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
            new TextureLoader.TextureParameter().textureData = texture.getTextureData();
            textureParameter.minFilter = texture.getMinFilter();
            textureParameter.magFilter = texture.getMagFilter();
            textureParameter.wrapU = texture.getUWrap();
            textureParameter.wrapV = texture.getVWrap();
            textureParameter.genMipMaps = texture.c.useMipMaps();
            textureParameter.texture = texture;
            textureParameter.loadedCallback = new AssetLoaderParameters.LoadedCallback(){

                @Override
                public final void finishedLoading(AssetManager assetManager, String fileName, Class type) {
                    assetManager.setReferenceCount(fileName, n);
                }
            };
            a.unload(string);
            texture.glHandle = Gdx.gl.glGenTexture();
            a.load(string, Texture.class, textureParameter);
        }
        array.clear();
        array.addAll(array2);
    }

    public static void setAssetManager(AssetManager manager) {
        a = manager;
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed textures/app: { ");
        for (Application application : b.keySet()) {
            stringBuilder.append(Texture.b.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedTextures() {
        return Texture.b.get((Object)Gdx.app).size;
    }

    @BA.Hide
    public static enum TextureFilter {
        Nearest(9728),
        Linear(9729),
        MipMap(9987),
        MipMapNearestNearest(9984),
        MipMapLinearNearest(9985),
        MipMapNearestLinear(9986),
        MipMapLinearLinear(9987);

        private int a;

        private TextureFilter(int glEnum) {
            this.a = glEnum;
        }

        public final boolean isMipMap() {
            return this.a != 9728 && this.a != 9729;
        }

        public final int getGLEnum() {
            return this.a;
        }
    }

    @BA.Hide
    public static enum TextureWrap {
        MirroredRepeat(33648),
        ClampToEdge(33071),
        Repeat(10497);

        private int a;

        private TextureWrap(int glEnum) {
            this.a = glEnum;
        }

        public final int getGLEnum() {
            return this.a;
        }
    }
}

