/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import anywheresoftware.b4a.BA;

@BA.ShortName(value="lgVertexAttribute")
public final class VertexAttribute {
    @BA.Hide
    public int usage;
    @BA.Hide
    public int numComponents;
    @BA.Hide
    public boolean normalized;
    @BA.Hide
    public int type;
    @BA.Hide
    public int offset;
    public String alias;
    public int unit;
    private int a;

    public final int getUsage() {
        return this.usage;
    }

    public final int getNumComponents() {
        return this.numComponents;
    }

    public final boolean getNormalized() {
        return this.normalized;
    }

    public final int getType() {
        return this.type;
    }

    public final int getOffset() {
        return this.offset;
    }

    public VertexAttribute() {
    }

    public final void Initialize(int Usage2, int NumComponents, String Alias) {
        this.Initialize2(Usage2, NumComponents, Alias, 0);
    }

    public final void Initialize2(int Usage2, int NumComponents, String Alias, int Index) {
        this.usage = Usage2;
        this.numComponents = NumComponents;
        this.type = Usage2 == 4 ? 5121 : 5126;
        this.normalized = Usage2 == 4;
        this.alias = Alias;
        this.unit = Index;
        this.a = Integer.numberOfTrailingZeros(Usage2);
    }

    public VertexAttribute(int usage, int numComponents, String alias) {
        this(usage, numComponents, alias, 0);
    }

    public VertexAttribute(int usage, int numComponents, String alias, int index) {
        this(usage, numComponents, usage == 4 ? 5121 : 5126, usage == 4, alias, index);
    }

    private VertexAttribute(int usage, int type, boolean normalized, String alias) {
        this(usage, 4, type, normalized, alias, 0);
    }

    private VertexAttribute(int usage, int numComponents, int type, boolean normalized, String alias, int index) {
        this.usage = usage;
        this.numComponents = numComponents;
        this.type = type;
        this.normalized = normalized;
        this.alias = alias;
        this.unit = index;
        this.a = Integer.numberOfTrailingZeros(usage);
    }

    public static VertexAttribute Position() {
        return new VertexAttribute(1, 3, "a_position");
    }

    public static VertexAttribute TexCoords(int unit) {
        return new VertexAttribute(16, 2, "a_texCoord".concat(String.valueOf(unit)), unit);
    }

    public static VertexAttribute Normal() {
        return new VertexAttribute(8, 3, "a_normal");
    }

    public static VertexAttribute ColorPacked() {
        return new VertexAttribute(4, 5121, true, "a_color");
    }

    public static VertexAttribute ColorUnpacked() {
        return new VertexAttribute(2, 5126, false, "a_color");
    }

    public static VertexAttribute Tangent() {
        return new VertexAttribute(128, 3, "a_tangent");
    }

    public static VertexAttribute Binormal() {
        return new VertexAttribute(256, 3, "a_binormal");
    }

    public static VertexAttribute BoneWeight(int unit) {
        return new VertexAttribute(64, 2, "a_boneWeight".concat(String.valueOf(unit)), unit);
    }

    public final boolean equals(Object obj) {
        while (obj instanceof VertexAttribute) {
            obj = (VertexAttribute)obj;
        }
        return false;
    }

    public final boolean equals2(VertexAttribute other) {
        return other != null && this.usage == other.usage && this.numComponents == other.numComponents && this.alias.equals(other.alias) && this.unit == other.unit;
    }

    public final int getKey() {
        return (this.a << 8) + (this.unit & 0xFF);
    }

    public final int hashCode() {
        int n = this.getKey();
        n = 541 * n + this.numComponents;
        return 541 * n + this.alias.hashCode();
    }
}

