/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;
import java.util.NoSuchElementException;

@BA.ShortName(value="lgVertexAttributes")
public final class VertexAttributes
implements Iterable<VertexAttribute> {
    private VertexAttribute[] a;
    @BA.Hide
    public int vertexSize;
    private long b = -1L;
    private a<VertexAttribute> c;

    public final int getVertexSize() {
        return this.vertexSize;
    }

    public VertexAttributes(VertexAttribute ... attributes) {
        this.Initialize(attributes);
    }

    public VertexAttributes() {
    }

    public final void Initialize(VertexAttribute ... attributes) {
        if (attributes.length == 0) {
            throw new IllegalArgumentException("attributes must be >= 1");
        }
        VertexAttribute[] vertexAttributeArray = new VertexAttribute[attributes.length];
        int n = 0;
        while (n < attributes.length) {
            vertexAttributeArray[n] = attributes[n];
            ++n;
        }
        this.a = vertexAttributeArray;
        this.vertexSize = this.a();
    }

    public final int getOffset(int usage) {
        VertexAttribute vertexAttribute = this.findByUsage(usage);
        if (vertexAttribute == null) {
            return -1;
        }
        return vertexAttribute.offset / 4;
    }

    public final VertexAttribute findByUsage(int usage) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.get((int)n2).usage == usage) {
                return this.get(n2);
            }
            ++n2;
        }
        return null;
    }

    private int a() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.a.length) {
            VertexAttribute vertexAttribute = this.a[n2];
            this.a[n2].offset = n;
            n = vertexAttribute.usage == 4 ? (n += 4) : (n += 4 * vertexAttribute.numComponents);
            ++n2;
        }
        return n;
    }

    public final int size() {
        return this.a.length;
    }

    public final VertexAttribute get(int index) {
        return this.a[index];
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = 0;
        while (n < this.a.length) {
            stringBuilder.append("(");
            stringBuilder.append(this.a[n].alias);
            stringBuilder.append(", ");
            stringBuilder.append(this.a[n].usage);
            stringBuilder.append(", ");
            stringBuilder.append(this.a[n].numComponents);
            stringBuilder.append(", ");
            stringBuilder.append(this.a[n].offset);
            stringBuilder.append(")");
            stringBuilder.append("\n");
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VertexAttributes)) {
            return false;
        }
        VertexAttributes vertexAttributes = (VertexAttributes)obj;
        if (this.a.length != vertexAttributes.a.length) {
            return false;
        }
        int n = 0;
        while (n < this.a.length) {
            if (!this.a[n].equals(vertexAttributes.a[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final long getMask() {
        if (this.b == -1L) {
            long l = 0L;
            int n = 0;
            while (n < this.a.length) {
                l |= (long)this.a[n].usage;
                ++n;
            }
            this.b = l;
        }
        return this.b;
    }

    @Override
    @BA.Hide
    public final Iterator<VertexAttribute> iterator() {
        if (this.c == null) {
            this.c = new a<VertexAttribute>(this.a);
        }
        return this.c.iterator();
    }

    static final class a<T>
    implements Iterable<T> {
        private final T[] a;
        private b b;
        private b c;

        public a(T[] TArray) {
            this.a = TArray;
        }

        @Override
        public final Iterator<T> iterator() {
            if (this.b == null) {
                this.b = new b<T>(this.a);
                this.c = new b<T>(this.a);
            }
            if (!this.b.b) {
                this.b.a = 0;
                this.b.b = true;
                this.c.b = false;
                return this.b;
            }
            this.c.a = 0;
            this.c.b = true;
            this.b.b = false;
            return this.c;
        }
    }

    static final class b<T>
    implements Iterable<T>,
    Iterator<T> {
        private final T[] c;
        int a;
        boolean b = true;

        public b(T[] TArray) {
            this.c = TArray;
        }

        @Override
        public final boolean hasNext() {
            if (!this.b) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.a < this.c.length;
        }

        @Override
        public final T next() {
            if (this.a >= this.c.length) {
                throw new NoSuchElementException(String.valueOf(this.a));
            }
            if (!this.b) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.c[this.a++];
        }

        @Override
        public final void remove() {
            throw new GdxRuntimeException("Remove not allowed.");
        }

        @Override
        public final Iterator<T> iterator() {
            return this;
        }
    }

    @BA.ShortName(value="lgVertexAttributesUsage")
    public static final class Usage {
        public static final int Position = 1;
        public static final int ColorUnpacked = 2;
        public static final int ColorPacked = 4;
        public static final int Normal = 8;
        public static final int TextureCoordinates = 16;
        public static final int Generic = 32;
        public static final int BoneWeight = 64;
        public static final int Tangent = 128;
        public static final int BiNormal = 256;
    }
}

