/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

@BA.Hide
public class BitmapFont
implements Disposable {
    final BitmapFontData a;
    TextureRegion[] b;
    private final BitmapFontCache c;
    private boolean d;
    private boolean e;
    private boolean f;

    public BitmapFont() {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.png"), false, true);
    }

    public BitmapFont(boolean flip) {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.png"), flip, true);
    }

    public BitmapFont(FileHandle fontFile, TextureRegion region) {
        this(fontFile, region, false);
    }

    public BitmapFont(FileHandle fontFile, TextureRegion region, boolean flip) {
        this(new BitmapFontData(fontFile, flip), region, true);
    }

    public BitmapFont(FileHandle fontFile) {
        this(fontFile, false);
    }

    public BitmapFont(FileHandle fontFile, boolean flip) {
        this(new BitmapFontData(fontFile, flip), (TextureRegion)null, true);
    }

    public BitmapFont(FileHandle fontFile, FileHandle imageFile, boolean flip) {
        this(fontFile, imageFile, flip, true);
    }

    public BitmapFont(FileHandle fontFile, FileHandle imageFile, boolean flip, boolean integer) {
        this(new BitmapFontData(fontFile, flip), new TextureRegion(new Texture(imageFile, false)), integer);
        this.f = true;
    }

    public BitmapFont(BitmapFontData data, TextureRegion region, boolean integer) {
        TextureRegion[] textureRegionArray;
        if (region != null) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = region;
        } else {
            textureRegionArray = null;
        }
        this(data, textureRegionArray, integer);
    }

    public BitmapFont(BitmapFontData data, TextureRegion[] pageRegions, boolean integer) {
        this.d = data.flipped;
        this.a = data;
        this.e = integer;
        if (pageRegions == null || pageRegions.length == 0) {
            int n = data.imagePaths.length;
            this.b = new TextureRegion[n];
            int n2 = 0;
            while (n2 < n) {
                FileHandle fileHandle = data.fontFile == null ? Gdx.files.internal(data.imagePaths[n2]) : Gdx.files.getFileHandle(data.imagePaths[n2], data.fontFile.type());
                this.b[n2] = new TextureRegion(new Texture(fileHandle, false));
                ++n2;
            }
            this.f = true;
        } else {
            this.b = pageRegions;
            this.f = false;
        }
        this.c = this.newFontCache();
        this.load(data);
    }

    protected void load(BitmapFontData data) {
        Glyph[][] glyphArray = data.glyphs;
        int n = data.glyphs.length;
        int n2 = 0;
        while (n2 < n) {
            Glyph[] glyphArray2 = glyphArray[n2];
            if (glyphArray2 != null) {
                Glyph[] glyphArray3 = glyphArray2;
                int n3 = glyphArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Glyph glyph = glyphArray3[n4];
                    if (glyph != null) {
                        data.setGlyphRegion(glyph, this.b[glyph.page]);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (data.missingGlyph != null) {
            BitmapFontData bitmapFontData = data;
            bitmapFontData.setGlyphRegion(bitmapFontData.missingGlyph, this.b[data.missingGlyph.page]);
        }
    }

    public TextBounds draw(Batch batch, CharSequence str, float x, float y) {
        this.c.clear();
        TextBounds textBounds = this.c.addText(str, x, y, 0, str.length());
        this.c.draw(batch);
        return textBounds;
    }

    public TextBounds draw(Batch batch, CharSequence str, float x, float y, int start, int end) {
        this.c.clear();
        TextBounds textBounds = this.c.addText(str, x, y, start, end);
        this.c.draw(batch);
        return textBounds;
    }

    public TextBounds drawMultiLine(Batch batch, CharSequence str, float x, float y) {
        this.c.clear();
        TextBounds textBounds = this.c.addMultiLineText(str, x, y, 0.0f, 8);
        this.c.draw(batch);
        return textBounds;
    }

    public TextBounds drawMultiLine(Batch batch, CharSequence str, float x, float y, float alignmentWidth, int alignment) {
        this.c.clear();
        TextBounds textBounds = this.c.addMultiLineText(str, x, y, alignmentWidth, alignment);
        this.c.draw(batch);
        return textBounds;
    }

    public TextBounds drawWrapped(Batch batch, CharSequence str, float x, float y, float wrapWidth) {
        this.c.clear();
        TextBounds textBounds = this.c.addWrappedText(str, x, y, wrapWidth, 8);
        this.c.draw(batch);
        return textBounds;
    }

    public TextBounds drawWrapped(Batch batch, CharSequence str, float x, float y, float wrapWidth, int alignment) {
        this.c.clear();
        TextBounds textBounds = this.c.addWrappedText(str, x, y, wrapWidth, alignment);
        this.c.draw(batch);
        return textBounds;
    }

    public TextBounds getBounds(CharSequence str) {
        return this.getBounds(str, 0, str.length(), this.c.getBounds());
    }

    public TextBounds getBounds(CharSequence str, TextBounds textBounds) {
        return this.getBounds(str, 0, str.length(), textBounds);
    }

    public TextBounds getBounds(CharSequence str, int start, int end) {
        return this.getBounds(str, start, end, this.c.getBounds());
    }

    public TextBounds getBounds(CharSequence str, int start, int end, TextBounds textBounds) {
        char c2;
        BitmapFontData bitmapFontData = this.a;
        int n = 0;
        Glyph glyph = null;
        while (start < end) {
            if ((c2 = str.charAt(start++)) == '[' && bitmapFontData.markupEnabled) {
                if (start >= end || str.charAt(start) != '[') {
                    while (start < end && str.charAt(start) != ']') {
                        ++start;
                    }
                    ++start;
                    continue;
                }
                ++start;
            }
            if ((glyph = bitmapFontData.getGlyph(c2)) == null) continue;
            n = glyph.xadvance;
            break;
        }
        while (start < end) {
            Glyph glyph2;
            if ((c2 = str.charAt(start++)) == '[' && bitmapFontData.markupEnabled) {
                if (start >= end || str.charAt(start) != '[') {
                    while (start < end && str.charAt(start) != ']') {
                        ++start;
                    }
                    ++start;
                    continue;
                }
                ++start;
            }
            if ((glyph2 = bitmapFontData.getGlyph(c2)) == null) continue;
            n += glyph.getKerning(c2);
            glyph = glyph2;
            n += glyph2.xadvance;
        }
        textBounds.width = (float)n * bitmapFontData.scaleX;
        textBounds.height = bitmapFontData.capHeight;
        return textBounds;
    }

    public TextBounds getMultiLineBounds(CharSequence str) {
        return this.getMultiLineBounds(str, this.c.getBounds());
    }

    public TextBounds getMultiLineBounds(CharSequence str, TextBounds textBounds) {
        int n = 0;
        float f = 0.0f;
        int n2 = 0;
        int n3 = str.length();
        while (n < n3) {
            int n4 = BitmapFont.a(str, n);
            float f2 = this.getBounds((CharSequence)str, (int)n, (int)n4).width;
            f = Math.max(f, f2);
            n = n4 + 1;
            ++n2;
        }
        textBounds.width = f;
        textBounds.height = this.a.capHeight + (float)(n2 - 1) * this.a.lineHeight;
        return textBounds;
    }

    public TextBounds getWrappedBounds(CharSequence str, float wrapWidth) {
        return this.getWrappedBounds(str, wrapWidth, this.c.getBounds());
    }

    public TextBounds getWrappedBounds(CharSequence str, float wrapWidth, TextBounds textBounds) {
        if (wrapWidth <= 0.0f) {
            wrapWidth = 2.1474836E9f;
        }
        int n = 0;
        int n2 = 0;
        int n3 = str.length();
        float f = 0.0f;
        while (n < n3) {
            int n4 = BitmapFont.a(str, n);
            int n5 = n + this.computeVisibleGlyphs(str, n, n4, wrapWidth);
            int n6 = n5 + 1;
            if (n5 < n4) {
                while (n5 > n) {
                    if (this.a.isWhitespace(str.charAt(n5)) || this.a.isBreakChar(str.charAt(n5 - 1))) break;
                    --n5;
                }
                if (n5 == n) {
                    if (n6 > n + 1) {
                        --n6;
                    }
                    n5 = n6;
                } else {
                    n6 = n5;
                    while (n6 < n3) {
                        char c2 = str.charAt(n6);
                        if (!this.a.isWhitespace(c2)) break;
                        ++n6;
                        if (c2 == '\n') break;
                    }
                    while (n5 > n) {
                        if (!this.a.isWhitespace(str.charAt(n5 - 1))) break;
                        --n5;
                    }
                }
            }
            if (n5 > n) {
                float f2 = this.getBounds((CharSequence)str, (int)n, (int)n5).width;
                f = Math.max(f, f2);
            }
            n = n6;
            ++n2;
        }
        textBounds.width = f;
        textBounds.height = this.a.capHeight + (float)(n2 - 1) * this.a.lineHeight;
        return textBounds;
    }

    public void computeGlyphAdvancesAndPositions(CharSequence str, FloatArray glyphAdvances, FloatArray glyphPositions) {
        glyphAdvances.clear();
        glyphPositions.clear();
        int n = 0;
        int n2 = str.length();
        float f = 0.0f;
        Glyph glyph = null;
        BitmapFontData bitmapFontData = this.a;
        if (bitmapFontData.scaleX == 1.0f) {
            while (n < n2) {
                char c2 = str.charAt(n);
                Glyph glyph2 = bitmapFontData.getGlyph(c2);
                if (glyph2 != null) {
                    if (glyph != null) {
                        f += (float)glyph.getKerning(c2);
                    }
                    glyph = glyph2;
                    glyphAdvances.add(glyph2.xadvance);
                    glyphPositions.add(f);
                    f += (float)glyph2.xadvance;
                }
                ++n;
            }
            glyphAdvances.add(0.0f);
            glyphPositions.add(f);
            return;
        }
        float f2 = this.a.scaleX;
        while (n < n2) {
            char c3 = str.charAt(n);
            Glyph glyph3 = bitmapFontData.getGlyph(c3);
            if (glyph3 != null) {
                if (glyph != null) {
                    f += (float)glyph.getKerning(c3) * f2;
                }
                glyph = glyph3;
                float f3 = (float)glyph3.xadvance * f2;
                glyphAdvances.add(f3);
                glyphPositions.add(f);
                f += f3;
            }
            ++n;
        }
        glyphAdvances.add(0.0f);
        glyphPositions.add(f);
    }

    public int computeVisibleGlyphs(CharSequence str, int start, int end, float availableWidth) {
        BitmapFontData bitmapFontData = this.a;
        int n = start;
        float f = 0.0f;
        Glyph glyph = null;
        availableWidth /= bitmapFontData.scaleX;
        while (n < end) {
            char c2 = str.charAt(n);
            if (c2 == '[' && bitmapFontData.markupEnabled && (++n >= end || str.charAt(n) != '[')) {
                while (n < end && str.charAt(n) != ']') {
                    ++n;
                }
            } else {
                Glyph glyph2 = bitmapFontData.getGlyph(c2);
                if (glyph2 != null) {
                    if (glyph != null) {
                        f += (float)glyph.getKerning(c2);
                    }
                    if (f + (float)glyph2.xadvance - availableWidth > 0.001f) break;
                    f += (float)glyph2.xadvance;
                    glyph = glyph2;
                }
            }
            ++n;
        }
        return n - start;
    }

    public Color getColor() {
        return this.c.getColor();
    }

    public void setColor(Color color) {
        this.c.setColor(color);
    }

    public void setColor(float r, float g, float b2, float a2) {
        this.c.setColor(r, g, b2, a2);
    }

    public float getScaleX() {
        return this.a.scaleX;
    }

    public float getScaleY() {
        return this.a.scaleY;
    }

    public TextureRegion getRegion() {
        return this.b[0];
    }

    public TextureRegion[] getRegions() {
        return this.b;
    }

    public TextureRegion getRegion(int index) {
        return this.b[index];
    }

    public float getLineHeight() {
        return this.a.lineHeight;
    }

    public float getSpaceWidth() {
        return this.a.spaceWidth;
    }

    public float getXHeight() {
        return this.a.xHeight;
    }

    public float getCapHeight() {
        return this.a.capHeight;
    }

    public float getAscent() {
        return this.a.ascent;
    }

    public float getDescent() {
        return this.a.descent;
    }

    public boolean isFlipped() {
        return this.d;
    }

    @Override
    public void dispose() {
        if (this.f) {
            int n = 0;
            while (n < this.b.length) {
                this.b[n].getTexture().dispose();
                ++n;
            }
        }
    }

    public void setFixedWidthGlyphs(CharSequence glyphs) {
        Glyph glyph;
        BitmapFontData bitmapFontData = this.a;
        int n = 0;
        int n2 = 0;
        int n3 = glyphs.length();
        while (n2 < n3) {
            glyph = bitmapFontData.getGlyph(glyphs.charAt(n2));
            if (glyph != null && glyph.xadvance > n) {
                n = glyph.xadvance;
            }
            ++n2;
        }
        n2 = 0;
        n3 = glyphs.length();
        while (n2 < n3) {
            glyph = bitmapFontData.getGlyph(glyphs.charAt(n2));
            if (glyph != null) {
                glyph.xoffset += Math.round((n - glyph.xadvance) / 2);
                glyph.xadvance = n;
                glyph.kerning = null;
                glyph.fixedWidth = true;
            }
            ++n2;
        }
    }

    public boolean containsCharacter(char character) {
        return this.a.getGlyph(character) != null;
    }

    public void setUseIntegerPositions(boolean integer) {
        this.e = integer;
        this.c.setUseIntegerPositions(integer);
    }

    public boolean usesIntegerPositions() {
        return this.e;
    }

    public BitmapFontCache getCache() {
        return this.c;
    }

    public BitmapFontData getData() {
        return this.a;
    }

    public boolean ownsTexture() {
        return this.f;
    }

    public void setOwnsTexture(boolean ownsTexture) {
        this.f = ownsTexture;
    }

    public BitmapFontCache newFontCache() {
        BitmapFont bitmapFont = this;
        return new BitmapFontCache(bitmapFont, bitmapFont.e);
    }

    public String toString() {
        if (this.a.fontFile != null) {
            return this.a.fontFile.nameWithoutExtension();
        }
        return super.toString();
    }

    static int a(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        while (n < n2) {
            if (charSequence.charAt(n) == '\n') {
                return n;
            }
            ++n;
        }
        return n2;
    }

    @BA.Hide
    public static class BitmapFontData {
        public String[] imagePaths;
        public FileHandle fontFile;
        public boolean flipped;
        public float padTop;
        public float padRight;
        public float padBottom;
        public float padLeft;
        public float lineHeight;
        public float capHeight = 1.0f;
        public float ascent;
        public float descent;
        public float down;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public boolean markupEnabled;
        public float cursorX;
        public final Glyph[][] glyphs = new Glyph[128][];
        public Glyph missingGlyph;
        public float spaceWidth;
        public float xHeight = 1.0f;
        public char[] breakChars;
        public char[] xChars = new char[]{'x', 'e', 'a', 'o', 'n', 's', 'r', 'c', 'u', 'm', 'v', 'w', 'z'};
        public char[] capChars = new char[]{'M', 'N', 'B', 'D', 'C', 'E', 'F', 'K', 'A', 'G', 'H', 'I', 'J', 'L', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

        public BitmapFontData() {
        }

        public BitmapFontData(FileHandle fontFile, boolean flip) {
            this.fontFile = fontFile;
            this.flipped = flip;
            this.load(fontFile, flip);
        }

        public void load(FileHandle fontFile, boolean flip) {
            if (this.imagePaths != null) {
                throw new IllegalStateException("Already loaded.");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fontFile.read()), 512);
            try {
                try {
                    int n;
                    Object object;
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        throw new GdxRuntimeException("File is empty.");
                    }
                    String string2 = string;
                    string = string2.substring(string2.indexOf("padding=") + 8);
                    String[] stringArray = string.substring(0, string.indexOf(32)).split(",", 4);
                    if (stringArray.length != 4) {
                        throw new GdxRuntimeException("Invalid padding.");
                    }
                    this.padTop = Integer.parseInt(stringArray[0]);
                    this.padLeft = Integer.parseInt(stringArray[1]);
                    this.padBottom = Integer.parseInt(stringArray[2]);
                    this.padRight = Integer.parseInt(stringArray[3]);
                    float f = this.padTop + this.padBottom;
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new GdxRuntimeException("Missing common header.");
                    }
                    String[] stringArray2 = string.split(" ", 7);
                    if (stringArray2.length < 3) {
                        throw new GdxRuntimeException("Invalid common header.");
                    }
                    if (!stringArray2[1].startsWith("lineHeight=")) {
                        throw new GdxRuntimeException("Missing: lineHeight");
                    }
                    this.lineHeight = Integer.parseInt(stringArray2[1].substring(11));
                    if (!stringArray2[2].startsWith("base=")) {
                        throw new GdxRuntimeException("Missing: base");
                    }
                    float f2 = Integer.parseInt(stringArray2[2].substring(5));
                    int n2 = 1;
                    if (stringArray2.length >= 6 && stringArray2[5] != null && stringArray2[5].startsWith("pages=")) {
                        try {
                            n2 = Math.max(1, Integer.parseInt(stringArray2[5].substring(6)));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    this.imagePaths = new String[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        string = bufferedReader.readLine();
                        if (string == null) {
                            throw new GdxRuntimeException("Missing additional page definitions.");
                        }
                        object = string.split(" ", 4);
                        if (!object[2].startsWith("file=")) {
                            throw new GdxRuntimeException("Missing: file");
                        }
                        if (object[1].startsWith("id=")) {
                            try {
                                if (Integer.parseInt(object[1].substring(3)) != n3) {
                                    throw new GdxRuntimeException("Page IDs must be indices starting at 0: " + ((String)object[1]).substring(3));
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new GdxRuntimeException("Invalid page id: " + ((String)object[1]).substring(3), numberFormatException);
                            }
                        }
                        String string3 = object[2].endsWith("\"") ? ((String)object[2]).substring(6, ((String)object[2]).length() - 1) : ((String)object[2]).substring(5, ((String)object[2]).length());
                        this.imagePaths[n3] = fontFile.parent().child(string3).path().replaceAll("\\\\", "/");
                        ++n3;
                    }
                    this.descent = 0.0f;
                    while ((string = bufferedReader.readLine()) != null && !string.startsWith("kernings ")) {
                        if (!string.startsWith("char ")) continue;
                        Glyph glyph = new Glyph();
                        object = new StringTokenizer(string, " =");
                        ((StringTokenizer)object).nextToken();
                        ((StringTokenizer)object).nextToken();
                        int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                        if (n4 == -1) {
                            this.missingGlyph = glyph;
                        } else {
                            if (n4 > 65535) continue;
                            this.setGlyph(n4, glyph);
                        }
                        glyph.id = n4;
                        ((StringTokenizer)object).nextToken();
                        glyph.srcX = Integer.parseInt(((StringTokenizer)object).nextToken());
                        ((StringTokenizer)object).nextToken();
                        glyph.srcY = Integer.parseInt(((StringTokenizer)object).nextToken());
                        ((StringTokenizer)object).nextToken();
                        glyph.width = Integer.parseInt(((StringTokenizer)object).nextToken());
                        ((StringTokenizer)object).nextToken();
                        glyph.height = Integer.parseInt(((StringTokenizer)object).nextToken());
                        ((StringTokenizer)object).nextToken();
                        glyph.xoffset = Integer.parseInt(((StringTokenizer)object).nextToken());
                        ((StringTokenizer)object).nextToken();
                        glyph.yoffset = flip ? Integer.parseInt(((StringTokenizer)object).nextToken()) : -(glyph.height + Integer.parseInt(((StringTokenizer)object).nextToken()));
                        ((StringTokenizer)object).nextToken();
                        glyph.xadvance = Integer.parseInt(((StringTokenizer)object).nextToken());
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            ((StringTokenizer)object).nextToken();
                        }
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            try {
                                glyph.page = Integer.parseInt(((StringTokenizer)object).nextToken());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if (glyph.width <= 0 || glyph.height <= 0) continue;
                        this.descent = Math.min(f2 + (float)glyph.yoffset, this.descent);
                    }
                    this.descent += this.padBottom;
                    while ((string = bufferedReader.readLine()) != null && string.startsWith("kerning ")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, " =");
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        int n5 = Integer.parseInt(stringTokenizer.nextToken());
                        stringTokenizer.nextToken();
                        int n6 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n5 < 0 || n5 > 65535 || n6 < 0 || n6 > 65535) continue;
                        Glyph glyph = this.getGlyph((char)n5);
                        stringTokenizer.nextToken();
                        n = Integer.parseInt(stringTokenizer.nextToken());
                        if (glyph == null) continue;
                        glyph.setKerning(n6, n);
                    }
                    Glyph glyph = this.getGlyph(' ');
                    if (glyph == null) {
                        glyph = new Glyph();
                        new Glyph().id = 32;
                        object = this.getGlyph('l');
                        if (object == null) {
                            object = this.getFirstGlyph();
                        }
                        glyph.xadvance = ((Glyph)object).xadvance;
                        this.setGlyph(32, glyph);
                    }
                    if (glyph.width == 0) {
                        glyph.width = (int)((float)glyph.xadvance + this.padRight);
                        glyph.xoffset = (int)(-this.padLeft);
                    }
                    this.spaceWidth = glyph.width;
                    object = null;
                    char[] cArray = this.xChars;
                    n = this.xChars.length;
                    int n7 = 0;
                    while (n7 < n) {
                        char c2 = cArray[n7];
                        object = this.getGlyph(c2);
                        if (object != null) break;
                        ++n7;
                    }
                    if (object == null) {
                        object = this.getFirstGlyph();
                    }
                    this.xHeight = (float)((Glyph)object).height - f;
                    Glyph glyph2 = null;
                    Object object2 = this.capChars;
                    int n8 = this.capChars.length;
                    n = 0;
                    while (n < n8) {
                        n7 = object2[n];
                        glyph2 = this.getGlyph((char)n7);
                        if (glyph2 != null) break;
                        ++n;
                    }
                    if (glyph2 == null) {
                        object2 = this.glyphs;
                        n8 = this.glyphs.length;
                        n = 0;
                        while (n < n8) {
                            char c3 = object2[n];
                            if (c3 != null) {
                                char c4 = c3;
                                int n9 = ((char)c4).length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    void var17_30 = c4[n10];
                                    if (var17_30 != null && var17_30.height != 0 && var17_30.width != 0) {
                                        this.capHeight = Math.max(this.capHeight, (float)var17_30.height);
                                    }
                                    ++n10;
                                }
                            }
                            ++n;
                        }
                    } else {
                        this.capHeight = glyph2.height;
                    }
                    this.capHeight -= f;
                    this.ascent = f2 - this.capHeight;
                    this.down = -this.lineHeight;
                    if (flip) {
                        this.ascent = -this.ascent;
                        this.down = -this.down;
                    }
                }
                catch (Exception exception) {
                    throw new GdxRuntimeException("Error loading font file: ".concat(String.valueOf(fontFile)), exception);
                }
            }
            finally {
                StreamUtils.closeQuietly(bufferedReader);
            }
        }

        public void setGlyphRegion(Glyph glyph, TextureRegion region) {
            Texture texture = region.getTexture();
            float f = 1.0f / (float)texture.getWidth();
            float f2 = 1.0f / (float)texture.getHeight();
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = region.d;
            float f6 = region.e;
            float f7 = region.getRegionWidth();
            float f8 = region.getRegionHeight();
            if (region instanceof TextureAtlas.AtlasRegion) {
                TextureAtlas.AtlasRegion atlasRegion = (TextureAtlas.AtlasRegion)region;
                f3 = atlasRegion.offsetX;
                f4 = (float)(atlasRegion.originalHeight - atlasRegion.packedHeight) - atlasRegion.offsetY;
            }
            float f9 = glyph.srcX;
            float f10 = glyph.srcX + glyph.width;
            float f11 = glyph.srcY;
            float f12 = glyph.srcY + glyph.height;
            if (f3 > 0.0f) {
                float f13;
                float f14;
                f9 -= f3;
                if (f14 < 0.0f) {
                    glyph.width = (int)((float)glyph.width + f9);
                    glyph.xoffset = (int)((float)glyph.xoffset - f9);
                    f9 = 0.0f;
                }
                f10 -= f3;
                if (f13 > f7) {
                    glyph.width = (int)((float)glyph.width - (f10 - f7));
                    f10 = f7;
                }
            }
            if (f4 > 0.0f) {
                float f15;
                float f16;
                f11 -= f4;
                if (f16 < 0.0f) {
                    glyph.height = (int)((float)glyph.height + f11);
                    f11 = 0.0f;
                }
                f12 -= f4;
                if (f15 > f8) {
                    float f17 = f12 - f8;
                    glyph.height = (int)((float)glyph.height - f17);
                    glyph.yoffset = (int)((float)glyph.yoffset + f17);
                    f12 = f8;
                }
            }
            glyph.u = f5 + f9 * f;
            glyph.u2 = f5 + f10 * f;
            if (this.flipped) {
                glyph.v = f6 + f11 * f2;
                glyph.v2 = f6 + f12 * f2;
                return;
            }
            glyph.v2 = f6 + f11 * f2;
            glyph.v = f6 + f12 * f2;
        }

        public void setLineHeight(float height) {
            this.lineHeight = height * this.scaleY;
            this.down = this.flipped ? this.lineHeight : -this.lineHeight;
        }

        public void setGlyph(int ch, Glyph glyph) {
            Glyph[] glyphArray = this.glyphs[ch / 512];
            if (glyphArray == null) {
                glyphArray = new Glyph[512];
                this.glyphs[ch / 512] = glyphArray;
            }
            glyphArray[ch & 0x1FF] = glyph;
        }

        public Glyph getFirstGlyph() {
            Glyph[][] glyphArray = this.glyphs;
            int n = this.glyphs.length;
            int n2 = 0;
            while (n2 < n) {
                Glyph[] glyphArray2 = glyphArray[n2];
                if (glyphArray2 != null) {
                    Glyph[] glyphArray3 = glyphArray2;
                    int n3 = glyphArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Glyph glyph = glyphArray3[n4];
                        if (glyph != null && glyph.height != 0 && glyph.width != 0) {
                            return glyph;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            throw new GdxRuntimeException("No glyphs found.");
        }

        public boolean hasGlyph(char ch) {
            if (this.missingGlyph != null) {
                return true;
            }
            return this.getGlyph(ch) != null;
        }

        public Glyph getGlyph(char ch) {
            Glyph[] glyphArray = this.glyphs[ch / 512];
            if (glyphArray != null) {
                return glyphArray[ch & 0x1FF];
            }
            return null;
        }

        public void getGlyphs(GlyphLayout.GlyphRun run, CharSequence str, int start, int end) {
            int n;
            boolean bl = this.markupEnabled;
            float f = this.scaleX;
            Glyph glyph = this.missingGlyph;
            Array<Glyph> array = run.glyphs;
            FloatArray floatArray = run.xAdvances;
            Glyph glyph2 = null;
            while (start < end) {
                Glyph glyph3;
                if ((glyph3 = this.getGlyph((char)(n = str.charAt(start++)))) == null) {
                    if (glyph == null) continue;
                    glyph3 = glyph;
                }
                array.add(glyph3);
                if (glyph2 == null) {
                    floatArray.add(glyph3.fixedWidth ? 0.0f : (float)(-glyph3.xoffset) * f - this.padLeft);
                } else {
                    floatArray.add((float)(glyph2.xadvance + glyph2.getKerning((char)n)) * f);
                }
                glyph2 = glyph3;
                if (!bl || n != 91 || start >= end || str.charAt(start) != '[') continue;
                ++start;
            }
            if (glyph2 != null) {
                n = glyph2.fixedWidth ? glyph2.xadvance : glyph2.xoffset + glyph2.width;
                floatArray.add((float)n * f - this.padRight);
            }
        }

        public int getWrapIndex(Array<Glyph> glyphs, int start) {
            int n = start - 1;
            while (n > 0) {
                if (!this.isWhitespace((char)glyphs.get((int)n).id)) break;
                --n;
            }
            while (n > 0) {
                char c2 = (char)glyphs.get((int)n).id;
                if (this.isWhitespace(c2) || this.isBreakChar(c2)) {
                    return n + 1;
                }
                --n;
            }
            return 0;
        }

        public boolean isBreakChar(char c2) {
            if (this.breakChars == null) {
                return false;
            }
            char[] cArray = this.breakChars;
            int n = this.breakChars.length;
            int n2 = 0;
            while (n2 < n) {
                char c3 = cArray[n2];
                if (c2 == c3) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean isWhitespace(char c2) {
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public String getImagePath(int index) {
            return this.imagePaths[index];
        }

        public String[] getImagePaths() {
            return this.imagePaths;
        }

        public FileHandle getFontFile() {
            return this.fontFile;
        }

        public void setScale(float scaleX, float scaleY) {
            if (scaleX == 0.0f) {
                throw new IllegalArgumentException("scaleX cannot be 0.");
            }
            if (scaleY == 0.0f) {
                throw new IllegalArgumentException("scaleY cannot be 0.");
            }
            float f = scaleX / this.scaleX;
            float f2 = scaleY / this.scaleY;
            this.lineHeight *= f2;
            this.spaceWidth *= f;
            this.xHeight *= f2;
            this.capHeight *= f2;
            this.ascent *= f2;
            this.descent *= f2;
            this.down *= f2;
            this.padTop *= f2;
            this.padLeft *= f2;
            this.padBottom *= f2;
            this.padRight *= f2;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
        }

        public void setScale(float scaleXY) {
            float f = scaleXY;
            this.setScale(f, f);
        }

        public void scale(float amount) {
            BitmapFontData bitmapFontData = this;
            bitmapFontData.setScale(bitmapFontData.scaleX + amount, this.scaleY + amount);
        }
    }

    @BA.Hide
    public static class Glyph {
        public int id;
        public int srcX;
        public int srcY;
        public int width;
        public int height;
        public float u;
        public float v;
        public float u2;
        public float v2;
        public int xoffset;
        public int yoffset;
        public int xadvance;
        public byte[][] kerning;
        public boolean fixedWidth;
        public int page = 0;

        public int getKerning(char ch) {
            byte[] byArray;
            if (this.kerning != null && (byArray = this.kerning[ch >>> 9]) != null) {
                return byArray[ch & 0x1FF];
            }
            return 0;
        }

        public void setKerning(int ch, int value) {
            byte[] byArray;
            if (this.kerning == null) {
                this.kerning = new byte[128][];
            }
            if ((byArray = this.kerning[ch >>> 9]) == null) {
                byArray = new byte[512];
                this.kerning[ch >>> 9] = byArray;
            }
            byArray[ch & 0x1FF] = (byte)value;
        }

        public String toString() {
            return Character.toString((char)this.id);
        }
    }

    @BA.Hide
    public static class TextBounds {
        public float width;
        public float height;

        public TextBounds() {
        }

        public TextBounds(TextBounds bounds) {
            this.set(bounds);
        }

        public void set(TextBounds bounds) {
            this.width = bounds.width;
            this.height = bounds.height;
        }
    }
}

