/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextMarkup;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.NumberUtils;

@BA.Hide
public class BitmapFontCache {
    private final Color a;
    private float b;
    private final BitmapFont c;
    private boolean d;
    private int e;
    private float f;
    private float g;
    private float[][] h;
    private int[] i;
    private IntArray[] j;
    private int[] k;
    private final BitmapFont.TextBounds l;
    private int m;
    private boolean n;
    private float o;
    private final TextMarkup p;

    public BitmapFontCache(BitmapFont font) {
        BitmapFont bitmapFont = font;
        this(bitmapFont, bitmapFont.usesIntegerPositions());
    }

    public BitmapFontCache(BitmapFont font, boolean integer) {
        this.a = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.b = Color.WHITE.toFloatBits();
        this.l = new BitmapFont.TextBounds();
        this.p = new TextMarkup();
        this.c = font;
        this.d = integer;
        int n = font.b.length;
        if (n == 0) {
            throw new IllegalArgumentException("The specified font must contain at least one texture page.");
        }
        this.h = new float[n][];
        this.i = new int[n];
        if (n > 1) {
            this.j = new IntArray[n];
            int n2 = 0;
            int n3 = this.j.length;
            while (n2 < n3) {
                this.j[n2] = new IntArray();
                ++n2;
            }
        }
        this.k = new int[n];
    }

    public void setPosition(float x, float y) {
        this.translate(x - this.f, y - this.g);
    }

    public void translate(float xAmount, float yAmount) {
        if (xAmount == 0.0f && yAmount == 0.0f) {
            return;
        }
        if (this.d) {
            xAmount = Math.round(xAmount);
            yAmount = Math.round(yAmount);
        }
        this.f += xAmount;
        this.g += yAmount;
        int n = 0;
        int n2 = this.h.length;
        while (n < n2) {
            float[] fArray = this.h[n];
            int n3 = 0;
            int n4 = this.i[n];
            while (n3 < n4) {
                int n5 = n3;
                fArray[n5] = fArray[n5] + xAmount;
                int n6 = n3 + 1;
                fArray[n6] = fArray[n6] + yAmount;
                n3 += 5;
            }
            ++n;
        }
    }

    public void tint(Color tint) {
        float f = tint.toFloatBits();
        if (this.n || this.o != f) {
            this.n = false;
            this.o = f;
            Color color = tint;
            BitmapFontCache bitmapFontCache = this;
            TextMarkup textMarkup = this.p;
            int n = 0;
            float f2 = TextMarkup.a.set(textMarkup.f).mul(color).toFloatBits();
            for (TextMarkup.ColorChunk colorChunk : textMarkup.c) {
                int n2 = colorChunk.start;
                if (n < n2) {
                    bitmapFontCache.setColors(f2, n, n2);
                    n = n2;
                }
                f2 = TextMarkup.a.set(colorChunk.color).mul(color).toFloatBits();
            }
            int n3 = bitmapFontCache.getCharsCount();
            if (n < n3) {
                bitmapFontCache.setColors(f2, n, n3);
            }
        }
    }

    public void setAlphas(float alpha) {
        int n = (int)(254.0f * alpha) << 24;
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        int n3 = this.h.length;
        while (n2 < n3) {
            float[] fArray = this.h[n2];
            int n4 = 2;
            int n5 = this.i[n2];
            while (n4 < n5) {
                float f3 = fArray[n4];
                if (f3 == f && n4 != 2) {
                    fArray[n4] = f2;
                } else {
                    f = f3;
                    fArray[n4] = f2 = NumberUtils.intToFloatColor(NumberUtils.floatToIntColor(f3) & 0xFFFFFF | n);
                }
                n4 += 5;
            }
            ++n2;
        }
    }

    public void setColors(float color) {
        int n = 0;
        int n2 = this.h.length;
        while (n < n2) {
            float[] fArray = this.h[n];
            int n3 = 2;
            int n4 = this.i[n];
            while (n3 < n4) {
                fArray[n3] = color;
                n3 += 5;
            }
            ++n;
        }
    }

    public void setColors(Color tint) {
        float f = tint.toFloatBits();
        int n = 0;
        int n2 = this.h.length;
        while (n < n2) {
            float[] fArray = this.h[n];
            int n3 = 2;
            int n4 = this.i[n];
            while (n3 < n4) {
                fArray[n3] = f;
                n3 += 5;
            }
            ++n;
        }
    }

    public void setColors(float r, float g, float b2, float a2) {
        float f = NumberUtils.intToFloatColor((int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r));
        int n = 0;
        int n2 = this.h.length;
        while (n < n2) {
            float[] fArray = this.h[n];
            int n3 = 2;
            int n4 = this.i[n];
            while (n3 < n4) {
                fArray[n3] = f;
                n3 += 5;
            }
            ++n;
        }
    }

    public void setColors(Color tint, int start, int end) {
        this.setColors(tint.toFloatBits(), start, end);
    }

    public void setColors(float color, int start, int end) {
        if (this.h.length == 1) {
            float[] fArray = this.h[0];
            int n = start * 20 + 2;
            int n2 = end * 20;
            while (n < n2) {
                fArray[n] = color;
                n += 5;
            }
            return;
        }
        int n = this.h.length;
        int n3 = 0;
        while (n3 < n) {
            float[] fArray = this.h[n3];
            IntArray intArray = this.j[n3];
            int n4 = 0;
            int n5 = intArray.size;
            while (n4 < n5) {
                int n6 = intArray.items[n4];
                if (n6 >= end) break;
                if (n6 >= start) {
                    int n7 = 0;
                    while (n7 < 20) {
                        fArray[n7 + (n4 * 20 + 2)] = color;
                        n7 += 5;
                    }
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void setColor(Color tint) {
        this.b = tint.toFloatBits();
        this.p.a(tint, this.m);
    }

    public void setColor(float r, float g, float b2, float a2) {
        int n = (int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.b = NumberUtils.intToFloatColor(n);
        this.p.a(n, this.m);
    }

    public void setColor(float color) {
        this.b = color;
        int n = this.m;
        TextMarkup textMarkup = this.p;
        int n2 = NumberUtils.floatToIntColor(color);
        textMarkup.a(n2, n);
    }

    public Color getColor() {
        int n = NumberUtils.floatToIntColor(this.b);
        Color color = this.a;
        this.a.r = (float)(n & 0xFF) / 255.0f;
        color.g = (float)(n >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(n >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(n >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    public void draw(Batch spriteBatch) {
        TextureRegion[] textureRegionArray = this.c.getRegions();
        int n = 0;
        int n2 = this.h.length;
        while (n < n2) {
            if (this.i[n] > 0) {
                float[] fArray = this.h[n];
                spriteBatch.draw(textureRegionArray[n].getTexture(), fArray, 0, this.i[n]);
            }
            ++n;
        }
    }

    public void draw(Batch spriteBatch, int start, int end) {
        if (this.h.length == 1) {
            spriteBatch.draw(this.c.getRegion().getTexture(), this.h[0], start * 20, (end - start) * 20);
            return;
        }
        TextureRegion[] textureRegionArray = this.c.getRegions();
        int n = 0;
        int n2 = this.h.length;
        while (n < n2) {
            int n3 = -1;
            int n4 = 0;
            IntArray intArray = this.j[n];
            int n5 = 0;
            int n6 = intArray.size;
            while (n5 < n6) {
                int n7 = intArray.items[n5];
                if (n7 >= end) break;
                if (n3 == -1 && n7 >= start) {
                    n3 = n5;
                }
                if (n7 >= start) {
                    ++n4;
                }
                ++n5;
            }
            if (n3 != -1 && n4 != 0) {
                spriteBatch.draw(textureRegionArray[n].getTexture(), this.h[n], n3 * 20, n4 * 20);
            }
            ++n;
        }
    }

    public void draw(Batch spriteBatch, float alphaModulation) {
        if (alphaModulation == 1.0f) {
            this.draw(spriteBatch);
            return;
        }
        Color color = this.getColor();
        float f = color.a;
        color.a *= alphaModulation;
        this.setColors(color);
        this.draw(spriteBatch);
        color.a = f;
        this.setColors(color);
    }

    public void clear() {
        this.f = 0.0f;
        this.g = 0.0f;
        this.e = 0;
        this.m = 0;
        TextMarkup textMarkup = this.p;
        int n = textMarkup.c.size;
        int n2 = 0;
        while (n2 < n) {
            TextMarkup.b.free(textMarkup.c.get(n2));
            textMarkup.c.set(n2, null);
            ++n2;
        }
        textMarkup.c.size = 0;
        textMarkup.d.clear();
        TextMarkup textMarkup2 = textMarkup;
        textMarkup2.a(textMarkup2.f, 0);
        int n3 = 0;
        int n4 = this.i.length;
        while (n3 < n4) {
            if (this.j != null) {
                this.j[n3].clear();
            }
            this.i[n3] = 0;
            ++n3;
        }
    }

    private void a(CharSequence charSequence, int n, int n2) {
        if (this.h.length == 1) {
            int n3 = n2;
            int n4 = n;
            CharSequence charSequence2 = charSequence;
            BitmapFontCache bitmapFontCache = this;
            int n5 = n3 - n4;
            if (bitmapFontCache.c.a.markupEnabled) {
                while (n4 < n3) {
                    if (charSequence2.charAt(n4++) != '[') continue;
                    if (n4 < n3 && charSequence2.charAt(n4) == '[') {
                        ++n4;
                        --n5;
                        continue;
                    }
                    int n6 = bitmapFontCache.p.a(charSequence2, -1, n4, n3);
                    if (n6 < 0) continue;
                    n4 += n6 + 1;
                    n5 -= n6 + 2;
                }
            }
            int n7 = n5;
            this.a(0, n7);
            return;
        }
        int n8 = 0;
        int n9 = this.k.length;
        while (n8 < n9) {
            this.k[n8] = 0;
            ++n8;
        }
        while (n < n2) {
            BitmapFont.Glyph glyph;
            char c2 = charSequence.charAt(n++);
            n8 = c2;
            if (c2 == '[' && this.c.a.markupEnabled) {
                int n10;
                if ((n >= n2 || charSequence.charAt(n) != '[') && (n10 = this.p.a(charSequence, -1, n, n2)) >= 0) {
                    n += n10 + 1;
                    continue;
                }
                ++n;
            }
            if ((glyph = this.c.a.getGlyph((char)n8)) == null) continue;
            int n11 = glyph.page;
            this.k[n11] = this.k[n11] + 1;
        }
        n8 = 0;
        int n12 = this.k.length;
        while (n8 < n12) {
            this.a(n8, this.k[n8]);
            ++n8;
        }
    }

    private void a(int n, int n2) {
        if (this.j != null && n2 > this.j[n].items.length) {
            IntArray intArray = this.j[n];
            intArray.ensureCapacity(n2 - intArray.items.length);
        }
        int n3 = this.i[n] + n2 * 20;
        float[] fArray = this.h[n];
        if (fArray == null) {
            this.h[n] = new float[n3];
            return;
        }
        if (fArray.length < n3) {
            float[] fArray2 = new float[n3];
            System.arraycopy(fArray, 0, fArray2, 0, this.i[n]);
            this.h[n] = fArray2;
        }
    }

    private float a(CharSequence charSequence, float f, float f2, int n, int n2) {
        float f3 = f;
        BitmapFont bitmapFont = this.c;
        BitmapFont.Glyph glyph = null;
        BitmapFont.BitmapFontData bitmapFontData = bitmapFont.a;
        boolean bl = this.n = n < n2;
        if (bitmapFontData.scaleX == 1.0f && bitmapFontData.scaleY == 1.0f) {
            char c2;
            while (n < n2) {
                if ((c2 = charSequence.charAt(n++)) == '[' && bitmapFont.a.markupEnabled) {
                    if (n < n2 && charSequence.charAt(n) == '[') {
                        ++n;
                    } else {
                        int n3 = this.p.a(charSequence, this.m, n, n2);
                        if (n3 >= 0) {
                            this.b = this.p.e.toFloatBits();
                            n += n3 + 1;
                            continue;
                        }
                    }
                }
                if ((glyph = bitmapFontData.getGlyph(c2)) == null) continue;
                this.a(glyph, f + (float)glyph.xoffset, f2 + (float)glyph.yoffset, (float)glyph.width, (float)glyph.height);
                f += (float)glyph.xadvance;
                break;
            }
            while (n < n2) {
                BitmapFont.Glyph glyph2;
                if ((c2 = charSequence.charAt(n++)) == '[' && bitmapFont.a.markupEnabled) {
                    if (n < n2 && charSequence.charAt(n) == '[') {
                        ++n;
                    } else {
                        int n4 = this.p.a(charSequence, this.m, n, n2);
                        if (n4 >= 0) {
                            this.b = this.p.e.toFloatBits();
                            n += n4 + 1;
                            continue;
                        }
                    }
                }
                if ((glyph2 = bitmapFontData.getGlyph(c2)) == null) continue;
                glyph = glyph2;
                this.a(glyph, (f += (float)glyph.getKerning(c2)) + (float)glyph2.xoffset, f2 + (float)glyph2.yoffset, (float)glyph2.width, (float)glyph2.height);
                f += (float)glyph2.xadvance;
            }
        } else {
            char c3;
            float f4 = bitmapFontData.scaleX;
            float f5 = bitmapFontData.scaleY;
            while (n < n2) {
                if ((c3 = charSequence.charAt(n++)) == '[' && bitmapFont.a.markupEnabled) {
                    if (n < n2 && charSequence.charAt(n) == '[') {
                        ++n;
                    } else {
                        int n5 = this.p.a(charSequence, this.m, n, n2);
                        if (n5 >= 0) {
                            this.b = this.p.e.toFloatBits();
                            n += n5 + 1;
                            continue;
                        }
                    }
                }
                if ((glyph = bitmapFontData.getGlyph(c3)) == null) continue;
                this.a(glyph, f + (float)glyph.xoffset * f4, f2 + (float)glyph.yoffset * f5, (float)glyph.width * f4, (float)glyph.height * f5);
                f += (float)glyph.xadvance * f4;
                break;
            }
            while (n < n2) {
                BitmapFont.Glyph glyph3;
                if ((c3 = charSequence.charAt(n++)) == '[' && bitmapFont.a.markupEnabled) {
                    if (n < n2 && charSequence.charAt(n) == '[') {
                        ++n;
                    } else {
                        int n6 = this.p.a(charSequence, this.m, n, n2);
                        if (n6 >= 0) {
                            this.b = this.p.e.toFloatBits();
                            n += n6 + 1;
                            continue;
                        }
                    }
                }
                if ((glyph3 = bitmapFontData.getGlyph(c3)) == null) continue;
                glyph = glyph3;
                this.a(glyph, (f += (float)glyph.getKerning(c3) * f4) + (float)glyph3.xoffset * f4, f2 + (float)glyph3.yoffset * f5, (float)glyph3.width * f4, (float)glyph3.height * f5);
                f += (float)glyph3.xadvance * f4;
            }
        }
        return f - f3;
    }

    private void a(BitmapFont.Glyph glyph, float f, float f2, float f3, float f4) {
        float f5 = glyph.u;
        float f6 = glyph.u2;
        float f7 = glyph.v;
        float f8 = glyph.v2;
        if (this.d) {
            f = Math.round(f);
            f2 = Math.round(f2);
            f3 = Math.round(f3);
            f4 = Math.round(f4);
        }
        float f9 = f + f3;
        float f10 = f2 + f4;
        int n = glyph.page;
        int n2 = this.i[n];
        int n3 = n;
        this.i[n3] = this.i[n3] + 20;
        if (this.j != null) {
            this.j[n].add(this.e++);
        }
        float[] fArray = this.h[n];
        float[] fArray2 = fArray;
        fArray[n2++] = f;
        fArray2[n2++] = f2;
        fArray2[n2++] = this.b;
        fArray2[n2++] = f5;
        fArray2[n2++] = f7;
        fArray2[n2++] = f;
        fArray2[n2++] = f10;
        fArray2[n2++] = this.b;
        fArray2[n2++] = f5;
        fArray2[n2++] = f8;
        fArray2[n2++] = f9;
        fArray2[n2++] = f10;
        fArray2[n2++] = this.b;
        fArray2[n2++] = f6;
        fArray2[n2++] = f8;
        fArray2[n2++] = f9;
        fArray2[n2++] = f2;
        fArray2[n2++] = this.b;
        fArray2[n2++] = f6;
        fArray2[n2] = f7;
        ++this.m;
    }

    public BitmapFont.TextBounds setText(CharSequence str, float x, float y) {
        this.clear();
        return this.addText(str, x, y, 0, str.length());
    }

    public BitmapFont.TextBounds setText(CharSequence str, float x, float y, int start, int end) {
        this.clear();
        return this.addText(str, x, y, start, end);
    }

    public BitmapFont.TextBounds addText(CharSequence str, float x, float y) {
        return this.addText(str, x, y, 0, str.length());
    }

    public BitmapFont.TextBounds addText(CharSequence str, float x, float y, int start, int end) {
        this.a(str, start, end);
        this.l.width = this.a(str, x, y += this.c.a.ascent, start, end);
        this.l.height = this.c.a.capHeight;
        return this.l;
    }

    public BitmapFont.TextBounds setMultiLineText(CharSequence str, float x, float y) {
        this.clear();
        return this.addMultiLineText(str, x, y, 0.0f, 8);
    }

    public BitmapFont.TextBounds setMultiLineText(CharSequence str, float x, float y, float alignmentWidth, int alignment) {
        this.clear();
        return this.addMultiLineText(str, x, y, alignmentWidth, alignment);
    }

    public BitmapFont.TextBounds addMultiLineText(CharSequence str, float x, float y) {
        return this.addMultiLineText(str, x, y, 0.0f, 8);
    }

    public BitmapFont.TextBounds addMultiLineText(CharSequence str, float x, float y, float alignmentWidth, int alignment) {
        BitmapFont bitmapFont = this.c;
        int n = str.length();
        this.a(str, 0, n);
        y += bitmapFont.a.ascent;
        float f = bitmapFont.a.down;
        float f2 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            float f3;
            int n4 = BitmapFont.a(str, n2);
            float f4 = 0.0f;
            if (alignment != 8) {
                f3 = bitmapFont.getBounds((CharSequence)str, (int)n2, (int)n4).width;
                f4 = alignmentWidth - f3;
                if (alignment == 1) {
                    f4 /= 2.0f;
                }
            }
            f3 = this.a(str, x + f4, y, n2, n4);
            f2 = Math.max(f2, f3);
            n2 = n4 + 1;
            y += f;
            ++n3;
        }
        this.l.width = f2;
        this.l.height = bitmapFont.a.capHeight + (float)(n3 - 1) * bitmapFont.a.lineHeight;
        return this.l;
    }

    public BitmapFont.TextBounds setWrappedText(CharSequence str, float x, float y, float wrapWidth) {
        this.clear();
        return this.addWrappedText(str, x, y, wrapWidth, 8);
    }

    public BitmapFont.TextBounds setWrappedText(CharSequence str, float x, float y, float wrapWidth, int alignment) {
        this.clear();
        return this.addWrappedText(str, x, y, wrapWidth, alignment);
    }

    public BitmapFont.TextBounds addWrappedText(CharSequence str, float x, float y, float wrapWidth) {
        return this.addWrappedText(str, x, y, wrapWidth, 8);
    }

    public BitmapFont.TextBounds addWrappedText(CharSequence str, float x, float y, float wrapWidth, int alignment) {
        BitmapFont bitmapFont = this.c;
        int n = str.length();
        this.a(str, 0, n);
        y += bitmapFont.a.ascent;
        float f = bitmapFont.a.down;
        if (wrapWidth <= 0.0f) {
            wrapWidth = 2.1474836E9f;
        }
        float f2 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = BitmapFont.a(str, n2);
            int n5 = n2 + bitmapFont.computeVisibleGlyphs(str, n2, n4, wrapWidth);
            int n6 = n5 + 1;
            if (n5 < n4) {
                while (n5 > n2) {
                    if (bitmapFont.a.isWhitespace(str.charAt(n5)) || bitmapFont.a.isBreakChar(str.charAt(n5 - 1))) break;
                    --n5;
                }
                if (n5 == n2) {
                    if (n6 > n2 + 1) {
                        --n6;
                    }
                    n5 = n6;
                } else {
                    n6 = n5;
                    while (n6 < n) {
                        char c2 = str.charAt(n6);
                        if (!bitmapFont.a.isWhitespace(c2)) break;
                        ++n6;
                        if (c2 == '\n') break;
                    }
                    while (n5 > n2) {
                        if (!bitmapFont.a.isWhitespace(str.charAt(n5 - 1))) break;
                        --n5;
                    }
                }
            }
            if (n5 > n2) {
                float f3;
                float f4 = 0.0f;
                if (alignment != 8) {
                    f3 = bitmapFont.getBounds((CharSequence)str, (int)n2, (int)n5).width;
                    f4 = wrapWidth - f3;
                    if (alignment == 1) {
                        f4 /= 2.0f;
                    }
                }
                f3 = this.a(str, x + f4, y, n2, n5);
                f2 = Math.max(f2, f3);
            }
            n2 = n6;
            y += f;
            ++n3;
        }
        this.l.width = f2;
        this.l.height = bitmapFont.a.capHeight + (float)(n3 - 1) * bitmapFont.a.lineHeight;
        return this.l;
    }

    public BitmapFont.TextBounds getBounds() {
        return this.l;
    }

    public float getX() {
        return this.f;
    }

    public float getY() {
        return this.g;
    }

    public BitmapFont getFont() {
        return this.c;
    }

    public void setUseIntegerPositions(boolean use) {
        this.d = use;
    }

    public boolean usesIntegerPositions() {
        return this.d;
    }

    public float[] getVertices() {
        return this.getVertices(0);
    }

    public float[] getVertices(int page) {
        return this.h[page];
    }

    public int getCharsCount() {
        return this.m;
    }
}

