/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@BA.Hide
public class Gdx2DPixmap
implements Disposable {
    public static final int GDX2D_FORMAT_ALPHA = 1;
    public static final int GDX2D_FORMAT_LUMINANCE_ALPHA = 2;
    public static final int GDX2D_FORMAT_RGB888 = 3;
    public static final int GDX2D_FORMAT_RGBA8888 = 4;
    public static final int GDX2D_FORMAT_RGB565 = 5;
    public static final int GDX2D_FORMAT_RGBA4444 = 6;
    public static final int GDX2D_SCALE_NEAREST = 0;
    public static final int GDX2D_SCALE_LINEAR = 1;
    public static final int GDX2D_BLEND_NONE = 0;
    public static final int GDX2D_BLEND_SRC_OVER = 1;
    private long a;
    private int b;
    private int c;
    private int d;
    private ByteBuffer e;
    private long[] f = new long[4];

    static {
        Gdx2DPixmap.setBlend(1);
        Gdx2DPixmap.setScale(1);
    }

    public static int toGlFormat(int format) {
        switch (format) {
            case 1: {
                return 6406;
            }
            case 2: {
                return 6410;
            }
            case 3: 
            case 5: {
                return 6407;
            }
            case 4: 
            case 6: {
                return 6408;
            }
        }
        throw new GdxRuntimeException("unknown format: ".concat(String.valueOf(format)));
    }

    public static int toGlType(int format) {
        switch (format) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 5121;
            }
            case 5: {
                return 33635;
            }
            case 6: {
                return 32819;
            }
        }
        throw new GdxRuntimeException("unknown format: ".concat(String.valueOf(format)));
    }

    public Gdx2DPixmap(byte[] encodedData, int offset, int len, int requestedFormat) throws IOException {
        this.e = Gdx2DPixmap.load(this.f, encodedData, offset, len);
        if (this.e == null) {
            throw new IOException("Error loading pixmap: " + Gdx2DPixmap.getFailureReason());
        }
        this.a = this.f[0];
        this.b = (int)this.f[1];
        this.c = (int)this.f[2];
        this.d = (int)this.f[3];
        if (requestedFormat != 0 && requestedFormat != this.d) {
            this.a(requestedFormat);
        }
    }

    public Gdx2DPixmap(InputStream in, int requestedFormat) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        while ((n = in.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray = byteArrayOutputStream.toByteArray();
        this.e = Gdx2DPixmap.load(this.f, byArray, 0, byArray.length);
        if (this.e == null) {
            throw new IOException("Error loading pixmap: " + Gdx2DPixmap.getFailureReason());
        }
        this.a = this.f[0];
        this.b = (int)this.f[1];
        this.c = (int)this.f[2];
        this.d = (int)this.f[3];
        if (requestedFormat != 0 && requestedFormat != this.d) {
            this.a(requestedFormat);
        }
    }

    public Gdx2DPixmap(int width, int height, int format) throws GdxRuntimeException {
        this.e = Gdx2DPixmap.newPixmap(this.f, width, height, format);
        if (this.e == null) {
            throw new GdxRuntimeException("Error loading pixmap.");
        }
        this.a = this.f[0];
        this.b = (int)this.f[1];
        this.c = (int)this.f[2];
        this.d = (int)this.f[3];
    }

    public Gdx2DPixmap(ByteBuffer pixelPtr, long[] nativeData) {
        this.e = pixelPtr;
        this.a = nativeData[0];
        this.b = (int)nativeData[1];
        this.c = (int)nativeData[2];
        this.d = (int)nativeData[3];
    }

    private void a(int n) {
        Gdx2DPixmap gdx2DPixmap = new Gdx2DPixmap(this.b, this.c, n);
        gdx2DPixmap.drawPixmap(this, 0, 0, 0, 0, this.b, this.c);
        this.dispose();
        this.a = gdx2DPixmap.a;
        this.d = gdx2DPixmap.d;
        this.c = gdx2DPixmap.c;
        this.f = gdx2DPixmap.f;
        this.e = gdx2DPixmap.e;
        this.b = gdx2DPixmap.b;
    }

    @Override
    public void dispose() {
        Gdx2DPixmap.free(this.a);
    }

    public void clear(int color) {
        Gdx2DPixmap.clear(this.a, color);
    }

    public void setPixel(int x, int y, int color) {
        Gdx2DPixmap.setPixel(this.a, x, y, color);
    }

    public int getPixel(int x, int y) {
        return Gdx2DPixmap.getPixel(this.a, x, y);
    }

    public void drawLine(int x, int y, int x2, int y2, int color) {
        Gdx2DPixmap.drawLine(this.a, x, y, x2, y2, color);
    }

    public void drawRect(int x, int y, int width, int height, int color) {
        Gdx2DPixmap.drawRect(this.a, x, y, width, height, color);
    }

    public void drawCircle(int x, int y, int radius, int color) {
        Gdx2DPixmap.drawCircle(this.a, x, y, radius, color);
    }

    public void fillRect(int x, int y, int width, int height, int color) {
        Gdx2DPixmap.fillRect(this.a, x, y, width, height, color);
    }

    public void fillCircle(int x, int y, int radius, int color) {
        Gdx2DPixmap.fillCircle(this.a, x, y, radius, color);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int color) {
        Gdx2DPixmap.fillTriangle(this.a, x1, y1, x2, y2, x3, y3, color);
    }

    public void drawPixmap(Gdx2DPixmap src, int srcX, int srcY, int dstX, int dstY, int width, int height) {
        Gdx2DPixmap.drawPixmap(src.a, this.a, srcX, srcY, width, height, dstX, dstY, width, height);
    }

    public void drawPixmap(Gdx2DPixmap src, int srcX, int srcY, int srcWidth, int srcHeight, int dstX, int dstY, int dstWidth, int dstHeight) {
        Gdx2DPixmap.drawPixmap(src.a, this.a, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight);
    }

    public static Gdx2DPixmap newPixmap(InputStream in, int requestedFormat) {
        try {
            return new Gdx2DPixmap(in, requestedFormat);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Gdx2DPixmap newPixmap(int width, int height, int format) {
        try {
            return new Gdx2DPixmap(width, height, format);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public ByteBuffer getPixels() {
        return this.e;
    }

    public int getHeight() {
        return this.c;
    }

    public int getWidth() {
        return this.b;
    }

    public int getFormat() {
        return this.d;
    }

    public int getGLInternalFormat() {
        return Gdx2DPixmap.toGlFormat(this.d);
    }

    public int getGLFormat() {
        return this.getGLInternalFormat();
    }

    public int getGLType() {
        return Gdx2DPixmap.toGlType(this.d);
    }

    public String getFormatString() {
        switch (this.d) {
            case 1: {
                return "alpha";
            }
            case 2: {
                return "luminance alpha";
            }
            case 3: {
                return "rgb888";
            }
            case 4: {
                return "rgba8888";
            }
            case 5: {
                return "rgb565";
            }
            case 6: {
                return "rgba4444";
            }
        }
        return "unknown";
    }

    private static native ByteBuffer load(long[] var0, byte[] var1, int var2, int var3);

    private static native ByteBuffer newPixmap(long[] var0, int var1, int var2, int var3);

    private static native void free(long var0);

    private static native void clear(long var0, int var2);

    private static native void setPixel(long var0, int var2, int var3, int var4);

    private static native int getPixel(long var0, int var2, int var3);

    private static native void drawLine(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void drawRect(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void drawCircle(long var0, int var2, int var3, int var4, int var5);

    private static native void fillRect(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void fillCircle(long var0, int var2, int var3, int var4, int var5);

    private static native void fillTriangle(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native void drawPixmap(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public static native void setBlend(int var0);

    public static native void setScale(int var0);

    public static native String getFailureReason();
}

