/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

@BA.Hide
public class GlyphLayout
implements Pool.Poolable {
    public final Array<GlyphRun> runs = new Array();
    public float width;
    public float height;
    private final Array<Color> a = new Array(4);

    public GlyphLayout() {
    }

    public GlyphLayout(BitmapFont font, CharSequence str) {
        this.setText(font, str);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, color, targetWidth, halign, wrap);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        this.setText(font, str, start, end, color, targetWidth, halign, wrap, truncate);
    }

    public void setText(BitmapFont font, CharSequence str) {
        this.setText(font, str, 0, str.length(), font.getColor(), 0.0f, 8, false, null);
    }

    public void setText(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, 0, str.length(), color, targetWidth, halign, wrap, null);
    }

    public void setText(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        int n;
        int n2;
        int n3;
        int n4;
        if (truncate != null) {
            wrap = true;
        } else if (targetWidth <= font.a.spaceWidth) {
            wrap = false;
        }
        BitmapFont.BitmapFontData bitmapFontData = font.a;
        boolean bl = bitmapFontData.markupEnabled;
        Pool<GlyphRun> pool = Pools.get(GlyphRun.class);
        Array<GlyphRun> array = this.runs;
        pool.freeAll(array);
        array.clear();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n5 = 0;
        Array<Color> array2 = this.a;
        Color color2 = color;
        array2.add(color);
        Pool<Color> pool2 = Pools.get(Color.class);
        int n6 = start;
        block9: while (true) {
            int n7;
            int n8;
            int n9;
            GlyphLayout glyphLayout;
            Object object;
            Object object2;
            n4 = -1;
            n3 = 0;
            if (start == end) {
                if (n6 == end) break;
                n4 = end;
            } else {
                switch (str.charAt(start++)) {
                    case '\n': {
                        n4 = start - 1;
                        n3 = 1;
                        break;
                    }
                    case '[': {
                        int n10;
                        int n11;
                        if (!bl) break;
                        object2 = pool2;
                        int n12 = start;
                        object = str;
                        glyphLayout = this;
                        if (n12 == end) {
                            n11 = -1;
                        } else {
                            block4 : switch (object.charAt(n12)) {
                                case '#': {
                                    Color color3;
                                    n9 = 0;
                                    int n13 = n12 + 1;
                                    while (n13 < end) {
                                        n8 = object.charAt(n13);
                                        if (n8 == 93) {
                                            if (n13 < n12 + 2 || n13 > n12 + 9) break;
                                            if (n13 - n12 <= 7) {
                                                int n14 = 0;
                                                n7 = 9 - (n13 - n12);
                                                while (n14 < n7) {
                                                    n9 <<= 4;
                                                    ++n14;
                                                }
                                                n9 |= 0xFF;
                                            }
                                            color3 = ((Pool)object2).obtain();
                                            glyphLayout.a.add(color3);
                                            Color.rgba8888ToColor(color3, n9);
                                            n11 = n13 - n12;
                                            break block4;
                                        }
                                        if (n8 >= 48 && n8 <= 57) {
                                            n9 = n9 * 16 + (n8 - 48);
                                        } else if (n8 >= 97 && n8 <= 102) {
                                            n9 = n9 * 16 + (n8 - 87);
                                        } else {
                                            if (n8 < 65 || n8 > 70) break;
                                            n9 = n9 * 16 + (n8 - 55);
                                        }
                                        ++n13;
                                    }
                                    n11 = -1;
                                    break;
                                }
                                case '[': {
                                    n11 = -1;
                                    break;
                                }
                                case ']': {
                                    if (glyphLayout.a.size > 1) {
                                        ((Pool)object2).free((Color)glyphLayout.a.pop());
                                    }
                                    n11 = 0;
                                    break;
                                }
                                default: {
                                    Color color3;
                                    n9 = n12;
                                    int n15 = n12 + 1;
                                    while (n15 < end) {
                                        if (object.charAt(n15) == ']') {
                                            color3 = Colors.get(object.subSequence(n9, n15).toString());
                                            if (color3 == null) {
                                                n11 = -1;
                                                break block4;
                                            }
                                            Color color4 = ((Pool)object2).obtain();
                                            glyphLayout.a.add(color4);
                                            color4.set(color3);
                                            n11 = n15 - n12;
                                            break block4;
                                        }
                                        ++n15;
                                    }
                                    n11 = n10 = -1;
                                }
                            }
                        }
                        if (n11 < 0) break;
                        n4 = start - 1;
                        start += n10 + 1;
                        color2 = array2.peek();
                    }
                }
            }
            if (n4 == -1) continue;
            if (n4 != n6) {
                GlyphRun glyphRun = pool.obtain();
                array.add(glyphRun);
                glyphRun.color.set(color);
                glyphRun.x = f;
                glyphRun.y = f2;
                bitmapFontData.getGlyphs(glyphRun, str, n6, n4);
                float[] fArray = glyphRun.xAdvances.items;
                n2 = 0;
                n = glyphRun.xAdvances.size;
                while (n2 < n) {
                    float f4 = fArray[n2];
                    f += f4;
                    if (wrap && f > targetWidth && n2 > 1 && f - f4 + (float)(glyphRun.glyphs.get((int)(n2 - 1)).xoffset + glyphRun.glyphs.get((int)(n2 - 1)).width) * bitmapFontData.scaleX - 1.0E-4f > targetWidth) {
                        if (truncate != null) {
                            Pool<GlyphRun> pool3 = pool;
                            object2 = truncate;
                            GlyphRun glyphRun2 = glyphRun;
                            object = bitmapFontData;
                            GlyphRun glyphRun3 = pool3.obtain();
                            ((BitmapFont.BitmapFontData)object).getGlyphs(glyphRun3, (CharSequence)object2, 0, ((String)object2).length());
                            float f5 = 0.0f;
                            n7 = 1;
                            int n16 = glyphRun3.xAdvances.size;
                            while (n7 < n16) {
                                f5 += glyphRun3.xAdvances.get(n7);
                                ++n7;
                            }
                            float f6 = targetWidth - f5;
                            n7 = 0;
                            float f7 = glyphRun2.x;
                            while (n7 < glyphRun2.xAdvances.size) {
                                float f8;
                                float f9 = glyphRun2.xAdvances.get(n7);
                                f7 += f9;
                                if (f8 > f6) {
                                    glyphRun2.width = f7 - glyphRun2.x - f9;
                                    break;
                                }
                                ++n7;
                            }
                            if (n7 > 1) {
                                glyphRun2.glyphs.truncate(n7 - 1);
                                glyphRun2.xAdvances.truncate(n7);
                                GlyphLayout.a((BitmapFont.BitmapFontData)object, glyphRun2);
                                if (glyphRun3.xAdvances.size > 0) {
                                    glyphRun2.xAdvances.addAll(glyphRun3.xAdvances, 1, glyphRun3.xAdvances.size - 1);
                                }
                            } else {
                                glyphRun2.glyphs.clear();
                                glyphRun2.xAdvances.clear();
                                glyphRun2.xAdvances.addAll(glyphRun3.xAdvances);
                                if (glyphRun3.xAdvances.size > 0) {
                                    glyphRun2.width += glyphRun3.xAdvances.get(0);
                                }
                            }
                            glyphRun2.glyphs.addAll(glyphRun3.glyphs);
                            glyphRun2.width += f5;
                            pool3.free(glyphRun3);
                            f = glyphRun.x + glyphRun.width;
                            break block9;
                        }
                        int n17 = bitmapFontData.getWrapIndex(glyphRun.glyphs, n2);
                        if (glyphRun.x == 0.0f && n17 == 0 || n17 >= glyphRun.glyphs.size) {
                            n17 = n2 - 1;
                        }
                        n9 = n2;
                        int n18 = n17;
                        Pool<GlyphRun> pool4 = pool;
                        GlyphRun glyphRun4 = glyphRun;
                        object = bitmapFontData;
                        glyphLayout = this;
                        GlyphRun glyphRun5 = pool4.obtain();
                        glyphRun5.color.set(glyphRun4.color);
                        n8 = glyphRun4.glyphs.size;
                        if (n18 < n8) {
                            glyphRun5.glyphs.addAll(glyphRun4.glyphs, n18, n8 - n18);
                            glyphRun5.xAdvances.add((float)(-glyphRun5.glyphs.first().xoffset) * ((BitmapFont.BitmapFontData)object).scaleX - ((BitmapFont.BitmapFontData)object).padLeft);
                            glyphRun5.xAdvances.addAll(glyphRun4.xAdvances, n18 + 1, glyphRun4.xAdvances.size - (n18 + 1));
                        }
                        while (n9 < n18) {
                            glyphRun4.width += glyphRun4.xAdvances.get(n9++);
                        }
                        while (n9 > n18 + 1) {
                            glyphRun4.width -= glyphRun4.xAdvances.get(--n9);
                        }
                        if (n18 == 0) {
                            pool4.free(glyphRun4);
                            glyphLayout.runs.pop();
                        } else {
                            glyphRun4.glyphs.truncate(n18);
                            glyphRun4.xAdvances.truncate(n18 + 1);
                            GlyphLayout.a((BitmapFont.BitmapFontData)object, glyphRun4);
                        }
                        GlyphRun glyphRun6 = glyphRun5;
                        array.add(glyphRun6);
                        f3 = Math.max(f3, glyphRun.x + glyphRun.width);
                        f = 0.0f;
                        ++n5;
                        glyphRun6.x = 0.0f;
                        glyphRun6.y = f2 += bitmapFontData.down;
                        n2 = -1;
                        n = glyphRun6.xAdvances.size;
                        fArray = glyphRun6.xAdvances.items;
                        glyphRun = glyphRun6;
                    } else {
                        glyphRun.width += f4;
                    }
                    ++n2;
                }
            }
            if (n3 != 0) {
                f3 = Math.max(f3, f);
                f = 0.0f;
                f2 += bitmapFontData.down;
                ++n5;
            }
            n6 = start;
            color = color2;
        }
        f3 = Math.max(f3, f);
        n4 = 1;
        n3 = array2.size;
        while (n4 < n3) {
            pool2.free(array2.get(n4));
            ++n4;
        }
        array2.clear();
        if ((halign & 8) == 0) {
            n4 = (halign & 1) != 0 ? 1 : 0;
            float f10 = 0.0f;
            float f11 = -2.1474836E9f;
            int n19 = 0;
            n2 = array.size;
            n = 0;
            while (n < n2) {
                GlyphRun glyphRun = array.get(n);
                if (glyphRun.y != f11) {
                    f11 = glyphRun.y;
                    float f12 = targetWidth - f10;
                    if (n4 != 0) {
                        f12 /= 2.0f;
                    }
                    while (n19 < n) {
                        array.get((int)n19++).x += f12;
                    }
                    f10 = 0.0f;
                }
                f10 += glyphRun.width;
                ++n;
            }
            float f13 = targetWidth - f10;
            if (n4 != 0) {
                f13 /= 2.0f;
            }
            while (n19 < n2) {
                array.get((int)n19++).x += f13;
            }
        }
        this.width = f3;
        this.height = bitmapFontData.capHeight + (float)n5 * bitmapFontData.lineHeight;
    }

    private static void a(BitmapFont.BitmapFontData bitmapFontData, GlyphRun glyphRun) {
        BitmapFont.Glyph glyph = glyphRun.glyphs.peek();
        if (bitmapFontData.isWhitespace((char)glyph.id)) {
            return;
        }
        float f = (float)(glyph.xoffset + glyph.width) * bitmapFontData.scaleX - bitmapFontData.padRight;
        glyphRun.width += f - glyphRun.xAdvances.peek();
        glyphRun.xAdvances.set(glyphRun.xAdvances.size - 1, f);
    }

    @Override
    public void reset() {
        Pools.get(GlyphRun.class).freeAll(this.runs);
        this.runs.clear();
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.width);
        stringBuilder.append('x');
        stringBuilder.append(this.height);
        stringBuilder.append('\n');
        int n = 0;
        int n2 = this.runs.size;
        while (n < n2) {
            stringBuilder.append(this.runs.get(n).toString());
            stringBuilder.append('\n');
            ++n;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 1);
        return stringBuilder.toString();
    }

    @BA.Hide
    public static class GlyphRun
    implements Pool.Poolable {
        public final Array<BitmapFont.Glyph> glyphs = new Array();
        public final FloatArray xAdvances = new FloatArray();
        public float x;
        public float y;
        public float width;
        public final Color color = new Color();

        @Override
        public void reset() {
            this.glyphs.clear();
            this.xAdvances.clear();
            this.width = 0.0f;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.glyphs.size);
            Array<BitmapFont.Glyph> array = this.glyphs;
            int n = 0;
            int n2 = array.size;
            while (n < n2) {
                BitmapFont.Glyph glyph = array.get(n);
                stringBuilder.append((char)glyph.id);
                ++n;
            }
            stringBuilder.append(", #");
            stringBuilder.append(this.color);
            stringBuilder.append(", ");
            stringBuilder.append(this.x);
            stringBuilder.append(", ");
            stringBuilder.append(this.y);
            stringBuilder.append(", ");
            stringBuilder.append(this.width);
            return stringBuilder.toString();
        }
    }
}

