/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.Hide
public class NinePatch {
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int MIDDLE_LEFT = 3;
    public static final int MIDDLE_CENTER = 4;
    public static final int MIDDLE_RIGHT = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_CENTER = 7;
    public static final int BOTTOM_RIGHT = 8;
    private static final Color a = new Color();
    private Texture b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;
    private float l;
    private float m;
    private float n;
    private float o;
    private float p;
    private float q;
    private float[] r;
    private int s;
    private final Color t;
    private float u;
    private float v;
    private float w;
    private float x;

    public NinePatch(Texture texture, int left, int right, int top, int bottom) {
        this(new TextureRegion(texture), left, right, top, bottom);
    }

    public NinePatch(TextureRegion region, int left, int right, int top, int bottom) {
        this.c = -1;
        this.d = -1;
        this.e = -1;
        this.f = -1;
        this.g = -1;
        this.h = -1;
        this.i = -1;
        this.j = -1;
        this.k = -1;
        this.r = new float[180];
        this.t = new Color(Color.WHITE);
        this.u = -1.0f;
        this.v = -1.0f;
        this.w = -1.0f;
        this.x = -1.0f;
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        int n = region.getRegionWidth() - left - right;
        int n2 = region.getRegionHeight() - top - bottom;
        TextureRegion[] textureRegionArray = new TextureRegion[9];
        if (top > 0) {
            if (left > 0) {
                textureRegionArray[0] = new TextureRegion(region, 0, 0, left, top);
            }
            if (n > 0) {
                textureRegionArray[1] = new TextureRegion(region, left, 0, n, top);
            }
            if (right > 0) {
                textureRegionArray[2] = new TextureRegion(region, left + n, 0, right, top);
            }
        }
        if (n2 > 0) {
            if (left > 0) {
                textureRegionArray[3] = new TextureRegion(region, 0, top, left, n2);
            }
            if (n > 0) {
                textureRegionArray[4] = new TextureRegion(region, left, top, n, n2);
            }
            if (right > 0) {
                textureRegionArray[5] = new TextureRegion(region, left + n, top, right, n2);
            }
        }
        if (bottom > 0) {
            if (left > 0) {
                textureRegionArray[6] = new TextureRegion(region, 0, top + n2, left, bottom);
            }
            if (n > 0) {
                textureRegionArray[7] = new TextureRegion(region, left, top + n2, n, bottom);
            }
            if (right > 0) {
                textureRegionArray[8] = new TextureRegion(region, left + n, top + n2, right, bottom);
            }
        }
        if (left == 0 && n == 0) {
            textureRegionArray[1] = textureRegionArray[2];
            textureRegionArray[4] = textureRegionArray[5];
            textureRegionArray[7] = textureRegionArray[8];
            textureRegionArray[2] = null;
            textureRegionArray[5] = null;
            textureRegionArray[8] = null;
        }
        if (top == 0 && n2 == 0) {
            textureRegionArray[3] = textureRegionArray[6];
            textureRegionArray[4] = textureRegionArray[7];
            textureRegionArray[5] = textureRegionArray[8];
            textureRegionArray[6] = null;
            textureRegionArray[7] = null;
            textureRegionArray[8] = null;
        }
        this.a(textureRegionArray);
    }

    public NinePatch(Texture texture, Color color) {
        this(texture);
        this.setColor(color);
    }

    public NinePatch(Texture texture) {
        this(new TextureRegion(texture));
    }

    public NinePatch(TextureRegion region, Color color) {
        this(region);
        this.setColor(color);
    }

    public NinePatch(TextureRegion region) {
        this.c = -1;
        this.d = -1;
        this.e = -1;
        this.f = -1;
        this.g = -1;
        this.h = -1;
        this.i = -1;
        this.j = -1;
        this.k = -1;
        this.r = new float[180];
        this.t = new Color(Color.WHITE);
        this.u = -1.0f;
        this.v = -1.0f;
        this.w = -1.0f;
        this.x = -1.0f;
        TextureRegion[] textureRegionArray = new TextureRegion[9];
        textureRegionArray[4] = region;
        this.a(textureRegionArray);
    }

    public NinePatch(TextureRegion ... patches) {
        this.c = -1;
        this.d = -1;
        this.e = -1;
        this.f = -1;
        this.g = -1;
        this.h = -1;
        this.i = -1;
        this.j = -1;
        this.k = -1;
        this.r = new float[180];
        this.t = new Color(Color.WHITE);
        this.u = -1.0f;
        this.v = -1.0f;
        this.w = -1.0f;
        this.x = -1.0f;
        if (patches == null || patches.length != 9) {
            throw new IllegalArgumentException("NinePatch needs nine TextureRegions");
        }
        this.a(patches);
        float f = this.getLeftWidth();
        if (patches[0] != null && (float)patches[0].getRegionWidth() != f || patches[3] != null && (float)patches[3].getRegionWidth() != f || patches[6] != null && (float)patches[6].getRegionWidth() != f) {
            throw new GdxRuntimeException("Left side patches must have the same width");
        }
        float f2 = this.getRightWidth();
        if (patches[2] != null && (float)patches[2].getRegionWidth() != f2 || patches[5] != null && (float)patches[5].getRegionWidth() != f2 || patches[8] != null && (float)patches[8].getRegionWidth() != f2) {
            throw new GdxRuntimeException("Right side patches must have the same width");
        }
        float f3 = this.getBottomHeight();
        if (patches[6] != null && (float)patches[6].getRegionHeight() != f3 || patches[7] != null && (float)patches[7].getRegionHeight() != f3 || patches[8] != null && (float)patches[8].getRegionHeight() != f3) {
            throw new GdxRuntimeException("Bottom side patches must have the same height");
        }
        float f4 = this.getTopHeight();
        if (patches[0] != null && (float)patches[0].getRegionHeight() != f4 || patches[1] != null && (float)patches[1].getRegionHeight() != f4 || patches[2] != null && (float)patches[2].getRegionHeight() != f4) {
            throw new GdxRuntimeException("Top side patches must have the same height");
        }
    }

    public NinePatch(NinePatch ninePatch) {
        NinePatch ninePatch2 = ninePatch;
        this(ninePatch2, ninePatch2.t);
    }

    public NinePatch(NinePatch ninePatch, Color color) {
        this.c = -1;
        this.d = -1;
        this.e = -1;
        this.f = -1;
        this.g = -1;
        this.h = -1;
        this.i = -1;
        this.j = -1;
        this.k = -1;
        this.r = new float[180];
        this.t = new Color(Color.WHITE);
        this.u = -1.0f;
        this.v = -1.0f;
        this.w = -1.0f;
        this.x = -1.0f;
        this.b = ninePatch.b;
        this.c = ninePatch.c;
        this.d = ninePatch.d;
        this.e = ninePatch.e;
        this.f = ninePatch.f;
        this.g = ninePatch.g;
        this.h = ninePatch.h;
        this.i = ninePatch.i;
        this.j = ninePatch.j;
        this.k = ninePatch.k;
        this.l = ninePatch.l;
        this.m = ninePatch.m;
        this.n = ninePatch.n;
        this.o = ninePatch.o;
        this.p = ninePatch.p;
        this.q = ninePatch.q;
        this.u = ninePatch.u;
        this.w = ninePatch.w;
        this.x = ninePatch.x;
        this.v = ninePatch.v;
        this.r = new float[ninePatch.r.length];
        System.arraycopy(ninePatch.r, 0, this.r, 0, ninePatch.r.length);
        this.s = ninePatch.s;
        this.t.set(color);
    }

    private void a(TextureRegion[] textureRegionArray) {
        float f = Color.WHITE.toFloatBits();
        if (textureRegionArray[6] != null) {
            this.c = this.a(textureRegionArray[6], f, false, false);
            this.l = textureRegionArray[6].getRegionWidth();
            this.q = textureRegionArray[6].getRegionHeight();
        }
        if (textureRegionArray[7] != null) {
            this.d = this.a(textureRegionArray[7], f, true, false);
            this.n = Math.max(this.n, (float)textureRegionArray[7].getRegionWidth());
            this.q = Math.max(this.q, (float)textureRegionArray[7].getRegionHeight());
        }
        if (textureRegionArray[8] != null) {
            this.e = this.a(textureRegionArray[8], f, false, false);
            this.m = Math.max(this.m, (float)textureRegionArray[8].getRegionWidth());
            this.q = Math.max(this.q, (float)textureRegionArray[8].getRegionHeight());
        }
        if (textureRegionArray[3] != null) {
            this.f = this.a(textureRegionArray[3], f, false, true);
            this.l = Math.max(this.l, (float)textureRegionArray[3].getRegionWidth());
            this.o = Math.max(this.o, (float)textureRegionArray[3].getRegionHeight());
        }
        if (textureRegionArray[4] != null) {
            this.g = this.a(textureRegionArray[4], f, true, true);
            this.n = Math.max(this.n, (float)textureRegionArray[4].getRegionWidth());
            this.o = Math.max(this.o, (float)textureRegionArray[4].getRegionHeight());
        }
        if (textureRegionArray[5] != null) {
            this.h = this.a(textureRegionArray[5], f, false, true);
            this.m = Math.max(this.m, (float)textureRegionArray[5].getRegionWidth());
            this.o = Math.max(this.o, (float)textureRegionArray[5].getRegionHeight());
        }
        if (textureRegionArray[0] != null) {
            this.i = this.a(textureRegionArray[0], f, false, false);
            this.l = Math.max(this.l, (float)textureRegionArray[0].getRegionWidth());
            this.p = Math.max(this.p, (float)textureRegionArray[0].getRegionHeight());
        }
        if (textureRegionArray[1] != null) {
            this.j = this.a(textureRegionArray[1], f, true, false);
            this.n = Math.max(this.n, (float)textureRegionArray[1].getRegionWidth());
            this.p = Math.max(this.p, (float)textureRegionArray[1].getRegionHeight());
        }
        if (textureRegionArray[2] != null) {
            this.k = this.a(textureRegionArray[2], f, false, false);
            this.m = Math.max(this.m, (float)textureRegionArray[2].getRegionWidth());
            this.p = Math.max(this.p, (float)textureRegionArray[2].getRegionHeight());
        }
        if (this.s < this.r.length) {
            float[] fArray = new float[this.s];
            System.arraycopy(this.r, 0, fArray, 0, this.s);
            this.r = fArray;
        }
    }

    private int a(TextureRegion textureRegion, float f, boolean bl, boolean bl2) {
        float f2;
        if (this.b == null) {
            this.b = textureRegion.getTexture();
        } else if (this.b != textureRegion.getTexture()) {
            throw new IllegalArgumentException("All regions must be from the same texture.");
        }
        float f3 = textureRegion.d;
        float f4 = textureRegion.g;
        float f5 = textureRegion.f;
        float f6 = textureRegion.e;
        if (bl) {
            f2 = 0.5f / (float)this.b.getWidth();
            f3 += f2;
            f5 -= f2;
        }
        if (bl2) {
            f2 = 0.5f / (float)this.b.getHeight();
            f4 -= f2;
            f6 += f2;
        }
        float[] fArray = this.r;
        this.s += 2;
        fArray[this.s++] = f;
        fArray[this.s++] = f3;
        fArray[this.s] = f4;
        this.s += 3;
        fArray[this.s++] = f;
        fArray[this.s++] = f3;
        fArray[this.s] = f6;
        this.s += 3;
        fArray[this.s++] = f;
        fArray[this.s++] = f5;
        fArray[this.s] = f6;
        this.s += 3;
        fArray[this.s++] = f;
        fArray[this.s++] = f5;
        fArray[this.s++] = f4;
        return this.s - 20;
    }

    private void a(int n, float f, float f2, float f3, float f4, float f5) {
        float f6 = f + f3;
        float f7 = f2 + f4;
        float[] fArray = this.r;
        this.r[n++] = f;
        fArray[n++] = f2;
        fArray[n] = f5;
        n += 3;
        fArray[n++] = f;
        fArray[n++] = f7;
        fArray[n] = f5;
        n += 3;
        fArray[n++] = f6;
        fArray[n++] = f7;
        fArray[n] = f5;
        n += 3;
        fArray[n++] = f6;
        fArray[n++] = f2;
        fArray[n] = f5;
    }

    public void draw(Batch batch, float x, float y, float width, float height) {
        float f = x + this.l;
        float f2 = x + width - this.m;
        float f3 = y + this.q;
        float f4 = y + height - this.p;
        float f5 = a.set(this.t).mul(batch.getColor()).toFloatBits();
        if (this.c != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.c, x, y, f - x, f3 - y, f5);
        }
        if (this.d != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.d, f, y, f2 - f, f3 - y, f5);
        }
        if (this.e != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.e, f2, y, x + width - f2, f3 - y, f5);
        }
        if (this.f != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.f, x, f3, f - x, f4 - f3, f5);
        }
        if (this.g != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.g, f, f3, f2 - f, f4 - f3, f5);
        }
        if (this.h != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.h, f2, f3, x + width - f2, f4 - f3, f5);
        }
        if (this.i != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.i, x, f4, f - x, y + height - f4, f5);
        }
        if (this.j != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.j, f, f4, f2 - f, y + height - f4, f5);
        }
        if (this.k != -1) {
            NinePatch ninePatch = this;
            ninePatch.a(ninePatch.k, f2, f4, x + width - f2, y + height - f4, f5);
        }
        batch.draw(this.b, this.r, 0, this.s);
    }

    public void setColor(Color color) {
        this.t.set(color);
    }

    public Color getColor() {
        return this.t;
    }

    public float getLeftWidth() {
        return this.l;
    }

    public void setLeftWidth(float leftWidth) {
        this.l = leftWidth;
    }

    public float getRightWidth() {
        return this.m;
    }

    public void setRightWidth(float rightWidth) {
        this.m = rightWidth;
    }

    public float getTopHeight() {
        return this.p;
    }

    public void setTopHeight(float topHeight) {
        this.p = topHeight;
    }

    public float getBottomHeight() {
        return this.q;
    }

    public void setBottomHeight(float bottomHeight) {
        this.q = bottomHeight;
    }

    public float getMiddleWidth() {
        return this.n;
    }

    public void setMiddleWidth(float middleWidth) {
        this.n = middleWidth;
    }

    public float getMiddleHeight() {
        return this.o;
    }

    public void setMiddleHeight(float middleHeight) {
        this.o = middleHeight;
    }

    public float getTotalWidth() {
        return this.l + this.n + this.m;
    }

    public float getTotalHeight() {
        return this.p + this.o + this.q;
    }

    public void setPadding(float left, float right, float top, float bottom) {
        this.u = left;
        this.v = right;
        this.w = top;
        this.x = bottom;
    }

    public float getPadLeft() {
        if (this.u == -1.0f) {
            return this.getLeftWidth();
        }
        return this.u;
    }

    public void setPadLeft(float left) {
        this.u = left;
    }

    public float getPadRight() {
        if (this.v == -1.0f) {
            return this.getRightWidth();
        }
        return this.v;
    }

    public void setPadRight(float right) {
        this.v = right;
    }

    public float getPadTop() {
        if (this.w == -1.0f) {
            return this.getTopHeight();
        }
        return this.w;
    }

    public void setPadTop(float top) {
        this.w = top;
    }

    public float getPadBottom() {
        if (this.x == -1.0f) {
            return this.getBottomHeight();
        }
        return this.x;
    }

    public void setPadBottom(float bottom) {
        this.x = bottom;
    }

    public void scale(float scaleX, float scaleY) {
        this.l *= scaleX;
        this.m *= scaleX;
        this.p *= scaleY;
        this.q *= scaleY;
        this.n *= scaleX;
        this.o *= scaleY;
        if (this.u != -1.0f) {
            this.u *= scaleX;
        }
        if (this.v != -1.0f) {
            this.v *= scaleX;
        }
        if (this.w != -1.0f) {
            this.w *= scaleY;
        }
        if (this.x != -1.0f) {
            this.x *= scaleY;
        }
    }

    public Texture getTexture() {
        return this.b;
    }
}

