/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;

@BA.Hide
public class ParticleEffect
implements Disposable {
    private final Array<ParticleEmitter> a;
    private BoundingBox b;
    private boolean c;

    public ParticleEffect() {
        this.a = new Array(8);
    }

    public ParticleEffect(ParticleEffect effect) {
        this.a = new Array(true, effect.a.size);
        int n = 0;
        int n2 = effect.a.size;
        while (n < n2) {
            this.a.add(new ParticleEmitter(effect.a.get(n)));
            ++n;
        }
    }

    public void start() {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).start();
            ++n;
        }
    }

    public void reset() {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).reset();
            ++n;
        }
    }

    public void update(float delta) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).update(delta);
            ++n;
        }
    }

    public void draw(Batch spriteBatch) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).draw(spriteBatch);
            ++n;
        }
    }

    public void draw(Batch spriteBatch, float delta) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).draw(spriteBatch, delta);
            ++n;
        }
    }

    public void allowCompletion() {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).allowCompletion();
            ++n;
        }
    }

    public boolean isComplete() {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (!this.a.get(n).isComplete()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setDuration(int duration) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            ParticleEmitter particleEmitter = this.a.get(n);
            particleEmitter.setContinuous(false);
            particleEmitter.duration = duration;
            particleEmitter.durationTimer = 0.0f;
            ++n;
        }
    }

    public void setPosition(float x, float y) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).setPosition(x, y);
            ++n;
        }
    }

    public void setFlip(boolean flipX, boolean flipY) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).setFlip(flipX, flipY);
            ++n;
        }
    }

    public void flipY() {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).flipY();
            ++n;
        }
    }

    public Array<ParticleEmitter> getEmitters() {
        return this.a;
    }

    public ParticleEmitter findEmitter(String name) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            ParticleEmitter particleEmitter = this.a.get(n);
            if (particleEmitter.getName().equals(name)) {
                return particleEmitter;
            }
            ++n;
        }
        return null;
    }

    public void save(Writer output) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = this.a.size;
        while (n2 < n3) {
            ParticleEmitter particleEmitter = this.a.get(n2);
            if (n++ > 0) {
                output.write("\n\n");
            }
            particleEmitter.save(output);
            ++n2;
        }
    }

    public void load(FileHandle effectFile, FileHandle imagesDir) {
        this.loadEmitters(effectFile);
        this.loadEmitterImages(imagesDir);
    }

    public void load(FileHandle effectFile, TextureAtlas atlas) {
        this.load(effectFile, atlas, null);
    }

    public void load(FileHandle effectFile, TextureAtlas atlas, String atlasPrefix) {
        this.loadEmitters(effectFile);
        this.loadEmitterImages(atlas, atlasPrefix);
    }

    public void loadEmitters(FileHandle effectFile) {
        InputStream inputStream = effectFile.read();
        this.a.clear();
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 512);
                do {
                    ParticleEmitter particleEmitter = new ParticleEmitter(bufferedReader);
                    this.a.add(particleEmitter);
                } while (bufferedReader.readLine() != null && bufferedReader.readLine() != null);
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error loading effect: ".concat(String.valueOf(effectFile)), iOException);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        StreamUtils.closeQuietly(bufferedReader);
    }

    public void loadEmitterImages(TextureAtlas atlas) {
        this.loadEmitterImages(atlas, null);
    }

    public void loadEmitterImages(TextureAtlas atlas, String atlasPrefix) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            ParticleEmitter particleEmitter = this.a.get(n);
            String string = particleEmitter.getImagePath();
            if (string != null) {
                Sprite sprite;
                String string2 = new File(string.replace('\\', '/')).getName();
                int n3 = string2.lastIndexOf(46);
                if (n3 != -1) {
                    string2 = string2.substring(0, n3);
                }
                if (atlasPrefix != null) {
                    string2 = String.valueOf(atlasPrefix) + string2;
                }
                if ((sprite = atlas.createSprite(string2)) == null) {
                    throw new IllegalArgumentException("SpriteSheet missing image: ".concat(String.valueOf(string2)));
                }
                particleEmitter.setSprite(sprite);
            }
            ++n;
        }
    }

    public void loadEmitterImages(FileHandle imagesDir) {
        this.c = true;
        HashMap<String, Sprite> hashMap = new HashMap<String, Sprite>(this.a.size);
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            ParticleEmitter particleEmitter = this.a.get(n);
            String string = particleEmitter.getImagePath();
            if (string != null) {
                String string2 = new File(string.replace('\\', '/')).getName();
                Sprite sprite = (Sprite)hashMap.get(string2);
                if (sprite == null) {
                    sprite = new Sprite(this.loadTexture(imagesDir.child(string2)));
                    hashMap.put(string2, sprite);
                }
                particleEmitter.setSprite(sprite);
            }
            ++n;
        }
    }

    protected Texture loadTexture(FileHandle file) {
        return new Texture(file, false);
    }

    @Override
    public void dispose() {
        if (!this.c) {
            return;
        }
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).getSprite().getTexture().dispose();
            ++n;
        }
    }

    public BoundingBox getBoundingBox() {
        if (this.b == null) {
            this.b = new BoundingBox();
        }
        BoundingBox boundingBox = this.b;
        boundingBox.inf();
        for (ParticleEmitter particleEmitter : this.a) {
            boundingBox.ext2(particleEmitter.getBoundingBox());
        }
        return boundingBox;
    }

    public void scaleEffect(float scaleFactor) {
        for (ParticleEmitter particleEmitter : this.a) {
            particleEmitter.getScale().setHigh(particleEmitter.getScale().getHighMin() * scaleFactor, particleEmitter.getScale().getHighMax() * scaleFactor);
            particleEmitter.getScale().setLow(particleEmitter.getScale().getLowMin() * scaleFactor, particleEmitter.getScale().getLowMax() * scaleFactor);
            particleEmitter.getVelocity().setHigh(particleEmitter.getVelocity().getHighMin() * scaleFactor, particleEmitter.getVelocity().getHighMax() * scaleFactor);
            particleEmitter.getVelocity().setLow(particleEmitter.getVelocity().getLowMin() * scaleFactor, particleEmitter.getVelocity().getLowMax() * scaleFactor);
            particleEmitter.getGravity().setHigh(particleEmitter.getGravity().getHighMin() * scaleFactor, particleEmitter.getGravity().getHighMax() * scaleFactor);
            particleEmitter.getGravity().setLow(particleEmitter.getGravity().getLowMin() * scaleFactor, particleEmitter.getGravity().getLowMax() * scaleFactor);
            particleEmitter.getWind().setHigh(particleEmitter.getWind().getHighMin() * scaleFactor, particleEmitter.getWind().getHighMax() * scaleFactor);
            particleEmitter.getWind().setLow(particleEmitter.getWind().getLowMin() * scaleFactor, particleEmitter.getWind().getLowMax() * scaleFactor);
            particleEmitter.getSpawnWidth().setHigh(particleEmitter.getSpawnWidth().getHighMin() * scaleFactor, particleEmitter.getSpawnWidth().getHighMax() * scaleFactor);
            particleEmitter.getSpawnWidth().setLow(particleEmitter.getSpawnWidth().getLowMin() * scaleFactor, particleEmitter.getSpawnWidth().getLowMax() * scaleFactor);
            particleEmitter.getSpawnHeight().setHigh(particleEmitter.getSpawnHeight().getHighMin() * scaleFactor, particleEmitter.getSpawnHeight().getHighMax() * scaleFactor);
            particleEmitter.getSpawnHeight().setLow(particleEmitter.getSpawnHeight().getLowMin() * scaleFactor, particleEmitter.getSpawnHeight().getLowMax() * scaleFactor);
            particleEmitter.getXOffsetValue().setLow(particleEmitter.getXOffsetValue().getLowMin() * scaleFactor, particleEmitter.getXOffsetValue().getLowMax() * scaleFactor);
            particleEmitter.getYOffsetValue().setLow(particleEmitter.getYOffsetValue().getLowMin() * scaleFactor, particleEmitter.getYOffsetValue().getLowMax() * scaleFactor);
        }
    }

    public void setEmittersCleanUpBlendFunction(boolean cleanUpBlendFunction) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            this.a.get(n).setCleansUpBlendFunction(cleanUpBlendFunction);
            ++n;
        }
    }
}

