/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;

@BA.Hide
public class ParticleEmitter {
    private RangedNumericValue a = new RangedNumericValue();
    private ScaledNumericValue b = new ScaledNumericValue();
    private RangedNumericValue c = new RangedNumericValue();
    private ScaledNumericValue d = new ScaledNumericValue();
    private ScaledNumericValue e = new ScaledNumericValue();
    private ScaledNumericValue f = new ScaledNumericValue();
    private ScaledNumericValue g = new ScaledNumericValue();
    private ScaledNumericValue h = new ScaledNumericValue();
    private ScaledNumericValue i = new ScaledNumericValue();
    private ScaledNumericValue j = new ScaledNumericValue();
    private ScaledNumericValue k = new ScaledNumericValue();
    private ScaledNumericValue l = new ScaledNumericValue();
    private GradientColorValue m = new GradientColorValue();
    private RangedNumericValue n = new ScaledNumericValue();
    private RangedNumericValue o = new ScaledNumericValue();
    private ScaledNumericValue p = new ScaledNumericValue();
    private ScaledNumericValue q = new ScaledNumericValue();
    private SpawnShapeValue r = new SpawnShapeValue();
    private float s;
    private Sprite t;
    private Particle[] u;
    private int v;
    private int w = 4;
    private float x;
    private float y;
    private String z;
    private String A;
    private int B;
    private boolean[] C;
    private boolean D;
    private boolean E;
    private boolean F;
    private int G;
    private boolean H;
    private BoundingBox I;
    private int J;
    private int K;
    private int L;
    private int M;
    private int N;
    private int O;
    private int P;
    private float Q;
    private float R;
    private float S;
    private float T;
    public float duration = 1.0f;
    public float durationTimer;
    private float U;
    private float V;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    private boolean aa = true;
    private boolean ab = false;
    private boolean ac = true;
    private static /* synthetic */ int[] ad;
    private static /* synthetic */ int[] ae;

    public ParticleEmitter() {
        this.a();
    }

    public ParticleEmitter(BufferedReader reader) throws IOException {
        this.a();
        this.load(reader);
    }

    public ParticleEmitter(ParticleEmitter emitter) {
        this.t = emitter.t;
        this.z = emitter.z;
        this.A = emitter.A;
        this.setMaxParticleCount(emitter.w);
        this.v = emitter.v;
        this.a.load(emitter.a);
        this.c.load(emitter.c);
        this.e.load(emitter.e);
        this.d.load(emitter.d);
        this.b.load(emitter.b);
        this.f.load(emitter.f);
        this.g.load(emitter.g);
        this.h.load(emitter.h);
        this.i.load(emitter.i);
        this.j.load(emitter.j);
        this.k.load(emitter.k);
        this.l.load(emitter.l);
        this.m.load(emitter.m);
        this.n.load(emitter.n);
        this.o.load(emitter.o);
        this.p.load(emitter.p);
        this.q.load(emitter.q);
        this.r.load(emitter.r);
        this.W = emitter.W;
        this.X = emitter.X;
        this.Y = emitter.Y;
        this.Z = emitter.Z;
        this.aa = emitter.aa;
        this.ab = emitter.ab;
        this.ac = emitter.ac;
    }

    private void a() {
        this.c.setAlwaysActive(true);
        this.e.setAlwaysActive(true);
        this.d.setAlwaysActive(true);
        this.f.setAlwaysActive(true);
        this.l.setAlwaysActive(true);
        this.r.setAlwaysActive(true);
        this.p.setAlwaysActive(true);
        this.q.setAlwaysActive(true);
    }

    public void setMaxParticleCount(int maxParticleCount) {
        this.w = maxParticleCount;
        this.C = new boolean[maxParticleCount];
        this.B = 0;
        this.u = new Particle[maxParticleCount];
    }

    public void addParticle() {
        int n = this.B;
        if (n == this.w) {
            return;
        }
        boolean[] blArray = this.C;
        int n2 = 0;
        int n3 = blArray.length;
        while (n2 < n3) {
            if (!blArray[n2]) {
                this.a(n2);
                blArray[n2] = true;
                this.B = n + 1;
                return;
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void addParticles(int count) {
        if ((count = Math.min(count, this.w - this.B)) == 0) {
            return;
        }
        var2_2 = this.C;
        var3_3 = 0;
        var4_4 = var2_2.length;
        var5_5 = 0;
        if (true) ** GOTO lbl16
        do {
            if (!var2_2[var3_3]) {
                this.a(var3_3);
                var2_2[var3_3++] = true;
                ++var5_5;
            } else {
                ++var3_3;
                continue;
            }
lbl16:
            // 2 sources

            if (var5_5 >= count) break;
        } while (var3_3 < var4_4);
        this.B += count;
    }

    public void update(float delta) {
        this.s += delta * 1000.0f;
        if (this.s < 1.0f) {
            return;
        }
        int n = (int)this.s;
        this.s -= (float)n;
        if (this.V < this.U) {
            this.V += (float)n;
        } else {
            boolean bl = false;
            if (this.D) {
                this.D = false;
                this.addParticle();
            }
            if (this.durationTimer < this.duration) {
                this.durationTimer += (float)n;
            } else if (!this.X || this.H) {
                bl = true;
            } else {
                this.b();
            }
            if (!bl) {
                float f;
                this.L += n;
                float f2 = (float)this.J + (float)this.K * this.e.getScale(this.durationTimer / this.duration);
                if (f > 0.0f && (float)this.L >= (f2 = 1000.0f / f2)) {
                    int n2 = Math.min((int)((float)this.L / f2), this.w - this.B);
                    this.L = (int)((float)this.L - (float)n2 * f2);
                    this.L = (int)((float)this.L % f2);
                    this.addParticles(n2);
                }
                if (this.B < this.v) {
                    ParticleEmitter particleEmitter = this;
                    particleEmitter.addParticles(particleEmitter.v - this.B);
                }
            }
        }
        boolean[] blArray = this.C;
        int n3 = this.B;
        Particle[] particleArray = this.u;
        int n4 = 0;
        int n5 = blArray.length;
        while (n4 < n5) {
            if (blArray[n4] && !this.a(particleArray[n4], delta, n)) {
                blArray[n4] = false;
                --n3;
            }
            ++n4;
        }
        this.B = n3;
    }

    public void draw(Batch batch) {
        if (this.ab) {
            batch.setBlendFunction(1, 771);
        } else if (this.aa) {
            batch.setBlendFunction(770, 1);
        } else {
            batch.setBlendFunction(770, 771);
        }
        Particle[] particleArray = this.u;
        boolean[] blArray = this.C;
        int n = 0;
        int n2 = blArray.length;
        while (n < n2) {
            if (blArray[n]) {
                particleArray[n].draw(batch);
            }
            ++n;
        }
        if (this.ac && (this.aa || this.ab)) {
            batch.setBlendFunction(770, 771);
        }
    }

    public void draw(Batch batch, float delta) {
        float f;
        this.s += delta * 1000.0f;
        if (this.s < 1.0f) {
            this.draw(batch);
            return;
        }
        int n = (int)this.s;
        this.s -= (float)n;
        if (this.ab) {
            batch.setBlendFunction(1, 771);
        } else if (this.aa) {
            batch.setBlendFunction(770, 1);
        } else {
            batch.setBlendFunction(770, 771);
        }
        Particle[] particleArray = this.u;
        boolean[] blArray = this.C;
        int n2 = this.B;
        int n3 = 0;
        int n4 = blArray.length;
        while (n3 < n4) {
            if (blArray[n3]) {
                Particle particle = particleArray[n3];
                if (this.a(particle, delta, n)) {
                    particle.draw(batch);
                } else {
                    blArray[n3] = false;
                    --n2;
                }
            }
            ++n3;
        }
        this.B = n2;
        if (this.ac && (this.aa || this.ab)) {
            batch.setBlendFunction(770, 771);
        }
        if (this.V < this.U) {
            this.V += (float)n;
            return;
        }
        if (this.D) {
            this.D = false;
            this.addParticle();
        }
        if (this.durationTimer < this.duration) {
            this.durationTimer += (float)n;
        } else {
            if (!this.X || this.H) {
                return;
            }
            this.b();
        }
        this.L += n;
        float f2 = (float)this.J + (float)this.K * this.e.getScale(this.durationTimer / this.duration);
        if (f > 0.0f && (float)this.L >= (f2 = 1000.0f / f2)) {
            n4 = Math.min((int)((float)this.L / f2), this.w - n2);
            this.L = (int)((float)this.L - (float)n4 * f2);
            this.L = (int)((float)this.L % f2);
            this.addParticles(n4);
        }
        if (n2 < this.v) {
            ParticleEmitter particleEmitter = this;
            particleEmitter.addParticles(particleEmitter.v - n2);
        }
    }

    public void start() {
        this.D = true;
        this.H = false;
        this.b();
    }

    public void reset() {
        this.L = 0;
        this.durationTimer = this.duration;
        boolean[] blArray = this.C;
        int n = 0;
        int n2 = blArray.length;
        while (n < n2) {
            blArray[n] = false;
            ++n;
        }
        this.B = 0;
        this.start();
    }

    private void b() {
        this.U = this.a.b ? this.a.newLowValue() : 0.0f;
        this.V = 0.0f;
        this.durationTimer -= this.duration;
        this.duration = this.c.newLowValue();
        this.J = (int)this.e.newLowValue();
        this.K = (int)this.e.newHighValue();
        if (!this.e.isRelative()) {
            this.K -= this.J;
        }
        this.O = (int)this.d.newLowValue();
        this.P = (int)this.d.newHighValue();
        if (!this.d.isRelative()) {
            this.P -= this.O;
        }
        this.M = this.b.b ? (int)this.b.newLowValue() : 0;
        this.N = (int)this.b.newHighValue();
        if (!this.b.isRelative()) {
            this.N -= this.M;
        }
        this.Q = this.p.newLowValue();
        this.R = this.p.newHighValue();
        if (!this.p.isRelative()) {
            this.R -= this.Q;
        }
        this.S = this.q.newLowValue();
        this.T = this.q.newHighValue();
        if (!this.q.isRelative()) {
            this.T -= this.S;
        }
        this.G = 0;
        if (this.i.b && this.i.a.length > 1) {
            this.G |= 2;
        }
        if (this.h.b) {
            this.G |= 8;
        }
        if (this.f.a.length > 1) {
            this.G |= 1;
        }
        if (this.g.b && this.g.a.length > 1) {
            this.G |= 4;
        }
        if (this.j.b) {
            this.G |= 0x10;
        }
        if (this.k.b) {
            this.G |= 0x20;
        }
        if (this.m.a.length > 1) {
            this.G |= 0x40;
        }
    }

    protected Particle newParticle(Sprite sprite) {
        return new Particle(sprite);
    }

    private void a(int n) {
        float f;
        Particle particle = this.u[n];
        if (particle == null) {
            ParticleEmitter particleEmitter = this;
            this.u[n] = particle = particleEmitter.newParticle(particleEmitter.t);
            particle.flip(this.E, this.F);
        }
        float f2 = this.durationTimer / this.duration;
        int n2 = this.G;
        Particle particle2 = particle;
        particle2.currentLife = particle2.life = this.O + (int)((float)this.P * this.d.getScale(f2));
        if (this.h.b) {
            particle.velocity = this.h.newLowValue();
            particle.velocityDiff = this.h.newHighValue();
            if (!this.h.isRelative()) {
                particle.velocityDiff -= particle.velocity;
            }
        }
        particle.angle = this.i.newLowValue();
        particle.angleDiff = this.i.newHighValue();
        if (!this.i.isRelative()) {
            particle.angleDiff -= particle.angle;
        }
        float f3 = 0.0f;
        if ((n2 & 2) == 0) {
            particle.angle = f3 = particle.angle + particle.angleDiff * this.i.getScale(0.0f);
            particle.angleCos = MathUtils.cosDeg(f3);
            particle.angleSin = MathUtils.sinDeg(f3);
        }
        float f4 = this.t.getWidth();
        particle.scale = this.f.newLowValue() / f4;
        particle.scaleDiff = this.f.newHighValue() / f4;
        if (!this.f.isRelative()) {
            particle.scaleDiff -= particle.scale;
        }
        Particle particle3 = particle;
        particle3.setScale(particle3.scale + particle.scaleDiff * this.f.getScale(0.0f));
        if (this.g.b) {
            particle.rotation = this.g.newLowValue();
            particle.rotationDiff = this.g.newHighValue();
            if (!this.g.isRelative()) {
                particle.rotationDiff -= particle.rotation;
            }
            float f5 = particle.rotation + particle.rotationDiff * this.g.getScale(0.0f);
            if (this.Y) {
                f5 += f3;
            }
            particle.setRotation(f5);
        }
        if (this.j.b) {
            particle.wind = this.j.newLowValue();
            particle.windDiff = this.j.newHighValue();
            if (!this.j.isRelative()) {
                particle.windDiff -= particle.wind;
            }
        }
        if (this.k.b) {
            particle.gravity = this.k.newLowValue();
            particle.gravityDiff = this.k.newHighValue();
            if (!this.k.isRelative()) {
                particle.gravityDiff -= particle.gravity;
            }
        }
        float[] fArray = particle.tint;
        if (particle.tint == null) {
            particle.tint = fArray = new float[3];
        }
        float[] fArray2 = this.m.getColor(0.0f);
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
        particle.transparency = this.l.newLowValue();
        particle.transparencyDiff = this.l.newHighValue() - particle.transparency;
        float f6 = this.x;
        if (this.n.b) {
            f6 += this.n.newLowValue();
        }
        float f7 = this.y;
        if (this.o.b) {
            f7 += this.o.newLowValue();
        }
        switch (ParticleEmitter.d()[this.r.a.ordinal()]) {
            case 3: {
                f = this.Q + this.R * this.p.getScale(f2);
                float f8 = this.S + this.T * this.q.getScale(f2);
                f6 += MathUtils.random(f) - f / 2.0f;
                f7 += MathUtils.random(f8) - f8 / 2.0f;
                break;
            }
            case 4: {
                float f9;
                float f10;
                float f11;
                float f12;
                f = this.Q + this.R * this.p.getScale(f2);
                float f8 = this.S + this.T * this.q.getScale(f2);
                float f13 = f / 2.0f;
                float f14 = f8 / 2.0f;
                if (f13 == 0.0f || f14 == 0.0f) break;
                float f15 = f13 / f14;
                if (this.r.d) {
                    float f16;
                    switch (ParticleEmitter.c()[this.r.e.ordinal()]) {
                        case 2: {
                            f16 = -MathUtils.random(179.0f);
                            break;
                        }
                        case 3: {
                            f16 = MathUtils.random(179.0f);
                            break;
                        }
                        default: {
                            f16 = MathUtils.random(360.0f);
                        }
                    }
                    float f17 = MathUtils.cosDeg(f16);
                    float f18 = MathUtils.sinDeg(f16);
                    f6 += f17 * f13;
                    f7 += f18 * f13 / f15;
                    if ((n2 & 2) != 0) break;
                    particle.angle = f16;
                    particle.angleCos = f17;
                    particle.angleSin = f18;
                    break;
                }
                float f19 = f13;
                float f20 = f19 * f19;
                do {
                    f10 = MathUtils.random(f) - f13;
                    f9 = MathUtils.random(f8) - f14;
                    f12 = f10;
                    f11 = f9;
                } while (!(f12 * f12 + f11 * f11 <= f20));
                f6 += f10;
                f7 += f9 / f15;
                break;
            }
            case 2: {
                f = this.Q + this.R * this.p.getScale(f2);
                float f8 = this.S + this.T * this.q.getScale(f2);
                if (f != 0.0f) {
                    float f21 = f * MathUtils.random();
                    f6 += f21;
                    f7 += f21 * (f8 / f);
                    break;
                }
                f7 += f8 * MathUtils.random();
            }
        }
        f = this.t.getHeight();
        particle.setBounds(f6 - f4 / 2.0f, f7 - f / 2.0f, f4, f);
        int n3 = (int)((float)this.M + (float)this.N * this.b.getScale(f2));
        if (n3 > 0) {
            if (n3 >= particle.currentLife) {
                n3 = particle.currentLife - 1;
            }
            this.a(particle, (float)n3 / 1000.0f, n3);
        }
    }

    private boolean a(Particle particle, float f, int n) {
        float f2;
        float f3;
        int n2 = particle.currentLife - n;
        if (n2 <= 0) {
            return false;
        }
        particle.currentLife = n2;
        float f4 = 1.0f - (float)particle.currentLife / (float)particle.life;
        int n3 = this.G;
        if ((n3 & 1) != 0) {
            Particle particle2 = particle;
            particle2.setScale(particle2.scale + particle.scaleDiff * this.f.getScale(f4));
        }
        if ((n3 & 8) != 0) {
            float f5 = (particle.velocity + particle.velocityDiff * this.h.getScale(f4)) * f;
            if ((n3 & 2) != 0) {
                float f6 = particle.angle + particle.angleDiff * this.i.getScale(f4);
                f3 = f5 * MathUtils.cosDeg(f6);
                f2 = f5 * MathUtils.sinDeg(f6);
                if ((n3 & 4) != 0) {
                    float f7 = particle.rotation + particle.rotationDiff * this.g.getScale(f4);
                    if (this.Y) {
                        f7 += f6;
                    }
                    particle.setRotation(f7);
                }
            } else {
                f3 = f5 * particle.angleCos;
                f2 = f5 * particle.angleSin;
                if (this.Y || (n3 & 4) != 0) {
                    float f8 = particle.rotation + particle.rotationDiff * this.g.getScale(f4);
                    if (this.Y) {
                        f8 += particle.angle;
                    }
                    particle.setRotation(f8);
                }
            }
            if ((n3 & 0x10) != 0) {
                f3 += (particle.wind + particle.windDiff * this.j.getScale(f4)) * f;
            }
            if ((n3 & 0x20) != 0) {
                f2 += (particle.gravity + particle.gravityDiff * this.k.getScale(f4)) * f;
            }
            particle.translate(f3, f2);
        } else if ((n3 & 4) != 0) {
            Particle particle3 = particle;
            particle3.setRotation(particle3.rotation + particle.rotationDiff * this.g.getScale(f4));
        }
        float[] fArray = (n3 & 0x40) != 0 ? this.m.getColor(f4) : particle.tint;
        if (this.ab) {
            f3 = !this.aa ? 1 : 0;
            f2 = particle.transparency + particle.transparencyDiff * this.l.getScale(f4);
            particle.setColor(fArray[0] * f2, fArray[1] * f2, fArray[2] * f2, f2 * f3);
        } else {
            particle.setColor(fArray[0], fArray[1], fArray[2], particle.transparency + particle.transparencyDiff * this.l.getScale(f4));
        }
        return true;
    }

    public void setPosition(float x, float y) {
        if (this.W) {
            float f = x - this.x;
            float f2 = y - this.y;
            boolean[] blArray = this.C;
            int n = 0;
            int n2 = blArray.length;
            while (n < n2) {
                if (blArray[n]) {
                    this.u[n].translate(f, f2);
                }
                ++n;
            }
        }
        this.x = x;
        this.y = y;
    }

    public void setSprite(Sprite sprite) {
        this.t = sprite;
        if (sprite == null) {
            return;
        }
        float f = sprite.getOriginX();
        float f2 = sprite.getOriginY();
        Texture texture = sprite.getTexture();
        int n = 0;
        int n2 = this.u.length;
        while (n < n2) {
            Particle particle = this.u[n];
            if (particle == null) break;
            particle.setTexture(texture);
            particle.setOrigin(f, f2);
            ++n;
        }
    }

    public void allowCompletion() {
        this.H = true;
        this.durationTimer = this.duration;
    }

    public Sprite getSprite() {
        return this.t;
    }

    public String getName() {
        return this.z;
    }

    public void setName(String name) {
        this.z = name;
    }

    public ScaledNumericValue getLife() {
        return this.d;
    }

    public ScaledNumericValue getScale() {
        return this.f;
    }

    public ScaledNumericValue getRotation() {
        return this.g;
    }

    public GradientColorValue getTint() {
        return this.m;
    }

    public ScaledNumericValue getVelocity() {
        return this.h;
    }

    public ScaledNumericValue getWind() {
        return this.j;
    }

    public ScaledNumericValue getGravity() {
        return this.k;
    }

    public ScaledNumericValue getAngle() {
        return this.i;
    }

    public ScaledNumericValue getEmission() {
        return this.e;
    }

    public ScaledNumericValue getTransparency() {
        return this.l;
    }

    public RangedNumericValue getDuration() {
        return this.c;
    }

    public RangedNumericValue getDelay() {
        return this.a;
    }

    public ScaledNumericValue getLifeOffset() {
        return this.b;
    }

    public RangedNumericValue getXOffsetValue() {
        return this.n;
    }

    public RangedNumericValue getYOffsetValue() {
        return this.o;
    }

    public ScaledNumericValue getSpawnWidth() {
        return this.p;
    }

    public ScaledNumericValue getSpawnHeight() {
        return this.q;
    }

    public SpawnShapeValue getSpawnShape() {
        return this.r;
    }

    public boolean isAttached() {
        return this.W;
    }

    public void setAttached(boolean attached) {
        this.W = attached;
    }

    public boolean isContinuous() {
        return this.X;
    }

    public void setContinuous(boolean continuous) {
        this.X = continuous;
    }

    public boolean isAligned() {
        return this.Y;
    }

    public void setAligned(boolean aligned) {
        this.Y = aligned;
    }

    public boolean isAdditive() {
        return this.aa;
    }

    public void setAdditive(boolean additive) {
        this.aa = additive;
    }

    public boolean cleansUpBlendFunction() {
        return this.ac;
    }

    public void setCleansUpBlendFunction(boolean cleansUpBlendFunction) {
        this.ac = cleansUpBlendFunction;
    }

    public boolean isBehind() {
        return this.Z;
    }

    public void setBehind(boolean behind) {
        this.Z = behind;
    }

    public boolean isPremultipliedAlpha() {
        return this.ab;
    }

    public void setPremultipliedAlpha(boolean premultipliedAlpha) {
        this.ab = premultipliedAlpha;
    }

    public int getMinParticleCount() {
        return this.v;
    }

    public void setMinParticleCount(int minParticleCount) {
        this.v = minParticleCount;
    }

    public int getMaxParticleCount() {
        return this.w;
    }

    public boolean isComplete() {
        if (this.X && !this.H) {
            return false;
        }
        if (this.V < this.U) {
            return false;
        }
        return this.durationTimer >= this.duration && this.B == 0;
    }

    public float getPercentComplete() {
        if (this.V < this.U) {
            return 0.0f;
        }
        return Math.min(1.0f, this.durationTimer / this.duration);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getActiveCount() {
        return this.B;
    }

    public String getImagePath() {
        return this.A;
    }

    public void setImagePath(String imagePath) {
        this.A = imagePath;
    }

    public void setFlip(boolean flipX, boolean flipY) {
        this.E = flipX;
        this.F = flipY;
        if (this.u == null) {
            return;
        }
        int n = 0;
        int n2 = this.u.length;
        while (n < n2) {
            Particle particle = this.u[n];
            if (particle != null) {
                particle.flip(flipX, flipY);
            }
            ++n;
        }
    }

    public void flipY() {
        this.i.setHigh(-this.i.getHighMin(), -this.i.getHighMax());
        this.i.setLow(-this.i.getLowMin(), -this.i.getLowMax());
        this.k.setHigh(-this.k.getHighMin(), -this.k.getHighMax());
        this.k.setLow(-this.k.getLowMin(), -this.k.getLowMax());
        this.j.setHigh(-this.j.getHighMin(), -this.j.getHighMax());
        this.j.setLow(-this.j.getLowMin(), -this.j.getLowMax());
        this.g.setHigh(-this.g.getHighMin(), -this.g.getHighMax());
        this.g.setLow(-this.g.getLowMin(), -this.g.getLowMax());
        this.o.setLow(-this.o.getLowMin(), -this.o.getLowMax());
    }

    public BoundingBox getBoundingBox() {
        if (this.I == null) {
            this.I = new BoundingBox();
        }
        Particle[] particleArray = this.u;
        boolean[] blArray = this.C;
        BoundingBox boundingBox = this.I;
        boundingBox.inf();
        int n = 0;
        int n2 = blArray.length;
        while (n < n2) {
            if (blArray[n]) {
                Rectangle rectangle = particleArray[n].getBoundingRectangle();
                boundingBox.ext4(rectangle.x, rectangle.y, 0.0f);
                boundingBox.ext4(rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0.0f);
            }
            ++n;
        }
        return boundingBox;
    }

    public void save(Writer output) throws IOException {
        output.write(String.valueOf(this.z) + "\n");
        output.write("- Delay -\n");
        this.a.save(output);
        output.write("- Duration - \n");
        this.c.save(output);
        output.write("- Count - \n");
        output.write("min: " + this.v + "\n");
        output.write("max: " + this.w + "\n");
        output.write("- Emission - \n");
        this.e.save(output);
        output.write("- Life - \n");
        this.d.save(output);
        output.write("- Life Offset - \n");
        this.b.save(output);
        output.write("- X Offset - \n");
        this.n.save(output);
        output.write("- Y Offset - \n");
        this.o.save(output);
        output.write("- Spawn Shape - \n");
        this.r.save(output);
        output.write("- Spawn Width - \n");
        this.p.save(output);
        output.write("- Spawn Height - \n");
        this.q.save(output);
        output.write("- Scale - \n");
        this.f.save(output);
        output.write("- Velocity - \n");
        this.h.save(output);
        output.write("- Angle - \n");
        this.i.save(output);
        output.write("- Rotation - \n");
        this.g.save(output);
        output.write("- Wind - \n");
        this.j.save(output);
        output.write("- Gravity - \n");
        this.k.save(output);
        output.write("- Tint - \n");
        this.m.save(output);
        output.write("- Transparency - \n");
        this.l.save(output);
        output.write("- Options - \n");
        output.write("attached: " + this.W + "\n");
        output.write("continuous: " + this.X + "\n");
        output.write("aligned: " + this.Y + "\n");
        output.write("additive: " + this.aa + "\n");
        output.write("behind: " + this.Z + "\n");
        output.write("premultipliedAlpha: " + this.ab + "\n");
        output.write("- Image Path -\n");
        output.write(String.valueOf(this.A) + "\n");
    }

    public void load(BufferedReader reader) throws IOException {
        try {
            this.z = ParticleEmitter.a(reader, "name");
            reader.readLine();
            this.a.load(reader);
            reader.readLine();
            this.c.load(reader);
            reader.readLine();
            this.setMinParticleCount(ParticleEmitter.c(reader, "minParticleCount"));
            this.setMaxParticleCount(ParticleEmitter.c(reader, "maxParticleCount"));
            reader.readLine();
            this.e.load(reader);
            reader.readLine();
            this.d.load(reader);
            reader.readLine();
            this.b.load(reader);
            reader.readLine();
            this.n.load(reader);
            reader.readLine();
            this.o.load(reader);
            reader.readLine();
            this.r.load(reader);
            reader.readLine();
            this.p.load(reader);
            reader.readLine();
            this.q.load(reader);
            reader.readLine();
            this.f.load(reader);
            reader.readLine();
            this.h.load(reader);
            reader.readLine();
            this.i.load(reader);
            reader.readLine();
            this.g.load(reader);
            reader.readLine();
            this.j.load(reader);
            reader.readLine();
            this.k.load(reader);
            reader.readLine();
            this.m.load(reader);
            reader.readLine();
            this.l.load(reader);
            reader.readLine();
            this.W = ParticleEmitter.b(reader, "attached");
            this.X = ParticleEmitter.b(reader, "continuous");
            this.Y = ParticleEmitter.b(reader, "aligned");
            this.aa = ParticleEmitter.b(reader, "additive");
            this.Z = ParticleEmitter.b(reader, "behind");
            String string = reader.readLine();
            if (string.startsWith("premultipliedAlpha")) {
                this.ab = Boolean.parseBoolean(ParticleEmitter.a(string));
                reader.readLine();
            }
            this.setImagePath(reader.readLine());
            return;
        }
        catch (RuntimeException runtimeException) {
            if (this.z == null) {
                throw runtimeException;
            }
            throw new RuntimeException("Error parsing emitter: " + this.z, runtimeException);
        }
    }

    private static String a(String string) throws IOException {
        String string2 = string;
        return string2.substring(string2.indexOf(":") + 1).trim();
    }

    static String a(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            throw new IOException("Missing value: ".concat(String.valueOf(string)));
        }
        return ParticleEmitter.a(string2);
    }

    static boolean b(BufferedReader bufferedReader, String string) throws IOException {
        return Boolean.parseBoolean(ParticleEmitter.a(bufferedReader, string));
    }

    static int c(BufferedReader bufferedReader, String string) throws IOException {
        return Integer.parseInt(ParticleEmitter.a(bufferedReader, string));
    }

    static float d(BufferedReader bufferedReader, String string) throws IOException {
        return Float.parseFloat(ParticleEmitter.a(bufferedReader, string));
    }

    private static /* synthetic */ int[] c() {
        if (ad != null) {
            return ad;
        }
        int[] nArray = new int[SpawnEllipseSide.values().length];
        try {
            nArray[SpawnEllipseSide.both.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SpawnEllipseSide.bottom.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SpawnEllipseSide.top.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        ad = nArray;
        return nArray;
    }

    private static /* synthetic */ int[] d() {
        if (ae != null) {
            return ae;
        }
        int[] nArray = new int[SpawnShape.values().length];
        try {
            nArray[SpawnShape.ellipse.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SpawnShape.line.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SpawnShape.point.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SpawnShape.square.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        ae = nArray;
        return nArray;
    }

    @BA.ShortName(value="lgParticleGradientColorValue")
    public static class GradientColorValue
    extends ParticleValue {
        private static float[] d = new float[4];
        private float[] e = new float[]{1.0f, 1.0f, 1.0f};
        float[] a = new float[]{0.0f};

        public GradientColorValue() {
            this.c = true;
        }

        public float[] getTimeline() {
            return this.a;
        }

        public void setTimeline(float[] timeline) {
            this.a = timeline;
        }

        public float[] getColors() {
            return this.e;
        }

        public void setColors(float[] colors) {
            this.e = colors;
        }

        public float[] getColor(float percent) {
            int n = 0;
            int n2 = -1;
            float[] fArray = this.a;
            int n3 = this.a.length;
            int n4 = 1;
            while (n4 < n3) {
                if (fArray[n4] > percent) {
                    n2 = n4;
                    break;
                }
                n = n4++;
            }
            float f = fArray[n];
            float f2 = this.e[n *= 3];
            float f3 = this.e[n + 1];
            float f4 = this.e[n + 2];
            if (n2 == -1) {
                GradientColorValue.d[0] = f2;
                GradientColorValue.d[1] = f3;
                GradientColorValue.d[2] = f4;
                return d;
            }
            float f5 = (percent - f) / (fArray[n2] - f);
            GradientColorValue.d[0] = f2 + (this.e[n2 *= 3] - f2) * f5;
            GradientColorValue.d[1] = f3 + (this.e[n2 + 1] - f3) * f5;
            GradientColorValue.d[2] = f4 + (this.e[n2 + 2] - f4) * f5;
            return d;
        }

        @Override
        @BA.Hide
        public void save(Writer output) throws IOException {
            super.save(output);
            if (!this.b) {
                return;
            }
            output.write("colorsCount: " + this.e.length + "\n");
            int n = 0;
            while (n < this.e.length) {
                output.write("colors" + n + ": " + this.e[n] + "\n");
                ++n;
            }
            output.write("timelineCount: " + this.a.length + "\n");
            n = 0;
            while (n < this.a.length) {
                output.write("timeline" + n + ": " + this.a[n] + "\n");
                ++n;
            }
        }

        @Override
        @BA.Hide
        public void load(BufferedReader reader) throws IOException {
            super.load(reader);
            if (!this.b) {
                return;
            }
            this.e = new float[ParticleEmitter.c(reader, "colorsCount")];
            int n = 0;
            while (n < this.e.length) {
                this.e[n] = ParticleEmitter.d(reader, "colors".concat(String.valueOf(n)));
                ++n;
            }
            this.a = new float[ParticleEmitter.c(reader, "timelineCount")];
            n = 0;
            while (n < this.a.length) {
                this.a[n] = ParticleEmitter.d(reader, "timeline".concat(String.valueOf(n)));
                ++n;
            }
        }

        @BA.Hide
        public void load(GradientColorValue value) {
            super.load(value);
            this.e = new float[value.e.length];
            System.arraycopy(value.e, 0, this.e, 0, this.e.length);
            this.a = new float[value.a.length];
            System.arraycopy(value.a, 0, this.a, 0, this.a.length);
        }
    }

    @BA.Hide
    public static class NumericValue
    extends ParticleValue {
        private float a;

        public float getValue() {
            return this.a;
        }

        public void setValue(float value) {
            this.a = value;
        }

        @Override
        public void save(Writer output) throws IOException {
            super.save(output);
            if (!this.b) {
                return;
            }
            output.write("value: " + this.a + "\n");
        }

        @Override
        public void load(BufferedReader reader) throws IOException {
            super.load(reader);
            if (!this.b) {
                return;
            }
            this.a = ParticleEmitter.d(reader, "value");
        }

        public void load(NumericValue value) {
            super.load(value);
            this.a = value.a;
        }
    }

    @BA.Hide
    public static class Particle
    extends Sprite {
        protected int life;
        protected int currentLife;
        protected float scale;
        protected float scaleDiff;
        protected float rotation;
        protected float rotationDiff;
        protected float velocity;
        protected float velocityDiff;
        protected float angle;
        protected float angleDiff;
        protected float angleCos;
        protected float angleSin;
        protected float transparency;
        protected float transparencyDiff;
        protected float wind;
        protected float windDiff;
        protected float gravity;
        protected float gravityDiff;
        protected float[] tint;

        public Particle(Sprite sprite) {
            super(sprite);
        }
    }

    @BA.Hide
    public static class ParticleValue {
        boolean b;
        boolean c;

        public void setAlwaysActive(boolean alwaysActive) {
            this.c = alwaysActive;
        }

        public boolean isAlwaysActive() {
            return this.c;
        }

        public boolean isActive() {
            return this.c || this.b;
        }

        public void setActive(boolean active) {
            this.b = active;
        }

        public void save(Writer output) throws IOException {
            if (!this.c) {
                output.write("active: " + this.b + "\n");
                return;
            }
            this.b = true;
        }

        public void load(BufferedReader reader) throws IOException {
            if (!this.c) {
                this.b = ParticleEmitter.b(reader, "active");
                return;
            }
            this.b = true;
        }

        public void load(ParticleValue value) {
            this.b = value.b;
            this.c = value.c;
        }
    }

    @BA.ShortName(value="lgParticleRangedNumericValue")
    public static class RangedNumericValue
    extends ParticleValue {
        private float a;
        private float d;

        public float newLowValue() {
            return this.a + (this.d - this.a) * MathUtils.random();
        }

        public void setLow(float value) {
            this.a = value;
            this.d = value;
        }

        public void setLow(float min, float max) {
            this.a = min;
            this.d = max;
        }

        public float getLowMin() {
            return this.a;
        }

        public void setLowMin(float lowMin) {
            this.a = lowMin;
        }

        public float getLowMax() {
            return this.d;
        }

        public void setLowMax(float lowMax) {
            this.d = lowMax;
        }

        @Override
        @BA.Hide
        public void save(Writer output) throws IOException {
            super.save(output);
            if (!this.b) {
                return;
            }
            output.write("lowMin: " + this.a + "\n");
            output.write("lowMax: " + this.d + "\n");
        }

        @Override
        @BA.Hide
        public void load(BufferedReader reader) throws IOException {
            super.load(reader);
            if (!this.b) {
                return;
            }
            this.a = ParticleEmitter.d(reader, "lowMin");
            this.d = ParticleEmitter.d(reader, "lowMax");
        }

        @BA.Hide
        public void load(RangedNumericValue value) {
            super.load(value);
            this.d = value.d;
            this.a = value.a;
        }
    }

    @BA.ShortName(value="lgParticleScaledNumericValue")
    public static class ScaledNumericValue
    extends RangedNumericValue {
        private float[] d = new float[]{1.0f};
        float[] a = new float[]{0.0f};
        private float e;
        private float f;
        private boolean g;

        public float newHighValue() {
            return this.e + (this.f - this.e) * MathUtils.random();
        }

        public void setHigh(float value) {
            this.e = value;
            this.f = value;
        }

        public void setHigh(float min, float max) {
            this.e = min;
            this.f = max;
        }

        public float getHighMin() {
            return this.e;
        }

        public void setHighMin(float highMin) {
            this.e = highMin;
        }

        public float getHighMax() {
            return this.f;
        }

        public void setHighMax(float highMax) {
            this.f = highMax;
        }

        public float[] getScaling() {
            return this.d;
        }

        public void setScaling(float[] values) {
            this.d = values;
        }

        public float[] getTimeline() {
            return this.a;
        }

        public void setTimeline(float[] timeline) {
            this.a = timeline;
        }

        public boolean isRelative() {
            return this.g;
        }

        public void setRelative(boolean relative) {
            this.g = relative;
        }

        public float getScale(float percent) {
            int n = -1;
            float[] fArray = this.a;
            int n2 = this.a.length;
            int n3 = 1;
            while (n3 < n2) {
                if (fArray[n3] > percent) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (n == -1) {
                return this.d[n2 - 1];
            }
            float[] fArray2 = this.d;
            int n4 = n - 1;
            float f = fArray2[n4];
            float f2 = fArray[n4];
            return f + (fArray2[n] - f) * ((percent - f2) / (fArray[n] - f2));
        }

        @Override
        @BA.Hide
        public void save(Writer output) throws IOException {
            super.save(output);
            if (!this.b) {
                return;
            }
            output.write("highMin: " + this.e + "\n");
            output.write("highMax: " + this.f + "\n");
            output.write("relative: " + this.g + "\n");
            output.write("scalingCount: " + this.d.length + "\n");
            int n = 0;
            while (n < this.d.length) {
                output.write("scaling" + n + ": " + this.d[n] + "\n");
                ++n;
            }
            output.write("timelineCount: " + this.a.length + "\n");
            n = 0;
            while (n < this.a.length) {
                output.write("timeline" + n + ": " + this.a[n] + "\n");
                ++n;
            }
        }

        @Override
        @BA.Hide
        public void load(BufferedReader reader) throws IOException {
            super.load(reader);
            if (!this.b) {
                return;
            }
            this.e = ParticleEmitter.d(reader, "highMin");
            this.f = ParticleEmitter.d(reader, "highMax");
            this.g = ParticleEmitter.b(reader, "relative");
            this.d = new float[ParticleEmitter.c(reader, "scalingCount")];
            int n = 0;
            while (n < this.d.length) {
                this.d[n] = ParticleEmitter.d(reader, "scaling".concat(String.valueOf(n)));
                ++n;
            }
            this.a = new float[ParticleEmitter.c(reader, "timelineCount")];
            n = 0;
            while (n < this.a.length) {
                this.a[n] = ParticleEmitter.d(reader, "timeline".concat(String.valueOf(n)));
                ++n;
            }
        }

        @BA.Hide
        public void load(ScaledNumericValue value) {
            super.load(value);
            this.f = value.f;
            this.e = value.e;
            this.d = new float[value.d.length];
            System.arraycopy(value.d, 0, this.d, 0, this.d.length);
            this.a = new float[value.a.length];
            System.arraycopy(value.a, 0, this.a, 0, this.a.length);
            this.g = value.g;
        }
    }

    @BA.Hide
    public static enum SpawnEllipseSide {
        both,
        top,
        bottom;

    }

    @BA.Hide
    public static enum SpawnShape {
        point,
        line,
        square,
        ellipse;

    }

    @BA.ShortName(value="lgParticleSpawnShapeValue")
    public static class SpawnShapeValue
    extends ParticleValue {
        SpawnShape a = SpawnShape.point;
        boolean d;
        SpawnEllipseSide e = SpawnEllipseSide.both;
        public static final SpawnShape SPAWNSHAPE_Ellipse = SpawnShape.ellipse;
        public static final SpawnShape SPAWNSHAPE_Line = SpawnShape.line;
        public static final SpawnShape SPAWNSHAPE_Point = SpawnShape.point;
        public static final SpawnShape SPAWNSHAPE_Square = SpawnShape.square;
        public static final SpawnEllipseSide SPAWNSIDE_Both = SpawnEllipseSide.both;
        public static final SpawnEllipseSide SPAWNSIDE_Bottom = SpawnEllipseSide.bottom;
        public static final SpawnEllipseSide SPAWNSIDE_Top = SpawnEllipseSide.top;

        public SpawnShape getShape() {
            return this.a;
        }

        public void setShape(SpawnShape shape) {
            this.a = shape;
        }

        public boolean isEdges() {
            return this.d;
        }

        public void setEdges(boolean edges) {
            this.d = edges;
        }

        public SpawnEllipseSide getSide() {
            return this.e;
        }

        public void setSide(SpawnEllipseSide side) {
            this.e = side;
        }

        @Override
        @BA.Hide
        public void save(Writer output) throws IOException {
            super.save(output);
            if (!this.b) {
                return;
            }
            output.write("shape: " + (Object)((Object)this.a) + "\n");
            if (this.a == SpawnShape.ellipse) {
                output.write("edges: " + this.d + "\n");
                output.write("side: " + (Object)((Object)this.e) + "\n");
            }
        }

        @Override
        @BA.Hide
        public void load(BufferedReader reader) throws IOException {
            super.load(reader);
            if (!this.b) {
                return;
            }
            this.a = SpawnShape.valueOf(ParticleEmitter.a(reader, "shape"));
            if (this.a == SpawnShape.ellipse) {
                this.d = ParticleEmitter.b(reader, "edges");
                this.e = SpawnEllipseSide.valueOf(ParticleEmitter.a(reader, "side"));
            }
        }

        @BA.Hide
        public void load(SpawnShapeValue value) {
            super.load(value);
            this.a = value.a;
            this.d = value.d;
            this.e = value.e;
        }
    }
}

