/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;

@BA.Hide
public class PolygonRegionLoader
extends SynchronousAssetLoader<PolygonRegion, PolygonRegionParameters> {
    private PolygonRegionParameters a = new PolygonRegionParameters();
    private EarClippingTriangulator b = new EarClippingTriangulator();

    public PolygonRegionLoader() {
        this(new InternalFileHandleResolver());
    }

    public PolygonRegionLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public PolygonRegion load(AssetManager manager, String fileName, FileHandle file, PolygonRegionParameters parameter) {
        AssetManager assetManager = manager;
        Texture texture = (Texture)assetManager.get(assetManager.getDependencies(fileName).first());
        return this.load(new TextureRegion(texture), file);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, PolygonRegionParameters params) {
        Object object;
        if (params == null) {
            params = this.a;
        }
        String string = null;
        try {
            String string2;
            object = file.reader(params.readerBuffer);
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (!string2.startsWith(params.texturePrefix)) continue;
                string = string2.substring(params.texturePrefix.length());
                break;
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error reading ".concat(String.valueOf(fileName)), iOException);
        }
        if (string == null && params.textureExtensions != null) {
            String[] stringArray = params.textureExtensions;
            int n = params.textureExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                FileHandle fileHandle = file;
                FileHandle fileHandle2 = fileHandle.sibling(fileHandle.nameWithoutExtension().concat(".".concat(String.valueOf(object))));
                if (fileHandle2.exists()) {
                    string = fileHandle2.name();
                }
                ++n2;
            }
        }
        if (string != null) {
            object = new Array<AssetDescriptor<Texture>>(1);
            ((Array)object).add(new AssetDescriptor<Texture>(file.sibling(string), Texture.class));
            return object;
        }
        return null;
    }

    public PolygonRegion load(TextureRegion textureRegion, FileHandle file) {
        BufferedReader bufferedReader = file.reader(256);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("s")) continue;
                String[] stringArray = string.substring(1).trim().split(",");
                float[] fArray = new float[stringArray.length];
                int n = 0;
                int n2 = fArray.length;
                while (n < n2) {
                    fArray[n] = Float.parseFloat(stringArray[n]);
                    ++n;
                }
                PolygonRegion polygonRegion = new PolygonRegion(textureRegion, fArray, this.b.computeTriangles(fArray).toArray());
                return polygonRegion;
            }
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error reading polygon shape file: ".concat(String.valueOf(file)), iOException);
        }
        finally {
            StreamUtils.closeQuietly(bufferedReader);
        }
        throw new GdxRuntimeException("Polygon shape not found: ".concat(String.valueOf(file)));
    }

    @BA.Hide
    public static class PolygonRegionParameters
    extends AssetLoaderParameters<PolygonRegion> {
        public String texturePrefix = "i ";
        public int readerBuffer = 1024;
        public String[] textureExtensions = new String[]{"png", "PNG", "jpeg", "JPEG", "jpg", "JPG", "cim", "CIM", "etc1", "ETC1", "ktx", "KTX", "zktx", "ZKTX"};
    }
}

