/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.NumberUtils;

@BA.Hide
public class PolygonSprite {
    private PolygonRegion a;
    private float b;
    private float c;
    private float d;
    private float e;
    private float f = 1.0f;
    private float g = 1.0f;
    private float h;
    private float i;
    private float j;
    private float[] k;
    private boolean l;
    private Rectangle m = new Rectangle();
    private final Color n = new Color(1.0f, 1.0f, 1.0f, 1.0f);

    public PolygonSprite(PolygonRegion region) {
        this.setRegion(region);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setSize(region.d.h, region.d.i);
        PolygonSprite polygonSprite = this;
        polygonSprite.setOrigin(polygonSprite.d / 2.0f, this.e / 2.0f);
    }

    public PolygonSprite(PolygonSprite sprite) {
        this.set(sprite);
    }

    public void set(PolygonSprite sprite) {
        if (sprite == null) {
            throw new IllegalArgumentException("sprite cannot be null.");
        }
        this.setRegion(sprite.a);
        this.b = sprite.b;
        this.c = sprite.c;
        this.d = sprite.d;
        this.e = sprite.e;
        this.i = sprite.i;
        this.j = sprite.j;
        this.h = sprite.h;
        this.f = sprite.f;
        this.g = sprite.g;
        this.n.set(sprite.n);
        this.l = sprite.l;
    }

    public void setBounds(float x, float y, float width, float height) {
        this.b = x;
        this.c = y;
        this.d = width;
        this.e = height;
        this.l = true;
    }

    public void setSize(float width, float height) {
        this.d = width;
        this.e = height;
        this.l = true;
    }

    public void setPosition(float x, float y) {
        this.translate(x - this.b, y - this.c);
    }

    public void setX(float x) {
        this.translateX(x - this.b);
    }

    public void setY(float y) {
        this.translateY(y - this.c);
    }

    public void translateX(float xAmount) {
        this.b += xAmount;
        if (this.l) {
            return;
        }
        float[] fArray = this.k;
        int n = 0;
        while (n < fArray.length) {
            int n2 = n;
            fArray[n2] = fArray[n2] + xAmount;
            n += 5;
        }
    }

    public void translateY(float yAmount) {
        this.c += yAmount;
        if (this.l) {
            return;
        }
        float[] fArray = this.k;
        int n = 1;
        while (n < fArray.length) {
            int n2 = n;
            fArray[n2] = fArray[n2] + yAmount;
            n += 5;
        }
    }

    public void translate(float xAmount, float yAmount) {
        this.b += xAmount;
        this.c += yAmount;
        if (this.l) {
            return;
        }
        float[] fArray = this.k;
        int n = 0;
        while (n < fArray.length) {
            int n2 = n;
            fArray[n2] = fArray[n2] + xAmount;
            int n3 = n + 1;
            fArray[n3] = fArray[n3] + yAmount;
            n += 5;
        }
    }

    public void setColor(Color tint) {
        this.n.set(tint);
        float f = tint.toFloatBits();
        float[] fArray = this.k;
        int n = 2;
        while (n < fArray.length) {
            fArray[n] = f;
            n += 5;
        }
    }

    public void setColor(float r, float g, float b2, float a2) {
        this.n.set(r, g, b2, a2);
        float f = NumberUtils.intToFloatColor((int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r));
        float[] fArray = this.k;
        int n = 2;
        while (n < fArray.length) {
            fArray[n] = f;
            n += 5;
        }
    }

    public void setOrigin(float originX, float originY) {
        this.i = originX;
        this.j = originY;
        this.l = true;
    }

    public void setRotation(float degrees) {
        this.h = degrees;
        this.l = true;
    }

    public void rotate(float degrees) {
        this.h += degrees;
        this.l = true;
    }

    public void setScale(float scaleXY) {
        this.f = scaleXY;
        this.g = scaleXY;
        this.l = true;
    }

    public void setScale(float scaleX, float scaleY) {
        this.f = scaleX;
        this.g = scaleY;
        this.l = true;
    }

    public void scale(float amount) {
        this.f += amount;
        this.g += amount;
        this.l = true;
    }

    public float[] getVertices() {
        if (!this.l) {
            return this.k;
        }
        this.l = false;
        float f = this.i;
        float f2 = this.j;
        float f3 = this.f;
        float f4 = this.g;
        PolygonRegion polygonRegion = this.a;
        float[] fArray = this.k;
        float[] fArray2 = polygonRegion.b;
        float f5 = this.b + f;
        float f6 = this.c + f2;
        float f7 = this.d / (float)polygonRegion.d.getRegionWidth();
        float f8 = this.e / (float)polygonRegion.d.getRegionHeight();
        float f9 = MathUtils.cosDeg(this.h);
        float f10 = MathUtils.sinDeg(this.h);
        int n = 0;
        int n2 = 0;
        int n3 = fArray2.length;
        while (n < n3) {
            float f11 = (fArray2[n] * f7 - f) * f3;
            float f12 = (fArray2[n + 1] * f8 - f2) * f4;
            fArray[n2] = f9 * f11 - f10 * f12 + f5;
            fArray[n2 + 1] = f10 * f11 + f9 * f12 + f6;
            n += 2;
            n2 += 5;
        }
        return fArray;
    }

    public Rectangle getBoundingRectangle() {
        float[] fArray = this.getVertices();
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[0];
        float f4 = fArray[1];
        int n = 5;
        while (n < fArray.length) {
            float f5 = fArray[n];
            float f6 = fArray[n + 1];
            f = f > f5 ? f5 : f;
            f3 = f3 < f5 ? f5 : f3;
            f2 = f2 > f6 ? f6 : f2;
            f4 = f4 < f6 ? f6 : f4;
            n += 5;
        }
        this.m.x = f;
        this.m.y = f2;
        this.m.width = f3 - f;
        this.m.height = f4 - f2;
        return this.m;
    }

    public void draw(PolygonSpriteBatch spriteBatch) {
        PolygonRegion polygonRegion = this.a;
        spriteBatch.draw(polygonRegion.d.c, this.getVertices(), 0, this.k.length, polygonRegion.c, 0, polygonRegion.c.length);
    }

    public void draw(PolygonSpriteBatch spriteBatch, float alphaModulation) {
        Color color = this.getColor();
        float f = color.a;
        color.a *= alphaModulation;
        this.setColor(color);
        this.draw(spriteBatch);
        color.a = f;
        this.setColor(color);
    }

    public float getX() {
        return this.b;
    }

    public float getY() {
        return this.c;
    }

    public float getWidth() {
        return this.d;
    }

    public float getHeight() {
        return this.e;
    }

    public float getOriginX() {
        return this.i;
    }

    public float getOriginY() {
        return this.j;
    }

    public float getRotation() {
        return this.h;
    }

    public float getScaleX() {
        return this.f;
    }

    public float getScaleY() {
        return this.g;
    }

    public Color getColor() {
        return this.n;
    }

    public Color getVertexColor() {
        int n = NumberUtils.floatToIntColor(this.k[2]);
        Color color = this.n;
        this.n.r = (float)(n & 0xFF) / 255.0f;
        color.g = (float)(n >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(n >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(n >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    public void setRegion(PolygonRegion region) {
        this.a = region;
        float[] fArray = region.b;
        float[] fArray2 = region.a;
        if (this.k == null || fArray.length != this.k.length) {
            this.k = new float[fArray.length / 2 * 5];
        }
        float[] fArray3 = this.k;
        int n = 0;
        int n2 = 2;
        int n3 = fArray.length;
        while (n < n3) {
            fArray3[n2] = this.n.toFloatBits();
            fArray3[n2 + 1] = fArray2[n];
            fArray3[n2 + 2] = fArray2[n + 1];
            n += 2;
            n2 += 5;
        }
        this.l = true;
    }

    public PolygonRegion getRegion() {
        return this.a;
    }
}

