/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.NumberUtils;

@BA.Hide
public class PolygonSpriteBatch
implements Batch {
    private Mesh a;
    private final float[] b;
    private final short[] c;
    private int d;
    private int e;
    private Texture f;
    private float g = 0.0f;
    private float h = 0.0f;
    private boolean i;
    private final Matrix4 j = new Matrix4();
    private final Matrix4 k = new Matrix4();
    private final Matrix4 l = new Matrix4();
    private boolean m;
    private int n = 770;
    private int o = 771;
    private final ShaderProgram p;
    private ShaderProgram q;
    private boolean r;
    private float s = Color.WHITE.toFloatBits();
    private Color t = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public int renderCalls = 0;
    public int totalRenderCalls = 0;
    public int maxTrianglesInBatch = 0;

    public PolygonSpriteBatch() {
        this(2000, null);
    }

    public PolygonSpriteBatch(int size) {
        this(size, null);
    }

    public PolygonSpriteBatch(int size, ShaderProgram defaultShader) {
        if (size > 10920) {
            throw new IllegalArgumentException("Can't have more than 10920 triangles per batch: ".concat(String.valueOf(size)));
        }
        Mesh.VertexDataType vertexDataType = Mesh.VertexDataType.VertexArray;
        int n = size;
        this.a = new Mesh(vertexDataType, false, n, n * 3, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.b = new float[size * 5];
        this.c = new short[size * 3];
        if (defaultShader == null) {
            this.p = SpriteBatch.createDefaultShader();
            this.r = true;
        } else {
            this.p = defaultShader;
        }
        this.k.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    @Override
    public void begin() {
        if (this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.end must be called before begin.");
        }
        this.renderCalls = 0;
        Gdx.gl.glDepthMask(false);
        if (this.q != null) {
            this.q.begin();
        } else {
            this.p.begin();
        }
        this.a();
        this.i = true;
    }

    @Override
    public void end() {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before end.");
        }
        if (this.d > 0) {
            this.flush();
        }
        this.f = null;
        this.i = false;
        GL20 gL20 = Gdx.gl;
        gL20.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            gL20.glDisable(3042);
        }
        if (this.q != null) {
            this.q.end();
            return;
        }
        this.p.end();
    }

    @Override
    public void setColor(Color tint) {
        this.s = tint.toFloatBits();
    }

    @Override
    public void setColor(float r, float g, float b2, float a2) {
        int n = (int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.s = NumberUtils.intToFloatColor(n);
    }

    @Override
    public void setColor(float color) {
        this.s = color;
    }

    @Override
    public Color getColor() {
        int n = NumberUtils.floatToIntColor(this.s);
        Color color = this.t;
        this.t.r = (float)(n & 0xFF) / 255.0f;
        color.g = (float)(n >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(n >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(n >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    @Override
    public float getPackedColor() {
        return this.s;
    }

    public void draw(PolygonRegion region, float x, float y) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        short[] sArray2 = region.c;
        int n = region.c.length;
        float[] fArray = region.b;
        int n2 = region.b.length;
        Texture texture = region.d.c;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + n > sArray.length || this.d + n2 * 5 / 2 > this.b.length) {
            this.flush();
        }
        int n3 = this.e;
        int n4 = this.d;
        int n5 = n4 / 5;
        int n6 = 0;
        while (n6 < n) {
            sArray[n3++] = (short)(sArray2[n6] + n5);
            ++n6;
        }
        this.e = n3;
        float[] fArray2 = this.b;
        float f = this.s;
        float[] fArray3 = region.a;
        int n7 = 0;
        while (n7 < n2) {
            fArray2[n4++] = fArray[n7] + x;
            fArray2[n4++] = fArray[n7 + 1] + y;
            fArray2[n4++] = f;
            fArray2[n4++] = fArray3[n7];
            fArray2[n4++] = fArray3[n7 + 1];
            n7 += 2;
        }
        this.d = n4;
    }

    public void draw(PolygonRegion region, float x, float y, float width, float height) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        short[] sArray2 = region.c;
        int n = region.c.length;
        float[] fArray = region.b;
        int n2 = region.b.length;
        TextureRegion textureRegion = region.d;
        Texture texture = textureRegion.c;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + n > sArray.length || this.d + n2 * 5 / 2 > this.b.length) {
            this.flush();
        }
        int n3 = this.e;
        int n4 = this.d;
        int n5 = n4 / 5;
        int n6 = 0;
        int n7 = sArray2.length;
        while (n6 < n7) {
            sArray[n3++] = (short)(sArray2[n6] + n5);
            ++n6;
        }
        this.e = n3;
        float[] fArray2 = this.b;
        float f = this.s;
        float[] fArray3 = region.a;
        float f2 = width / (float)textureRegion.h;
        float f3 = height / (float)textureRegion.i;
        int n8 = 0;
        while (n8 < n2) {
            fArray2[n4++] = fArray[n8] * f2 + x;
            fArray2[n4++] = fArray[n8 + 1] * f3 + y;
            fArray2[n4++] = f;
            fArray2[n4++] = fArray3[n8];
            fArray2[n4++] = fArray3[n8 + 1];
            n8 += 2;
        }
        this.d = n4;
    }

    public void draw(PolygonRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        short[] sArray2 = region.c;
        int n = region.c.length;
        float[] fArray = region.b;
        int n2 = region.b.length;
        TextureRegion textureRegion = region.d;
        Texture texture = textureRegion.c;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + n > sArray.length || this.d + n2 * 5 / 2 > this.b.length) {
            this.flush();
        }
        int n3 = this.e;
        int n4 = this.d;
        int n5 = n4 / 5;
        int n6 = 0;
        while (n6 < n) {
            sArray[n3++] = (short)(sArray2[n6] + n5);
            ++n6;
        }
        this.e = n3;
        float[] fArray2 = this.b;
        float f = this.s;
        float[] fArray3 = region.a;
        float f2 = x + originX;
        float f3 = y + originY;
        float f4 = width / (float)textureRegion.h;
        float f5 = height / (float)textureRegion.i;
        float f6 = MathUtils.cosDeg(rotation);
        float f7 = MathUtils.sinDeg(rotation);
        int n7 = 0;
        while (n7 < n2) {
            float f8 = (fArray[n7] * f4 - originX) * scaleX;
            float f9 = (fArray[n7 + 1] * f5 - originY) * scaleY;
            fArray2[n4++] = f6 * f8 - f7 * f9 + f2;
            fArray2[n4++] = f7 * f8 + f6 * f9 + f3;
            fArray2[n4++] = f;
            fArray2[n4++] = fArray3[n7];
            fArray2[n4++] = fArray3[n7 + 1];
            n7 += 2;
        }
        this.d = n4;
    }

    public void draw(Texture texture, float[] polygonVertices, int verticesOffset, int verticesCount, short[] polygonTriangles, int trianglesOffset, int trianglesCount) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + trianglesCount > sArray.length || this.d + verticesCount > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d;
        int n3 = n2 / 5;
        int n4 = trianglesOffset;
        int n5 = trianglesOffset + trianglesCount;
        while (n4 < n5) {
            sArray[n++] = (short)(polygonTriangles[n4] + n3);
            ++n4;
        }
        this.e = n;
        System.arraycopy(polygonVertices, verticesOffset, fArray, n2, verticesCount);
        this.d += verticesCount;
    }

    @Override
    public void draw(Texture texture, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f12 = x + originX;
        float f13 = y + originY;
        float f14 = -originX;
        float f15 = -originY;
        float f16 = width - originX;
        float f17 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            f14 *= scaleX;
            f15 *= scaleY;
            f16 *= scaleX;
            f17 *= scaleY;
        }
        float f18 = f14;
        float f19 = f15;
        float f20 = f14;
        float f21 = f17;
        float f22 = f16;
        float f23 = f17;
        float f24 = f16;
        float f25 = f15;
        if (rotation != 0.0f) {
            f11 = MathUtils.cosDeg(rotation);
            f10 = MathUtils.sinDeg(rotation);
            f9 = f11 * f18 - f10 * f19;
            f8 = f10 * f18 + f11 * f19;
            f7 = f11 * f20 - f10 * f21;
            f6 = f10 * f20 + f11 * f21;
            f5 = f11 * f22 - f10 * f23;
            f4 = f10 * f22 + f11 * f23;
            f3 = f9 + (f5 - f7);
            f2 = f4 - (f6 - f8);
        } else {
            f9 = f18;
            f8 = f19;
            f7 = f20;
            f6 = f21;
            f5 = f22;
            f4 = f23;
            f3 = f24;
            f2 = f25;
        }
        f9 += f12;
        f8 += f13;
        f7 += f12;
        f6 += f13;
        f5 += f12;
        f4 += f13;
        f3 += f12;
        f2 += f13;
        f11 = (float)srcX * this.g;
        f10 = (float)(srcY + srcHeight) * this.h;
        float f26 = (float)(srcX + srcWidth) * this.g;
        float f27 = (float)srcY * this.h;
        if (flipX) {
            f = f11;
            f11 = f26;
            f26 = f;
        }
        if (flipY) {
            f = f10;
            f10 = f27;
            f27 = f;
        }
        f = this.s;
        int n3 = this.d;
        fArray[n3++] = f9;
        fArray[n3++] = f8;
        fArray[n3++] = f;
        fArray[n3++] = f11;
        fArray[n3++] = f10;
        fArray[n3++] = f7;
        fArray[n3++] = f6;
        fArray[n3++] = f;
        fArray[n3++] = f11;
        fArray[n3++] = f27;
        fArray[n3++] = f5;
        fArray[n3++] = f4;
        fArray[n3++] = f;
        fArray[n3++] = f26;
        fArray[n3++] = f27;
        fArray[n3++] = f3;
        fArray[n3++] = f2;
        fArray[n3++] = f;
        fArray[n3++] = f26;
        fArray[n3++] = f10;
        this.d = n3;
    }

    @Override
    public void draw(Texture texture, float x, float y, float width, float height, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        float f;
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f2 = (float)srcX * this.g;
        float f3 = (float)(srcY + srcHeight) * this.h;
        float f4 = (float)(srcX + srcWidth) * this.g;
        float f5 = (float)srcY * this.h;
        float f6 = x + width;
        float f7 = y + height;
        if (flipX) {
            f = f2;
            f2 = f4;
            f4 = f;
        }
        if (flipY) {
            f = f3;
            f3 = f5;
            f5 = f;
        }
        f = this.s;
        int n3 = this.d;
        fArray[n3++] = x;
        fArray[n3++] = y;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f3;
        fArray[n3++] = x;
        fArray[n3++] = f7;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f7;
        fArray[n3++] = f;
        fArray[n3++] = f4;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = y;
        fArray[n3++] = f;
        fArray[n3++] = f4;
        fArray[n3++] = f3;
        this.d = n3;
    }

    @Override
    public void draw(Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f = (float)srcX * this.g;
        float f2 = (float)(srcY + srcHeight) * this.h;
        float f3 = (float)(srcX + srcWidth) * this.g;
        float f4 = (float)srcY * this.h;
        float f5 = x + (float)srcWidth;
        float f6 = y + (float)srcHeight;
        float f7 = this.s;
        int n3 = this.d;
        fArray[n3++] = x;
        fArray[n3++] = y;
        fArray[n3++] = f7;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = x;
        fArray[n3++] = f6;
        fArray[n3++] = f7;
        fArray[n3++] = f;
        fArray[n3++] = f4;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f7;
        fArray[n3++] = f3;
        fArray[n3++] = f4;
        fArray[n3++] = f5;
        fArray[n3++] = y;
        fArray[n3++] = f7;
        fArray[n3++] = f3;
        fArray[n3++] = f2;
        this.d = n3;
    }

    @Override
    public void draw(Texture texture, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f = x + width;
        float f2 = y + height;
        float f3 = this.s;
        int n3 = this.d;
        fArray[n3++] = x;
        fArray[n3++] = y;
        fArray[n3++] = f3;
        fArray[n3++] = u;
        fArray[n3++] = v;
        fArray[n3++] = x;
        fArray[n3++] = f2;
        fArray[n3++] = f3;
        fArray[n3++] = u;
        fArray[n3++] = v2;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f3;
        fArray[n3++] = u2;
        fArray[n3++] = v2;
        fArray[n3++] = f;
        fArray[n3++] = y;
        fArray[n3++] = f3;
        fArray[n3++] = u2;
        fArray[n3++] = v;
        this.d = n3;
    }

    @Override
    public void draw(Texture texture, float x, float y) {
        this.draw(texture, x, y, (float)texture.getWidth(), (float)texture.getHeight());
    }

    @Override
    public void draw(Texture texture, float x, float y, float width, float height) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f = x + width;
        float f2 = y + height;
        float f3 = this.s;
        int n3 = this.d;
        fArray[n3++] = x;
        fArray[n3++] = y;
        fArray[n3++] = f3;
        fArray[n3++] = 0.0f;
        fArray[n3++] = 1.0f;
        fArray[n3++] = x;
        fArray[n3++] = f2;
        fArray[n3++] = f3;
        fArray[n3++] = 0.0f;
        fArray[n3++] = 0.0f;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f3;
        fArray[n3++] = 1.0f;
        fArray[n3++] = 0.0f;
        fArray[n3++] = f;
        fArray[n3++] = y;
        fArray[n3++] = f3;
        fArray[n3++] = 1.0f;
        fArray[n3++] = 1.0f;
        this.d = n3;
    }

    @Override
    public void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        int n = count / 20 * 6;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + n > sArray.length || this.d + count > fArray.length) {
            this.flush();
        }
        int n2 = this.d;
        int n3 = this.e;
        short s = (short)(n2 / 5);
        int n4 = n3 + n;
        while (n3 < n4) {
            sArray[n3] = s;
            sArray[n3 + 1] = (short)(s + 1);
            sArray[n3 + 2] = (short)(s + 2);
            sArray[n3 + 3] = (short)(s + 2);
            sArray[n3 + 4] = (short)(s + 3);
            sArray[n3 + 5] = s;
            n3 += 6;
            s = (short)(s + 4);
        }
        this.e = n3;
        System.arraycopy(spriteVertices, offset, fArray, n2, count);
        this.d += count;
    }

    @Override
    public void draw(TextureRegion region, float x, float y) {
        this.draw(region, x, y, (float)region.getRegionWidth(), (float)region.getRegionHeight());
    }

    @Override
    public void draw(TextureRegion region, float x, float y, float width, float height) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f = x + width;
        float f2 = y + height;
        float f3 = region.d;
        float f4 = region.g;
        float f5 = region.f;
        float f6 = region.e;
        float f7 = this.s;
        int n3 = this.d;
        fArray[n3++] = x;
        fArray[n3++] = y;
        fArray[n3++] = f7;
        fArray[n3++] = f3;
        fArray[n3++] = f4;
        fArray[n3++] = x;
        fArray[n3++] = f2;
        fArray[n3++] = f7;
        fArray[n3++] = f3;
        fArray[n3++] = f6;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f7;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f;
        fArray[n3++] = y;
        fArray[n3++] = f7;
        fArray[n3++] = f5;
        fArray[n3++] = f4;
        this.d = n3;
    }

    @Override
    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f11 = x + originX;
        float f12 = y + originY;
        float f13 = -originX;
        float f14 = -originY;
        float f15 = width - originX;
        float f16 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            f13 *= scaleX;
            f14 *= scaleY;
            f15 *= scaleX;
            f16 *= scaleY;
        }
        float f17 = f13;
        float f18 = f14;
        float f19 = f13;
        float f20 = f16;
        float f21 = f15;
        float f22 = f16;
        float f23 = f15;
        float f24 = f14;
        if (rotation != 0.0f) {
            f10 = MathUtils.cosDeg(rotation);
            f9 = MathUtils.sinDeg(rotation);
            f8 = f10 * f17 - f9 * f18;
            f7 = f9 * f17 + f10 * f18;
            f6 = f10 * f19 - f9 * f20;
            f5 = f9 * f19 + f10 * f20;
            f4 = f10 * f21 - f9 * f22;
            f3 = f9 * f21 + f10 * f22;
            f2 = f8 + (f4 - f6);
            f = f3 - (f5 - f7);
        } else {
            f8 = f17;
            f7 = f18;
            f6 = f19;
            f5 = f20;
            f4 = f21;
            f3 = f22;
            f2 = f23;
            f = f24;
        }
        f8 += f11;
        f7 += f12;
        f6 += f11;
        f5 += f12;
        f4 += f11;
        f3 += f12;
        f2 += f11;
        f += f12;
        f10 = region.d;
        f9 = region.g;
        float f25 = region.f;
        float f26 = region.e;
        float f27 = this.s;
        int n3 = this.d;
        fArray[n3++] = f8;
        fArray[n3++] = f7;
        fArray[n3++] = f27;
        fArray[n3++] = f10;
        fArray[n3++] = f9;
        fArray[n3++] = f6;
        fArray[n3++] = f5;
        fArray[n3++] = f27;
        fArray[n3++] = f10;
        fArray[n3++] = f26;
        fArray[n3++] = f4;
        fArray[n3++] = f3;
        fArray[n3++] = f27;
        fArray[n3++] = f25;
        fArray[n3++] = f26;
        fArray[n3++] = f2;
        fArray[n3++] = f;
        fArray[n3++] = f27;
        fArray[n3++] = f25;
        fArray[n3++] = f9;
        this.d = n3;
    }

    @Override
    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, boolean clockwise) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f17 = x + originX;
        float f18 = y + originY;
        float f19 = -originX;
        float f20 = -originY;
        float f21 = width - originX;
        float f22 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            f19 *= scaleX;
            f20 *= scaleY;
            f21 *= scaleX;
            f22 *= scaleY;
        }
        float f23 = f19;
        float f24 = f20;
        float f25 = f19;
        float f26 = f22;
        float f27 = f21;
        float f28 = f22;
        float f29 = f21;
        float f30 = f20;
        if (rotation != 0.0f) {
            f16 = MathUtils.cosDeg(rotation);
            f15 = MathUtils.sinDeg(rotation);
            f14 = f16 * f23 - f15 * f24;
            f13 = f15 * f23 + f16 * f24;
            f12 = f16 * f25 - f15 * f26;
            f11 = f15 * f25 + f16 * f26;
            f10 = f16 * f27 - f15 * f28;
            f9 = f15 * f27 + f16 * f28;
            f8 = f14 + (f10 - f12);
            f7 = f9 - (f11 - f13);
        } else {
            f14 = f23;
            f13 = f24;
            f12 = f25;
            f11 = f26;
            f10 = f27;
            f9 = f28;
            f8 = f29;
            f7 = f30;
        }
        f14 += f17;
        f13 += f18;
        f12 += f17;
        f11 += f18;
        f10 += f17;
        f9 += f18;
        f8 += f17;
        f7 += f18;
        if (clockwise) {
            f16 = region.f;
            f15 = region.g;
            f6 = region.d;
            f5 = region.g;
            f4 = region.d;
            f3 = region.e;
            f2 = region.f;
            f = region.e;
        } else {
            f16 = region.d;
            f15 = region.e;
            f6 = region.f;
            f5 = region.e;
            f4 = region.f;
            f3 = region.g;
            f2 = region.d;
            f = region.g;
        }
        float f31 = this.s;
        int n3 = this.d;
        fArray[n3++] = f14;
        fArray[n3++] = f13;
        fArray[n3++] = f31;
        fArray[n3++] = f16;
        fArray[n3++] = f15;
        fArray[n3++] = f12;
        fArray[n3++] = f11;
        fArray[n3++] = f31;
        fArray[n3++] = f6;
        fArray[n3++] = f5;
        fArray[n3++] = f10;
        fArray[n3++] = f9;
        fArray[n3++] = f31;
        fArray[n3++] = f4;
        fArray[n3++] = f3;
        fArray[n3++] = f8;
        fArray[n3++] = f7;
        fArray[n3++] = f31;
        fArray[n3++] = f2;
        fArray[n3++] = f;
        this.d = n3;
    }

    @Override
    public void draw(TextureRegion region, float width, float height, Affine2 transform) {
        if (!this.i) {
            throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        }
        short[] sArray = this.c;
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.f) {
            this.a(texture);
        } else if (this.e + 6 > sArray.length || this.d + 20 > fArray.length) {
            this.flush();
        }
        int n = this.e;
        int n2 = this.d / 5;
        sArray[n++] = (short)n2;
        sArray[n++] = (short)(n2 + 1);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 2);
        sArray[n++] = (short)(n2 + 3);
        sArray[n++] = (short)n2;
        this.e = n;
        float f = transform.m02;
        float f2 = transform.m12;
        float f3 = transform.m01 * height + transform.m02;
        float f4 = transform.m11 * height + transform.m12;
        float f5 = transform.m00 * width + transform.m01 * height + transform.m02;
        float f6 = transform.m10 * width + transform.m11 * height + transform.m12;
        float f7 = transform.m00 * width + transform.m02;
        float f8 = transform.m10 * width + transform.m12;
        float f9 = region.d;
        float f10 = region.g;
        float f11 = region.f;
        float f12 = region.e;
        float f13 = this.s;
        int n3 = this.d;
        fArray[n3++] = f;
        fArray[n3++] = f2;
        fArray[n3++] = f13;
        fArray[n3++] = f9;
        fArray[n3++] = f10;
        fArray[n3++] = f3;
        fArray[n3++] = f4;
        fArray[n3++] = f13;
        fArray[n3++] = f9;
        fArray[n3++] = f12;
        fArray[n3++] = f5;
        fArray[n3++] = f6;
        fArray[n3++] = f13;
        fArray[n3++] = f11;
        fArray[n3++] = f12;
        fArray[n3++] = f7;
        fArray[n3++] = f8;
        fArray[n3++] = f13;
        fArray[n3++] = f11;
        fArray[n3++] = f10;
        this.d = n3;
    }

    @Override
    public void flush() {
        if (this.d == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int n = this.e;
        if (n > this.maxTrianglesInBatch) {
            this.maxTrianglesInBatch = n;
        }
        this.f.bind();
        Mesh mesh = this.a;
        mesh.setVertices(this.b, 0, this.d);
        mesh.setIndices(this.c, 0, this.e);
        if (this.m) {
            Gdx.gl.glDisable(3042);
        } else {
            Gdx.gl.glEnable(3042);
            if (this.n != -1) {
                Gdx.gl.glBlendFunc(this.n, this.o);
            }
        }
        mesh.render(this.q != null ? this.q : this.p, 4, 0, n);
        this.d = 0;
        this.e = 0;
    }

    @Override
    public void disableBlending() {
        this.flush();
        this.m = true;
    }

    @Override
    public void enableBlending() {
        this.flush();
        this.m = false;
    }

    @Override
    public void setBlendFunction(int srcFunc, int dstFunc) {
        if (this.n == srcFunc && this.o == dstFunc) {
            return;
        }
        this.flush();
        this.n = srcFunc;
        this.o = dstFunc;
    }

    @Override
    public int getBlendSrcFunc() {
        return this.n;
    }

    @Override
    public int getBlendDstFunc() {
        return this.o;
    }

    @Override
    public void dispose() {
        this.a.dispose();
        if (this.r && this.p != null) {
            this.p.dispose();
        }
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.k;
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.j;
    }

    @Override
    public void setProjectionMatrix(Matrix4 projection) {
        if (this.i) {
            this.flush();
        }
        this.k.set(projection);
        if (this.i) {
            this.a();
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 transform) {
        if (this.i) {
            this.flush();
        }
        this.j.set(transform);
        if (this.i) {
            this.a();
        }
    }

    private void a() {
        this.l.set(this.k).mul(this.j);
        if (this.q != null) {
            this.q.setUniformMatrix("u_projTrans", this.l);
            this.q.setUniformi("u_texture", 0);
            return;
        }
        this.p.setUniformMatrix("u_projTrans", this.l);
        this.p.setUniformi("u_texture", 0);
    }

    private void a(Texture texture) {
        this.flush();
        this.f = texture;
        this.g = 1.0f / (float)texture.getWidth();
        this.h = 1.0f / (float)texture.getHeight();
    }

    @Override
    public void setShader(ShaderProgram shader) {
        if (this.i) {
            this.flush();
            if (this.q != null) {
                this.q.end();
            } else {
                this.p.end();
            }
        }
        this.q = shader;
        if (this.i) {
            if (this.q != null) {
                this.q.begin();
            } else {
                this.p.begin();
            }
            this.a();
        }
    }

    @Override
    public ShaderProgram getShader() {
        if (this.q == null) {
            return this.p;
        }
        return this.q;
    }

    @Override
    public boolean isBlendingEnabled() {
        return !this.m;
    }

    @Override
    public boolean isDrawing() {
        return this.i;
    }
}

