/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.NumberUtils;

@BA.Hide
public class Sprite
extends TextureRegion {
    private float[] j = new float[20];
    private final Color k = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private float l;
    private float m;
    float a;
    float b;
    private float n;
    private float o;
    private float p;
    private float q = 1.0f;
    private float r = 1.0f;
    private boolean s = true;
    private Rectangle t;

    public Sprite() {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Sprite(Texture texture) {
        this(texture, 0, 0, texture.getWidth(), texture.getHeight());
    }

    public Sprite(Texture texture, int srcWidth, int srcHeight) {
        this(texture, 0, 0, srcWidth, srcHeight);
    }

    public Sprite(Texture texture, int srcX, int srcY, int srcWidth, int srcHeight) {
        if (texture == null) {
            throw new IllegalArgumentException("texture cannot be null.");
        }
        this.c = texture;
        this.setRegion(srcX, srcY, srcWidth, srcHeight);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setSize(Math.abs(srcWidth), Math.abs(srcHeight));
        Sprite sprite = this;
        sprite.setOrigin(sprite.a / 2.0f, this.b / 2.0f);
    }

    public Sprite(TextureRegion region) {
        this.setRegion(region);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setSize(region.getRegionWidth(), region.getRegionHeight());
        Sprite sprite = this;
        sprite.setOrigin(sprite.a / 2.0f, this.b / 2.0f);
    }

    public Sprite(TextureRegion region, int srcX, int srcY, int srcWidth, int srcHeight) {
        this.setRegion(region, srcX, srcY, srcWidth, srcHeight);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setSize(Math.abs(srcWidth), Math.abs(srcHeight));
        Sprite sprite = this;
        sprite.setOrigin(sprite.a / 2.0f, this.b / 2.0f);
    }

    public Sprite(Sprite sprite) {
        this.set(sprite);
    }

    public void set(Sprite sprite) {
        if (sprite == null) {
            throw new IllegalArgumentException("sprite cannot be null.");
        }
        System.arraycopy(sprite.j, 0, this.j, 0, 20);
        this.c = sprite.c;
        this.d = sprite.d;
        this.e = sprite.e;
        this.f = sprite.f;
        this.g = sprite.g;
        this.l = sprite.l;
        this.m = sprite.m;
        this.a = sprite.a;
        this.b = sprite.b;
        this.h = sprite.h;
        this.i = sprite.i;
        this.n = sprite.n;
        this.o = sprite.o;
        this.p = sprite.p;
        this.q = sprite.q;
        this.r = sprite.r;
        this.k.set(sprite.k);
        this.s = sprite.s;
    }

    public void setBounds(float x, float y, float width, float height) {
        this.l = x;
        this.m = y;
        this.a = width;
        this.b = height;
        if (this.s) {
            return;
        }
        float f = x + width;
        float f2 = y + height;
        float[] fArray = this.j;
        this.j[0] = x;
        fArray[1] = y;
        fArray[5] = x;
        fArray[6] = f2;
        fArray[10] = f;
        fArray[11] = f2;
        fArray[15] = f;
        fArray[16] = y;
        if (this.p != 0.0f || this.q != 1.0f || this.r != 1.0f) {
            this.s = true;
        }
    }

    public void setSize(float width, float height) {
        this.a = width;
        this.b = height;
        if (this.s) {
            return;
        }
        float f = this.l + width;
        float f2 = this.m + height;
        float[] fArray = this.j;
        this.j[0] = this.l;
        fArray[1] = this.m;
        fArray[5] = this.l;
        fArray[6] = f2;
        fArray[10] = f;
        fArray[11] = f2;
        fArray[15] = f;
        fArray[16] = this.m;
        if (this.p != 0.0f || this.q != 1.0f || this.r != 1.0f) {
            this.s = true;
        }
    }

    public void setPosition(float x, float y) {
        this.translate(x - this.l, y - this.m);
    }

    public void setX(float x) {
        this.translateX(x - this.l);
    }

    public void setY(float y) {
        this.translateY(y - this.m);
    }

    public void setCenterX(float x) {
        this.setX(x - this.a / 2.0f);
    }

    public void setCenterY(float y) {
        this.setY(y - this.b / 2.0f);
    }

    public void setCenter(float x, float y) {
        this.setCenterX(x);
        this.setCenterY(y);
    }

    public void translateX(float xAmount) {
        float[] fArray;
        this.l += xAmount;
        if (this.s) {
            return;
        }
        float[] fArray2 = fArray = this.j;
        fArray2[0] = fArray2[0] + xAmount;
        fArray[5] = fArray[5] + xAmount;
        fArray[10] = fArray[10] + xAmount;
        fArray[15] = fArray[15] + xAmount;
    }

    public void translateY(float yAmount) {
        float[] fArray;
        this.m += yAmount;
        if (this.s) {
            return;
        }
        float[] fArray2 = fArray = this.j;
        fArray2[1] = fArray2[1] + yAmount;
        fArray[6] = fArray[6] + yAmount;
        fArray[11] = fArray[11] + yAmount;
        fArray[16] = fArray[16] + yAmount;
    }

    public void translate(float xAmount, float yAmount) {
        float[] fArray;
        this.l += xAmount;
        this.m += yAmount;
        if (this.s) {
            return;
        }
        float[] fArray2 = fArray = this.j;
        fArray2[0] = fArray2[0] + xAmount;
        fArray[1] = fArray[1] + yAmount;
        fArray[5] = fArray[5] + xAmount;
        fArray[6] = fArray[6] + yAmount;
        fArray[10] = fArray[10] + xAmount;
        fArray[11] = fArray[11] + yAmount;
        fArray[15] = fArray[15] + xAmount;
        fArray[16] = fArray[16] + yAmount;
    }

    public void setColor(Color tint) {
        float f = tint.toFloatBits();
        float[] fArray = this.j;
        this.j[2] = f;
        fArray[7] = f;
        fArray[12] = f;
        fArray[17] = f;
    }

    public void setAlpha(float a2) {
        float f;
        int n = NumberUtils.floatToIntColor(this.j[2]);
        int n2 = (int)(255.0f * a2) << 24;
        this.j[2] = f = NumberUtils.intToFloatColor(n & 0xFFFFFF | n2);
        this.j[7] = f;
        this.j[12] = f;
        this.j[17] = f;
    }

    public void setColor(float r, float g, float b2, float a2) {
        float f = NumberUtils.intToFloatColor((int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r));
        float[] fArray = this.j;
        this.j[2] = f;
        fArray[7] = f;
        fArray[12] = f;
        fArray[17] = f;
    }

    public void setColor(float color) {
        float[] fArray = this.j;
        this.j[2] = color;
        fArray[7] = color;
        fArray[12] = color;
        fArray[17] = color;
    }

    public void setOrigin(float originX, float originY) {
        this.n = originX;
        this.o = originY;
        this.s = true;
    }

    public void setOriginCenter() {
        this.n = this.a / 2.0f;
        this.o = this.b / 2.0f;
        this.s = true;
    }

    public void setRotation(float degrees) {
        this.p = degrees;
        this.s = true;
    }

    public float getRotation() {
        return this.p;
    }

    public void rotate(float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        this.p += degrees;
        this.s = true;
    }

    public void rotate90(boolean clockwise) {
        float[] fArray = this.j;
        if (clockwise) {
            float f = fArray[4];
            fArray[4] = fArray[19];
            fArray[19] = fArray[14];
            fArray[14] = fArray[9];
            fArray[9] = f;
            f = fArray[3];
            fArray[3] = fArray[18];
            fArray[18] = fArray[13];
            fArray[13] = fArray[8];
            fArray[8] = f;
            return;
        }
        float f = fArray[4];
        fArray[4] = fArray[9];
        fArray[9] = fArray[14];
        fArray[14] = fArray[19];
        fArray[19] = f;
        f = fArray[3];
        fArray[3] = fArray[8];
        fArray[8] = fArray[13];
        fArray[13] = fArray[18];
        fArray[18] = f;
    }

    public void setScale(float scaleXY) {
        this.q = scaleXY;
        this.r = scaleXY;
        this.s = true;
    }

    public void setScale(float scaleX, float scaleY) {
        this.q = scaleX;
        this.r = scaleY;
        this.s = true;
    }

    public void scale(float amount) {
        this.q += amount;
        this.r += amount;
        this.s = true;
    }

    public float[] getVertices() {
        if (this.s) {
            this.s = false;
            float[] fArray = this.j;
            float f = -this.n;
            float f2 = -this.o;
            float f3 = f + this.a;
            float f4 = f2 + this.b;
            float f5 = this.l - f;
            float f6 = this.m - f2;
            if (this.q != 1.0f || this.r != 1.0f) {
                f *= this.q;
                f2 *= this.r;
                f3 *= this.q;
                f4 *= this.r;
            }
            if (this.p != 0.0f) {
                float f7 = MathUtils.cosDeg(this.p);
                float f8 = MathUtils.sinDeg(this.p);
                float f9 = f * f7;
                float f10 = f * f8;
                float f11 = f2 * f7;
                float f12 = f2 * f8;
                float f13 = f3 * f7;
                float f14 = f3 * f8;
                float f15 = f4 * f7;
                float f16 = f4 * f8;
                float f17 = f9 - f12 + f5;
                float f18 = f11 + f10 + f6;
                fArray[0] = f17;
                fArray[1] = f18;
                float f19 = f9 - f16 + f5;
                float f20 = f15 + f10 + f6;
                fArray[5] = f19;
                fArray[6] = f20;
                float f21 = f13 - f16 + f5;
                float f22 = f15 + f14 + f6;
                fArray[10] = f21;
                fArray[11] = f22;
                fArray[15] = f17 + (f21 - f19);
                fArray[16] = f22 - (f20 - f18);
            } else {
                float f23 = f + f5;
                float f24 = f2 + f6;
                float f25 = f3 + f5;
                float f26 = f4 + f6;
                fArray[0] = f23;
                fArray[1] = f24;
                fArray[5] = f23;
                fArray[6] = f26;
                fArray[10] = f25;
                fArray[11] = f26;
                fArray[15] = f25;
                fArray[16] = f24;
            }
        }
        return this.j;
    }

    public Rectangle getBoundingRectangle() {
        float[] fArray = this.getVertices();
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[0];
        float f4 = fArray[1];
        f = f > fArray[5] ? fArray[5] : f;
        f = f > fArray[10] ? fArray[10] : f;
        f = f > fArray[15] ? fArray[15] : f;
        f3 = f3 < fArray[5] ? fArray[5] : f3;
        f3 = f3 < fArray[10] ? fArray[10] : f3;
        f3 = f3 < fArray[15] ? fArray[15] : f3;
        f2 = f2 > fArray[6] ? fArray[6] : f2;
        f2 = f2 > fArray[11] ? fArray[11] : f2;
        f2 = f2 > fArray[16] ? fArray[16] : f2;
        f4 = f4 < fArray[6] ? fArray[6] : f4;
        f4 = f4 < fArray[11] ? fArray[11] : f4;
        float f5 = f4 = f4 < fArray[16] ? fArray[16] : f4;
        if (this.t == null) {
            this.t = new Rectangle();
        }
        this.t.x = f;
        this.t.y = f2;
        this.t.width = f3 - f;
        this.t.height = f4 - f2;
        return this.t;
    }

    public void draw(Batch batch) {
        batch.draw(this.c, this.getVertices(), 0, 20);
    }

    public void draw(Batch batch, float alphaModulation) {
        float f = this.getColor().a;
        this.setAlpha(f * alphaModulation);
        this.draw(batch);
        this.setAlpha(f);
    }

    public float getX() {
        return this.l;
    }

    public float getY() {
        return this.m;
    }

    public float getWidth() {
        return this.a;
    }

    public float getHeight() {
        return this.b;
    }

    public float getOriginX() {
        return this.n;
    }

    public float getOriginY() {
        return this.o;
    }

    public float getScaleX() {
        return this.q;
    }

    public float getScaleY() {
        return this.r;
    }

    public Color getColor() {
        int n = NumberUtils.floatToIntColor(this.j[2]);
        Color color = this.k;
        this.k.r = (float)(n & 0xFF) / 255.0f;
        color.g = (float)(n >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(n >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(n >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    @Override
    public void setRegion(float u, float v, float u2, float v2) {
        super.setRegion(u, v, u2, v2);
        float[] fArray = this.j;
        this.j[3] = u;
        fArray[4] = v2;
        fArray[8] = u;
        fArray[9] = v;
        fArray[13] = u2;
        fArray[14] = v;
        fArray[18] = u2;
        fArray[19] = v2;
    }

    @Override
    public void setU(float u) {
        super.setU(u);
        this.j[3] = u;
        this.j[8] = u;
    }

    @Override
    public void setV(float v) {
        super.setV(v);
        this.j[9] = v;
        this.j[14] = v;
    }

    @Override
    public void setU2(float u2) {
        super.setU2(u2);
        this.j[13] = u2;
        this.j[18] = u2;
    }

    @Override
    public void setV2(float v2) {
        super.setV2(v2);
        this.j[4] = v2;
        this.j[19] = v2;
    }

    public void setFlip(boolean x, boolean y) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isFlipX() != x) {
            bl = true;
        }
        if (this.isFlipY() != y) {
            bl2 = true;
        }
        this.flip(bl, bl2);
    }

    @Override
    public void flip(boolean x, boolean y) {
        float f;
        super.flip(x, y);
        float[] fArray = this.j;
        if (x) {
            f = fArray[3];
            fArray[3] = fArray[13];
            fArray[13] = f;
            f = fArray[8];
            fArray[8] = fArray[18];
            fArray[18] = f;
        }
        if (y) {
            f = fArray[4];
            fArray[4] = fArray[14];
            fArray[14] = f;
            f = fArray[9];
            fArray[9] = fArray[19];
            fArray[19] = f;
        }
    }

    @Override
    public void scroll(float xAmount, float yAmount) {
        float f;
        float f2;
        float[] fArray = this.j;
        if (xAmount != 0.0f) {
            f2 = (fArray[3] + xAmount) % 1.0f;
            f = f2 + this.a / (float)this.c.getWidth();
            this.d = f2;
            this.f = f;
            fArray[3] = f2;
            fArray[8] = f2;
            fArray[13] = f;
            fArray[18] = f;
        }
        if (yAmount != 0.0f) {
            f2 = (fArray[9] + yAmount) % 1.0f;
            f = f2 + this.b / (float)this.c.getHeight();
            this.e = f2;
            this.g = f;
            fArray[4] = f;
            fArray[9] = f2;
            fArray[14] = f2;
            fArray[19] = f;
        }
    }
}

