/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.NumberUtils;

@BA.Hide
public class SpriteBatch
implements Batch {
    private Mesh a;
    private float[] b;
    private int c = 0;
    private Texture d = null;
    private float e = 0.0f;
    private float f = 0.0f;
    private boolean g = false;
    private final Matrix4 h = new Matrix4();
    private final Matrix4 i = new Matrix4();
    private final Matrix4 j = new Matrix4();
    private boolean k = false;
    private int l = 770;
    private int m = 771;
    private final ShaderProgram n;
    private ShaderProgram o = null;
    private boolean p;
    private float q = Color.WHITE.toFloatBits();
    private Color r = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public int renderCalls = 0;
    public int totalRenderCalls = 0;
    public int maxSpritesInBatch = 0;

    public SpriteBatch() {
        this(1000, null);
    }

    public SpriteBatch(int size) {
        this(size, null);
    }

    public SpriteBatch(int size, ShaderProgram defaultShader) {
        if (size > 5460) {
            throw new IllegalArgumentException("Can't have more than 5460 sprites per batch: ".concat(String.valueOf(size)));
        }
        Mesh.VertexDataType vertexDataType = Mesh.VertexDataType.VertexArray;
        this.a = new Mesh(vertexDataType, false, size * 4, size * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.i.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.b = new float[size * 20];
        int n = size * 6;
        short[] sArray = new short[n];
        short s = 0;
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = s;
            sArray[n2 + 1] = (short)(s + 1);
            sArray[n2 + 2] = (short)(s + 2);
            sArray[n2 + 3] = (short)(s + 2);
            sArray[n2 + 4] = (short)(s + 3);
            sArray[n2 + 5] = s;
            n2 += 6;
            s = (short)(s + 4);
        }
        this.a.setIndices(sArray);
        if (defaultShader == null) {
            this.n = SpriteBatch.createDefaultShader();
            this.p = true;
            return;
        }
        this.n = defaultShader;
    }

    public static ShaderProgram createDefaultShader() {
        String string = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
        String string2 = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying LOWP vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}";
        ShaderProgram shaderProgram = new ShaderProgram(string, string2);
        if (!shaderProgram.isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + shaderProgram.getLog());
        }
        return shaderProgram;
    }

    @Override
    public void begin() {
        if (this.g) {
            throw new IllegalStateException("SpriteBatch.end must be called before begin.");
        }
        this.renderCalls = 0;
        Gdx.gl.glDepthMask(false);
        if (this.o != null) {
            this.o.begin();
        } else {
            this.n.begin();
        }
        this.a();
        this.g = true;
    }

    @Override
    public void end() {
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before end.");
        }
        if (this.c > 0) {
            this.flush();
        }
        this.d = null;
        this.g = false;
        GL20 gL20 = Gdx.gl;
        gL20.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            gL20.glDisable(3042);
        }
        if (this.o != null) {
            this.o.end();
            return;
        }
        this.n.end();
    }

    @Override
    public void setColor(Color tint) {
        this.q = tint.toFloatBits();
    }

    @Override
    public void setColor(float r, float g, float b2, float a2) {
        int n = (int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.q = NumberUtils.intToFloatColor(n);
    }

    @Override
    public void setColor(float color) {
        this.q = color;
    }

    @Override
    public Color getColor() {
        int n = NumberUtils.floatToIntColor(this.q);
        Color color = this.r;
        this.r.r = (float)(n & 0xFF) / 255.0f;
        color.g = (float)(n >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(n >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(n >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    @Override
    public float getPackedColor() {
        return this.q;
    }

    @Override
    public void draw(Texture texture, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f12 = x + originX;
        float f13 = y + originY;
        float f14 = -originX;
        float f15 = -originY;
        float f16 = width - originX;
        float f17 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            f14 *= scaleX;
            f15 *= scaleY;
            f16 *= scaleX;
            f17 *= scaleY;
        }
        float f18 = f14;
        float f19 = f15;
        float f20 = f14;
        float f21 = f17;
        float f22 = f16;
        float f23 = f17;
        float f24 = f16;
        float f25 = f15;
        if (rotation != 0.0f) {
            f11 = MathUtils.cosDeg(rotation);
            f10 = MathUtils.sinDeg(rotation);
            f9 = f11 * f18 - f10 * f19;
            f8 = f10 * f18 + f11 * f19;
            f7 = f11 * f20 - f10 * f21;
            f6 = f10 * f20 + f11 * f21;
            f5 = f11 * f22 - f10 * f23;
            f4 = f10 * f22 + f11 * f23;
            f3 = f9 + (f5 - f7);
            f2 = f4 - (f6 - f8);
        } else {
            f9 = f18;
            f8 = f19;
            f7 = f20;
            f6 = f21;
            f5 = f22;
            f4 = f23;
            f3 = f24;
            f2 = f25;
        }
        f9 += f12;
        f8 += f13;
        f7 += f12;
        f6 += f13;
        f5 += f12;
        f4 += f13;
        f3 += f12;
        f2 += f13;
        f11 = (float)srcX * this.e;
        f10 = (float)(srcY + srcHeight) * this.f;
        float f26 = (float)(srcX + srcWidth) * this.e;
        float f27 = (float)srcY * this.f;
        if (flipX) {
            f = f11;
            f11 = f26;
            f26 = f;
        }
        if (flipY) {
            f = f10;
            f10 = f27;
            f27 = f;
        }
        f = this.q;
        int n = this.c;
        fArray[n++] = f9;
        fArray[n++] = f8;
        fArray[n++] = f;
        fArray[n++] = f11;
        fArray[n++] = f10;
        fArray[n++] = f7;
        fArray[n++] = f6;
        fArray[n++] = f;
        fArray[n++] = f11;
        fArray[n++] = f27;
        fArray[n++] = f5;
        fArray[n++] = f4;
        fArray[n++] = f;
        fArray[n++] = f26;
        fArray[n++] = f27;
        fArray[n++] = f3;
        fArray[n++] = f2;
        fArray[n++] = f;
        fArray[n++] = f26;
        fArray[n++] = f10;
        this.c = n;
    }

    @Override
    public void draw(Texture texture, float x, float y, float width, float height, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        float f;
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f2 = (float)srcX * this.e;
        float f3 = (float)(srcY + srcHeight) * this.f;
        float f4 = (float)(srcX + srcWidth) * this.e;
        float f5 = (float)srcY * this.f;
        float f6 = x + width;
        float f7 = y + height;
        if (flipX) {
            f = f2;
            f2 = f4;
            f4 = f;
        }
        if (flipY) {
            f = f3;
            f3 = f5;
            f5 = f;
        }
        f = this.q;
        int n = this.c;
        fArray[n++] = x;
        fArray[n++] = y;
        fArray[n++] = f;
        fArray[n++] = f2;
        fArray[n++] = f3;
        fArray[n++] = x;
        fArray[n++] = f7;
        fArray[n++] = f;
        fArray[n++] = f2;
        fArray[n++] = f5;
        fArray[n++] = f6;
        fArray[n++] = f7;
        fArray[n++] = f;
        fArray[n++] = f4;
        fArray[n++] = f5;
        fArray[n++] = f6;
        fArray[n++] = y;
        fArray[n++] = f;
        fArray[n++] = f4;
        fArray[n++] = f3;
        this.c = n;
    }

    @Override
    public void draw(Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight) {
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f = (float)srcX * this.e;
        float f2 = (float)(srcY + srcHeight) * this.f;
        float f3 = (float)(srcX + srcWidth) * this.e;
        float f4 = (float)srcY * this.f;
        float f5 = x + (float)srcWidth;
        float f6 = y + (float)srcHeight;
        float f7 = this.q;
        int n = this.c;
        fArray[n++] = x;
        fArray[n++] = y;
        fArray[n++] = f7;
        fArray[n++] = f;
        fArray[n++] = f2;
        fArray[n++] = x;
        fArray[n++] = f6;
        fArray[n++] = f7;
        fArray[n++] = f;
        fArray[n++] = f4;
        fArray[n++] = f5;
        fArray[n++] = f6;
        fArray[n++] = f7;
        fArray[n++] = f3;
        fArray[n++] = f4;
        fArray[n++] = f5;
        fArray[n++] = y;
        fArray[n++] = f7;
        fArray[n++] = f3;
        fArray[n++] = f2;
        this.c = n;
    }

    @Override
    public void draw(Texture texture, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f = x + width;
        float f2 = y + height;
        float f3 = this.q;
        int n = this.c;
        fArray[n++] = x;
        fArray[n++] = y;
        fArray[n++] = f3;
        fArray[n++] = u;
        fArray[n++] = v;
        fArray[n++] = x;
        fArray[n++] = f2;
        fArray[n++] = f3;
        fArray[n++] = u;
        fArray[n++] = v2;
        fArray[n++] = f;
        fArray[n++] = f2;
        fArray[n++] = f3;
        fArray[n++] = u2;
        fArray[n++] = v2;
        fArray[n++] = f;
        fArray[n++] = y;
        fArray[n++] = f3;
        fArray[n++] = u2;
        fArray[n++] = v;
        this.c = n;
    }

    @Override
    public void draw(Texture texture, float x, float y) {
        this.draw(texture, x, y, (float)texture.getWidth(), (float)texture.getHeight());
    }

    @Override
    public void draw(Texture texture, float x, float y, float width, float height) {
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f = x + width;
        float f2 = y + height;
        float f3 = this.q;
        int n = this.c;
        fArray[n++] = x;
        fArray[n++] = y;
        fArray[n++] = f3;
        fArray[n++] = 0.0f;
        fArray[n++] = 1.0f;
        fArray[n++] = x;
        fArray[n++] = f2;
        fArray[n++] = f3;
        fArray[n++] = 0.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = f;
        fArray[n++] = f2;
        fArray[n++] = f3;
        fArray[n++] = 1.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = f;
        fArray[n++] = y;
        fArray[n++] = f3;
        fArray[n++] = 1.0f;
        fArray[n++] = 1.0f;
        this.c = n;
    }

    @Override
    public void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        int n;
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        int n2 = n = this.b.length;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else {
            n2 = n - this.c;
            if (n2 == 0) {
                this.flush();
                n2 = n;
            }
        }
        int n3 = Math.min(n2, count);
        System.arraycopy(spriteVertices, offset, this.b, this.c, n3);
        this.c += n3;
        count -= n3;
        while (count > 0) {
            this.flush();
            n3 = Math.min(n, count);
            System.arraycopy(spriteVertices, offset += n3, this.b, 0, n3);
            this.c += n3;
            count -= n3;
        }
    }

    @Override
    public void draw(TextureRegion region, float x, float y) {
        this.draw(region, x, y, (float)region.getRegionWidth(), (float)region.getRegionHeight());
    }

    @Override
    public void draw(TextureRegion region, float x, float y, float width, float height) {
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f = x + width;
        float f2 = y + height;
        float f3 = region.d;
        float f4 = region.g;
        float f5 = region.f;
        float f6 = region.e;
        float f7 = this.q;
        int n = this.c;
        fArray[n++] = x;
        fArray[n++] = y;
        fArray[n++] = f7;
        fArray[n++] = f3;
        fArray[n++] = f4;
        fArray[n++] = x;
        fArray[n++] = f2;
        fArray[n++] = f7;
        fArray[n++] = f3;
        fArray[n++] = f6;
        fArray[n++] = f;
        fArray[n++] = f2;
        fArray[n++] = f7;
        fArray[n++] = f5;
        fArray[n++] = f6;
        fArray[n++] = f;
        fArray[n++] = y;
        fArray[n++] = f7;
        fArray[n++] = f5;
        fArray[n++] = f4;
        this.c = n;
    }

    @Override
    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f11 = x + originX;
        float f12 = y + originY;
        float f13 = -originX;
        float f14 = -originY;
        float f15 = width - originX;
        float f16 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            f13 *= scaleX;
            f14 *= scaleY;
            f15 *= scaleX;
            f16 *= scaleY;
        }
        float f17 = f13;
        float f18 = f14;
        float f19 = f13;
        float f20 = f16;
        float f21 = f15;
        float f22 = f16;
        float f23 = f15;
        float f24 = f14;
        if (rotation != 0.0f) {
            f10 = MathUtils.cosDeg(rotation);
            f9 = MathUtils.sinDeg(rotation);
            f8 = f10 * f17 - f9 * f18;
            f7 = f9 * f17 + f10 * f18;
            f6 = f10 * f19 - f9 * f20;
            f5 = f9 * f19 + f10 * f20;
            f4 = f10 * f21 - f9 * f22;
            f3 = f9 * f21 + f10 * f22;
            f2 = f8 + (f4 - f6);
            f = f3 - (f5 - f7);
        } else {
            f8 = f17;
            f7 = f18;
            f6 = f19;
            f5 = f20;
            f4 = f21;
            f3 = f22;
            f2 = f23;
            f = f24;
        }
        f8 += f11;
        f7 += f12;
        f6 += f11;
        f5 += f12;
        f4 += f11;
        f3 += f12;
        f2 += f11;
        f += f12;
        f10 = region.d;
        f9 = region.g;
        float f25 = region.f;
        float f26 = region.e;
        float f27 = this.q;
        int n = this.c;
        fArray[n++] = f8;
        fArray[n++] = f7;
        fArray[n++] = f27;
        fArray[n++] = f10;
        fArray[n++] = f9;
        fArray[n++] = f6;
        fArray[n++] = f5;
        fArray[n++] = f27;
        fArray[n++] = f10;
        fArray[n++] = f26;
        fArray[n++] = f4;
        fArray[n++] = f3;
        fArray[n++] = f27;
        fArray[n++] = f25;
        fArray[n++] = f26;
        fArray[n++] = f2;
        fArray[n++] = f;
        fArray[n++] = f27;
        fArray[n++] = f25;
        fArray[n++] = f9;
        this.c = n;
    }

    @Override
    public void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation, boolean clockwise) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f17 = x + originX;
        float f18 = y + originY;
        float f19 = -originX;
        float f20 = -originY;
        float f21 = width - originX;
        float f22 = height - originY;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            f19 *= scaleX;
            f20 *= scaleY;
            f21 *= scaleX;
            f22 *= scaleY;
        }
        float f23 = f19;
        float f24 = f20;
        float f25 = f19;
        float f26 = f22;
        float f27 = f21;
        float f28 = f22;
        float f29 = f21;
        float f30 = f20;
        if (rotation != 0.0f) {
            f16 = MathUtils.cosDeg(rotation);
            f15 = MathUtils.sinDeg(rotation);
            f14 = f16 * f23 - f15 * f24;
            f13 = f15 * f23 + f16 * f24;
            f12 = f16 * f25 - f15 * f26;
            f11 = f15 * f25 + f16 * f26;
            f10 = f16 * f27 - f15 * f28;
            f9 = f15 * f27 + f16 * f28;
            f8 = f14 + (f10 - f12);
            f7 = f9 - (f11 - f13);
        } else {
            f14 = f23;
            f13 = f24;
            f12 = f25;
            f11 = f26;
            f10 = f27;
            f9 = f28;
            f8 = f29;
            f7 = f30;
        }
        f14 += f17;
        f13 += f18;
        f12 += f17;
        f11 += f18;
        f10 += f17;
        f9 += f18;
        f8 += f17;
        f7 += f18;
        if (clockwise) {
            f16 = region.f;
            f15 = region.g;
            f6 = region.d;
            f5 = region.g;
            f4 = region.d;
            f3 = region.e;
            f2 = region.f;
            f = region.e;
        } else {
            f16 = region.d;
            f15 = region.e;
            f6 = region.f;
            f5 = region.e;
            f4 = region.f;
            f3 = region.g;
            f2 = region.d;
            f = region.g;
        }
        float f31 = this.q;
        int n = this.c;
        fArray[n++] = f14;
        fArray[n++] = f13;
        fArray[n++] = f31;
        fArray[n++] = f16;
        fArray[n++] = f15;
        fArray[n++] = f12;
        fArray[n++] = f11;
        fArray[n++] = f31;
        fArray[n++] = f6;
        fArray[n++] = f5;
        fArray[n++] = f10;
        fArray[n++] = f9;
        fArray[n++] = f31;
        fArray[n++] = f4;
        fArray[n++] = f3;
        fArray[n++] = f8;
        fArray[n++] = f7;
        fArray[n++] = f31;
        fArray[n++] = f2;
        fArray[n++] = f;
        this.c = n;
    }

    @Override
    public void draw(TextureRegion region, float width, float height, Affine2 transform) {
        if (!this.g) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.b;
        Texture texture = region.c;
        if (texture != this.d) {
            this.switchTexture(texture);
        } else if (this.c == fArray.length) {
            this.flush();
        }
        float f = transform.m02;
        float f2 = transform.m12;
        float f3 = transform.m01 * height + transform.m02;
        float f4 = transform.m11 * height + transform.m12;
        float f5 = transform.m00 * width + transform.m01 * height + transform.m02;
        float f6 = transform.m10 * width + transform.m11 * height + transform.m12;
        float f7 = transform.m00 * width + transform.m02;
        float f8 = transform.m10 * width + transform.m12;
        float f9 = region.d;
        float f10 = region.g;
        float f11 = region.f;
        float f12 = region.e;
        float f13 = this.q;
        int n = this.c;
        fArray[n++] = f;
        fArray[n++] = f2;
        fArray[n++] = f13;
        fArray[n++] = f9;
        fArray[n++] = f10;
        fArray[n++] = f3;
        fArray[n++] = f4;
        fArray[n++] = f13;
        fArray[n++] = f9;
        fArray[n++] = f12;
        fArray[n++] = f5;
        fArray[n++] = f6;
        fArray[n++] = f13;
        fArray[n++] = f11;
        fArray[n++] = f12;
        fArray[n++] = f7;
        fArray[n++] = f8;
        fArray[n++] = f13;
        fArray[n++] = f11;
        fArray[n++] = f10;
        this.c = n;
    }

    @Override
    public void flush() {
        if (this.c == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int n = this.c / 20;
        if (n > this.maxSpritesInBatch) {
            this.maxSpritesInBatch = n;
        }
        int n2 = n * 6;
        this.d.bind();
        Mesh mesh = this.a;
        mesh.setVertices(this.b, 0, this.c);
        mesh.getIndicesBuffer().position(0);
        mesh.getIndicesBuffer().limit(n2);
        if (this.k) {
            Gdx.gl.glDisable(3042);
        } else {
            Gdx.gl.glEnable(3042);
            if (this.l != -1) {
                Gdx.gl.glBlendFunc(this.l, this.m);
            }
        }
        mesh.render(this.o != null ? this.o : this.n, 4, 0, n2);
        this.c = 0;
    }

    @Override
    public void disableBlending() {
        if (this.k) {
            return;
        }
        this.flush();
        this.k = true;
    }

    @Override
    public void enableBlending() {
        if (!this.k) {
            return;
        }
        this.flush();
        this.k = false;
    }

    @Override
    public void setBlendFunction(int srcFunc, int dstFunc) {
        if (this.l == srcFunc && this.m == dstFunc) {
            return;
        }
        this.flush();
        this.l = srcFunc;
        this.m = dstFunc;
    }

    @Override
    public int getBlendSrcFunc() {
        return this.l;
    }

    @Override
    public int getBlendDstFunc() {
        return this.m;
    }

    @Override
    public void dispose() {
        this.a.dispose();
        if (this.p && this.n != null) {
            this.n.dispose();
        }
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.i;
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.h;
    }

    @Override
    public void setProjectionMatrix(Matrix4 projection) {
        if (this.g) {
            this.flush();
        }
        this.i.set(projection);
        if (this.g) {
            this.a();
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 transform) {
        if (this.g) {
            this.flush();
        }
        this.h.set(transform);
        if (this.g) {
            this.a();
        }
    }

    private void a() {
        this.j.set(this.i).mul(this.h);
        if (this.o != null) {
            this.o.setUniformMatrix("u_projTrans", this.j);
            this.o.setUniformi("u_texture", 0);
            return;
        }
        this.n.setUniformMatrix("u_projTrans", this.j);
        this.n.setUniformi("u_texture", 0);
    }

    protected void switchTexture(Texture texture) {
        this.flush();
        this.d = texture;
        this.e = 1.0f / (float)texture.getWidth();
        this.f = 1.0f / (float)texture.getHeight();
    }

    @Override
    public void setShader(ShaderProgram shader) {
        if (this.g) {
            this.flush();
            if (this.o != null) {
                this.o.end();
            } else {
                this.n.end();
            }
        }
        this.o = shader;
        if (this.g) {
            if (this.o != null) {
                this.o.begin();
            } else {
                this.n.begin();
            }
            this.a();
        }
    }

    @Override
    public ShaderProgram getShader() {
        if (this.o == null) {
            return this.n;
        }
        return this.o;
    }

    @Override
    public boolean isBlendingEnabled() {
        return !this.k;
    }

    @Override
    public boolean isDrawing() {
        return this.g;
    }
}

