/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.Iterator;

@BA.Hide
public class TextureAtlas
implements Disposable {
    static final String[] a = new String[4];
    private final ObjectSet<Texture> c;
    private final Array<AtlasRegion> d;
    static final Comparator<TextureAtlasData.Region> b = new Comparator<TextureAtlasData.Region>(){};

    public TextureAtlas() {
        this.c = new ObjectSet(4);
        this.d = new Array();
    }

    public TextureAtlas(String internalPackFile) {
        this(Gdx.files.internal(internalPackFile));
    }

    public TextureAtlas(FileHandle packFile) {
        FileHandle fileHandle = packFile;
        this(fileHandle, fileHandle.parent());
    }

    public TextureAtlas(FileHandle packFile, boolean flip) {
        FileHandle fileHandle = packFile;
        this(fileHandle, fileHandle.parent(), flip);
    }

    public TextureAtlas(FileHandle packFile, FileHandle imagesDir) {
        this(packFile, imagesDir, false);
    }

    public TextureAtlas(FileHandle packFile, FileHandle imagesDir, boolean flip) {
        this(new TextureAtlasData(packFile, imagesDir, flip));
    }

    public TextureAtlas(TextureAtlasData data) {
        this.c = new ObjectSet(4);
        this.d = new Array();
        if (data != null) {
            this.a(data);
        }
    }

    private void a(TextureAtlasData textureAtlasData) {
        ObjectMap<TextureAtlasData.Page, Texture> objectMap = new ObjectMap<TextureAtlasData.Page, Texture>();
        for (TextureAtlasData.Page object : textureAtlasData.a) {
            Texture n;
            if (object.texture == null) {
                n = new Texture(object.textureFile, object.format, object.useMipMaps);
                n.setFilter(object.minFilter, object.magFilter);
                n.setWrap(object.uWrap, object.vWrap);
            } else {
                n = object.texture;
                n.setFilter(object.minFilter, object.magFilter);
                n.setWrap(object.uWrap, object.vWrap);
            }
            this.c.add(n);
            objectMap.put(object, n);
        }
        for (TextureAtlasData.Region region : textureAtlasData.b) {
            int n = region.width;
            int n2 = region.height;
            AtlasRegion atlasRegion = new AtlasRegion((Texture)objectMap.get(region.page), region.left, region.top, region.rotate ? n2 : n, region.rotate ? n : n2);
            new AtlasRegion((Texture)objectMap.get(region.page), region.left, region.top, region.rotate ? n2 : n, region.rotate ? n : n2).index = region.index;
            atlasRegion.name = region.name;
            atlasRegion.offsetX = region.offsetX;
            atlasRegion.offsetY = region.offsetY;
            atlasRegion.originalHeight = region.originalHeight;
            atlasRegion.originalWidth = region.originalWidth;
            atlasRegion.rotate = region.rotate;
            atlasRegion.splits = region.splits;
            atlasRegion.pads = region.pads;
            if (region.flip) {
                atlasRegion.flip(false, true);
            }
            this.d.add(atlasRegion);
        }
    }

    public AtlasRegion addRegion(String name, Texture texture, int x, int y, int width, int height) {
        this.c.add(texture);
        AtlasRegion atlasRegion = new AtlasRegion(texture, x, y, width, height);
        new AtlasRegion(texture, x, y, width, height).name = name;
        atlasRegion.originalWidth = width;
        atlasRegion.originalHeight = height;
        atlasRegion.index = -1;
        this.d.add(atlasRegion);
        return atlasRegion;
    }

    public AtlasRegion addRegion(String name, TextureRegion textureRegion) {
        return this.addRegion(name, textureRegion.c, textureRegion.getRegionX(), textureRegion.getRegionY(), textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
    }

    public Array<AtlasRegion> getRegions() {
        return this.d;
    }

    public AtlasRegion findRegion(String name) {
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            if (this.d.get((int)n).name.equals(name)) {
                return this.d.get(n);
            }
            ++n;
        }
        return null;
    }

    public AtlasRegion findRegion(String name, int index) {
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            AtlasRegion atlasRegion = this.d.get(n);
            if (atlasRegion.name.equals(name) && atlasRegion.index == index) {
                return atlasRegion;
            }
            ++n;
        }
        return null;
    }

    public Array<AtlasRegion> findRegions(String name) {
        Array<AtlasRegion> array = new Array<AtlasRegion>();
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            AtlasRegion atlasRegion = this.d.get(n);
            if (atlasRegion.name.equals(name)) {
                array.add(new AtlasRegion(atlasRegion));
            }
            ++n;
        }
        return array;
    }

    public Array<Sprite> createSprites() {
        Array<Sprite> array = new Array<Sprite>(this.d.size);
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            array.add(TextureAtlas.a(this.d.get(n)));
            ++n;
        }
        return array;
    }

    public Sprite createSprite(String name) {
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            if (this.d.get((int)n).name.equals(name)) {
                return TextureAtlas.a(this.d.get(n));
            }
            ++n;
        }
        return null;
    }

    public Sprite createSprite(String name, int index) {
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            AtlasRegion atlasRegion = this.d.get(n);
            if (atlasRegion.name.equals(name) && atlasRegion.index == index) {
                return TextureAtlas.a(this.d.get(n));
            }
            ++n;
        }
        return null;
    }

    public Array<Sprite> createSprites(String name) {
        Array<Sprite> array = new Array<Sprite>();
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            AtlasRegion atlasRegion = this.d.get(n);
            if (atlasRegion.name.equals(name)) {
                array.add(TextureAtlas.a(atlasRegion));
            }
            ++n;
        }
        return array;
    }

    private static Sprite a(AtlasRegion atlasRegion) {
        if (atlasRegion.packedWidth == atlasRegion.originalWidth && atlasRegion.packedHeight == atlasRegion.originalHeight) {
            if (atlasRegion.rotate) {
                Sprite sprite = new Sprite(atlasRegion);
                sprite.setBounds(0.0f, 0.0f, atlasRegion.getRegionHeight(), atlasRegion.getRegionWidth());
                sprite.rotate90(true);
                return sprite;
            }
            return new Sprite(atlasRegion);
        }
        return new AtlasSprite(atlasRegion);
    }

    public NinePatch createPatch(String name) {
        int n = 0;
        int n2 = this.d.size;
        while (n < n2) {
            AtlasRegion atlasRegion = this.d.get(n);
            if (atlasRegion.name.equals(name)) {
                int[] nArray = atlasRegion.splits;
                if (atlasRegion.splits == null) {
                    throw new IllegalArgumentException("Region does not have ninepatch splits: ".concat(String.valueOf(name)));
                }
                NinePatch ninePatch = new NinePatch((TextureRegion)atlasRegion, nArray[0], nArray[1], nArray[2], nArray[3]);
                if (atlasRegion.pads != null) {
                    ninePatch.setPadding(atlasRegion.pads[0], atlasRegion.pads[1], atlasRegion.pads[2], atlasRegion.pads[3]);
                }
                return ninePatch;
            }
            ++n;
        }
        return null;
    }

    public ObjectSet<Texture> getTextures() {
        return this.c;
    }

    @Override
    public void dispose() {
        Iterator iterator = this.c.iterator();
        while (iterator.hasNext()) {
            ((Texture)iterator.next()).dispose();
        }
        this.c.clear();
    }

    static String a(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        int n = string.indexOf(58);
        if (n == -1) {
            throw new GdxRuntimeException("Invalid line: ".concat(String.valueOf(string)));
        }
        return string.substring(n + 1).trim();
    }

    static int b(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        int n = string.indexOf(58);
        if (n == -1) {
            throw new GdxRuntimeException("Invalid line: ".concat(String.valueOf(string)));
        }
        int n2 = n + 1;
        int n3 = 0;
        while (n3 < 3) {
            int n4 = string.indexOf(44, n2);
            if (n4 == -1) break;
            TextureAtlas.a[n3] = string.substring(n2, n4).trim();
            n2 = n4 + 1;
            ++n3;
        }
        TextureAtlas.a[n3] = string.substring(n2).trim();
        return n3 + 1;
    }

    @BA.Hide
    public static class AtlasRegion
    extends TextureRegion {
        public int index;
        public String name;
        public float offsetX;
        public float offsetY;
        public int packedWidth;
        public int packedHeight;
        public int originalWidth;
        public int originalHeight;
        public boolean rotate;
        public int[] splits;
        public int[] pads;

        public AtlasRegion(Texture texture, int x, int y, int width, int height) {
            super(texture, x, y, width, height);
            this.originalWidth = width;
            this.originalHeight = height;
            this.packedWidth = width;
            this.packedHeight = height;
        }

        public AtlasRegion(AtlasRegion region) {
            this.setRegion(region);
            this.index = region.index;
            this.name = region.name;
            this.offsetX = region.offsetX;
            this.offsetY = region.offsetY;
            this.packedWidth = region.packedWidth;
            this.packedHeight = region.packedHeight;
            this.originalWidth = region.originalWidth;
            this.originalHeight = region.originalHeight;
            this.rotate = region.rotate;
            this.splits = region.splits;
        }

        @Override
        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = (float)this.originalWidth - this.offsetX - this.getRotatedPackedWidth();
            }
            if (y) {
                this.offsetY = (float)this.originalHeight - this.offsetY - this.getRotatedPackedHeight();
            }
        }

        public float getRotatedPackedWidth() {
            return this.rotate ? this.packedHeight : this.packedWidth;
        }

        public float getRotatedPackedHeight() {
            return this.rotate ? this.packedWidth : this.packedHeight;
        }

        public String toString() {
            return this.name;
        }
    }

    @BA.Hide
    public static class AtlasSprite
    extends Sprite {
        private AtlasRegion j;
        private float k;
        private float l;

        public AtlasSprite(AtlasRegion region) {
            this.j = new AtlasRegion(region);
            this.k = region.offsetX;
            this.l = region.offsetY;
            this.setRegion(region);
            this.setOrigin((float)region.originalWidth / 2.0f, (float)region.originalHeight / 2.0f);
            int n = region.getRegionWidth();
            int n2 = region.getRegionHeight();
            if (region.rotate) {
                super.rotate90(true);
                super.setBounds(region.offsetX, region.offsetY, n2, n);
            } else {
                super.setBounds(region.offsetX, region.offsetY, n, n2);
            }
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public AtlasSprite(AtlasSprite sprite) {
            this.j = sprite.j;
            this.k = sprite.k;
            this.l = sprite.l;
            this.set(sprite);
        }

        @Override
        public void setPosition(float x, float y) {
            super.setPosition(x + this.j.offsetX, y + this.j.offsetY);
        }

        @Override
        public void setX(float x) {
            super.setX(x + this.j.offsetX);
        }

        @Override
        public void setY(float y) {
            super.setY(y + this.j.offsetY);
        }

        @Override
        public void setBounds(float x, float y, float width, float height) {
            float f = width / (float)this.j.originalWidth;
            float f2 = height / (float)this.j.originalHeight;
            this.j.offsetX = this.k * f;
            this.j.offsetY = this.l * f2;
            int n = this.j.rotate ? this.j.packedHeight : this.j.packedWidth;
            int n2 = this.j.rotate ? this.j.packedWidth : this.j.packedHeight;
            super.setBounds(x + this.j.offsetX, y + this.j.offsetY, (float)n * f, (float)n2 * f2);
        }

        @Override
        public void setSize(float width, float height) {
            AtlasSprite atlasSprite = this;
            atlasSprite.setBounds(atlasSprite.getX(), this.getY(), width, height);
        }

        @Override
        public void setOrigin(float originX, float originY) {
            super.setOrigin(originX - this.j.offsetX, originY - this.j.offsetY);
        }

        @Override
        public void setOriginCenter() {
            AtlasSprite atlasSprite = this;
            super.setOrigin(atlasSprite.a / 2.0f - this.j.offsetX, this.b / 2.0f - this.j.offsetY);
        }

        @Override
        public void flip(boolean x, boolean y) {
            if (this.j.rotate) {
                super.flip(y, x);
            } else {
                super.flip(x, y);
            }
            float f = this.getOriginX();
            float f2 = this.getOriginY();
            float f3 = this.j.offsetX;
            float f4 = this.j.offsetY;
            float f5 = this.getWidthRatio();
            float f6 = this.getHeightRatio();
            this.j.offsetX = this.k;
            this.j.offsetY = this.l;
            this.j.flip(x, y);
            this.k = this.j.offsetX;
            this.l = this.j.offsetY;
            this.j.offsetX *= f5;
            this.j.offsetY *= f6;
            AtlasSprite atlasSprite = this;
            atlasSprite.translate(atlasSprite.j.offsetX - f3, this.j.offsetY - f4);
            this.setOrigin(f, f2);
        }

        @Override
        public void rotate90(boolean clockwise) {
            super.rotate90(clockwise);
            float f = this.getOriginX();
            float f2 = this.getOriginY();
            float f3 = this.j.offsetX;
            float f4 = this.j.offsetY;
            float f5 = this.getWidthRatio();
            float f6 = this.getHeightRatio();
            if (clockwise) {
                this.j.offsetX = f4;
                this.j.offsetY = (float)this.j.originalHeight * f6 - f3 - (float)this.j.packedWidth * f5;
            } else {
                this.j.offsetX = (float)this.j.originalWidth * f5 - f4 - (float)this.j.packedHeight * f6;
                this.j.offsetY = f3;
            }
            AtlasSprite atlasSprite = this;
            atlasSprite.translate(atlasSprite.j.offsetX - f3, this.j.offsetY - f4);
            this.setOrigin(f, f2);
        }

        @Override
        public float getX() {
            return super.getX() - this.j.offsetX;
        }

        @Override
        public float getY() {
            return super.getY() - this.j.offsetY;
        }

        @Override
        public float getOriginX() {
            return super.getOriginX() + this.j.offsetX;
        }

        @Override
        public float getOriginY() {
            return super.getOriginY() + this.j.offsetY;
        }

        @Override
        public float getWidth() {
            return super.getWidth() / this.j.getRotatedPackedWidth() * (float)this.j.originalWidth;
        }

        @Override
        public float getHeight() {
            return super.getHeight() / this.j.getRotatedPackedHeight() * (float)this.j.originalHeight;
        }

        public float getWidthRatio() {
            return super.getWidth() / this.j.getRotatedPackedWidth();
        }

        public float getHeightRatio() {
            return super.getHeight() / this.j.getRotatedPackedHeight();
        }

        public AtlasRegion getAtlasRegion() {
            return this.j;
        }

        public String toString() {
            return this.j.toString();
        }
    }

    @BA.Hide
    public static class TextureAtlasData {
        final Array<Page> a = new Array();
        final Array<Region> b = new Array();

        public TextureAtlasData(FileHandle packFile, FileHandle imagesDir, boolean flip) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(packFile.read()), 64);
            try {
                try {
                    String string;
                    Page page = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        Object object;
                        if (string.trim().length() == 0) {
                            page = null;
                            continue;
                        }
                        if (page == null) {
                            FileHandle fileHandle = imagesDir.child(string);
                            float f = 0.0f;
                            float f2 = 0.0f;
                            if (TextureAtlas.b(bufferedReader) == 2) {
                                f = Integer.parseInt(a[0]);
                                f2 = Integer.parseInt(a[1]);
                                TextureAtlas.b(bufferedReader);
                            }
                            Pixmap.Format format = Pixmap.Format.valueOf(a[0]);
                            TextureAtlas.b(bufferedReader);
                            Texture.TextureFilter textureFilter = Texture.TextureFilter.valueOf(a[0]);
                            object = Texture.TextureFilter.valueOf(a[1]);
                            String string2 = TextureAtlas.a(bufferedReader);
                            Texture.TextureWrap textureWrap = Texture.TextureWrap.ClampToEdge;
                            Texture.TextureWrap textureWrap2 = Texture.TextureWrap.ClampToEdge;
                            if (string2.equals("x")) {
                                textureWrap = Texture.TextureWrap.Repeat;
                            } else if (string2.equals("y")) {
                                textureWrap2 = Texture.TextureWrap.Repeat;
                            } else if (string2.equals("xy")) {
                                textureWrap = Texture.TextureWrap.Repeat;
                                textureWrap2 = Texture.TextureWrap.Repeat;
                            }
                            page = new Page(fileHandle, f, f2, textureFilter.isMipMap(), format, textureFilter, (Texture.TextureFilter)((Object)object), textureWrap, textureWrap2);
                            this.a.add(page);
                            continue;
                        }
                        boolean bl = Boolean.valueOf(TextureAtlas.a(bufferedReader));
                        TextureAtlas.b(bufferedReader);
                        int n = Integer.parseInt(a[0]);
                        int n2 = Integer.parseInt(a[1]);
                        TextureAtlas.b(bufferedReader);
                        int n3 = Integer.parseInt(a[0]);
                        int n4 = Integer.parseInt(a[1]);
                        object = new Region();
                        new Region().page = page;
                        ((Region)object).left = n;
                        ((Region)object).top = n2;
                        ((Region)object).width = n3;
                        ((Region)object).height = n4;
                        ((Region)object).name = string;
                        ((Region)object).rotate = bl;
                        if (TextureAtlas.b(bufferedReader) == 4) {
                            ((Region)object).splits = new int[]{Integer.parseInt(a[0]), Integer.parseInt(a[1]), Integer.parseInt(a[2]), Integer.parseInt(a[3])};
                            if (TextureAtlas.b(bufferedReader) == 4) {
                                ((Region)object).pads = new int[]{Integer.parseInt(a[0]), Integer.parseInt(a[1]), Integer.parseInt(a[2]), Integer.parseInt(a[3])};
                                TextureAtlas.b(bufferedReader);
                            }
                        }
                        ((Region)object).originalWidth = Integer.parseInt(a[0]);
                        ((Region)object).originalHeight = Integer.parseInt(a[1]);
                        TextureAtlas.b(bufferedReader);
                        ((Region)object).offsetX = Integer.parseInt(a[0]);
                        ((Region)object).offsetY = Integer.parseInt(a[1]);
                        ((Region)object).index = Integer.parseInt(TextureAtlas.a(bufferedReader));
                        if (flip) {
                            ((Region)object).flip = true;
                        }
                        this.b.add((Region)object);
                    }
                }
                catch (Exception exception) {
                    throw new GdxRuntimeException("Error reading pack file: ".concat(String.valueOf(packFile)), exception);
                }
            }
            finally {
                StreamUtils.closeQuietly(bufferedReader);
            }
            this.b.sort(b);
        }

        public Array<Page> getPages() {
            return this.a;
        }

        public Array<Region> getRegions() {
            return this.b;
        }

        @BA.Hide
        public static class Page {
            public final FileHandle textureFile;
            public Texture texture;
            public final float width;
            public final float height;
            public final boolean useMipMaps;
            public final Pixmap.Format format;
            public final Texture.TextureFilter minFilter;
            public final Texture.TextureFilter magFilter;
            public final Texture.TextureWrap uWrap;
            public final Texture.TextureWrap vWrap;

            public Page(FileHandle handle, float width, float height, boolean useMipMaps, Pixmap.Format format, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, Texture.TextureWrap uWrap, Texture.TextureWrap vWrap) {
                this.width = width;
                this.height = height;
                this.textureFile = handle;
                this.useMipMaps = useMipMaps;
                this.format = format;
                this.minFilter = minFilter;
                this.magFilter = magFilter;
                this.uWrap = uWrap;
                this.vWrap = vWrap;
            }
        }

        @BA.Hide
        public static class Region {
            public Page page;
            public int index;
            public String name;
            public float offsetX;
            public float offsetY;
            public int originalWidth;
            public int originalHeight;
            public boolean rotate;
            public int left;
            public int top;
            public int width;
            public int height;
            public boolean flip;
            public int[] splits;
            public int[] pads;
        }
    }
}

