/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Texture;

@BA.Hide
public class TextureRegion {
    Texture c;
    float d;
    float e;
    float f;
    float g;
    int h;
    int i;

    public TextureRegion() {
    }

    public TextureRegion(Texture texture) {
        if (texture == null) {
            throw new IllegalArgumentException("texture cannot be null.");
        }
        this.c = texture;
        this.setRegion(0, 0, texture.getWidth(), texture.getHeight());
    }

    public TextureRegion(Texture texture, int width, int height) {
        this.c = texture;
        this.setRegion(0, 0, width, height);
    }

    public TextureRegion(Texture texture, int x, int y, int width, int height) {
        this.c = texture;
        this.setRegion(x, y, width, height);
    }

    public TextureRegion(Texture texture, float u, float v, float u2, float v2) {
        this.c = texture;
        this.setRegion(u, v, u2, v2);
    }

    public TextureRegion(TextureRegion region) {
        this.setRegion(region);
    }

    public TextureRegion(TextureRegion region, int x, int y, int width, int height) {
        this.setRegion(region, x, y, width, height);
    }

    public void setRegion(Texture texture) {
        this.c = texture;
        this.setRegion(0, 0, texture.getWidth(), texture.getHeight());
    }

    public void setRegion(int x, int y, int width, int height) {
        float f = 1.0f / (float)this.c.getWidth();
        float f2 = 1.0f / (float)this.c.getHeight();
        this.setRegion((float)x * f, (float)y * f2, (float)(x + width) * f, (float)(y + height) * f2);
        this.h = Math.abs(width);
        this.i = Math.abs(height);
    }

    public void setRegion(float u, float v, float u2, float v2) {
        int n = this.c.getWidth();
        int n2 = this.c.getHeight();
        this.h = Math.round(Math.abs(u2 - u) * (float)n);
        this.i = Math.round(Math.abs(v2 - v) * (float)n2);
        if (this.h == 1 && this.i == 1) {
            float f = 0.25f / (float)n;
            u += f;
            u2 -= f;
            float f2 = 0.25f / (float)n2;
            v += f2;
            v2 -= f2;
        }
        this.d = u;
        this.e = v;
        this.f = u2;
        this.g = v2;
    }

    public void setRegion(TextureRegion region) {
        this.c = region.c;
        this.setRegion(region.d, region.e, region.f, region.g);
    }

    public void setRegion(TextureRegion region, int x, int y, int width, int height) {
        this.c = region.c;
        this.setRegion(region.getRegionX() + x, region.getRegionY() + y, width, height);
    }

    public Texture getTexture() {
        return this.c;
    }

    public void setTexture(Texture texture) {
        this.c = texture;
    }

    public float getU() {
        return this.d;
    }

    public void setU(float u) {
        this.d = u;
        this.h = Math.round(Math.abs(this.f - u) * (float)this.c.getWidth());
    }

    public float getV() {
        return this.e;
    }

    public void setV(float v) {
        this.e = v;
        this.i = Math.round(Math.abs(this.g - v) * (float)this.c.getHeight());
    }

    public float getU2() {
        return this.f;
    }

    public void setU2(float u2) {
        this.f = u2;
        this.h = Math.round(Math.abs(u2 - this.d) * (float)this.c.getWidth());
    }

    public float getV2() {
        return this.g;
    }

    public void setV2(float v2) {
        this.g = v2;
        this.i = Math.round(Math.abs(v2 - this.e) * (float)this.c.getHeight());
    }

    public int getRegionX() {
        return Math.round(this.d * (float)this.c.getWidth());
    }

    public void setRegionX(int x) {
        this.setU((float)x / (float)this.c.getWidth());
    }

    public int getRegionY() {
        return Math.round(this.e * (float)this.c.getHeight());
    }

    public void setRegionY(int y) {
        this.setV((float)y / (float)this.c.getHeight());
    }

    public int getRegionWidth() {
        return this.h;
    }

    public void setRegionWidth(int width) {
        if (this.isFlipX()) {
            TextureRegion textureRegion = this;
            textureRegion.setU(textureRegion.f + (float)width / (float)this.c.getWidth());
            return;
        }
        TextureRegion textureRegion = this;
        textureRegion.setU2(textureRegion.d + (float)width / (float)this.c.getWidth());
    }

    public int getRegionHeight() {
        return this.i;
    }

    public void setRegionHeight(int height) {
        if (this.isFlipY()) {
            TextureRegion textureRegion = this;
            textureRegion.setV(textureRegion.g + (float)height / (float)this.c.getHeight());
            return;
        }
        TextureRegion textureRegion = this;
        textureRegion.setV2(textureRegion.e + (float)height / (float)this.c.getHeight());
    }

    public void flip(boolean x, boolean y) {
        float f;
        if (x) {
            f = this.d;
            this.d = this.f;
            this.f = f;
        }
        if (y) {
            f = this.e;
            this.e = this.g;
            this.g = f;
        }
    }

    public boolean isFlipX() {
        return this.d > this.f;
    }

    public boolean isFlipY() {
        return this.e > this.g;
    }

    public void scroll(float xAmount, float yAmount) {
        float f;
        if (xAmount != 0.0f) {
            f = (this.f - this.d) * (float)this.c.getWidth();
            this.d = (this.d + xAmount) % 1.0f;
            this.f = this.d + f / (float)this.c.getWidth();
        }
        if (yAmount != 0.0f) {
            f = (this.g - this.e) * (float)this.c.getHeight();
            this.e = (this.e + yAmount) % 1.0f;
            this.g = this.e + f / (float)this.c.getHeight();
        }
    }

    public TextureRegion[][] split(int tileWidth, int tileHeight) {
        int n = this.getRegionX();
        int n2 = this.getRegionY();
        int n3 = this.h;
        int n4 = this.i / tileHeight;
        int n5 = n3 / tileWidth;
        int n6 = n;
        TextureRegion[][] textureRegionArray = new TextureRegion[n4][n5];
        int n7 = 0;
        while (n7 < n4) {
            n = n6;
            int n8 = 0;
            while (n8 < n5) {
                textureRegionArray[n7][n8] = new TextureRegion(this.c, n, n2, tileWidth, tileHeight);
                ++n8;
                n += tileWidth;
            }
            ++n7;
            n2 += tileHeight;
        }
        return textureRegionArray;
    }

    public static TextureRegion[][] split(Texture texture, int tileWidth, int tileHeight) {
        return new TextureRegion(texture).split(tileWidth, tileHeight);
    }
}

