/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;

@BA.Hide
public class FreeType {
    public static int FT_PIXEL_MODE_NONE = 0;
    public static int FT_PIXEL_MODE_MONO = 1;
    public static int FT_PIXEL_MODE_GRAY = 2;
    public static int FT_PIXEL_MODE_GRAY2 = 3;
    public static int FT_PIXEL_MODE_GRAY4 = 4;
    public static int FT_PIXEL_MODE_LCD = 5;
    public static int FT_PIXEL_MODE_LCD_V = 6;
    public static int FT_ENCODING_NONE = 0;
    public static int FT_ENCODING_MS_SYMBOL = FreeType.a('s', 'y', 'm', 'b');
    public static int FT_ENCODING_UNICODE = FreeType.a('u', 'n', 'i', 'c');
    public static int FT_ENCODING_SJIS = FreeType.a('s', 'j', 'i', 's');
    public static int FT_ENCODING_GB2312 = FreeType.a('g', 'b', ' ', ' ');
    public static int FT_ENCODING_BIG5 = FreeType.a('b', 'i', 'g', '5');
    public static int FT_ENCODING_WANSUNG = FreeType.a('w', 'a', 'n', 's');
    public static int FT_ENCODING_JOHAB = FreeType.a('j', 'o', 'h', 'a');
    public static int FT_ENCODING_ADOBE_STANDARD = FreeType.a('A', 'D', 'O', 'B');
    public static int FT_ENCODING_ADOBE_EXPERT = FreeType.a('A', 'D', 'B', 'E');
    public static int FT_ENCODING_ADOBE_CUSTOM = FreeType.a('A', 'D', 'B', 'C');
    public static int FT_ENCODING_ADOBE_LATIN_1 = FreeType.a('l', 'a', 't', '1');
    public static int FT_ENCODING_OLD_LATIN_2 = FreeType.a('l', 'a', 't', '2');
    public static int FT_ENCODING_APPLE_ROMAN = FreeType.a('a', 'r', 'm', 'n');
    public static int FT_FACE_FLAG_SCALABLE = 1;
    public static int FT_FACE_FLAG_FIXED_SIZES = 2;
    public static int FT_FACE_FLAG_FIXED_WIDTH = 4;
    public static int FT_FACE_FLAG_SFNT = 8;
    public static int FT_FACE_FLAG_HORIZONTAL = 16;
    public static int FT_FACE_FLAG_VERTICAL = 32;
    public static int FT_FACE_FLAG_KERNING = 64;
    public static int FT_FACE_FLAG_FAST_GLYPHS = 128;
    public static int FT_FACE_FLAG_MULTIPLE_MASTERS = 256;
    public static int FT_FACE_FLAG_GLYPH_NAMES = 512;
    public static int FT_FACE_FLAG_EXTERNAL_STREAM = 1024;
    public static int FT_FACE_FLAG_HINTER = 2048;
    public static int FT_FACE_FLAG_CID_KEYED = 4096;
    public static int FT_FACE_FLAG_TRICKY = 8192;
    public static int FT_STYLE_FLAG_ITALIC = 1;
    public static int FT_STYLE_FLAG_BOLD = 2;
    public static int FT_LOAD_DEFAULT = 0;
    public static int FT_LOAD_NO_SCALE = 1;
    public static int FT_LOAD_NO_HINTING = 2;
    public static int FT_LOAD_RENDER = 4;
    public static int FT_LOAD_NO_BITMAP = 8;
    public static int FT_LOAD_VERTICAL_LAYOUT = 16;
    public static int FT_LOAD_FORCE_AUTOHINT = 32;
    public static int FT_LOAD_CROP_BITMAP = 64;
    public static int FT_LOAD_PEDANTIC = 128;
    public static int FT_LOAD_IGNORE_GLOBAL_ADVANCE_WIDTH = 512;
    public static int FT_LOAD_NO_RECURSE = 1024;
    public static int FT_LOAD_IGNORE_TRANSFORM = 2048;
    public static int FT_LOAD_MONOCHROME = 4096;
    public static int FT_LOAD_LINEAR_DESIGN = 8192;
    public static int FT_LOAD_NO_AUTOHINT = 32768;
    public static int FT_RENDER_MODE_NORMAL = 0;
    public static int FT_RENDER_MODE_LIGHT = 1;
    public static int FT_RENDER_MODE_MONO = 2;
    public static int FT_RENDER_MODE_LCD = 3;
    public static int FT_RENDER_MODE_LCD_V = 4;
    public static int FT_RENDER_MODE_MAX = 5;
    public static int FT_KERNING_DEFAULT = 0;
    public static int FT_KERNING_UNFITTED = 1;
    public static int FT_KERNING_UNSCALED = 2;
    public static int FT_STROKER_LINECAP_BUTT = 0;
    public static int FT_STROKER_LINECAP_ROUND = 1;
    public static int FT_STROKER_LINECAP_SQUARE = 2;
    public static int FT_STROKER_LINEJOIN_ROUND = 0;
    public static int FT_STROKER_LINEJOIN_BEVEL = 1;
    public static int FT_STROKER_LINEJOIN_MITER_VARIABLE = 2;
    public static int FT_STROKER_LINEJOIN_MITER = 2;
    public static int FT_STROKER_LINEJOIN_MITER_FIXED = 3;

    private static int a(char c2, char c3, char c4, char c5) {
        return c2 << 24 | c3 << 16 | c4 << 8 | c5;
    }

    public static Library initFreeType() {
        new SharedLibraryLoader().load("gdx-freetype");
        long l = FreeType.initFreeTypeJni();
        if (l == 0L) {
            throw new GdxRuntimeException("Couldn't initialize FreeType library");
        }
        return new Library(l);
    }

    private static native long initFreeTypeJni();

    public static int toInt(int value) {
        if (value < 0) {
            return value - 32 >> 6;
        }
        return value + 32 >> 6;
    }

    @BA.Hide
    public static class Bitmap
    extends a {
        Bitmap(long address) {
            super(address);
        }

        public int getRows() {
            return Bitmap.getRows(this.b);
        }

        private static native int getRows(long var0);

        public int getWidth() {
            return Bitmap.getWidth(this.b);
        }

        private static native int getWidth(long var0);

        public int getPitch() {
            return Bitmap.getPitch(this.b);
        }

        private static native int getPitch(long var0);

        public ByteBuffer getBuffer() {
            if (this.getRows() == 0) {
                return BufferUtils.newByteBuffer(1);
            }
            return Bitmap.getBuffer(this.b);
        }

        private static native ByteBuffer getBuffer(long var0);

        public Pixmap getPixmap(Pixmap.Format format, Color color, float gamma) {
            Object object;
            Pixmap pixmap;
            int n = this.getWidth();
            int n2 = this.getRows();
            ByteBuffer byteBuffer = this.getBuffer();
            int n3 = this.getPitch();
            if (color == Color.WHITE && n3 == 1 && gamma == 1.0f) {
                pixmap = new Pixmap(n, n2, Pixmap.Format.Alpha);
                BufferUtils.copy(byteBuffer, pixmap.getPixels(), pixmap.getPixels().capacity());
            } else {
                pixmap = new Pixmap(n, n2, Pixmap.Format.RGBA8888);
                int n4 = Color.rgba8888(color);
                object = pixmap.getPixels().asIntBuffer();
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = n5 * n3;
                    int n7 = n5 * n;
                    int n8 = 0;
                    while (n8 < n) {
                        float f = (float)Math.pow((float)(byteBuffer.get(n6 + n8) & 0xFF) / 255.0f, gamma);
                        ((IntBuffer)object).put(n7 + n8, n4 & 0xFFFFFF00 | (int)((float)(n4 & 0xFF) * f));
                        ++n8;
                    }
                    ++n5;
                }
            }
            Pixmap pixmap2 = pixmap;
            if (format != pixmap.getFormat()) {
                pixmap2 = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), format);
                object = Pixmap.getBlending();
                Pixmap.setBlending(Pixmap.Blending.None);
                pixmap2.drawPixmap(pixmap, 0, 0);
                Pixmap.setBlending((Pixmap.Blending)((Object)object));
                pixmap.dispose();
            }
            return pixmap2;
        }

        public int getNumGray() {
            return Bitmap.getNumGray(this.b);
        }

        private static native int getNumGray(long var0);

        public int getPixelMode() {
            return Bitmap.getPixelMode(this.b);
        }

        private static native int getPixelMode(long var0);
    }

    @BA.Hide
    public static class Face
    extends a
    implements Disposable {
        private Library a;

        public Face(long address, Library library) {
            super(address);
            this.a = library;
        }

        @Override
        public void dispose() {
            Face.doneFace(this.b);
            ByteBuffer byteBuffer = this.a.a.get(this.b);
            if (byteBuffer != null) {
                this.a.a.remove(this.b);
                BufferUtils.disposeUnsafeByteBuffer(byteBuffer);
            }
        }

        private static native void doneFace(long var0);

        public int getFaceFlags() {
            return Face.getFaceFlags(this.b);
        }

        private static native int getFaceFlags(long var0);

        public int getStyleFlags() {
            return Face.getStyleFlags(this.b);
        }

        private static native int getStyleFlags(long var0);

        public int getNumGlyphs() {
            return Face.getNumGlyphs(this.b);
        }

        private static native int getNumGlyphs(long var0);

        public int getAscender() {
            return Face.getAscender(this.b);
        }

        private static native int getAscender(long var0);

        public int getDescender() {
            return Face.getDescender(this.b);
        }

        private static native int getDescender(long var0);

        public int getHeight() {
            return Face.getHeight(this.b);
        }

        private static native int getHeight(long var0);

        public int getMaxAdvanceWidth() {
            return Face.getMaxAdvanceWidth(this.b);
        }

        private static native int getMaxAdvanceWidth(long var0);

        public int getMaxAdvanceHeight() {
            return Face.getMaxAdvanceHeight(this.b);
        }

        private static native int getMaxAdvanceHeight(long var0);

        public int getUnderlinePosition() {
            return Face.getUnderlinePosition(this.b);
        }

        private static native int getUnderlinePosition(long var0);

        public int getUnderlineThickness() {
            return Face.getUnderlineThickness(this.b);
        }

        private static native int getUnderlineThickness(long var0);

        public boolean selectSize(int strikeIndex) {
            return Face.selectSize(this.b, strikeIndex);
        }

        private static native boolean selectSize(long var0, int var2);

        public boolean setCharSize(int charWidth, int charHeight, int horzResolution, int vertResolution) {
            return Face.setCharSize(this.b, charWidth, charHeight, horzResolution, vertResolution);
        }

        private static native boolean setCharSize(long var0, int var2, int var3, int var4, int var5);

        public boolean setPixelSizes(int pixelWidth, int pixelHeight) {
            return Face.setPixelSizes(this.b, pixelWidth, pixelHeight);
        }

        private static native boolean setPixelSizes(long var0, int var2, int var3);

        public boolean loadGlyph(int glyphIndex, int loadFlags) {
            return Face.loadGlyph(this.b, glyphIndex, loadFlags);
        }

        private static native boolean loadGlyph(long var0, int var2, int var3);

        public boolean loadChar(int charCode, int loadFlags) {
            return Face.loadChar(this.b, charCode, loadFlags);
        }

        private static native boolean loadChar(long var0, int var2, int var3);

        public GlyphSlot getGlyph() {
            return new GlyphSlot(Face.getGlyph(this.b));
        }

        private static native long getGlyph(long var0);

        public Size getSize() {
            return new Size(Face.getSize(this.b));
        }

        private static native long getSize(long var0);

        public boolean hasKerning() {
            return Face.hasKerning(this.b);
        }

        private static native boolean hasKerning(long var0);

        public int getKerning(int leftGlyph, int rightGlyph, int kernMode) {
            return Face.getKerning(this.b, leftGlyph, rightGlyph, kernMode);
        }

        private static native int getKerning(long var0, int var2, int var3, int var4);

        public int getCharIndex(int charCode) {
            return Face.getCharIndex(this.b, charCode);
        }

        private static native int getCharIndex(long var0, int var2);
    }

    @BA.Hide
    public static class Glyph
    extends a
    implements Disposable {
        private boolean a;

        Glyph(long address) {
            super(address);
        }

        @Override
        public void dispose() {
            Glyph.done(this.b);
        }

        private static native void done(long var0);

        public void strokeBorder(Stroker stroker, boolean inside) {
            this.b = Glyph.strokeBorder(this.b, stroker.b, inside);
        }

        private static native long strokeBorder(long var0, long var2, boolean var4);

        public void toBitmap(int renderMode) {
            long l = Glyph.toBitmap(this.b, renderMode);
            if (l == 0L) {
                throw new GdxRuntimeException("Couldn't render glyph");
            }
            this.b = l;
            this.a = true;
        }

        private static native long toBitmap(long var0, int var2);

        public Bitmap getBitmap() {
            if (!this.a) {
                throw new GdxRuntimeException("Glyph is not yet rendered");
            }
            return new Bitmap(Glyph.getBitmap(this.b));
        }

        private static native long getBitmap(long var0);

        public int getLeft() {
            if (!this.a) {
                throw new GdxRuntimeException("Glyph is not yet rendered");
            }
            return Glyph.getLeft(this.b);
        }

        private static native int getLeft(long var0);

        public int getTop() {
            if (!this.a) {
                throw new GdxRuntimeException("Glyph is not yet rendered");
            }
            return Glyph.getTop(this.b);
        }

        private static native int getTop(long var0);
    }

    @BA.Hide
    public static class GlyphMetrics
    extends a {
        GlyphMetrics(long address) {
            super(address);
        }

        public int getWidth() {
            return GlyphMetrics.getWidth(this.b);
        }

        private static native int getWidth(long var0);

        public int getHeight() {
            return GlyphMetrics.getHeight(this.b);
        }

        private static native int getHeight(long var0);

        public int getHoriBearingX() {
            return GlyphMetrics.getHoriBearingX(this.b);
        }

        private static native int getHoriBearingX(long var0);

        public int getHoriBearingY() {
            return GlyphMetrics.getHoriBearingY(this.b);
        }

        private static native int getHoriBearingY(long var0);

        public int getHoriAdvance() {
            return GlyphMetrics.getHoriAdvance(this.b);
        }

        private static native int getHoriAdvance(long var0);

        public int getVertBearingX() {
            return GlyphMetrics.getVertBearingX(this.b);
        }

        private static native int getVertBearingX(long var0);

        public int getVertBearingY() {
            return GlyphMetrics.getVertBearingY(this.b);
        }

        private static native int getVertBearingY(long var0);

        public int getVertAdvance() {
            return GlyphMetrics.getVertAdvance(this.b);
        }

        private static native int getVertAdvance(long var0);
    }

    @BA.Hide
    public static class GlyphSlot
    extends a {
        GlyphSlot(long address) {
            super(address);
        }

        public GlyphMetrics getMetrics() {
            return new GlyphMetrics(GlyphSlot.getMetrics(this.b));
        }

        private static native long getMetrics(long var0);

        public int getLinearHoriAdvance() {
            return GlyphSlot.getLinearHoriAdvance(this.b);
        }

        private static native int getLinearHoriAdvance(long var0);

        public int getLinearVertAdvance() {
            return GlyphSlot.getLinearVertAdvance(this.b);
        }

        private static native int getLinearVertAdvance(long var0);

        public int getAdvanceX() {
            return GlyphSlot.getAdvanceX(this.b);
        }

        private static native int getAdvanceX(long var0);

        public int getAdvanceY() {
            return GlyphSlot.getAdvanceY(this.b);
        }

        private static native int getAdvanceY(long var0);

        public int getFormat() {
            return GlyphSlot.getFormat(this.b);
        }

        private static native int getFormat(long var0);

        public Bitmap getBitmap() {
            return new Bitmap(GlyphSlot.getBitmap(this.b));
        }

        private static native long getBitmap(long var0);

        public int getBitmapLeft() {
            return GlyphSlot.getBitmapLeft(this.b);
        }

        private static native int getBitmapLeft(long var0);

        public int getBitmapTop() {
            return GlyphSlot.getBitmapTop(this.b);
        }

        private static native int getBitmapTop(long var0);

        public boolean renderGlyph(int renderMode) {
            return GlyphSlot.renderGlyph(this.b, renderMode);
        }

        private static native boolean renderGlyph(long var0, int var2);

        public Glyph getGlyph() {
            long l = GlyphSlot.getGlyph(this.b);
            if (l == 0L) {
                throw new GdxRuntimeException("Couldn't get glyph");
            }
            return new Glyph(l);
        }

        private static native long getGlyph(long var0);
    }

    @BA.Hide
    public static class Library
    extends a
    implements Disposable {
        LongMap<ByteBuffer> a = new LongMap();

        Library(long address) {
            super(address);
        }

        @Override
        public void dispose() {
            Library.doneFreeType(this.b);
            Iterator<ByteBuffer> iterator = this.a.values().iterator();
            while (iterator.hasNext()) {
                BufferUtils.disposeUnsafeByteBuffer(iterator.next());
            }
        }

        private static native void doneFreeType(long var0);

        public Face newFace(FileHandle font, int faceIndex) {
            byte[] byArray = font.readBytes();
            return this.newMemoryFace(byArray, byArray.length, faceIndex);
        }

        public Face newMemoryFace(byte[] data, int dataSize, int faceIndex) {
            ByteBuffer byteBuffer = BufferUtils.newUnsafeByteBuffer(data.length);
            BufferUtils.copy(data, 0, (Buffer)byteBuffer, data.length);
            return this.newMemoryFace(byteBuffer, faceIndex);
        }

        public Face newMemoryFace(ByteBuffer buffer, int faceIndex) {
            ByteBuffer byteBuffer = buffer;
            long l = Library.newMemoryFace(this.b, byteBuffer, byteBuffer.remaining(), faceIndex);
            if (l == 0L) {
                BufferUtils.disposeUnsafeByteBuffer(buffer);
                throw new GdxRuntimeException("Couldn't load font");
            }
            this.a.put(l, buffer);
            return new Face(l, this);
        }

        private static native long newMemoryFace(long var0, ByteBuffer var2, int var3, int var4);

        public Stroker createStroker() {
            long l = Library.strokerNew(this.b);
            if (l == 0L) {
                throw new GdxRuntimeException("Couldn't create FreeType stroker");
            }
            return new Stroker(l);
        }

        private static native long strokerNew(long var0);
    }

    static class a {
        long b;

        a(long l) {
            this.b = l;
        }
    }

    @BA.Hide
    public static class Size
    extends a {
        Size(long address) {
            super(address);
        }

        public SizeMetrics getMetrics() {
            return new SizeMetrics(Size.getMetrics(this.b));
        }

        private static native long getMetrics(long var0);
    }

    @BA.Hide
    public static class SizeMetrics
    extends a {
        SizeMetrics(long address) {
            super(address);
        }

        public int getXppem() {
            return SizeMetrics.getXppem(this.b);
        }

        private static native int getXppem(long var0);

        public int getYppem() {
            return SizeMetrics.getYppem(this.b);
        }

        private static native int getYppem(long var0);

        public int getXScale() {
            return SizeMetrics.getXscale(this.b);
        }

        private static native int getXscale(long var0);

        public int getYscale() {
            return SizeMetrics.getYscale(this.b);
        }

        private static native int getYscale(long var0);

        public int getAscender() {
            return SizeMetrics.getAscender(this.b);
        }

        private static native int getAscender(long var0);

        public int getDescender() {
            return SizeMetrics.getDescender(this.b);
        }

        private static native int getDescender(long var0);

        public int getHeight() {
            return SizeMetrics.getHeight(this.b);
        }

        private static native int getHeight(long var0);

        public int getMaxAdvance() {
            return SizeMetrics.getMaxAdvance(this.b);
        }

        private static native int getMaxAdvance(long var0);
    }

    @BA.Hide
    public static class Stroker
    extends a
    implements Disposable {
        Stroker(long address) {
            super(address);
        }

        public void set(int radius, int lineCap, int lineJoin, int miterLimit) {
            Stroker.set(this.b, radius, lineCap, lineJoin, miterLimit);
        }

        private static native void set(long var0, int var2, int var3, int var4, int var5);

        @Override
        public void dispose() {
            Stroker.done(this.b);
        }

        private static native void done(long var0);
    }
}

