/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@BA.Hide
public class FreeTypeFontGenerator
implements Disposable {
    public static final String DEFAULT_CHARS = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    public static final int NO_MAXIMUM = -1;
    private static int b = 1024;
    private FreeType.Library c;
    final FreeType.Face a;
    private String d;
    private boolean e = false;

    public FreeTypeFontGenerator(FileHandle font) {
        ByteBuffer byteBuffer;
        this.d = font.pathWithoutExtension();
        int n = (int)font.length();
        this.c = FreeType.initFreeType();
        if (this.c == null) {
            throw new GdxRuntimeException("Couldn't initialize FreeType");
        }
        InputStream inputStream = font.read();
        try {
            try {
                if (n == 0) {
                    byte[] byArray = StreamUtils.copyStreamToByteArray(inputStream, n > 0 ? (int)((float)n * 1.5f) : 16384);
                    byteBuffer = BufferUtils.newUnsafeByteBuffer(byArray.length);
                    BufferUtils.copy(byArray, 0, (Buffer)byteBuffer, byArray.length);
                } else {
                    byteBuffer = BufferUtils.newUnsafeByteBuffer(n);
                    StreamUtils.copyStream(inputStream, byteBuffer);
                }
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException(iOException);
            }
        }
        finally {
            StreamUtils.closeQuietly(inputStream);
        }
        this.a = this.c.newMemoryFace(byteBuffer, 0);
        if (this.a == null) {
            throw new GdxRuntimeException("Couldn't create face for font: ".concat(String.valueOf(font)));
        }
        FreeTypeFontGenerator freeTypeFontGenerator = this;
        if ((freeTypeFontGenerator.a.getFaceFlags() & FreeType.FT_FACE_FLAG_FIXED_SIZES) == FreeType.FT_FACE_FLAG_FIXED_SIZES && (freeTypeFontGenerator.a.getFaceFlags() & FreeType.FT_FACE_FLAG_HORIZONTAL) == FreeType.FT_FACE_FLAG_HORIZONTAL && freeTypeFontGenerator.a.loadChar(32, FreeType.FT_LOAD_DEFAULT) && freeTypeFontGenerator.a.getGlyph().getFormat() == 1651078259) {
            freeTypeFontGenerator.e = true;
        }
        if (freeTypeFontGenerator.e) {
            return;
        }
        this.a(15);
    }

    public BitmapFont generateFont(FreeTypeFontParameter parameter) {
        return this.generateFont(parameter, new FreeTypeBitmapFontData());
    }

    public BitmapFont generateFont(FreeTypeFontParameter parameter, FreeTypeBitmapFontData data) {
        this.generateData(parameter, data);
        if (data.a == null && parameter.packer != null) {
            data.a = new Array();
            parameter.packer.updateTextureRegions(data.a, parameter.minFilter, parameter.magFilter, parameter.genMipMaps);
        }
        TextureRegion[] textureRegionArray = new TextureRegion[data.a.size];
        int n = 0;
        while (n < textureRegionArray.length) {
            textureRegionArray[n] = data.a.get(n);
            ++n;
        }
        BitmapFont bitmapFont = new BitmapFont((BitmapFont.BitmapFontData)data, textureRegionArray, true);
        bitmapFont.setOwnsTexture(parameter.packer == null);
        return bitmapFont;
    }

    public int scaleForPixelHeight(int height) {
        this.a(height);
        FreeType.SizeMetrics sizeMetrics = this.a.getSize().getMetrics();
        int n = FreeType.toInt(sizeMetrics.getAscender());
        int n2 = FreeType.toInt(sizeMetrics.getDescender());
        int n3 = height;
        return n3 * n3 / (n - n2);
    }

    public int scaleForPixelWidth(int width, int numChars) {
        FreeType.SizeMetrics sizeMetrics = this.a.getSize().getMetrics();
        int n = FreeType.toInt(sizeMetrics.getMaxAdvance());
        int n2 = FreeType.toInt(sizeMetrics.getAscender());
        int n3 = FreeType.toInt(sizeMetrics.getDescender());
        int n4 = (n2 - n3) * width / (n * numChars);
        this.a(n4);
        return n4;
    }

    public int scaleToFitSquare(int width, int height, int numChars) {
        return Math.min(this.scaleForPixelHeight(height), this.scaleForPixelWidth(width, numChars));
    }

    public GlyphAndBitmap generateGlyphAndBitmap(int c2, int size, boolean flip) {
        this.a(size);
        int n = FreeType.toInt(this.a.getSize().getMetrics().getAscender());
        if (this.a.getCharIndex(c2) == 0) {
            return null;
        }
        if (!this.a.loadChar(c2, FreeType.FT_LOAD_DEFAULT)) {
            throw new GdxRuntimeException("Unable to load character!");
        }
        FreeType.GlyphSlot glyphSlot = this.a.getGlyph();
        FreeType.Bitmap bitmap = !this.e && !glyphSlot.renderGlyph(FreeType.FT_RENDER_MODE_NORMAL) ? null : glyphSlot.getBitmap();
        FreeType.GlyphMetrics glyphMetrics = glyphSlot.getMetrics();
        BitmapFont.Glyph glyph = new BitmapFont.Glyph();
        if (bitmap != null) {
            glyph.width = bitmap.getWidth();
            glyph.height = bitmap.getRows();
        } else {
            glyph.width = 0;
            glyph.height = 0;
        }
        glyph.xoffset = glyphSlot.getBitmapLeft();
        glyph.yoffset = flip ? -glyphSlot.getBitmapTop() + n : -(glyph.height - glyphSlot.getBitmapTop()) - n;
        glyph.xadvance = FreeType.toInt(glyphMetrics.getHoriAdvance());
        glyph.srcX = 0;
        glyph.srcY = 0;
        glyph.id = c2;
        GlyphAndBitmap glyphAndBitmap = new GlyphAndBitmap(this);
        new GlyphAndBitmap(this).glyph = glyph;
        glyphAndBitmap.bitmap = bitmap;
        return glyphAndBitmap;
    }

    public FreeTypeBitmapFontData generateData(FreeTypeFontParameter parameter) {
        return this.generateData(parameter, new FreeTypeBitmapFontData());
    }

    final void a(int n) {
        if (!this.e && !this.a.setPixelSizes(0, n)) {
            throw new GdxRuntimeException("Couldn't set size for font");
        }
    }

    public FreeTypeBitmapFontData generateData(FreeTypeFontParameter parameter, FreeTypeBitmapFontData data) {
        BitmapFont.Glyph glyph;
        BitmapFont.Glyph glyph2;
        char c2;
        int n;
        int n2;
        parameter = parameter == null ? new FreeTypeFontParameter() : parameter;
        String string = parameter.characters;
        int n3 = string.length();
        boolean bl = parameter.incremental;
        this.a(parameter.size);
        FreeType.SizeMetrics sizeMetrics = this.a.getSize().getMetrics();
        data.flipped = parameter.flip;
        data.ascent = FreeType.toInt(sizeMetrics.getAscender());
        data.descent = FreeType.toInt(sizeMetrics.getDescender());
        data.lineHeight = FreeType.toInt(sizeMetrics.getHeight());
        float f = data.ascent;
        if (this.e && data.lineHeight == 0.0f) {
            n2 = 32;
            while (n2 < 32 + this.a.getNumGlyphs()) {
                if (this.a.loadChar(n2, FreeType.FT_LOAD_DEFAULT)) {
                    n = FreeType.toInt(this.a.getGlyph().getMetrics().getHeight());
                    data.lineHeight = (float)n > data.lineHeight ? (float)n : data.lineHeight;
                }
                ++n2;
            }
        }
        data.spaceWidth = this.a.loadChar(32, FreeType.FT_LOAD_DEFAULT) || this.a.loadChar(108, FreeType.FT_LOAD_DEFAULT) ? (float)FreeType.toInt(this.a.getGlyph().getMetrics().getHoriAdvance()) : (float)this.a.getMaxAdvanceWidth();
        char[] cArray = data.xChars;
        int n4 = data.xChars.length;
        n = 0;
        while (n < n4) {
            n2 = cArray[n];
            if (this.a.loadChar(n2, FreeType.FT_LOAD_DEFAULT)) {
                data.xHeight = FreeType.toInt(this.a.getGlyph().getMetrics().getHeight());
                break;
            }
            ++n;
        }
        if (data.xHeight == 0.0f) {
            throw new GdxRuntimeException("No x-height character found in font");
        }
        cArray = data.capChars;
        n4 = data.capChars.length;
        n = 0;
        while (n < n4) {
            n2 = cArray[n];
            if (this.a.loadChar(n2, FreeType.FT_LOAD_DEFAULT)) {
                data.capHeight = FreeType.toInt(this.a.getGlyph().getMetrics().getHeight());
                break;
            }
            ++n;
        }
        if (!this.e && data.capHeight == 1.0f) {
            throw new GdxRuntimeException("No cap character found in font");
        }
        data.ascent -= data.capHeight;
        data.down = -data.lineHeight;
        if (parameter.flip) {
            data.ascent = -data.ascent;
            data.down = -data.down;
        }
        n2 = 0;
        PixmapPacker pixmapPacker = parameter.packer;
        if (pixmapPacker == null) {
            if (bl) {
                n4 = b;
            } else {
                int n5 = (int)Math.ceil(data.lineHeight);
                n4 = MathUtils.nextPowerOfTwo((int)Math.sqrt(n5 * n5 * n3));
                if (b > 0) {
                    n4 = Math.min(n4, b);
                }
            }
            n2 = 1;
            int n6 = n4;
            pixmapPacker = new PixmapPacker(n6, n6, Pixmap.Format.RGBA8888, 2, false);
        }
        FreeType.Stroker stroker = null;
        if (parameter.borderWidth > 0.0f) {
            stroker = this.c.createStroker();
            stroker.set((int)(parameter.borderWidth * 64.0f), parameter.borderStraight ? FreeType.FT_STROKER_LINECAP_BUTT : FreeType.FT_STROKER_LINECAP_ROUND, parameter.borderStraight ? FreeType.FT_STROKER_LINEJOIN_MITER_FIXED : FreeType.FT_STROKER_LINEJOIN_ROUND, 0);
        }
        if (bl) {
            data.b = this;
            data.c = parameter;
            data.d = stroker;
            data.e = pixmapPacker;
            data.f = new Array(n3 + 32);
        }
        int n7 = 0;
        while (n7 < n3) {
            c2 = string.charAt(n7);
            glyph2 = this.a(c2, data, parameter, stroker, f, pixmapPacker);
            if (glyph2 != null) {
                data.setGlyph(c2, glyph2);
                if (bl) {
                    data.f.add(glyph2);
                }
            }
            ++n7;
        }
        if (stroker != null && !bl) {
            stroker.dispose();
        }
        if (parameter.kerning) {
            n7 = 0;
            while (n7 < n3) {
                c2 = string.charAt(n7);
                glyph2 = data.getGlyph(c2);
                if (glyph2 != null) {
                    int n8 = this.a.getCharIndex(c2);
                    int n9 = n7;
                    while (n9 < n3) {
                        char c3 = string.charAt(n9);
                        BitmapFont.Glyph glyph3 = data.getGlyph(c3);
                        if (glyph3 != null) {
                            int n10 = this.a.getCharIndex(c3);
                            int n11 = this.a.getKerning(n8, n10, 0);
                            if (n11 != 0) {
                                glyph2.setKerning(c3, FreeType.toInt(n11));
                            }
                            if ((n11 = this.a.getKerning(n10, n8, 0)) != 0) {
                                glyph3.setKerning(c2, FreeType.toInt(n11));
                            }
                        }
                        ++n9;
                    }
                }
                ++n7;
            }
        }
        if (n2 != 0) {
            data.a = new Array();
            pixmapPacker.updateTextureRegions(data.a, parameter.minFilter, parameter.magFilter, parameter.genMipMaps);
        }
        if ((glyph = data.getGlyph(' ')) == null) {
            glyph = new BitmapFont.Glyph();
            new BitmapFont.Glyph().xadvance = (int)data.spaceWidth;
            glyph.id = 32;
            data.setGlyph(32, glyph);
        }
        if (glyph.width == 0) {
            glyph.width = (int)((float)glyph.xadvance + data.padRight);
        }
        return data;
    }

    final BitmapFont.Glyph a(char c2, FreeTypeBitmapFontData freeTypeBitmapFontData, FreeTypeFontParameter freeTypeFontParameter, FreeType.Stroker stroker, float f, PixmapPacker pixmapPacker) {
        int n;
        int n2;
        int n3;
        int n4;
        Pixmap pixmap;
        if (this.a.getCharIndex(c2) == 0) {
            return null;
        }
        if (!this.a.loadChar(c2, FreeType.FT_LOAD_DEFAULT)) {
            Gdx.app.log("FreeTypeFontGenerator", "Couldn't load char: ".concat(String.valueOf(c2)));
            return null;
        }
        FreeType.GlyphSlot glyphSlot = this.a.getGlyph();
        FreeType.Glyph glyph = glyphSlot.getGlyph();
        try {
            glyph.toBitmap(FreeType.FT_RENDER_MODE_NORMAL);
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            glyph.dispose();
            Gdx.app.log("FreeTypeFontGenerator", "Couldn't render char: ".concat(String.valueOf(c2)));
            return null;
        }
        FreeType.Bitmap bitmap = glyph.getBitmap();
        if (bitmap.getWidth() == 0 || bitmap.getRows() == 0) {
            return null;
        }
        Pixmap pixmap2 = bitmap.getPixmap(Pixmap.Format.RGBA8888, freeTypeFontParameter.color, freeTypeFontParameter.gamma);
        FreeType.Bitmap bitmap2 = bitmap;
        if (freeTypeFontParameter.borderWidth > 0.0f) {
            FreeType.Glyph glyph2 = glyphSlot.getGlyph();
            glyph2.strokeBorder(stroker, false);
            glyph2.toBitmap(FreeType.FT_RENDER_MODE_NORMAL);
            bitmap2 = glyph2.getBitmap();
            pixmap = bitmap2.getPixmap(Pixmap.Format.RGBA8888, freeTypeFontParameter.borderColor, freeTypeFontParameter.borderGamma);
            n4 = 0;
            n3 = freeTypeFontParameter.renderCount;
            while (n4 < n3) {
                pixmap.drawPixmap(pixmap2, glyph.getLeft() - glyph2.getLeft(), -(glyph.getTop() - glyph2.getTop()));
                ++n4;
            }
            pixmap2.dispose();
            glyph.dispose();
            pixmap2 = pixmap;
            glyph = glyph2;
        }
        if (freeTypeFontParameter.shadowOffsetX != 0 || freeTypeFontParameter.shadowOffsetY != 0) {
            float f2 = freeTypeFontParameter.shadowColor.a;
            freeTypeFontParameter.shadowColor.a = 1.0f;
            pixmap = bitmap2.getPixmap(Pixmap.Format.RGBA8888, freeTypeFontParameter.shadowColor, freeTypeFontParameter.shadowGamma);
            freeTypeFontParameter.shadowColor.a = f2;
            n4 = pixmap.getWidth() + Math.abs(freeTypeFontParameter.shadowOffsetX);
            n3 = pixmap.getHeight() + Math.abs(freeTypeFontParameter.shadowOffsetY);
            Pixmap pixmap3 = new Pixmap(n4, n3, Pixmap.Format.RGBA8888);
            Pixmap.Blending blending = Pixmap.getBlending();
            Pixmap.setBlending(Pixmap.Blending.None);
            pixmap3.drawPixmap(pixmap, Math.max(freeTypeFontParameter.shadowOffsetX, 0), Math.max(freeTypeFontParameter.shadowOffsetY, 0));
            Pixmap.setBlending(blending);
            int n5 = 0;
            n2 = freeTypeFontParameter.shadowRenderCount - 1;
            while (n5 < n2) {
                Pixmap pixmap4 = pixmap3;
                pixmap4.drawPixmap(pixmap4, 0, 0);
                ++n5;
            }
            ByteBuffer byteBuffer = pixmap3.getPixels();
            n2 = 0;
            n = n4 * 4;
            while (n2 < n3) {
                int n6 = n2 * n + 3;
                int n7 = n6 + n;
                while (n6 < n7) {
                    byteBuffer.put(n6, (byte)((float)(byteBuffer.get(n6) & 0xFF) * f2));
                    n6 += 4;
                }
                ++n2;
            }
            n2 = 0;
            n = freeTypeFontParameter.renderCount;
            while (n2 < n) {
                pixmap3.drawPixmap(pixmap2, Math.max(-freeTypeFontParameter.shadowOffsetX, 0), Math.max(-freeTypeFontParameter.shadowOffsetY, 0));
                ++n2;
            }
            pixmap2.dispose();
            pixmap2 = pixmap3;
        } else if (freeTypeFontParameter.borderWidth == 0.0f) {
            int n8 = 0;
            int n9 = freeTypeFontParameter.renderCount - 1;
            while (n8 < n9) {
                Pixmap pixmap5 = pixmap2;
                pixmap5.drawPixmap(pixmap5, 0, 0);
                ++n8;
            }
        }
        FreeType.GlyphMetrics glyphMetrics = glyphSlot.getMetrics();
        BitmapFont.Glyph glyph3 = new BitmapFont.Glyph();
        new BitmapFont.Glyph().id = c2;
        glyph3.width = pixmap2.getWidth();
        glyph3.height = pixmap2.getHeight();
        glyph3.xoffset = glyph.getLeft();
        glyph3.yoffset = freeTypeFontParameter.flip ? -glyph.getTop() + (int)f : -(glyph3.height - glyph.getTop()) - (int)f;
        glyph3.xadvance = FreeType.toInt(glyphMetrics.getHoriAdvance()) + (int)freeTypeFontParameter.borderWidth;
        if (this.e) {
            pixmap2.setColor(Color.CLEAR);
            pixmap2.fill();
            ByteBuffer byteBuffer = bitmap.getBuffer();
            n3 = Color.WHITE.toIntBits();
            int n10 = Color.CLEAR.toIntBits();
            int n11 = 0;
            while (n11 < glyph3.height) {
                int n12 = n11 * bitmap.getPitch();
                n2 = 0;
                while (n2 < glyph3.width + glyph3.xoffset) {
                    n = byteBuffer.get(n12 + n2 / 8) >>> 7 - n2 % 8 & 1;
                    pixmap2.drawPixel(n2, n11, n == 1 ? n3 : n10);
                    ++n2;
                }
                ++n11;
            }
        }
        Rectangle rectangle = pixmapPacker.pack(pixmap2);
        glyph3.page = pixmapPacker.getPages().size - 1;
        glyph3.srcX = (int)rectangle.x;
        glyph3.srcY = (int)rectangle.y;
        if (freeTypeFontParameter.incremental && freeTypeBitmapFontData.a != null && freeTypeBitmapFontData.a.size <= glyph3.page) {
            pixmapPacker.updateTextureRegions(freeTypeBitmapFontData.a, freeTypeFontParameter.minFilter, freeTypeFontParameter.magFilter, freeTypeFontParameter.genMipMaps);
        }
        pixmap2.dispose();
        glyph.dispose();
        return glyph3;
    }

    @Override
    public void dispose() {
        this.a.dispose();
        this.c.dispose();
    }

    public static void setMaxTextureSize(int texSize) {
        b = texSize;
    }

    public static int getMaxTextureSize() {
        return b;
    }

    @BA.Hide
    public static class FreeTypeBitmapFontData
    extends BitmapFont.BitmapFontData
    implements Disposable {
        Array<TextureRegion> a;
        FreeTypeFontGenerator b;
        FreeTypeFontParameter c;
        FreeType.Stroker d;
        PixmapPacker e;
        Array<BitmapFont.Glyph> f;
        private boolean g;

        @Override
        public BitmapFont.Glyph getGlyph(char ch) {
            BitmapFont.Glyph glyph = super.getGlyph(ch);
            if (glyph == null && this.b != null) {
                this.b.a(this.c.size);
                FreeTypeBitmapFontData freeTypeBitmapFontData = this;
                glyph = this.b.a(ch, freeTypeBitmapFontData, freeTypeBitmapFontData.c, this.d, (this.ascent + this.capHeight) / this.scaleY, this.e);
                if (glyph == null) {
                    return this.missingGlyph;
                }
                this.setGlyphRegion(glyph, this.a.get(glyph.page));
                this.setGlyph(ch, glyph);
                this.f.add(glyph);
                this.g = true;
                if (this.c.kerning) {
                    FreeType.Face face = this.b.a;
                    int n = face.getCharIndex(ch);
                    int n2 = 0;
                    int n3 = this.f.size;
                    while (n2 < n3) {
                        BitmapFont.Glyph glyph2 = this.f.get(n2);
                        int n4 = face.getCharIndex(glyph2.id);
                        int n5 = face.getKerning(n, n4, 0);
                        if (n5 != 0) {
                            glyph.setKerning(glyph2.id, FreeType.toInt(n5));
                        }
                        if ((n5 = face.getKerning(n4, n, 0)) != 0) {
                            glyph2.setKerning(ch, FreeType.toInt(n5));
                        }
                        ++n2;
                    }
                }
            }
            return glyph;
        }

        @Override
        public void getGlyphs(GlyphLayout.GlyphRun run, CharSequence str, int start, int end) {
            if (this.e != null) {
                this.e.setPackToTexture(true);
            }
            super.getGlyphs(run, str, start, end);
            if (this.g) {
                this.g = false;
                this.e.updateTextureRegions(this.a, this.c.minFilter, this.c.magFilter, this.c.genMipMaps);
            }
        }

        @Override
        public void dispose() {
            if (this.d != null) {
                this.d.dispose();
            }
            if (this.e != null) {
                this.e.dispose();
            }
        }
    }

    @BA.Hide
    public static class FreeTypeFontParameter {
        public int size = 16;
        public Color color = Color.WHITE;
        public float gamma = 1.8f;
        public int renderCount = 2;
        public float borderWidth = 0.0f;
        public Color borderColor = Color.BLACK;
        public boolean borderStraight = false;
        public float borderGamma = 1.8f;
        public int shadowOffsetX = 0;
        public int shadowOffsetY = 0;
        public int shadowRenderCount = 1;
        public Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.75f);
        public float shadowGamma = 1.8f;
        public String characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
        public boolean kerning = true;
        public PixmapPacker packer = null;
        public boolean flip = false;
        public boolean genMipMaps = false;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
        public boolean incremental;
    }

    @BA.Hide
    public class GlyphAndBitmap {
        public BitmapFont.Glyph glyph;
        public FreeType.Bitmap bitmap;
        private /* synthetic */ FreeTypeFontGenerator a;

        public GlyphAndBitmap(FreeTypeFontGenerator freeTypeFontGenerator) {
            this.a = freeTypeFontGenerator;
        }
    }
}

