/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.decals;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.decals.DecalMaterial;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;

@BA.Hide
public class Decal {
    public static final int SIZE = 24;
    private static Vector3 a = new Vector3();
    private static Vector3 b = new Vector3();
    public int value;
    protected float[] vertices = new float[24];
    protected Vector3 position = new Vector3();
    protected Quaternion rotation = new Quaternion();
    protected Vector2 scale = new Vector2(1.0f, 1.0f);
    protected Color color = new Color();
    public Vector2 transformationOffset = null;
    protected Vector2 dimensions = new Vector2();
    protected DecalMaterial material = new DecalMaterial();
    protected boolean updated = false;
    private static Vector3 c = new Vector3();
    public static final int X1 = 0;
    public static final int Y1 = 1;
    public static final int Z1 = 2;
    public static final int C1 = 3;
    public static final int U1 = 4;
    public static final int V1 = 5;
    public static final int X2 = 6;
    public static final int Y2 = 7;
    public static final int Z2 = 8;
    public static final int C2 = 9;
    public static final int U2 = 10;
    public static final int V2 = 11;
    public static final int X3 = 12;
    public static final int Y3 = 13;
    public static final int Z3 = 14;
    public static final int C3 = 15;
    public static final int U3 = 16;
    public static final int V3 = 17;
    public static final int X4 = 18;
    public static final int Y4 = 19;
    public static final int Z4 = 20;
    public static final int C4 = 21;
    public static final int U4 = 22;
    public static final int V4 = 23;
    protected static Quaternion rotator = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);

    public void setColor(float r, float g, float b2, float a2) {
        float f;
        this.color.set(r, g, b2, a2);
        this.vertices[3] = f = NumberUtils.intToFloatColor((int)(255.0f * a2) << 24 | (int)(255.0f * b2) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r));
        this.vertices[9] = f;
        this.vertices[15] = f;
        this.vertices[21] = f;
    }

    public void setColor(Color tint) {
        float f;
        this.color.set(tint);
        this.vertices[3] = f = tint.toFloatBits();
        this.vertices[9] = f;
        this.vertices[15] = f;
        this.vertices[21] = f;
    }

    public void setColor(float color) {
        this.color.set(NumberUtils.floatToIntColor(color));
        this.vertices[3] = color;
        this.vertices[9] = color;
        this.vertices[15] = color;
        this.vertices[21] = color;
    }

    public void setRotationX(float angle) {
        this.rotation.set(Vector3.X3, angle);
        this.updated = false;
    }

    public void setRotationY(float angle) {
        this.rotation.set(Vector3.Y3, angle);
        this.updated = false;
    }

    public void setRotationZ(float angle) {
        this.rotation.set(Vector3.Z3, angle);
        this.updated = false;
    }

    public void rotateX(float angle) {
        rotator.set(Vector3.X3, angle);
        this.rotation.mul(rotator);
        this.updated = false;
    }

    public void rotateY(float angle) {
        rotator.set(Vector3.Y3, angle);
        this.rotation.mul(rotator);
        this.updated = false;
    }

    public void rotateZ(float angle) {
        rotator.set(Vector3.Z3, angle);
        this.rotation.mul(rotator);
        this.updated = false;
    }

    public void setRotation(float yaw, float pitch, float roll) {
        this.rotation.setEulerAngles(yaw, pitch, roll);
        this.updated = false;
    }

    public void setRotation(Vector3 dir, Vector3 up) {
        a.set(up).crs(dir).nor();
        b.set(dir).crs(a).nor();
        this.rotation.setFromAxes(Decal.a.x, Decal.b.x, dir.x, Decal.a.y, Decal.b.y, dir.y, Decal.a.z, Decal.b.z, dir.z);
        this.updated = false;
    }

    public void setRotation(Quaternion q) {
        this.rotation.set(q);
        this.updated = false;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void translateX(float units) {
        this.position.x += units;
        this.updated = false;
    }

    public void setX(float x) {
        this.position.x = x;
        this.updated = false;
    }

    public float getX() {
        return this.position.x;
    }

    public void translateY(float units) {
        this.position.y += units;
        this.updated = false;
    }

    public void setY(float y) {
        this.position.y = y;
        this.updated = false;
    }

    public float getY() {
        return this.position.y;
    }

    public void translateZ(float units) {
        this.position.z += units;
        this.updated = false;
    }

    public void setZ(float z) {
        this.position.z = z;
        this.updated = false;
    }

    public float getZ() {
        return this.position.z;
    }

    public void translate(float x, float y, float z) {
        this.position.add(x, y, z);
        this.updated = false;
    }

    public void translate(Vector3 trans) {
        this.position.add(trans);
        this.updated = false;
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
        this.updated = false;
    }

    public void setPosition(Vector3 pos) {
        this.position.set(pos);
        this.updated = false;
    }

    public Color getColor() {
        return this.color;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public void setScaleX(float scale) {
        this.scale.x = scale;
        this.updated = false;
    }

    public float getScaleX() {
        return this.scale.x;
    }

    public void setScaleY(float scale) {
        this.scale.y = scale;
        this.updated = false;
    }

    public float getScaleY() {
        return this.scale.y;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scale.set(scaleX, scaleY);
        this.updated = false;
    }

    public void setScale(float scale) {
        float f = scale;
        this.scale.set(f, f);
        this.updated = false;
    }

    public void setWidth(float width) {
        this.dimensions.x = width;
        this.updated = false;
    }

    public float getWidth() {
        return this.dimensions.x;
    }

    public void setHeight(float height) {
        this.dimensions.y = height;
        this.updated = false;
    }

    public float getHeight() {
        return this.dimensions.y;
    }

    public void setDimensions(float width, float height) {
        this.dimensions.set(width, height);
        this.updated = false;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    protected void update() {
        if (!this.updated) {
            this.resetVertices();
            this.transformVertices();
        }
    }

    protected void transformVertices() {
        float f;
        float f2;
        if (this.transformationOffset != null) {
            f2 = -this.transformationOffset.x;
            f = -this.transformationOffset.y;
        } else {
            f = 0.0f;
            f2 = 0.0f;
        }
        float f3 = (this.vertices[0] + f2) * this.scale.x;
        float f4 = (this.vertices[1] + f) * this.scale.y;
        float f5 = this.vertices[2];
        this.vertices[0] = this.rotation.w * f3 + this.rotation.y * f5 - this.rotation.z * f4;
        this.vertices[1] = this.rotation.w * f4 + this.rotation.z * f3 - this.rotation.x * f5;
        this.vertices[2] = this.rotation.w * f5 + this.rotation.x * f4 - this.rotation.y * f3;
        float f6 = -this.rotation.x * f3 - this.rotation.y * f4 - this.rotation.z * f5;
        this.rotation.conjugate();
        f3 = this.vertices[0];
        f4 = this.vertices[1];
        f5 = this.vertices[2];
        this.vertices[0] = f6 * this.rotation.x + f3 * this.rotation.w + f4 * this.rotation.z - f5 * this.rotation.y;
        this.vertices[1] = f6 * this.rotation.y + f4 * this.rotation.w + f5 * this.rotation.x - f3 * this.rotation.z;
        this.vertices[2] = f6 * this.rotation.z + f5 * this.rotation.w + f3 * this.rotation.y - f4 * this.rotation.x;
        this.rotation.conjugate();
        this.vertices[0] = this.vertices[0] + (this.position.x - f2);
        this.vertices[1] = this.vertices[1] + (this.position.y - f);
        this.vertices[2] = this.vertices[2] + this.position.z;
        f3 = (this.vertices[6] + f2) * this.scale.x;
        f4 = (this.vertices[7] + f) * this.scale.y;
        f5 = this.vertices[8];
        this.vertices[6] = this.rotation.w * f3 + this.rotation.y * f5 - this.rotation.z * f4;
        this.vertices[7] = this.rotation.w * f4 + this.rotation.z * f3 - this.rotation.x * f5;
        this.vertices[8] = this.rotation.w * f5 + this.rotation.x * f4 - this.rotation.y * f3;
        f6 = -this.rotation.x * f3 - this.rotation.y * f4 - this.rotation.z * f5;
        this.rotation.conjugate();
        f3 = this.vertices[6];
        f4 = this.vertices[7];
        f5 = this.vertices[8];
        this.vertices[6] = f6 * this.rotation.x + f3 * this.rotation.w + f4 * this.rotation.z - f5 * this.rotation.y;
        this.vertices[7] = f6 * this.rotation.y + f4 * this.rotation.w + f5 * this.rotation.x - f3 * this.rotation.z;
        this.vertices[8] = f6 * this.rotation.z + f5 * this.rotation.w + f3 * this.rotation.y - f4 * this.rotation.x;
        this.rotation.conjugate();
        this.vertices[6] = this.vertices[6] + (this.position.x - f2);
        this.vertices[7] = this.vertices[7] + (this.position.y - f);
        this.vertices[8] = this.vertices[8] + this.position.z;
        f3 = (this.vertices[12] + f2) * this.scale.x;
        f4 = (this.vertices[13] + f) * this.scale.y;
        f5 = this.vertices[14];
        this.vertices[12] = this.rotation.w * f3 + this.rotation.y * f5 - this.rotation.z * f4;
        this.vertices[13] = this.rotation.w * f4 + this.rotation.z * f3 - this.rotation.x * f5;
        this.vertices[14] = this.rotation.w * f5 + this.rotation.x * f4 - this.rotation.y * f3;
        f6 = -this.rotation.x * f3 - this.rotation.y * f4 - this.rotation.z * f5;
        this.rotation.conjugate();
        f3 = this.vertices[12];
        f4 = this.vertices[13];
        f5 = this.vertices[14];
        this.vertices[12] = f6 * this.rotation.x + f3 * this.rotation.w + f4 * this.rotation.z - f5 * this.rotation.y;
        this.vertices[13] = f6 * this.rotation.y + f4 * this.rotation.w + f5 * this.rotation.x - f3 * this.rotation.z;
        this.vertices[14] = f6 * this.rotation.z + f5 * this.rotation.w + f3 * this.rotation.y - f4 * this.rotation.x;
        this.rotation.conjugate();
        this.vertices[12] = this.vertices[12] + (this.position.x - f2);
        this.vertices[13] = this.vertices[13] + (this.position.y - f);
        this.vertices[14] = this.vertices[14] + this.position.z;
        f3 = (this.vertices[18] + f2) * this.scale.x;
        f4 = (this.vertices[19] + f) * this.scale.y;
        f5 = this.vertices[20];
        this.vertices[18] = this.rotation.w * f3 + this.rotation.y * f5 - this.rotation.z * f4;
        this.vertices[19] = this.rotation.w * f4 + this.rotation.z * f3 - this.rotation.x * f5;
        this.vertices[20] = this.rotation.w * f5 + this.rotation.x * f4 - this.rotation.y * f3;
        f6 = -this.rotation.x * f3 - this.rotation.y * f4 - this.rotation.z * f5;
        this.rotation.conjugate();
        f3 = this.vertices[18];
        f4 = this.vertices[19];
        f5 = this.vertices[20];
        this.vertices[18] = f6 * this.rotation.x + f3 * this.rotation.w + f4 * this.rotation.z - f5 * this.rotation.y;
        this.vertices[19] = f6 * this.rotation.y + f4 * this.rotation.w + f5 * this.rotation.x - f3 * this.rotation.z;
        this.vertices[20] = f6 * this.rotation.z + f5 * this.rotation.w + f3 * this.rotation.y - f4 * this.rotation.x;
        this.rotation.conjugate();
        this.vertices[18] = this.vertices[18] + (this.position.x - f2);
        this.vertices[19] = this.vertices[19] + (this.position.y - f);
        this.vertices[20] = this.vertices[20] + this.position.z;
        this.updated = true;
    }

    protected void resetVertices() {
        float f = -this.dimensions.x / 2.0f;
        float f2 = f + this.dimensions.x;
        float f3 = this.dimensions.y / 2.0f;
        float f4 = f3 - this.dimensions.y;
        this.vertices[0] = f;
        this.vertices[1] = f3;
        this.vertices[2] = 0.0f;
        this.vertices[6] = f2;
        this.vertices[7] = f3;
        this.vertices[8] = 0.0f;
        this.vertices[12] = f;
        this.vertices[13] = f4;
        this.vertices[14] = 0.0f;
        this.vertices[18] = f2;
        this.vertices[19] = f4;
        this.vertices[20] = 0.0f;
        this.updated = false;
    }

    protected void updateUVs() {
        TextureRegion textureRegion = this.material.textureRegion;
        this.vertices[4] = textureRegion.getU();
        this.vertices[5] = textureRegion.getV();
        this.vertices[10] = textureRegion.getU2();
        this.vertices[11] = textureRegion.getV();
        this.vertices[16] = textureRegion.getU();
        this.vertices[17] = textureRegion.getV2();
        this.vertices[22] = textureRegion.getU2();
        this.vertices[23] = textureRegion.getV2();
    }

    public void setTextureRegion(TextureRegion textureRegion) {
        this.material.textureRegion = textureRegion;
        this.updateUVs();
    }

    public TextureRegion getTextureRegion() {
        return this.material.textureRegion;
    }

    public void setBlending(int srcBlendFactor, int dstBlendFactor) {
        this.material.srcBlendFactor = srcBlendFactor;
        this.material.dstBlendFactor = dstBlendFactor;
    }

    public DecalMaterial getMaterial() {
        return this.material;
    }

    public void lookAt(Vector3 position, Vector3 up) {
        c.set(position).sub(this.position).nor();
        this.setRotation(c, up);
    }

    public static Decal newDecal(TextureRegion textureRegion) {
        return Decal.newDecal(textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), textureRegion, -1, -1);
    }

    public static Decal newDecal(TextureRegion textureRegion, boolean hasTransparency) {
        return Decal.newDecal(textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), textureRegion, hasTransparency ? 770 : -1, hasTransparency ? 771 : -1);
    }

    public static Decal newDecal(float width, float height, TextureRegion textureRegion) {
        return Decal.newDecal(width, height, textureRegion, -1, -1);
    }

    public static Decal newDecal(float width, float height, TextureRegion textureRegion, boolean hasTransparency) {
        return Decal.newDecal(width, height, textureRegion, hasTransparency ? 770 : -1, hasTransparency ? 771 : -1);
    }

    public static Decal newDecal(float width, float height, TextureRegion textureRegion, int srcBlendFactor, int dstBlendFactor) {
        Decal decal = new Decal();
        decal.setTextureRegion(textureRegion);
        decal.setBlending(srcBlendFactor, dstBlendFactor);
        decal.dimensions.x = width;
        decal.dimensions.y = height;
        decal.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        return decal;
    }
}

