/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.decals;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.DecalMaterial;
import com.badlogic.gdx.graphics.g3d.decals.GroupStrategy;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SortedIntList;

@BA.Hide
public class DecalBatch
implements Disposable {
    private float[] a;
    private Mesh b;
    private final SortedIntList<Array<Decal>> c = new SortedIntList();
    private GroupStrategy d;
    private final Pool<Array<Decal>> e = new Pool<Array<Decal>>(this){
        private /* synthetic */ DecalBatch a;
        {
            this.a = decalBatch;
            super(16);
        }

        @Override
        public final /* synthetic */ Object newObject() {
            return new Array(false, 100);
        }
    };
    private final Array<Array<Decal>> f = new Array(16);

    public DecalBatch(GroupStrategy groupStrategy) {
        this(1000, groupStrategy);
    }

    public DecalBatch(int size, GroupStrategy groupStrategy) {
        this.initialize(size);
        this.setGroupStrategy(groupStrategy);
    }

    public void setGroupStrategy(GroupStrategy groupStrategy) {
        this.d = groupStrategy;
    }

    public void initialize(int size) {
        this.a = new float[size * 24];
        this.b = new Mesh(Mesh.VertexDataType.VertexArray, false, size * 4, size * 6, new VertexAttribute(1, 3, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        short[] sArray = new short[size * 6];
        int n = 0;
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = (short)n;
            sArray[n2 + 1] = (short)(n + 2);
            sArray[n2 + 2] = (short)(n + 1);
            sArray[n2 + 3] = (short)(n + 1);
            sArray[n2 + 4] = (short)(n + 2);
            sArray[n2 + 5] = (short)(n + 3);
            n2 += 6;
            n += 4;
        }
        this.b.setIndices(sArray);
    }

    public int getSize() {
        return this.a.length / 24;
    }

    public void add(Decal decal) {
        int n = this.d.decideGroup(decal);
        Array<Decal> array = this.c.get(n);
        if (array == null) {
            array = this.e.obtain();
            array.clear();
            this.f.add(array);
            this.c.insert(n, array);
        }
        array.add(decal);
    }

    public void flush() {
        this.render();
        this.clear();
    }

    protected void render() {
        this.d.beforeGroups();
        for (SortedIntList.Node<Array<Decal>> node : this.c) {
            this.d.beforeGroup(node.index, (Array)node.value);
            ShaderProgram shaderProgram = this.d.getGroupShader(node.index);
            Array array = (Array)node.value;
            ShaderProgram shaderProgram2 = shaderProgram;
            DecalBatch decalBatch = this;
            DecalMaterial decalMaterial = null;
            int n = 0;
            for (Decal decal : array) {
                if (decalMaterial == null || !decalMaterial.equals(decal.getMaterial())) {
                    if (n > 0) {
                        decalBatch.flush(shaderProgram2, n);
                        n = 0;
                    }
                    decal.material.set();
                    decalMaterial = decal.material;
                }
                decal.update();
                System.arraycopy(decal.vertices, 0, decalBatch.a, n, decal.vertices.length);
                if ((n += decal.vertices.length) != decalBatch.a.length) continue;
                decalBatch.flush(shaderProgram2, n);
                n = 0;
            }
            if (n > 0) {
                decalBatch.flush(shaderProgram2, n);
            }
            this.d.afterGroup(node.index);
        }
        this.d.afterGroups();
    }

    protected void flush(ShaderProgram shader, int verticesPosition) {
        this.b.setVertices(this.a, 0, verticesPosition);
        this.b.render(shader, 4, 0, verticesPosition / 4);
    }

    protected void clear() {
        this.c.clear();
        this.e.freeAll(this.f);
        this.f.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        this.a = null;
        this.b.dispose();
    }
}

