/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.decals;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

@BA.Hide
public class DecalMaterial {
    public static final int NO_BLEND = -1;
    protected TextureRegion textureRegion;
    protected int srcBlendFactor;
    protected int dstBlendFactor;

    public void set() {
        this.textureRegion.getTexture().bind();
        if (!this.isOpaque()) {
            Gdx.gl.glBlendFunc(this.srcBlendFactor, this.dstBlendFactor);
        }
    }

    public boolean isOpaque() {
        return this.srcBlendFactor == -1;
    }

    public int getSrcBlendFactor() {
        return this.srcBlendFactor;
    }

    public int getDstBlendFactor() {
        return this.dstBlendFactor;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        DecalMaterial decalMaterial = (DecalMaterial)o;
        return this.dstBlendFactor == decalMaterial.dstBlendFactor && this.srcBlendFactor == decalMaterial.srcBlendFactor && this.textureRegion.getTexture() == decalMaterial.textureRegion.getTexture();
    }

    public int hashCode() {
        int n = this.textureRegion.getTexture() != null ? this.textureRegion.getTexture().hashCode() : 0;
        n = 31 * n + this.srcBlendFactor;
        return 31 * n + this.dstBlendFactor;
    }
}

