/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@BA.Hide
public class ETC1 {
    public static int PKM_HEADER_SIZE = 16;
    @BA.Hide
    public static int ETC1_RGB8_OES = 36196;

    private static int a(Pixmap.Format format) {
        if (format == Pixmap.Format.RGB565) {
            return 2;
        }
        if (format == Pixmap.Format.RGB888) {
            return 3;
        }
        throw new GdxRuntimeException("Can only handle RGB565 or RGB888 images");
    }

    public static ETC1Data encodeImage(Pixmap pixmap) {
        int n = ETC1.a(pixmap.getFormat());
        ByteBuffer byteBuffer = ETC1.encodeImage(pixmap.getPixels(), 0, pixmap.getWidth(), pixmap.getHeight(), n);
        BufferUtils.newUnsafeByteBuffer(byteBuffer);
        return new ETC1Data(pixmap.getWidth(), pixmap.getHeight(), byteBuffer, 0);
    }

    public static ETC1Data encodeImagePKM(Pixmap pixmap) {
        int n = ETC1.a(pixmap.getFormat());
        ByteBuffer byteBuffer = ETC1.encodeImagePKM(pixmap.getPixels(), 0, pixmap.getWidth(), pixmap.getHeight(), n);
        BufferUtils.newUnsafeByteBuffer(byteBuffer);
        return new ETC1Data(pixmap.getWidth(), pixmap.getHeight(), byteBuffer, 16);
    }

    @BA.Hide
    public static Pixmap decodeImage(ETC1Data etc1Data, Pixmap.Format format) {
        int height;
        int width;
        int dataOffset;
        if (etc1Data.hasPKMHeader()) {
            dataOffset = 16;
            width = ETC1.getWidthPKM(etc1Data.compressedData, 0);
            height = ETC1.getHeightPKM(etc1Data.compressedData, 0);
        } else {
            dataOffset = 0;
            width = etc1Data.width;
            height = etc1Data.height;
        }
        int n = ETC1.a(format);
        Pixmap pixmap = new Pixmap(width, height, format);
        ETC1.decodeImage(etc1Data.compressedData, dataOffset, pixmap.getPixels(), 0, width, height, n);
        return pixmap;
    }

    public static native int getCompressedDataSize(int var0, int var1);

    @BA.Hide
    public static native void formatHeader(ByteBuffer var0, int var1, int var2, int var3);

    static native int getWidthPKM(ByteBuffer var0, int var1);

    static native int getHeightPKM(ByteBuffer var0, int var1);

    static native boolean isValidPKM(ByteBuffer var0, int var1);

    private static native void decodeImage(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4, int var5, int var6);

    private static native ByteBuffer encodeImage(ByteBuffer var0, int var1, int var2, int var3, int var4);

    private static native ByteBuffer encodeImagePKM(ByteBuffer var0, int var1, int var2, int var3, int var4);

    @BA.Hide
    public static final class ETC1Data
    implements Disposable {
        public final int width;
        public final int height;
        @BA.Hide
        public final ByteBuffer compressedData;
        public final int dataOffset;

        public ETC1Data(int width, int height, ByteBuffer compressedData, int dataOffset) {
            this.width = width;
            this.height = height;
            this.compressedData = compressedData;
            this.dataOffset = dataOffset;
            this.a();
        }

        public ETC1Data(FileHandle pkmFile) {
            byte[] byArray = new byte[10240];
            DataInputStream dataInputStream = null;
            try {
                try {
                    int n;
                    dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(pkmFile.read())));
                    int n2 = dataInputStream.readInt();
                    this.compressedData = BufferUtils.newUnsafeByteBuffer(n2);
                    while ((n = dataInputStream.read(byArray)) != -1) {
                        this.compressedData.put(byArray, 0, n);
                    }
                    this.compressedData.position(0);
                    this.compressedData.limit(this.compressedData.capacity());
                }
                catch (Exception exception) {
                    throw new GdxRuntimeException("Couldn't load pkm file '" + pkmFile + "'", exception);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(dataInputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(dataInputStream);
            this.width = ETC1.getWidthPKM(this.compressedData, 0);
            this.height = ETC1.getHeightPKM(this.compressedData, 0);
            this.dataOffset = PKM_HEADER_SIZE;
            this.compressedData.position(this.dataOffset);
            this.a();
        }

        private void a() {
            if (!MathUtils.isPowerOfTwo(this.width) || !MathUtils.isPowerOfTwo(this.height)) {
                Gdx.app.debug("ETC1Data", "warning: non-power-of-two ETC1 textures may crash the driver of PowerVR GPUs");
            }
        }

        public final boolean hasPKMHeader() {
            return this.dataOffset == 16;
        }

        public final void write(FileHandle file) {
            DataOutputStream dataOutputStream = null;
            byte[] byArray = new byte[10240];
            int n = 0;
            this.compressedData.position(0);
            this.compressedData.limit(this.compressedData.capacity());
            try {
                try {
                    dataOutputStream = new DataOutputStream(new GZIPOutputStream(file.write(false)));
                    dataOutputStream.writeInt(this.compressedData.capacity());
                    while (n != this.compressedData.capacity()) {
                        int n2 = Math.min(this.compressedData.remaining(), 10240);
                        this.compressedData.get(byArray, 0, n2);
                        dataOutputStream.write(byArray, 0, n2);
                        n += n2;
                    }
                }
                catch (Exception exception) {
                    throw new GdxRuntimeException("Couldn't write PKM file to '" + file + "'", exception);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(dataOutputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(dataOutputStream);
            this.compressedData.position(this.dataOffset);
            this.compressedData.limit(this.compressedData.capacity());
        }

        @Override
        public final void dispose() {
            BufferUtils.disposeUnsafeByteBuffer(this.compressedData);
        }

        public final String toString() {
            if (this.hasPKMHeader()) {
                return String.valueOf(ETC1.isValidPKM(this.compressedData, 0) ? "valid" : "invalid") + " pkm [" + ETC1.getWidthPKM(this.compressedData, 0) + "x" + ETC1.getHeightPKM(this.compressedData, 0) + "], compressed: " + (this.compressedData.capacity() - PKM_HEADER_SIZE);
            }
            return "raw [" + this.width + "x" + this.height + "], compressed: " + (this.compressedData.capacity() - PKM_HEADER_SIZE);
        }
    }
}

