/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import java.util.HashMap;
import java.util.Map;

@BA.Hide
public class GLFrameBuffer
implements Disposable {
    private static final Map<Application, Array<GLFrameBuffer>> a = new HashMap<Application, Array<GLFrameBuffer>>();
    protected Texture colorTexture;
    private int b;
    private int c;
    protected final int width;
    protected final int height;
    protected final boolean hasDepth;
    protected final Pixmap.Format format;

    public GLFrameBuffer(Pixmap.Format format, int width, int height, boolean hasDepth) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.hasDepth = hasDepth;
        this.a();
        GLFrameBuffer gLFrameBuffer = this;
        Application application = Gdx.app;
        Array<GLFrameBuffer> array = a.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(gLFrameBuffer);
        a.put(application, array);
    }

    protected void createColorTexture() {
        this.colorTexture = new Texture(this.width, this.height, this.format);
        Texture.TextureFilter textureFilter = Texture.TextureFilter.Linear;
        this.colorTexture.setFilter(textureFilter, textureFilter);
        Texture.TextureWrap textureWrap = Texture.TextureWrap.ClampToEdge;
        this.colorTexture.setWrap(textureWrap, textureWrap);
    }

    protected void disposeColorTexture() {
        this.colorTexture.dispose();
    }

    private void a() {
        GL20 gL20 = Gdx.gl20;
        this.createColorTexture();
        this.b = gL20.glGenFramebuffer();
        if (this.hasDepth) {
            this.c = gL20.glGenRenderbuffer();
        }
        gL20.glBindTexture(3553, this.colorTexture.getTextureObjectHandle());
        if (this.hasDepth) {
            gL20.glBindRenderbuffer(36161, this.c);
            gL20.glRenderbufferStorage(36161, 33189, this.colorTexture.getWidth(), this.colorTexture.getHeight());
        }
        gL20.glBindFramebuffer(36160, this.b);
        gL20.glFramebufferTexture2D(36160, 36064, 3553, this.colorTexture.getTextureObjectHandle(), 0);
        if (this.hasDepth) {
            gL20.glFramebufferRenderbuffer(36160, 36096, 36161, this.c);
        }
        gL20.glBindRenderbuffer(36161, 0);
        gL20.glBindTexture(3553, 0);
        int n = gL20.glCheckFramebufferStatus(36160);
        gL20.glBindFramebuffer(36160, 0);
        if (n != 36053) {
            this.disposeColorTexture();
            if (this.hasDepth) {
                gL20.glDeleteRenderbuffer(this.c);
            }
            gL20.glDeleteFramebuffer(this.b);
            if (n == 36054) {
                throw new IllegalStateException("frame buffer couldn't be constructed: incomplete attachment");
            }
            if (n == 36057) {
                throw new IllegalStateException("frame buffer couldn't be constructed: incomplete dimensions");
            }
            if (n == 36055) {
                throw new IllegalStateException("frame buffer couldn't be constructed: missing attachment");
            }
            if (n == 36061) {
                throw new IllegalStateException("frame buffer couldn't be constructed: unsupported combination of formats");
            }
            throw new IllegalStateException("frame buffer couldn't be constructed: unknown error ".concat(String.valueOf(n)));
        }
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        this.disposeColorTexture();
        if (this.hasDepth) {
            gL20.glDeleteRenderbuffer(this.c);
        }
        gL20.glDeleteFramebuffer(this.b);
        if (a.get(Gdx.app) != null) {
            a.get(Gdx.app).removeValue(this, true);
        }
    }

    public void bind() {
        Gdx.gl20.glBindFramebuffer(36160, this.b);
    }

    public static void unbind() {
        Gdx.gl20.glBindFramebuffer(36160, 0);
    }

    public void begin() {
        this.bind();
        this.setFrameBufferViewport();
    }

    protected void setFrameBufferViewport() {
        Gdx.gl20.glViewport(0, 0, this.colorTexture.getWidth(), this.colorTexture.getHeight());
    }

    public void end() {
        this.end(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
    }

    public void end(int x, int y, int width, int height) {
        GLFrameBuffer.unbind();
        Gdx.gl20.glViewport(x, y, width, height);
    }

    public Texture getColorBufferTexture() {
        return this.colorTexture;
    }

    public int getHeight() {
        return this.colorTexture.getHeight();
    }

    public int getWidth() {
        return this.colorTexture.getWidth();
    }

    public static void invalidateAllFrameBuffers(Application app) {
        if (Gdx.gl20 == null) {
            return;
        }
        Array<GLFrameBuffer> array = a.get(app);
        if (array == null) {
            return;
        }
        int n = 0;
        while (n < array.size) {
            array.get(n).a();
            ++n;
        }
    }

    public static void clearAllFrameBuffers(Application app) {
        a.remove(app);
    }

    public static StringBuilder getManagedStatus(StringBuilder builder) {
        builder.append("Managed buffers/app: { ");
        for (Application application : a.keySet()) {
            builder.append(GLFrameBuffer.a.get((Object)application).size);
            builder.append(" ");
        }
        builder.append("}");
        return builder;
    }

    public static String getManagedStatus() {
        return GLFrameBuffer.getManagedStatus(new StringBuilder()).toString();
    }
}

