/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;

@BA.Hide
public class ImmediateModeRenderer20
implements ImmediateModeRenderer {
    private int a;
    private int b;
    private int c;
    private final int d;
    private int e;
    private final Mesh f;
    private ShaderProgram g;
    private boolean h;
    private final int i;
    private final int j;
    private final int k;
    private final int l;
    private final int m;
    private final Matrix4 n = new Matrix4();
    private final float[] o;
    private final String[] p;

    public ImmediateModeRenderer20(boolean hasNormals, boolean hasColors, int numTexCoords) {
        this(5000, hasNormals, hasColors, numTexCoords, ImmediateModeRenderer20.createDefaultShader(hasNormals, hasColors, numTexCoords));
        this.h = true;
    }

    public ImmediateModeRenderer20(int maxVertices, boolean hasNormals, boolean hasColors, int numTexCoords) {
        this(maxVertices, hasNormals, hasColors, numTexCoords, ImmediateModeRenderer20.createDefaultShader(hasNormals, hasColors, numTexCoords));
        this.h = true;
    }

    public ImmediateModeRenderer20(int maxVertices, boolean hasNormals, boolean hasColors, int numTexCoords, ShaderProgram shader) {
        this.d = maxVertices;
        this.i = numTexCoords;
        this.g = shader;
        VertexAttribute[] vertexAttributeArray = ImmediateModeRenderer20.a(hasNormals, hasColors, numTexCoords);
        this.f = new Mesh(false, maxVertices, 0, vertexAttributeArray);
        this.o = new float[maxVertices * (this.f.getVertexAttributes().vertexSize / 4)];
        this.j = this.f.getVertexAttributes().vertexSize / 4;
        this.k = this.f.getVertexAttribute(8) != null ? this.f.getVertexAttribute((int)8).offset / 4 : 0;
        this.l = this.f.getVertexAttribute(4) != null ? this.f.getVertexAttribute((int)4).offset / 4 : 0;
        this.m = this.f.getVertexAttribute(16) != null ? this.f.getVertexAttribute((int)16).offset / 4 : 0;
        this.p = new String[numTexCoords];
        int n = 0;
        while (n < numTexCoords) {
            this.p[n] = "u_sampler".concat(String.valueOf(n));
            ++n;
        }
    }

    private static VertexAttribute[] a(boolean bl, boolean bl2, int n) {
        Array<VertexAttribute> array = new Array<VertexAttribute>();
        array.add(new VertexAttribute(1, 3, "a_position"));
        if (bl) {
            array.add(new VertexAttribute(8, 3, "a_normal"));
        }
        if (bl2) {
            array.add(new VertexAttribute(4, 4, "a_color"));
        }
        int n2 = 0;
        while (n2 < n) {
            array.add(new VertexAttribute(16, 2, "a_texCoord".concat(String.valueOf(n2))));
            ++n2;
        }
        VertexAttribute[] vertexAttributeArray = new VertexAttribute[array.size];
        int n3 = 0;
        while (n3 < array.size) {
            vertexAttributeArray[n3] = (VertexAttribute)array.get(n3);
            ++n3;
        }
        return vertexAttributeArray;
    }

    public void setShader(ShaderProgram shader) {
        if (this.h) {
            this.g.dispose();
        }
        this.g = shader;
        this.h = false;
    }

    @Override
    public void begin(Matrix4 projModelView, int primitiveType) {
        this.n.set(projModelView);
        this.a = primitiveType;
    }

    @Override
    public void color(Color color) {
        this.o[this.b + this.l] = color.toFloatBits();
    }

    @Override
    public void color(float r, float g, float b2, float a2) {
        this.o[this.b + this.l] = Color.toFloatBits(r, g, b2, a2);
    }

    @Override
    public void color(float colorBits) {
        this.o[this.b + this.l] = colorBits;
    }

    @Override
    public void texCoord(float u, float v) {
        int n = this.b + this.m;
        this.o[n + this.c] = u;
        this.o[n + this.c + 1] = v;
        this.c += 2;
    }

    @Override
    public void normal(float x, float y, float z) {
        int n = this.b + this.k;
        this.o[n] = x;
        this.o[n + 1] = y;
        this.o[n + 2] = z;
    }

    @Override
    public void vertex(float x, float y, float z) {
        int n = this.b;
        this.o[n] = x;
        this.o[n + 1] = y;
        this.o[n + 2] = z;
        this.c = 0;
        this.b += this.j;
        ++this.e;
    }

    @Override
    public void flush() {
        if (this.e == 0) {
            return;
        }
        this.g.begin();
        this.g.setUniformMatrix("u_projModelView", this.n);
        int n = 0;
        while (n < this.i) {
            this.g.setUniformi(this.p[n], n);
            ++n;
        }
        this.f.setVertices(this.o, 0, this.b);
        this.f.render(this.g, this.a);
        this.g.end();
        this.c = 0;
        this.b = 0;
        this.e = 0;
    }

    @Override
    public void end() {
        this.flush();
    }

    @Override
    public int getNumVertices() {
        return this.e;
    }

    @Override
    public int getMaxVertices() {
        return this.d;
    }

    @Override
    public void dispose() {
        if (this.h && this.g != null) {
            this.g.dispose();
        }
        this.f.dispose();
    }

    private static String a(boolean bl, int n) {
        String string = "#ifdef GL_ES\nprecision mediump float;\n#endif\n";
        if (bl) {
            string = String.valueOf(string) + "varying vec4 v_col;\n";
        }
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "varying vec2 v_tex" + n2 + ";\n";
            string = String.valueOf(string) + "uniform sampler2D u_sampler" + n2 + ";\n";
            ++n2;
        }
        string = String.valueOf(string) + "void main() {\n   gl_FragColor = " + (bl ? "v_col" : "vec4(1, 1, 1, 1)");
        if (n > 0) {
            string = String.valueOf(string) + " * ";
        }
        n2 = 0;
        while (n2 < n) {
            string = n2 == n - 1 ? String.valueOf(string) + " texture2D(u_sampler" + n2 + ",  v_tex" + n2 + ")" : String.valueOf(string) + " texture2D(u_sampler" + n2 + ",  v_tex" + n2 + ") *";
            ++n2;
        }
        return String.valueOf(string) + ";\n}";
    }

    public static ShaderProgram createDefaultShader(boolean hasNormals, boolean hasColors, int numTexCoords) {
        String string = "attribute vec4 a_position;\n" + (hasNormals ? "attribute vec3 a_normal;\n" : "") + (hasColors ? "attribute vec4 a_color;\n" : "");
        int n = 0;
        while (n < numTexCoords) {
            string = String.valueOf(string) + "attribute vec2 a_texCoord" + n + ";\n";
            ++n;
        }
        string = String.valueOf(string) + "uniform mat4 u_projModelView;\n";
        string = String.valueOf(string) + (hasColors ? "varying vec4 v_col;\n" : "");
        n = 0;
        while (n < numTexCoords) {
            string = String.valueOf(string) + "varying vec2 v_tex" + n + ";\n";
            ++n;
        }
        string = String.valueOf(string) + "void main() {\n   gl_Position = u_projModelView * a_position;\n" + (hasColors ? "   v_col = a_color;\n" : "");
        n = 0;
        while (n < numTexCoords) {
            string = String.valueOf(string) + "   v_tex" + n + " = a_texCoord" + n + ";\n";
            ++n;
        }
        string = String.valueOf(string) + "   gl_PointSize = 1.0;\n";
        String string2 = String.valueOf(string) + "}\n";
        String string3 = ImmediateModeRenderer20.a(hasColors, numTexCoords);
        return new ShaderProgram(string2, string3);
    }
}

