/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

@BA.Hide
public class IndexArray
implements IndexData {
    private ShortBuffer a;
    private ByteBuffer b;
    private final boolean c;

    static {
        BufferUtils.newIntBuffer(1);
    }

    public IndexArray(int maxIndices) {
        boolean bl = this.c = maxIndices == 0;
        if (this.c) {
            maxIndices = 1;
        }
        this.b = BufferUtils.newUnsafeByteBuffer(maxIndices * 2);
        this.a = this.b.asShortBuffer();
        this.a.flip();
        this.b.flip();
    }

    @Override
    public int getNumIndices() {
        if (this.c) {
            return 0;
        }
        return this.a.limit();
    }

    @Override
    public int getNumMaxIndices() {
        if (this.c) {
            return 0;
        }
        return this.a.capacity();
    }

    @Override
    public void setIndices(short[] indices, int offset, int count) {
        this.a.clear();
        this.a.put(indices, offset, count);
        this.a.flip();
        this.b.position(0);
        this.b.limit(count << 1);
    }

    @Override
    public void setIndices(ShortBuffer indices) {
        int n = indices.position();
        this.a.clear();
        this.a.limit(indices.remaining());
        this.a.put(indices);
        this.a.flip();
        indices.position(n);
        this.b.position(0);
        this.b.limit(this.a.limit() << 1);
    }

    @Override
    public ShortBuffer getBuffer() {
        return this.a;
    }

    @Override
    public void bind() {
    }

    @Override
    public void unbind() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void dispose() {
        BufferUtils.disposeUnsafeByteBuffer(this.b);
    }
}

