/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgPixmap;
import anywheresoftware.b4a.libgdx.graphics.lgTextureData;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.ETC1;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.zip.GZIPInputStream;

@BA.ShortName(value="lgKTXTextureData")
public class KTXTextureData
extends lgTextureData {
    private FileHandle a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g = -1;
    private int h = -1;
    private int i = -1;
    private int j;
    private int k;
    private int l;
    private int m;
    private ByteBuffer n;
    private boolean o;

    public KTXTextureData() {
    }

    public void Initialize(FileHandle File2, boolean UseMipMaps) {
        this.a = File2;
        this.o = UseMipMaps;
    }

    public KTXTextureData(FileHandle file, boolean genMipMaps) {
        this.a = file;
        this.o = genMipMaps;
    }

    @Override
    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Custom;
    }

    @Override
    public boolean isPrepared() {
        return this.n != null;
    }

    @Override
    public void prepare() {
        int n;
        int n2;
        if (this.n != null) {
            throw new GdxRuntimeException("Already prepared");
        }
        if (this.a == null) {
            throw new GdxRuntimeException("Need a file to load from");
        }
        if (this.a.name().endsWith(".zktx")) {
            byte[] byArray = new byte[10240];
            DataInputStream dataInputStream = null;
            try {
                try {
                    dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(this.a.read())));
                    n2 = dataInputStream.readInt();
                    this.n = BufferUtils.newUnsafeByteBuffer(n2);
                    while ((n = dataInputStream.read(byArray)) != -1) {
                        this.n.put(byArray, 0, n);
                    }
                    this.n.position(0);
                    this.n.limit(this.n.capacity());
                }
                catch (Exception exception) {
                    throw new GdxRuntimeException("Couldn't load zktx file '" + this.a + "'", exception);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(dataInputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(dataInputStream);
        } else {
            this.n = ByteBuffer.wrap(this.a.readBytes());
        }
        if (this.n.get() != -85) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 75) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 84) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 88) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 32) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 49) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 49) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != -69) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 13) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 10) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 26) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (this.n.get() != 10) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        int n3 = this.n.getInt();
        if (n3 != 67305985 && n3 != 16909060) {
            throw new GdxRuntimeException("Invalid KTX Header");
        }
        if (n3 != 67305985) {
            this.n.order(this.n.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        this.b = this.n.getInt();
        this.c = this.n.getInt();
        this.d = this.n.getInt();
        this.e = this.n.getInt();
        this.f = this.n.getInt();
        this.g = this.n.getInt();
        this.h = this.n.getInt();
        this.i = this.n.getInt();
        this.j = this.n.getInt();
        this.k = this.n.getInt();
        this.l = this.n.getInt();
        if (this.l == 0) {
            this.l = 1;
            this.o = true;
        }
        int n4 = this.n.getInt();
        this.m = this.n.position() + n4;
        if (!this.n.isDirect()) {
            n2 = this.m;
            n = 0;
            while (n < this.l) {
                int n5 = this.n.getInt(n2) + 3 & 0xFFFFFFFC;
                n2 += n5 * this.k + 4;
                ++n;
            }
            this.n.limit(n2);
            this.n.position(0);
            ByteBuffer byteBuffer = BufferUtils.newUnsafeByteBuffer(n2);
            byteBuffer.order(this.n.order());
            byteBuffer.put(this.n);
            this.n = byteBuffer;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void consumeCustomData(int target) {
        if (this.n == null) {
            throw new GdxRuntimeException("Call prepare() before calling consumeCompressedData()");
        }
        IntBuffer intBuffer = BufferUtils.newIntBuffer(16);
        boolean bl = false;
        if (this.b == 0 || this.d == 0) {
            if (this.b + this.d != 0) {
                throw new GdxRuntimeException("either both or none of glType, glFormat must be zero");
            }
            bl = true;
        }
        int n = 1;
        int n2 = 4660;
        if (this.h > 0) {
            n = 2;
            n2 = 3553;
        }
        if (this.i > 0) {
            n = 3;
            n2 = 4660;
        }
        if (this.k == 6) {
            if (n != 2) throw new GdxRuntimeException("cube map needs 2D faces");
            n2 = 34067;
        } else if (this.k != 1) {
            throw new GdxRuntimeException("numberOfFaces must be either 1 or 6");
        }
        if (this.j > 0) {
            if (n2 == 4660) {
                n2 = 4660;
            } else {
                if (n2 != 3553) throw new GdxRuntimeException("No API for 3D and cube arrays yet");
                n2 = 4660;
            }
            ++n;
        }
        if (n2 == 4660) {
            throw new GdxRuntimeException("Unsupported texture format (only 2D texture are supported in LibGdx for the time being)");
        }
        int n3 = -1;
        if (this.k == 6 && target != 34067) {
            if (34069 > target || target > 34074) {
                throw new GdxRuntimeException("You must specify either GL_TEXTURE_CUBE_MAP to bind all 6 faces of the cube or the requested face GL_TEXTURE_CUBE_MAP_POSITIVE_X and followings.");
            }
            n3 = target - 34069;
            target = 34069;
        } else if (this.k == 6 && target == 34067) {
            target = 34069;
        } else if (target != n2 && (34069 > target || target > 34074 || target != 3553)) {
            throw new GdxRuntimeException("Invalid target requested : 0x" + Integer.toHexString(target) + ", expecting : 0x" + Integer.toHexString(n2));
        }
        Gdx.gl.glGetIntegerv(3317, intBuffer);
        int n4 = intBuffer.get(0);
        if (n4 != 4) {
            Gdx.gl.glPixelStorei(3317, 4);
        }
        int n5 = this.e;
        int n6 = this.d;
        int n7 = this.m;
        int n8 = 0;
        while (n8 < this.l) {
            int n9 = Math.max(1, this.g >> n8);
            int n10 = Math.max(1, this.h >> n8);
            this.n.position(n7);
            int n11 = this.n.getInt();
            int n12 = n11 + 3 & 0xFFFFFFFC;
            n7 += 4;
            int n13 = 0;
            while (n13 < this.k) {
                this.n.position(n7);
                n7 += n12;
                if (n3 == -1 || n3 == n13) {
                    ByteBuffer byteBuffer = this.n.slice();
                    byteBuffer.limit(n12);
                    if (n != 1) {
                        if (n == 2) {
                            if (this.j > 0) {
                                n10 = this.j;
                            }
                            if (bl) {
                                if (n5 == ETC1.ETC1_RGB8_OES) {
                                    if (!Gdx.graphics.supportsExtension("GL_OES_compressed_ETC1_RGB8_texture")) {
                                        Pixmap pixmap = ETC1.decodeImage(new ETC1.ETC1Data(n9, n10, byteBuffer, 0), Pixmap.Format.RGB888);
                                        Gdx.gl.glTexImage2D(target + n13, n8, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
                                        pixmap.dispose();
                                    } else {
                                        Gdx.gl.glCompressedTexImage2D(target + n13, n8, n5, n9, n10, 0, n11, byteBuffer);
                                    }
                                } else {
                                    Gdx.gl.glCompressedTexImage2D(target + n13, n8, n5, n9, n10, 0, n11, byteBuffer);
                                }
                            } else {
                                Gdx.gl.glTexImage2D(target + n13, n8, n5, n9, n10, 0, n6, this.b, byteBuffer);
                            }
                        } else if (n == 3 && this.j > 0) {
                            this.i = this.j;
                        }
                    }
                }
                ++n13;
            }
            ++n8;
        }
        if (n4 != 4) {
            Gdx.gl.glPixelStorei(3317, n4);
        }
        if (this.useMipMaps()) {
            Gdx.gl.glGenerateMipmap(target);
        }
        this.disposePreparedData();
    }

    public void disposePreparedData() {
        if (this.n != null) {
            BufferUtils.disposeUnsafeByteBuffer(this.n);
        }
        this.n = null;
    }

    @Override
    public lgPixmap consumePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public boolean disposePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public int getWidth() {
        return this.g;
    }

    @Override
    public int getHeight() {
        return this.h;
    }

    public int getNumberOfMipMapLevels() {
        return this.l;
    }

    public int getNumberOfFaces() {
        return this.k;
    }

    public int getGlInternalFormat() {
        return this.e;
    }

    public ByteBuffer getData(int requestedLevel, int requestedFace) {
        int n = this.m;
        int n2 = 0;
        while (n2 < this.l) {
            int n3 = this.n.getInt(n) + 3 & 0xFFFFFFFC;
            n += 4;
            if (n2 == requestedLevel) {
                int n4 = 0;
                while (n4 < this.k) {
                    if (n4 == requestedFace) {
                        this.n.position(n);
                        ByteBuffer byteBuffer = this.n.slice();
                        byteBuffer.limit(n3);
                        return byteBuffer;
                    }
                    n += n3;
                    ++n4;
                }
            } else {
                n += n3 * this.k;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Pixmap.Format getFormat() {
        throw new GdxRuntimeException("This TextureData implementation directly handles texture formats.");
    }

    @Override
    public boolean useMipMaps() {
        return this.o;
    }

    @Override
    public boolean isManaged() {
        return true;
    }
}

