/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

@BA.Hide
public class ShaderProgram
implements Disposable {
    public static final String POSITION_ATTRIBUTE = "a_position";
    public static final String NORMAL_ATTRIBUTE = "a_normal";
    public static final String COLOR_ATTRIBUTE = "a_color";
    public static final String TEXCOORD_ATTRIBUTE = "a_texCoord";
    public static final String TANGENT_ATTRIBUTE = "a_tangent";
    public static final String BINORMAL_ATTRIBUTE = "a_binormal";
    public static boolean pedantic = true;
    public static String prependVertexCode = "";
    public static String prependFragmentCode = "";
    private static final ObjectMap<Application, Array<ShaderProgram>> a = new ObjectMap();
    private String b = "";
    private boolean c;
    private final ObjectIntMap<String> d = new ObjectIntMap();
    private final ObjectIntMap<String> e = new ObjectIntMap();
    private final ObjectIntMap<String> f = new ObjectIntMap();
    private String[] g;
    private final ObjectIntMap<String> h = new ObjectIntMap();
    private final ObjectIntMap<String> i = new ObjectIntMap();
    private final ObjectIntMap<String> j = new ObjectIntMap();
    private String[] k;
    private int l;
    private int m;
    private int n;
    private final FloatBuffer o;
    private final String p;
    private final String q;
    private boolean r;
    private IntBuffer s = BufferUtils.newIntBuffer(1);
    private IntBuffer t = BufferUtils.newIntBuffer(1);

    static {
        BufferUtils.newIntBuffer(1);
    }

    public ShaderProgram(String vertexShader, String fragmentShader) {
        if (vertexShader == null) {
            throw new IllegalArgumentException("vertex shader must not be null");
        }
        if (fragmentShader == null) {
            throw new IllegalArgumentException("fragment shader must not be null");
        }
        if (prependVertexCode != null && prependVertexCode.length() > 0) {
            vertexShader = String.valueOf(prependVertexCode) + vertexShader;
        }
        if (prependFragmentCode != null && prependFragmentCode.length() > 0) {
            fragmentShader = String.valueOf(prependFragmentCode) + fragmentShader;
        }
        this.p = vertexShader;
        this.q = fragmentShader;
        this.o = BufferUtils.newFloatBuffer(16);
        this.a(vertexShader, fragmentShader);
        if (this.isCompiled()) {
            this.c();
            this.b();
            ShaderProgram shaderProgram = this;
            Application application = Gdx.app;
            Array<ShaderProgram> array = a.get(application);
            if (array == null) {
                array = new Array();
            }
            array.add(shaderProgram);
            a.put(application, array);
        }
    }

    public ShaderProgram(FileHandle vertexShader, FileHandle fragmentShader) {
        this(vertexShader.readString(), fragmentShader.readString());
    }

    private void a(String string, String string2) {
        this.m = this.a(35633, string);
        this.n = this.a(35632, string2);
        if (this.m == -1 || this.n == -1) {
            this.c = false;
            return;
        }
        this.l = this.a(this.createProgram());
        if (this.l == -1) {
            this.c = false;
            return;
        }
        this.c = true;
    }

    private int a(int n, String string) {
        GL20 gL20 = Gdx.gl20;
        IntBuffer intBuffer = BufferUtils.newIntBuffer(1);
        int n2 = gL20.glCreateShader(n);
        if (n2 == 0) {
            return -1;
        }
        gL20.glShaderSource(n2, string);
        gL20.glCompileShader(n2);
        gL20.glGetShaderiv(n2, 35713, intBuffer);
        if (intBuffer.get(0) == 0) {
            String string2 = gL20.glGetShaderInfoLog(n2);
            this.b = String.valueOf(this.b) + string2;
            return -1;
        }
        return n2;
    }

    protected int createProgram() {
        int n = Gdx.gl20.glCreateProgram();
        if (n != 0) {
            return n;
        }
        return -1;
    }

    private int a(int n) {
        GL20 gL20 = Gdx.gl20;
        if (n == -1) {
            return -1;
        }
        gL20.glAttachShader(n, this.m);
        gL20.glAttachShader(n, this.n);
        gL20.glLinkProgram(n);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        gL20.glGetProgramiv(n, 35714, intBuffer);
        if (intBuffer.get(0) == 0) {
            this.b = Gdx.gl20.glGetProgramInfoLog(n);
            return -1;
        }
        return n;
    }

    public String getLog() {
        if (this.c) {
            this.b = Gdx.gl20.glGetProgramInfoLog(this.l);
            return this.b;
        }
        return this.b;
    }

    public boolean isCompiled() {
        return this.c;
    }

    private int a(String string) {
        GL20 gL20 = Gdx.gl20;
        int n = this.h.get(string, -2);
        if (n == -2) {
            n = gL20.glGetAttribLocation(this.l, string);
            this.h.put(string, n);
        }
        return n;
    }

    private int b(String string) {
        return this.fetchUniformLocation(string, pedantic);
    }

    public int fetchUniformLocation(String name, boolean pedantic) {
        GL20 gL20 = Gdx.gl20;
        int n = this.d.get(name, -2);
        if (n == -2) {
            n = gL20.glGetUniformLocation(this.l, name);
            if (n == -1 && pedantic) {
                throw new IllegalArgumentException("no uniform with name '" + name + "' in shader");
            }
            this.d.put(name, n);
        }
        return n;
    }

    public void setUniformi(String name, int value) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform1i(n, value);
    }

    public void setUniformi(int location, int value) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform1i(location, value);
    }

    public void setUniformi(String name, int value1, int value2) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform2i(n, value1, value2);
    }

    public void setUniformi(int location, int value1, int value2) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform2i(location, value1, value2);
    }

    public void setUniformi(String name, int value1, int value2, int value3) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform3i(n, value1, value2, value3);
    }

    public void setUniformi(int location, int value1, int value2, int value3) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform3i(location, value1, value2, value3);
    }

    public void setUniformi(String name, int value1, int value2, int value3, int value4) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform4i(n, value1, value2, value3, value4);
    }

    public void setUniformi(int location, int value1, int value2, int value3, int value4) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform4i(location, value1, value2, value3, value4);
    }

    public void setUniformf(String name, float value) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform1f(n, value);
    }

    public void setUniformf(int location, float value) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform1f(location, value);
    }

    public void setUniformf(String name, float value1, float value2) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform2f(n, value1, value2);
    }

    public void setUniformf(int location, float value1, float value2) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform2f(location, value1, value2);
    }

    public void setUniformf(String name, float value1, float value2, float value3) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform3f(n, value1, value2, value3);
    }

    public void setUniformf(int location, float value1, float value2, float value3) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform3f(location, value1, value2, value3);
    }

    public void setUniformf(String name, float value1, float value2, float value3, float value4) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform4f(n, value1, value2, value3, value4);
    }

    public void setUniformf(int location, float value1, float value2, float value3, float value4) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform4f(location, value1, value2, value3, value4);
    }

    public void setUniform1fv(String name, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform1fv(n, length, values, offset);
    }

    public void setUniform1fv(int location, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform1fv(location, length, values, offset);
    }

    public void setUniform2fv(String name, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform2fv(n, length / 2, values, offset);
    }

    public void setUniform2fv(int location, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform2fv(location, length / 2, values, offset);
    }

    public void setUniform3fv(String name, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform3fv(n, length / 3, values, offset);
    }

    public void setUniform3fv(int location, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform3fv(location, length / 3, values, offset);
    }

    public void setUniform4fv(String name, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.b(name);
        gL20.glUniform4fv(n, length / 4, values, offset);
    }

    public void setUniform4fv(int location, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniform4fv(location, length / 4, values, offset);
    }

    public void setUniformMatrix(String name, Matrix4 matrix) {
        this.setUniformMatrix(name, matrix, false);
    }

    public void setUniformMatrix(String name, Matrix4 matrix, boolean transpose) {
        ShaderProgram shaderProgram = this;
        shaderProgram.setUniformMatrix(shaderProgram.b(name), matrix, transpose);
    }

    public void setUniformMatrix(int location, Matrix4 matrix) {
        this.setUniformMatrix(location, matrix, false);
    }

    public void setUniformMatrix(int location, Matrix4 matrix, boolean transpose) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniformMatrix4fv(location, 1, transpose, matrix.val, 0);
    }

    public void setUniformMatrix(String name, Matrix3 matrix) {
        this.setUniformMatrix(name, matrix, false);
    }

    public void setUniformMatrix(String name, Matrix3 matrix, boolean transpose) {
        ShaderProgram shaderProgram = this;
        shaderProgram.setUniformMatrix(shaderProgram.b(name), matrix, transpose);
    }

    public void setUniformMatrix(int location, Matrix3 matrix) {
        this.setUniformMatrix(location, matrix, false);
    }

    public void setUniformMatrix(int location, Matrix3 matrix, boolean transpose) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniformMatrix3fv(location, 1, transpose, matrix.val, 0);
    }

    public void setUniformMatrix3fv(String name, FloatBuffer buffer, int count, boolean transpose) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        buffer.position(0);
        int n = this.b(name);
        gL20.glUniformMatrix3fv(n, count, transpose, buffer);
    }

    public void setUniformMatrix4fv(String name, FloatBuffer buffer, int count, boolean transpose) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        buffer.position(0);
        int n = this.b(name);
        gL20.glUniformMatrix4fv(n, count, transpose, buffer);
    }

    public void setUniformMatrix4fv(int location, float[] values, int offset, int length) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUniformMatrix4fv(location, length / 16, false, values, offset);
    }

    public void setUniformMatrix4fv(String name, float[] values, int offset, int length) {
        ShaderProgram shaderProgram = this;
        shaderProgram.setUniformMatrix4fv(shaderProgram.b(name), values, offset, length);
    }

    public void setUniformf(String name, Vector2 values) {
        this.setUniformf(name, values.x, values.y);
    }

    public void setUniformf(int location, Vector2 values) {
        this.setUniformf(location, values.x, values.y);
    }

    public void setUniformf(String name, Vector3 values) {
        this.setUniformf(name, values.x, values.y, values.z);
    }

    public void setUniformf(int location, Vector3 values) {
        this.setUniformf(location, values.x, values.y, values.z);
    }

    public void setUniformf(String name, Color values) {
        this.setUniformf(name, values.r, values.g, values.b, values.a);
    }

    public void setUniformf(int location, Color values) {
        this.setUniformf(location, values.r, values.g, values.b, values.a);
    }

    public void setVertexAttribute(String name, int size, int type, boolean normalize, int stride, Buffer buffer) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.a(name);
        if (n == -1) {
            return;
        }
        gL20.glVertexAttribPointer(n, size, type, normalize, stride, buffer);
    }

    public void setVertexAttribute(int location, int size, int type, boolean normalize, int stride, Buffer buffer) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glVertexAttribPointer(location, size, type, normalize, stride, buffer);
    }

    public void setVertexAttribute(String name, int size, int type, boolean normalize, int stride, int offset) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.a(name);
        if (n == -1) {
            return;
        }
        gL20.glVertexAttribPointer(n, size, type, normalize, stride, offset);
    }

    public void setVertexAttribute(int location, int size, int type, boolean normalize, int stride, int offset) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glVertexAttribPointer(location, size, type, normalize, stride, offset);
    }

    public void begin() {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glUseProgram(this.l);
    }

    public void end() {
        Gdx.gl20.glUseProgram(0);
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        gL20.glUseProgram(0);
        gL20.glDeleteShader(this.m);
        gL20.glDeleteShader(this.n);
        gL20.glDeleteProgram(this.l);
        if (a.get(Gdx.app) != null) {
            a.get(Gdx.app).removeValue(this, true);
        }
    }

    public void disableVertexAttribute(String name) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.a(name);
        if (n == -1) {
            return;
        }
        gL20.glDisableVertexAttribArray(n);
    }

    public void disableVertexAttribute(int location) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glDisableVertexAttribArray(location);
    }

    public void enableVertexAttribute(String name) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        int n = this.a(name);
        if (n == -1) {
            return;
        }
        gL20.glEnableVertexAttribArray(n);
    }

    public void enableVertexAttribute(int location) {
        GL20 gL20 = Gdx.gl20;
        this.a();
        gL20.glEnableVertexAttribArray(location);
    }

    private void a() {
        if (this.r) {
            ShaderProgram shaderProgram = this;
            shaderProgram.a(shaderProgram.p, this.q);
            this.r = false;
        }
    }

    public static void invalidateAllShaderPrograms(Application app) {
        if (Gdx.gl20 == null) {
            return;
        }
        Array<ShaderProgram> array = a.get(app);
        if (array == null) {
            return;
        }
        int n = 0;
        while (n < array.size) {
            array.get((int)n).r = true;
            array.get(n).a();
            ++n;
        }
    }

    public static void clearAllShaderPrograms(Application app) {
        a.remove(app);
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed shaders/app: { ");
        for (Application application : a.keys()) {
            stringBuilder.append(ShaderProgram.a.get((Application)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void setAttributef(String name, float value1, float value2, float value3, float value4) {
        GL20 gL20 = Gdx.gl20;
        int n = this.a(name);
        gL20.glVertexAttrib4f(n, value1, value2, value3, value4);
    }

    private void b() {
        this.s.clear();
        Gdx.gl20.glGetProgramiv(this.l, 35718, this.s);
        int n = this.s.get(0);
        this.g = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.s.clear();
            this.s.put(0, 1);
            this.t.clear();
            String string = Gdx.gl20.glGetActiveUniform(this.l, n2, this.s, this.t);
            int n3 = Gdx.gl20.glGetUniformLocation(this.l, string);
            this.d.put(string, n3);
            this.e.put(string, this.t.get(0));
            this.f.put(string, this.s.get(0));
            this.g[n2] = string;
            ++n2;
        }
    }

    private void c() {
        this.s.clear();
        Gdx.gl20.glGetProgramiv(this.l, 35721, this.s);
        int n = this.s.get(0);
        this.k = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.s.clear();
            this.s.put(0, 1);
            this.t.clear();
            String string = Gdx.gl20.glGetActiveAttrib(this.l, n2, this.s, this.t);
            int n3 = Gdx.gl20.glGetAttribLocation(this.l, string);
            this.h.put(string, n3);
            this.i.put(string, this.t.get(0));
            this.j.put(string, this.s.get(0));
            this.k[n2] = string;
            ++n2;
        }
    }

    public boolean hasAttribute(String name) {
        return this.h.containsKey(name);
    }

    public int getAttributeType(String name) {
        return this.i.get(name, 0);
    }

    public int getAttributeLocation(String name) {
        return this.h.get(name, -1);
    }

    public int getAttributeSize(String name) {
        return this.j.get(name, 0);
    }

    public boolean hasUniform(String name) {
        return this.d.containsKey(name);
    }

    public int getUniformType(String name) {
        return this.e.get(name, 0);
    }

    public int getUniformLocation(String name) {
        return this.d.get(name, -1);
    }

    public int getUniformSize(String name) {
        return this.f.get(name, 0);
    }

    public String[] getAttributes() {
        return this.k;
    }

    public String[] getUniforms() {
        return this.g;
    }

    public String getVertexShaderSource() {
        return this.p;
    }

    public String getFragmentShaderSource() {
        return this.q;
    }
}

