/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.Hide
public class ShapeRenderer
implements Disposable {
    private final ImmediateModeRenderer a;
    private boolean b = false;
    private final Matrix4 c = new Matrix4();
    private final Matrix4 d = new Matrix4();
    private final Matrix4 e = new Matrix4();
    private final Vector2 f = new Vector2();
    private final Color g = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private ShapeType h;

    public ShapeRenderer() {
        this(5000);
    }

    public ShapeRenderer(int maxVertices) {
        this(maxVertices, null);
    }

    public ShapeRenderer(int maxVertices, ShaderProgram defaultShader) {
        this.a = defaultShader == null ? new ImmediateModeRenderer20(maxVertices, false, true, 0) : new ImmediateModeRenderer20(maxVertices, false, true, 0, defaultShader);
        this.c.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.b = true;
    }

    public void setColor(Color color) {
        this.g.set(color);
    }

    public void setColor(float r, float g, float b2, float a2) {
        this.g.set(r, g, b2, a2);
    }

    public Color getColor() {
        return this.g;
    }

    public void updateMatrices() {
        this.b = true;
    }

    public void setProjectionMatrix(Matrix4 matrix) {
        this.c.set(matrix);
        this.b = true;
    }

    public Matrix4 getProjectionMatrix() {
        return this.c;
    }

    public void setTransformMatrix(Matrix4 matrix) {
        this.d.set(matrix);
        this.b = true;
    }

    public Matrix4 getTransformMatrix() {
        return this.d;
    }

    public void identity() {
        this.d.idt();
        this.b = true;
    }

    public void translate(float x, float y, float z) {
        this.d.translate(x, y, z);
        this.b = true;
    }

    public void rotate(float axisX, float axisY, float axisZ, float degrees) {
        this.d.rotate(axisX, axisY, axisZ, degrees);
        this.b = true;
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.d.scale(scaleX, scaleY, scaleZ);
        this.b = true;
    }

    public void begin(ShapeType type) {
        if (this.h != null) {
            throw new IllegalStateException("Call end() before beginning a new shape batch.");
        }
        this.h = type;
        if (this.b) {
            this.e.set(this.c);
            Matrix4.mul(this.e.val, this.d.val);
            this.b = false;
        }
        this.a.begin(this.e, this.h.getGlType());
    }

    public void point(float x, float y, float z) {
        if (this.h != ShapeType.Point) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Point)");
        }
        this.a();
        this.a(1);
        this.a.color(this.g);
        this.a.vertex(x, y, z);
    }

    public final void line(float x, float y, float z, float x2, float y2, float z2) {
        this.line(x, y, z, x2, y2, z2, this.g, this.g);
    }

    public final void line(Vector3 v0, Vector3 v1) {
        this.line(v0.x, v0.y, v0.z, v1.x, v1.y, v1.z, this.g, this.g);
    }

    public final void line(float x, float y, float x2, float y2) {
        this.line(x, y, 0.0f, x2, y2, 0.0f, this.g, this.g);
    }

    public final void line(Vector2 v0, Vector2 v1) {
        this.line(v0.x, v0.y, 0.0f, v1.x, v1.y, 0.0f, this.g, this.g);
    }

    public final void line(float x, float y, float x2, float y2, Color c1, Color c2) {
        this.line(x, y, 0.0f, x2, y2, 0.0f, c1, c2);
    }

    public void line(float x, float y, float z, float x2, float y2, float z2, Color c1, Color c2) {
        if (this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.a();
        this.a(2);
        this.a.color(c1.r, c1.g, c1.b, c1.a);
        this.a.vertex(x, y, z);
        this.a.color(c2.r, c2.g, c2.b, c2.a);
        this.a.vertex(x2, y2, z2);
    }

    public void curve(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2, int segments) {
        if (this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.a();
        this.a(segments * 2 + 2);
        float f = this.g.toFloatBits();
        float f2 = 1.0f / (float)segments;
        float f3 = f2 * f2;
        float f4 = f3 * f2;
        float f5 = 3.0f * f2;
        float f6 = 3.0f * f3;
        float f7 = 6.0f * f3;
        float f8 = 6.0f * f4;
        float f9 = x1 - cx1 * 2.0f + cx2;
        float f10 = y1 - cy1 * 2.0f + cy2;
        float f11 = (cx1 - cx2) * 3.0f - x1 + x2;
        float f12 = (cy1 - cy2) * 3.0f - y1 + y2;
        float f13 = x1;
        float f14 = y1;
        float f15 = (cx1 - x1) * f5 + f9 * f6 + f11 * f4;
        float f16 = (cy1 - y1) * f5 + f10 * f6 + f12 * f4;
        float f17 = f9 * f7 + f11 * f8;
        float f18 = f10 * f7 + f12 * f8;
        float f19 = f11 * f8;
        float f20 = f12 * f8;
        while (segments-- > 0) {
            this.a.color(f);
            this.a.vertex(f13, f14, 0.0f);
            f13 += f15;
            f14 += f16;
            f15 += f17;
            f16 += f18;
            f17 += f19;
            f18 += f20;
            this.a.color(f);
            this.a.vertex(f13, f14, 0.0f);
        }
        this.a.color(f);
        this.a.vertex(f13, f14, 0.0f);
        this.a.color(f);
        this.a.vertex(x2, y2, 0.0f);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(6);
        float f = this.g.toFloatBits();
        if (this.h == ShapeType.Line) {
            this.a.color(f);
            this.a.vertex(x1, y1, 0.0f);
            this.a.color(f);
            this.a.vertex(x2, y2, 0.0f);
            this.a.color(f);
            this.a.vertex(x2, y2, 0.0f);
            this.a.color(f);
            this.a.vertex(x3, y3, 0.0f);
            this.a.color(f);
            this.a.vertex(x3, y3, 0.0f);
            this.a.color(f);
            this.a.vertex(x1, y1, 0.0f);
            return;
        }
        this.a.color(f);
        this.a.vertex(x1, y1, 0.0f);
        this.a.color(f);
        this.a.vertex(x2, y2, 0.0f);
        this.a.color(f);
        this.a.vertex(x3, y3, 0.0f);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3, Color col1, Color col2, Color col3) {
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(6);
        if (this.h == ShapeType.Line) {
            this.a.color(col1.r, col1.g, col1.b, col1.a);
            this.a.vertex(x1, y1, 0.0f);
            this.a.color(col2.r, col2.g, col2.b, col2.a);
            this.a.vertex(x2, y2, 0.0f);
            this.a.color(col2.r, col2.g, col2.b, col2.a);
            this.a.vertex(x2, y2, 0.0f);
            this.a.color(col3.r, col3.g, col3.b, col3.a);
            this.a.vertex(x3, y3, 0.0f);
            this.a.color(col3.r, col3.g, col3.b, col3.a);
            this.a.vertex(x3, y3, 0.0f);
            this.a.color(col1.r, col1.g, col1.b, col1.a);
            this.a.vertex(x1, y1, 0.0f);
            return;
        }
        this.a.color(col1.r, col1.g, col1.b, col1.a);
        this.a.vertex(x1, y1, 0.0f);
        this.a.color(col2.r, col2.g, col2.b, col2.a);
        this.a.vertex(x2, y2, 0.0f);
        this.a.color(col3.r, col3.g, col3.b, col3.a);
        this.a.vertex(x3, y3, 0.0f);
    }

    public void rect(float x, float y, float width, float height) {
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(8);
        float f = this.g.toFloatBits();
        if (this.h == ShapeType.Line) {
            this.a.color(f);
            this.a.vertex(x, y, 0.0f);
            this.a.color(f);
            this.a.vertex(x + width, y, 0.0f);
            this.a.color(f);
            this.a.vertex(x + width, y, 0.0f);
            this.a.color(f);
            this.a.vertex(x + width, y + height, 0.0f);
            this.a.color(f);
            this.a.vertex(x + width, y + height, 0.0f);
            this.a.color(f);
            this.a.vertex(x, y + height, 0.0f);
            this.a.color(f);
            this.a.vertex(x, y + height, 0.0f);
            this.a.color(f);
            this.a.vertex(x, y, 0.0f);
            return;
        }
        this.a.color(f);
        this.a.vertex(x, y, 0.0f);
        this.a.color(f);
        this.a.vertex(x + width, y, 0.0f);
        this.a.color(f);
        this.a.vertex(x + width, y + height, 0.0f);
        this.a.color(f);
        this.a.vertex(x + width, y + height, 0.0f);
        this.a.color(f);
        this.a.vertex(x, y + height, 0.0f);
        this.a.color(f);
        this.a.vertex(x, y, 0.0f);
    }

    public void rect(float x, float y, float width, float height, Color col1, Color col2, Color col3, Color col4) {
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(8);
        if (this.h == ShapeType.Line) {
            this.a.color(col1.r, col1.g, col1.b, col1.a);
            this.a.vertex(x, y, 0.0f);
            this.a.color(col2.r, col2.g, col2.b, col2.a);
            this.a.vertex(x + width, y, 0.0f);
            this.a.color(col2.r, col2.g, col2.b, col2.a);
            this.a.vertex(x + width, y, 0.0f);
            this.a.color(col3.r, col3.g, col3.b, col3.a);
            this.a.vertex(x + width, y + height, 0.0f);
            this.a.color(col3.r, col3.g, col3.b, col3.a);
            this.a.vertex(x + width, y + height, 0.0f);
            this.a.color(col4.r, col4.g, col4.b, col4.a);
            this.a.vertex(x, y + height, 0.0f);
            this.a.color(col4.r, col4.g, col4.b, col4.a);
            this.a.vertex(x, y + height, 0.0f);
            this.a.color(col1.r, col1.g, col1.b, col1.a);
            this.a.vertex(x, y, 0.0f);
            return;
        }
        this.a.color(col1.r, col1.g, col1.b, col1.a);
        this.a.vertex(x, y, 0.0f);
        this.a.color(col2.r, col2.g, col2.b, col2.a);
        this.a.vertex(x + width, y, 0.0f);
        this.a.color(col3.r, col3.g, col3.b, col3.a);
        this.a.vertex(x + width, y + height, 0.0f);
        this.a.color(col3.r, col3.g, col3.b, col3.a);
        this.a.vertex(x + width, y + height, 0.0f);
        this.a.color(col4.r, col4.g, col4.b, col4.a);
        this.a.vertex(x, y + height, 0.0f);
        this.a.color(col1.r, col1.g, col1.b, col1.a);
        this.a.vertex(x, y, 0.0f);
    }

    public void rect(float x, float y, float width, float height, float originX, float originY, float rotation) {
        this.rect(x, y, width, height, originX, originY, rotation, this.g, this.g, this.g, this.g);
    }

    public void rect(float x, float y, float width, float height, float originX, float originY, float rotation, Color col1, Color col2, Color col3, Color col4) {
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(8);
        float f = (float)Math.toRadians(rotation);
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = x + f2 * (0.0f - originX) + -f3 * (0.0f - originY) + originX;
        float f5 = y + f3 * (0.0f - originX) + f2 * (0.0f - originY) + originY;
        float f6 = x + f2 * (width - originX) + -f3 * (0.0f - originY) + originX;
        float f7 = y + f3 * (width - originX) + f2 * (0.0f - originY) + originY;
        float f8 = x + f2 * (width - originX) + -f3 * (height - originY) + originX;
        float f9 = y + f3 * (width - originX) + f2 * (height - originY) + originY;
        float f10 = x + f2 * (0.0f - originX) + -f3 * (height - originY) + originX;
        float f11 = y + f3 * (0.0f - originX) + f2 * (height - originY) + originY;
        if (this.h == ShapeType.Line) {
            this.a.color(col1.r, col1.g, col1.b, col1.a);
            this.a.vertex(f4, f5, 0.0f);
            this.a.color(col2.r, col2.g, col2.b, col2.a);
            this.a.vertex(f6, f7, 0.0f);
            this.a.color(col2.r, col2.g, col2.b, col2.a);
            this.a.vertex(f6, f7, 0.0f);
            this.a.color(col3.r, col3.g, col3.b, col3.a);
            this.a.vertex(f8, f9, 0.0f);
            this.a.color(col3.r, col3.g, col3.b, col3.a);
            this.a.vertex(f8, f9, 0.0f);
            this.a.color(col4.r, col4.g, col4.b, col4.a);
            this.a.vertex(f10, f11, 0.0f);
            this.a.color(col4.r, col4.g, col4.b, col4.a);
            this.a.vertex(f10, f11, 0.0f);
            this.a.color(col1.r, col1.g, col1.b, col1.a);
            this.a.vertex(f4, f5, 0.0f);
            return;
        }
        this.a.color(col1.r, col1.g, col1.b, col1.a);
        this.a.vertex(f4, f5, 0.0f);
        this.a.color(col2.r, col2.g, col2.b, col2.a);
        this.a.vertex(f6, f7, 0.0f);
        this.a.color(col3.r, col3.g, col3.b, col3.a);
        this.a.vertex(f8, f9, 0.0f);
        this.a.color(col3.r, col3.g, col3.b, col3.a);
        this.a.vertex(f8, f9, 0.0f);
        this.a.color(col4.r, col4.g, col4.b, col4.a);
        this.a.vertex(f10, f11, 0.0f);
        this.a.color(col1.r, col1.g, col1.b, col1.a);
        this.a.vertex(f4, f5, 0.0f);
    }

    public void rectLine(Vector2 p1, Vector2 p2, float width) {
        this.rectLine(p1.x, p1.y, p2.x, p2.y, width);
    }

    public void rectLine(float x1, float y1, float x2, float y2, float width) {
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(8);
        float f = this.g.toFloatBits();
        Vector2 vector2 = this.f.set(y2 - y1, x1 - x2).nor();
        float f2 = vector2.x * (width *= 0.5f);
        float f3 = vector2.y * width;
        if (this.h == ShapeType.Line) {
            this.a.color(f);
            this.a.vertex(x1 + f2, y1 + f3, 0.0f);
            this.a.color(f);
            this.a.vertex(x1 - f2, y1 - f3, 0.0f);
            this.a.color(f);
            this.a.vertex(x2 + f2, y2 + f3, 0.0f);
            this.a.color(f);
            this.a.vertex(x2 - f2, y2 - f3, 0.0f);
            this.a.color(f);
            this.a.vertex(x2 + f2, y2 + f3, 0.0f);
            this.a.color(f);
            this.a.vertex(x1 + f2, y1 + f3, 0.0f);
            this.a.color(f);
            this.a.vertex(x2 - f2, y2 - f3, 0.0f);
            this.a.color(f);
            this.a.vertex(x1 - f2, y1 - f3, 0.0f);
            return;
        }
        this.a.color(f);
        this.a.vertex(x1 + f2, y1 + f3, 0.0f);
        this.a.color(f);
        this.a.vertex(x1 - f2, y1 - f3, 0.0f);
        this.a.color(f);
        this.a.vertex(x2 + f2, y2 + f3, 0.0f);
        this.a.color(f);
        this.a.vertex(x2 - f2, y2 - f3, 0.0f);
        this.a.color(f);
        this.a.vertex(x2 + f2, y2 + f3, 0.0f);
        this.a.color(f);
        this.a.vertex(x1 - f2, y1 - f3, 0.0f);
    }

    public void box(float x, float y, float z, float width, float height, float depth) {
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        depth = -depth;
        float f = this.g.toFloatBits();
        if (this.h == ShapeType.Line) {
            this.a(24);
            this.a.color(f);
            this.a.vertex(x, y, z);
            this.a.color(f);
            this.a.vertex(x + width, y, z);
            this.a.color(f);
            this.a.vertex(x + width, y, z);
            this.a.color(f);
            this.a.vertex(x + width, y, z + depth);
            this.a.color(f);
            this.a.vertex(x + width, y, z + depth);
            this.a.color(f);
            this.a.vertex(x, y, z + depth);
            this.a.color(f);
            this.a.vertex(x, y, z + depth);
            this.a.color(f);
            this.a.vertex(x, y, z);
            this.a.color(f);
            this.a.vertex(x, y, z);
            this.a.color(f);
            this.a.vertex(x, y + height, z);
            this.a.color(f);
            this.a.vertex(x, y + height, z);
            this.a.color(f);
            this.a.vertex(x + width, y + height, z);
            this.a.color(f);
            this.a.vertex(x + width, y + height, z);
            this.a.color(f);
            this.a.vertex(x + width, y + height, z + depth);
            this.a.color(f);
            this.a.vertex(x + width, y + height, z + depth);
            this.a.color(f);
            this.a.vertex(x, y + height, z + depth);
            this.a.color(f);
            this.a.vertex(x, y + height, z + depth);
            this.a.color(f);
            this.a.vertex(x, y + height, z);
            this.a.color(f);
            this.a.vertex(x + width, y, z);
            this.a.color(f);
            this.a.vertex(x + width, y + height, z);
            this.a.color(f);
            this.a.vertex(x + width, y, z + depth);
            this.a.color(f);
            this.a.vertex(x + width, y + height, z + depth);
            this.a.color(f);
            this.a.vertex(x, y, z + depth);
            this.a.color(f);
            this.a.vertex(x, y + height, z + depth);
            return;
        }
        this.a(36);
        this.a.color(f);
        this.a.vertex(x, y, z);
        this.a.color(f);
        this.a.vertex(x + width, y, z);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z);
        this.a.color(f);
        this.a.vertex(x, y, z);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z);
        this.a.color(f);
        this.a.vertex(x, y + height, z);
        this.a.color(f);
        this.a.vertex(x + width, y, z + depth);
        this.a.color(f);
        this.a.vertex(x, y, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x, y, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x, y, z + depth);
        this.a.color(f);
        this.a.vertex(x, y, z);
        this.a.color(f);
        this.a.vertex(x, y + height, z);
        this.a.color(f);
        this.a.vertex(x, y, z + depth);
        this.a.color(f);
        this.a.vertex(x, y + height, z);
        this.a.color(f);
        this.a.vertex(x, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y, z);
        this.a.color(f);
        this.a.vertex(x + width, y, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y, z);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z);
        this.a.color(f);
        this.a.vertex(x, y + height, z);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x, y + height, z);
        this.a.color(f);
        this.a.vertex(x + width, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x, y + height, z + depth);
        this.a.color(f);
        this.a.vertex(x, y, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y, z);
        this.a.color(f);
        this.a.vertex(x, y, z + depth);
        this.a.color(f);
        this.a.vertex(x + width, y, z);
        this.a.color(f);
        this.a.vertex(x, y, z);
    }

    public void x(float x, float y, float radius) {
        if (this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        this.line(x - radius, y - radius, x + radius, y + radius);
        this.line(x - radius, y + radius, x + radius, y - radius);
    }

    public void x(Vector2 p, float radius) {
        this.x(p.x, p.y, radius);
    }

    public void arc(float x, float y, float radius, float start, float angle) {
        this.arc(x, y, radius, start, angle, Math.max(1, (int)(6.0f * (float)Math.cbrt(radius) * (angle / 360.0f))));
    }

    public void arc(float x, float y, float radius, float start, float angle, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        float f = (float)Math.PI * 2 * (angle / 360.0f) / (float)segments;
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        float f4 = radius * MathUtils.cos(start * ((float)Math.PI / 180));
        float f5 = radius * MathUtils.sin(start * ((float)Math.PI / 180));
        if (this.h == ShapeType.Line) {
            this.a(segments * 2 + 2);
            this.a.color(this.g);
            this.a.vertex(x, y, 0.0f);
            this.a.color(this.g);
            this.a.vertex(x + f4, y + f5, 0.0f);
            int n = 0;
            while (n < segments) {
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                float f6 = f4;
                f4 = f2 * f4 - f3 * f5;
                f5 = f3 * f6 + f2 * f5;
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                ++n;
            }
            this.a.color(this.g);
            this.a.vertex(x + f4, y + f5, 0.0f);
        } else {
            this.a(segments * 3 + 3);
            int n = 0;
            while (n < segments) {
                this.a.color(this.g);
                this.a.vertex(x, y, 0.0f);
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                float f7 = f4;
                f4 = f2 * f4 - f3 * f5;
                f5 = f3 * f7 + f2 * f5;
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                ++n;
            }
            this.a.color(this.g);
            this.a.vertex(x, y, 0.0f);
            this.a.color(this.g);
            this.a.vertex(x + f4, y + f5, 0.0f);
        }
        this.a.color(this.g);
        this.a.vertex(x + 0.0f, y + 0.0f, 0.0f);
    }

    public void circle(float x, float y, float radius) {
        this.circle(x, y, radius, Math.max(1, (int)(6.0f * (float)Math.cbrt(radius))));
    }

    public void circle(float x, float y, float radius, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        float f = (float)Math.PI * 2 / (float)segments;
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        float f4 = radius;
        float f5 = 0.0f;
        if (this.h == ShapeType.Line) {
            this.a(segments * 2 + 2);
            int n = 0;
            while (n < segments) {
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                float f6 = f4;
                f4 = f2 * f4 - f3 * f5;
                f5 = f3 * f6 + f2 * f5;
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                ++n;
            }
            this.a.color(this.g);
            this.a.vertex(x + f4, y + f5, 0.0f);
        } else {
            this.a(segments * 3 + 3);
            --segments;
            int n = 0;
            while (n < segments) {
                this.a.color(this.g);
                this.a.vertex(x, y, 0.0f);
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                float f7 = f4;
                f4 = f2 * f4 - f3 * f5;
                f5 = f3 * f7 + f2 * f5;
                this.a.color(this.g);
                this.a.vertex(x + f4, y + f5, 0.0f);
                ++n;
            }
            this.a.color(this.g);
            this.a.vertex(x, y, 0.0f);
            this.a.color(this.g);
            this.a.vertex(x + f4, y + f5, 0.0f);
        }
        this.a.color(this.g);
        this.a.vertex(x + radius, y + 0.0f, 0.0f);
    }

    public void ellipse(float x, float y, float width, float height) {
        this.ellipse(x, y, width, height, Math.max(1, (int)(12.0f * (float)Math.cbrt(Math.max(width * 0.5f, height * 0.5f)))));
    }

    public void ellipse(float x, float y, float width, float height, int segments) {
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(segments * 3);
        float f = (float)Math.PI * 2 / (float)segments;
        float f2 = x + width / 2.0f;
        float f3 = y + height / 2.0f;
        if (this.h == ShapeType.Line) {
            int n = 0;
            while (n < segments) {
                this.a.color(this.g);
                this.a.vertex(f2 + width * 0.5f * MathUtils.cos((float)n * f), f3 + height * 0.5f * MathUtils.sin((float)n * f), 0.0f);
                this.a.color(this.g);
                this.a.vertex(f2 + width * 0.5f * MathUtils.cos((float)(n + 1) * f), f3 + height * 0.5f * MathUtils.sin((float)(n + 1) * f), 0.0f);
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < segments) {
            this.a.color(this.g);
            this.a.vertex(f2 + width * 0.5f * MathUtils.cos((float)n * f), f3 + height * 0.5f * MathUtils.sin((float)n * f), 0.0f);
            this.a.color(this.g);
            this.a.vertex(f2, f3, 0.0f);
            this.a.color(this.g);
            this.a.vertex(f2 + width * 0.5f * MathUtils.cos((float)(n + 1) * f), f3 + height * 0.5f * MathUtils.sin((float)(n + 1) * f), 0.0f);
            ++n;
        }
    }

    public void cone(float x, float y, float z, float radius, float height) {
        this.cone(x, y, z, radius, height, Math.max(1, (int)(4.0f * (float)Math.sqrt(radius))));
    }

    public void cone(float x, float y, float z, float radius, float height, int segments) {
        float f;
        int n;
        if (segments <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        if (this.h != ShapeType.Filled && this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Filled) or begin(ShapeType.Line)");
        }
        this.a();
        this.a(segments * 4 + 2);
        float f2 = (float)Math.PI * 2 / (float)segments;
        float f3 = MathUtils.cos(f2);
        float f4 = MathUtils.sin(f2);
        float f5 = radius;
        float f6 = 0.0f;
        if (this.h == ShapeType.Line) {
            n = 0;
            while (n < segments) {
                this.a.color(this.g);
                this.a.vertex(x + f5, y + f6, z);
                this.a.color(this.g);
                this.a.vertex(x, y, z + height);
                this.a.color(this.g);
                this.a.vertex(x + f5, y + f6, z);
                f = f5;
                f5 = f3 * f5 - f4 * f6;
                f6 = f4 * f + f3 * f6;
                this.a.color(this.g);
                this.a.vertex(x + f5, y + f6, z);
                ++n;
            }
            this.a.color(this.g);
            this.a.vertex(x + f5, y + f6, z);
        } else {
            --segments;
            n = 0;
            while (n < segments) {
                this.a.color(this.g);
                this.a.vertex(x, y, z);
                this.a.color(this.g);
                this.a.vertex(x + f5, y + f6, z);
                f = f5;
                float f7 = f6;
                f5 = f3 * f5 - f4 * f6;
                f6 = f4 * f + f3 * f6;
                this.a.color(this.g);
                this.a.vertex(x + f5, y + f6, z);
                this.a.color(this.g);
                this.a.vertex(x + f, y + f7, z);
                this.a.color(this.g);
                this.a.vertex(x + f5, y + f6, z);
                this.a.color(this.g);
                this.a.vertex(x, y, z + height);
                ++n;
            }
            this.a.color(this.g);
            this.a.vertex(x, y, z);
            this.a.color(this.g);
            this.a.vertex(x + f5, y + f6, z);
        }
        float f8 = f5;
        f = f6;
        this.a.color(this.g);
        this.a.vertex(x + radius, y + 0.0f, z);
        if (this.h != ShapeType.Line) {
            this.a.color(this.g);
            this.a.vertex(x + f8, y + f, z);
            this.a.color(this.g);
            this.a.vertex(x + radius, y + 0.0f, z);
            this.a.color(this.g);
            this.a.vertex(x, y, z + height);
        }
    }

    public void polygon(float[] vertices) {
        this.polygon(vertices, 0, vertices.length);
    }

    public void polygon(float[] vertices, int offset, int count) {
        if (this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        if (count < 6) {
            throw new IllegalArgumentException("Polygons must contain at least 3 points.");
        }
        if (count % 2 != 0) {
            throw new IllegalArgumentException("Polygons must have an even number of vertices.");
        }
        this.a();
        this.a(count);
        float f = vertices[0];
        float f2 = vertices[1];
        int n = offset;
        int n2 = offset + count;
        while (n < n2) {
            float f3;
            float f4;
            float f5 = vertices[n];
            float f6 = vertices[n + 1];
            if (n + 2 >= count) {
                f4 = f;
                f3 = f2;
            } else {
                f4 = vertices[n + 2];
                f3 = vertices[n + 3];
            }
            this.a.color(this.g);
            this.a.vertex(f5, f6, 0.0f);
            this.a.color(this.g);
            this.a.vertex(f4, f3, 0.0f);
            n += 2;
        }
    }

    public void polyline(float[] vertices) {
        this.polyline(vertices, 0, vertices.length);
    }

    public void polyline(float[] vertices, int offset, int count) {
        if (this.h != ShapeType.Line) {
            throw new GdxRuntimeException("Must call begin(ShapeType.Line)");
        }
        if (count < 4) {
            throw new IllegalArgumentException("Polylines must contain at least 2 points.");
        }
        if (count % 2 != 0) {
            throw new IllegalArgumentException("Polylines must have an even number of vertices.");
        }
        this.a();
        this.a(count);
        int n = offset;
        int n2 = offset + count - 2;
        while (n < n2) {
            float f = vertices[n];
            float f2 = vertices[n + 1];
            float f3 = vertices[n + 2];
            float f4 = vertices[n + 3];
            this.a.color(this.g);
            this.a.vertex(f, f2, 0.0f);
            this.a.color(this.g);
            this.a.vertex(f3, f4, 0.0f);
            n += 2;
        }
    }

    private void a() {
        if (!this.b) {
            return;
        }
        ShapeType shapeType = this.h;
        this.end();
        this.begin(shapeType);
    }

    private void a(int n) {
        if (this.a.getMaxVertices() - this.a.getNumVertices() >= n) {
            return;
        }
        ShapeType shapeType = this.h;
        this.end();
        this.begin(shapeType);
    }

    public void end() {
        this.a.end();
        this.h = null;
    }

    public void flush() {
        ShapeType shapeType = this.h;
        this.end();
        this.begin(shapeType);
    }

    public ShapeType getCurrentType() {
        return this.h;
    }

    public ImmediateModeRenderer getRenderer() {
        return this.a;
    }

    public boolean isDrawing() {
        return this.h != null;
    }

    @Override
    public void dispose() {
        this.a.dispose();
    }

    @BA.Hide
    public static enum ShapeType {
        Point(0),
        Line(1),
        Filled(4);

        private final int a;

        private ShapeType(int glType) {
            this.a = glType;
        }

        public final int getGlType() {
            return this.a;
        }
    }
}

