/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

@BA.Hide
public class VertexArray
implements VertexData {
    private VertexAttributes a;
    private FloatBuffer b;
    private ByteBuffer c;
    private boolean d = false;

    public VertexArray(int numVertices, VertexAttribute ... attributes) {
        this(numVertices, new VertexAttributes(attributes));
    }

    public VertexArray(int numVertices, VertexAttributes attributes) {
        this.a = attributes;
        this.c = BufferUtils.newUnsafeByteBuffer(this.a.vertexSize * numVertices);
        this.b = this.c.asFloatBuffer();
        this.b.flip();
        this.c.flip();
    }

    @Override
    public void dispose() {
        BufferUtils.disposeUnsafeByteBuffer(this.c);
    }

    @Override
    public FloatBuffer getBuffer() {
        return this.b;
    }

    @Override
    public int getNumVertices() {
        return this.b.limit() * 4 / this.a.vertexSize;
    }

    @Override
    public int getNumMaxVertices() {
        return this.c.capacity() / this.a.vertexSize;
    }

    @Override
    public void setVertices(float[] vertices, int offset, int count) {
        BufferUtils.copy(vertices, this.c, count, offset);
        this.b.position(0);
        this.b.limit(count);
    }

    @Override
    public void updateVertices(int targetOffset, float[] vertices, int sourceOffset, int count) {
        int n = this.c.position();
        this.c.position(targetOffset * 4);
        BufferUtils.copy(vertices, sourceOffset, count, (Buffer)this.c);
        this.c.position(n);
    }

    @Override
    public void bind(ShaderProgram shader) {
        this.bind(shader, null);
    }

    @Override
    public void bind(ShaderProgram shader, int[] locations) {
        int n = this.a.size();
        this.c.limit(this.b.limit() * 4);
        if (locations == null) {
            int n2 = 0;
            while (n2 < n) {
                VertexAttribute vertexAttribute = this.a.get(n2);
                int n3 = shader.getAttributeLocation(vertexAttribute.alias);
                if (n3 >= 0) {
                    shader.enableVertexAttribute(n3);
                    if (vertexAttribute.type == 5126) {
                        this.b.position(vertexAttribute.offset / 4);
                        shader.setVertexAttribute(n3, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.a.vertexSize, (Buffer)this.b);
                    } else {
                        this.c.position(vertexAttribute.offset);
                        shader.setVertexAttribute(n3, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.a.vertexSize, (Buffer)this.c);
                    }
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                VertexAttribute vertexAttribute = this.a.get(n4);
                int n5 = locations[n4];
                if (n5 >= 0) {
                    shader.enableVertexAttribute(n5);
                    if (vertexAttribute.type == 5126) {
                        this.b.position(vertexAttribute.offset / 4);
                        shader.setVertexAttribute(n5, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.a.vertexSize, (Buffer)this.b);
                    } else {
                        this.c.position(vertexAttribute.offset);
                        shader.setVertexAttribute(n5, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.a.vertexSize, (Buffer)this.c);
                    }
                }
                ++n4;
            }
        }
        this.d = true;
    }

    @Override
    public void unbind(ShaderProgram shader) {
        this.unbind(shader, null);
    }

    @Override
    public void unbind(ShaderProgram shader, int[] locations) {
        int n = this.a.size();
        if (locations == null) {
            int n2 = 0;
            while (n2 < n) {
                shader.disableVertexAttribute(this.a.get((int)n2).alias);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                int n4 = locations[n3];
                if (n4 >= 0) {
                    shader.disableVertexAttribute(n4);
                }
                ++n3;
            }
        }
        this.d = false;
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.a;
    }

    @Override
    public void invalidate() {
    }
}

