/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

@BA.Hide
public class VertexBufferObject
implements VertexData {
    private VertexAttributes a;
    private FloatBuffer b;
    private ByteBuffer c;
    private boolean d;
    private int e = Gdx.gl20.glGenBuffer();
    private int f;
    private boolean g = false;
    private boolean h = false;

    public VertexBufferObject(boolean isStatic, int numVertices, VertexAttribute ... attributes) {
        this(isStatic, numVertices, new VertexAttributes(attributes));
    }

    public VertexBufferObject(boolean isStatic, int numVertices, VertexAttributes attributes) {
        ByteBuffer byteBuffer = BufferUtils.newUnsafeByteBuffer(attributes.vertexSize * numVertices);
        byteBuffer.limit(0);
        this.setBuffer(byteBuffer, true, attributes);
        this.setUsage(isStatic ? 35044 : 35048);
    }

    protected VertexBufferObject(int usage, ByteBuffer data, boolean ownsBuffer, VertexAttributes attributes) {
        this.setBuffer(data, ownsBuffer, attributes);
        this.setUsage(usage);
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.a;
    }

    @Override
    public int getNumVertices() {
        return this.b.limit() * 4 / this.a.vertexSize;
    }

    @Override
    public int getNumMaxVertices() {
        return this.c.capacity() / this.a.vertexSize;
    }

    @Override
    public FloatBuffer getBuffer() {
        this.g = true;
        return this.b;
    }

    protected void setBuffer(Buffer data, boolean ownsBuffer, VertexAttributes value) {
        if (this.h) {
            throw new GdxRuntimeException("Cannot change attributes while VBO is bound");
        }
        if (this.d && this.c != null) {
            BufferUtils.disposeUnsafeByteBuffer(this.c);
        }
        this.a = value;
        if (!(data instanceof ByteBuffer)) {
            throw new GdxRuntimeException("Only ByteBuffer is currently supported");
        }
        this.c = (ByteBuffer)data;
        this.d = ownsBuffer;
        int n = this.c.limit();
        this.c.limit(this.c.capacity());
        this.b = this.c.asFloatBuffer();
        this.c.limit(n);
        this.b.limit(n / 4);
    }

    private void a() {
        if (this.h) {
            Gdx.gl20.glBufferData(34962, this.c.limit(), this.c, this.f);
            this.g = false;
        }
    }

    @Override
    public void setVertices(float[] vertices, int offset, int count) {
        this.g = true;
        BufferUtils.copy(vertices, this.c, count, offset);
        this.b.position(0);
        this.b.limit(count);
        this.a();
    }

    @Override
    public void updateVertices(int targetOffset, float[] vertices, int sourceOffset, int count) {
        this.g = true;
        int n = this.c.position();
        this.c.position(targetOffset * 4);
        BufferUtils.copy(vertices, sourceOffset, count, (Buffer)this.c);
        this.c.position(n);
        this.b.position(0);
        this.a();
    }

    protected int getUsage() {
        return this.f;
    }

    protected void setUsage(int value) {
        if (this.h) {
            throw new GdxRuntimeException("Cannot change usage while VBO is bound");
        }
        this.f = value;
    }

    @Override
    public void bind(ShaderProgram shader) {
        this.bind(shader, null);
    }

    @Override
    public void bind(ShaderProgram shader, int[] locations) {
        GL20 gL20 = Gdx.gl20;
        gL20.glBindBuffer(34962, this.e);
        if (this.g) {
            this.c.limit(this.b.limit() * 4);
            gL20.glBufferData(34962, this.c.limit(), this.c, this.f);
            this.g = false;
        }
        int n = this.a.size();
        if (locations == null) {
            int n2 = 0;
            while (n2 < n) {
                VertexAttribute vertexAttribute = this.a.get(n2);
                int n3 = shader.getAttributeLocation(vertexAttribute.alias);
                if (n3 >= 0) {
                    shader.enableVertexAttribute(n3);
                    shader.setVertexAttribute(n3, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.a.vertexSize, vertexAttribute.offset);
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                VertexAttribute vertexAttribute = this.a.get(n4);
                int n5 = locations[n4];
                if (n5 >= 0) {
                    shader.enableVertexAttribute(n5);
                    shader.setVertexAttribute(n5, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.a.vertexSize, vertexAttribute.offset);
                }
                ++n4;
            }
        }
        this.h = true;
    }

    @Override
    public void unbind(ShaderProgram shader) {
        this.unbind(shader, null);
    }

    @Override
    public void unbind(ShaderProgram shader, int[] locations) {
        GL20 gL20 = Gdx.gl20;
        int n = this.a.size();
        if (locations == null) {
            int n2 = 0;
            while (n2 < n) {
                shader.disableVertexAttribute(this.a.get((int)n2).alias);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                int n4 = locations[n3];
                if (n4 >= 0) {
                    shader.disableVertexAttribute(n4);
                }
                ++n3;
            }
        }
        gL20.glBindBuffer(34962, 0);
        this.h = false;
    }

    @Override
    public void invalidate() {
        this.e = Gdx.gl20.glGenBuffer();
        this.g = true;
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        gL20.glBindBuffer(34962, 0);
        gL20.glDeleteBuffer(this.e);
        this.e = 0;
        if (this.d) {
            BufferUtils.disposeUnsafeByteBuffer(this.c);
        }
    }
}

