/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.utils.GdxRuntimeException;

public interface GLErrorListener {
    public static final GLErrorListener LOGGING_LISTENER = new GLErrorListener(){

        @Override
        public final void onError(int error) {
            String string = null;
            try {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                int n = 0;
                while (n < stackTraceElementArray.length) {
                    if ("check".equals(stackTraceElementArray[n].getMethodName())) {
                        if (n + 1 < stackTraceElementArray.length) {
                            string = stackTraceElementArray[n + 1].getMethodName();
                        }
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
            if (string != null) {
                Gdx.app.error("GLProfiler", "Error " + GLProfiler.resolveErrorNumber(error) + " from " + string);
                return;
            }
            Gdx.app.error("GLProfiler", "Error " + GLProfiler.resolveErrorNumber(error) + " at: ", new Exception());
        }
    };
    public static final GLErrorListener THROWING_LISTENER = new GLErrorListener(){

        @Override
        public final void onError(int error) {
            throw new GdxRuntimeException("GLProfiler: Got GL error " + GLProfiler.resolveErrorNumber(error));
        }
    };

    public void onError(int var1);
}

