/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.ObjectMap;

public interface ImageResolver {
    public TextureRegion getImage(String var1);

    @BA.Hide
    public static class AssetManagerImageResolver
    implements ImageResolver {
        private final AssetManager a;

        public AssetManagerImageResolver(AssetManager assetManager) {
            this.a = assetManager;
        }

        @Override
        public TextureRegion getImage(String name) {
            return new TextureRegion(this.a.get(name, Texture.class));
        }
    }

    @BA.Hide
    public static class DirectImageResolver
    implements ImageResolver {
        private final ObjectMap<String, Texture> a;

        public DirectImageResolver(ObjectMap<String, Texture> images) {
            this.a = images;
        }

        @Override
        public TextureRegion getImage(String name) {
            return new TextureRegion(this.a.get(name));
        }
    }

    @BA.Hide
    public static class TextureAtlasImageResolver
    implements ImageResolver {
        private final TextureAtlas a;

        public TextureAtlasImageResolver(TextureAtlas atlas) {
            this.a = atlas;
        }

        @Override
        public TextureRegion getImage(String name) {
            return this.a.findRegion(name);
        }
    }
}

