/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureAtlasRegion;
import anywheresoftware.b4a.libgdx.maps.lgMapProperties;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.io.IOException;
import java.util.Iterator;

@BA.Hide
public class AtlasTmxMapLoader
extends BaseTmxMapLoader<AtlasTiledMapLoaderParameters> {
    protected Array<Texture> trackedTextures = new Array();

    public AtlasTmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public AtlasTmxMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public TiledMap load(String fileName) {
        return this.load(fileName, new AtlasTiledMapLoaderParameters());
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle tmxFile, AtlasTiledMapLoaderParameters parameter) {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        try {
            this.root = this.xml.parse(tmxFile);
            XmlReader.Element element = this.root.getChildByName("properties");
            if (element != null) {
                for (XmlReader.Element element2 : element.getChildrenByName("property")) {
                    String string = element2.getAttribute("name");
                    String string2 = element2.getAttribute("value");
                    if (!string.startsWith("atlas")) continue;
                    FileHandle fileHandle = AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, string2);
                    array.add(new AssetDescriptor<TextureAtlas>(fileHandle, TextureAtlas.class));
                }
            }
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Unable to parse .tmx file.");
        }
        return array;
    }

    public TiledMap load(String fileName, AtlasTiledMapLoaderParameters parameter) {
        try {
            this.convertObjectToTileSpace = parameter != null ? parameter.convertObjectToTileSpace : false;
            FileHandle fileHandle = this.resolve(fileName);
            this.root = this.xml.parse(fileHandle);
            ObjectMap<String, TextureAtlas> objectMap = new ObjectMap<String, TextureAtlas>();
            AtlasTmxMapLoader atlasTmxMapLoader = this;
            FileHandle fileHandle2 = atlasTmxMapLoader.loadAtlas(atlasTmxMapLoader.root, fileHandle);
            if (fileHandle2 == null) {
                throw new GdxRuntimeException("Couldn't load atlas");
            }
            TextureAtlas textureAtlas = new TextureAtlas(fileHandle2);
            objectMap.put(fileHandle2.path(), textureAtlas);
            AtlasResolver.DirectAtlasResolver directAtlasResolver = new AtlasResolver.DirectAtlasResolver(objectMap);
            AtlasTmxMapLoader atlasTmxMapLoader2 = this;
            TiledMap tiledMap = atlasTmxMapLoader2.loadMap(atlasTmxMapLoader2.root, fileHandle, directAtlasResolver);
            tiledMap.setOwnedResources(objectMap.values().toArray());
            this.a(parameter.textureMinFilter, parameter.textureMagFilter);
            return tiledMap;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", iOException);
        }
    }

    protected FileHandle loadAtlas(XmlReader.Element root, FileHandle tmxFile) throws IOException {
        FileHandle fileHandle;
        XmlReader.Element element = root.getChildByName("properties");
        if (element != null) {
            for (XmlReader.Element object2 : element.getChildrenByName("property")) {
                String string = object2.getAttribute("name", null);
                String string2 = object2.getAttribute("value", null);
                if (!string.equals("atlas")) continue;
                if (string2 == null) {
                    string2 = object2.getText();
                }
                if (string2 == null || string2.length() == 0) continue;
                return AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, string2);
            }
        }
        if ((fileHandle = tmxFile.sibling(String.valueOf(tmxFile.nameWithoutExtension()) + ".atlas")).exists()) {
            return fileHandle;
        }
        return null;
    }

    private void a(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2) {
        Iterator<Texture> iterator = this.trackedTextures.iterator();
        while (iterator.hasNext()) {
            iterator.next().setFilter(textureFilter, textureFilter2);
        }
        this.trackedTextures.clear();
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle tmxFile, AtlasTiledMapLoaderParameters parameter) {
        this.map = null;
        this.convertObjectToTileSpace = parameter != null ? parameter.convertObjectToTileSpace : false;
        try {
            this.map = this.loadMap(this.root, tmxFile, new AtlasResolver.AssetManagerAtlasResolver(manager));
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", exception);
        }
    }

    @Override
    public TiledMap loadSync(AssetManager manager, String fileName, FileHandle file, AtlasTiledMapLoaderParameters parameter) {
        if (parameter != null) {
            this.a(parameter.textureMinFilter, parameter.textureMagFilter);
        }
        return this.map;
    }

    protected TiledMap loadMap(XmlReader.Element root, FileHandle tmxFile, AtlasResolver resolver) {
        TiledMap tiledMap = new TiledMap();
        String string = root.getAttribute("orientation", null);
        int n = root.getIntAttribute("width", 0);
        int n2 = root.getIntAttribute("height", 0);
        int n3 = root.getIntAttribute("tilewidth", 0);
        int n4 = root.getIntAttribute("tileheight", 0);
        String string2 = root.getAttribute("backgroundcolor", null);
        lgMapProperties lgMapProperties2 = tiledMap.getProperties();
        if (string != null) {
            lgMapProperties2.put("orientation", string);
        }
        lgMapProperties2.put("width", n);
        lgMapProperties2.put("height", n2);
        lgMapProperties2.put("tilewidth", n3);
        lgMapProperties2.put("tileheight", n4);
        if (string2 != null) {
            lgMapProperties2.put("backgroundcolor", string2);
        }
        this.mapTileWidth = n3;
        this.mapTileHeight = n4;
        this.mapWidthInPixels = n * n3;
        this.mapHeightInPixels = n2 * n4;
        if (string != null && "staggered".equals(string) && n2 > 1) {
            this.mapWidthInPixels += n3 / 2;
            this.mapHeightInPixels = this.mapHeightInPixels / 2 + n4 / 2;
        }
        int n5 = 0;
        int n6 = root.getChildCount();
        while (n5 < n6) {
            XmlReader.Element element = root.getChild(n5);
            String string3 = element.getName();
            if (string3.equals("properties")) {
                this.loadProperties(tiledMap.getProperties(), element);
            } else if (string3.equals("tileset")) {
                this.loadTileset(tiledMap, element, tmxFile, resolver);
            } else if (string3.equals("layer")) {
                this.loadTileLayer(tiledMap, element);
            } else if (string3.equals("objectgroup")) {
                this.loadObjectGroup(tiledMap, element);
            }
            ++n5;
        }
        return tiledMap;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void loadTileset(TiledMap map, XmlReader.Element element, FileHandle tmxFile, AtlasResolver resolver) {
        if (element.getName().equals("tileset")) {
            var5_5 = element.get("name", null);
            var6_6 = element.getIntAttribute("firstgid", 1);
            var7_7 = element.getIntAttribute("tilewidth", 0);
            var8_8 = element.getIntAttribute("tileheight", 0);
            var9_9 = element.getIntAttribute("spacing", 0);
            var10_10 = element.getIntAttribute("margin", 0);
            var11_11 = element.getAttribute("source", null);
            var12_12 = 0;
            var13_13 = 0;
            var14_14 = "";
            var15_15 = 0;
            var16_16 = 0;
            if (var11_11 != null) {
                var17_17 = AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, var11_11);
                try {
                    element = this.xml.parse((FileHandle)var17_17);
                    var5_5 = element.get("name", null);
                    var7_7 = element.getIntAttribute("tilewidth", 0);
                    var8_8 = element.getIntAttribute("tileheight", 0);
                    var9_9 = element.getIntAttribute("spacing", 0);
                    var10_10 = element.getIntAttribute("margin", 0);
                    var18_18 = element.getChildByName("tileoffset");
                    if (var18_18 != null) {
                        var12_12 = var18_18.getIntAttribute("x", 0);
                        var13_13 = var18_18.getIntAttribute("y", 0);
                    }
                    if ((var19_19 = element.getChildByName("image")) == null) ** GOTO lbl46
                    var14_14 = var19_19.getAttribute("source");
                    var15_15 = var19_19.getIntAttribute("width", 0);
                    var16_16 = var19_19.getIntAttribute("height", 0);
                    AtlasTmxMapLoader.getRelativeFileHandle((FileHandle)var17_17, var14_14);
                }
                catch (IOException v0) {
                    throw new GdxRuntimeException("Error parsing external tileset.");
                }
            } else {
                var17_17 = element.getChildByName("tileoffset");
                if (var17_17 != null) {
                    var12_12 = var17_17.getIntAttribute("x", 0);
                    var13_13 = var17_17.getIntAttribute("y", 0);
                }
                if ((var18_18 = element.getChildByName("image")) != null) {
                    var14_14 = var18_18.getAttribute("source");
                    var15_15 = var18_18.getIntAttribute("width", 0);
                    var16_16 = var18_18.getIntAttribute("height", 0);
                    AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, var14_14);
                }
            }
lbl46:
            // 5 sources

            if ((var17_17 = map.getProperties().get("atlas", String.class)) == null && (var18_18 = tmxFile.sibling(String.valueOf(tmxFile.nameWithoutExtension()) + ".atlas")).exists()) {
                var17_17 = var18_18.name();
            }
            if (var17_17 == null) {
                throw new GdxRuntimeException("The map is missing the 'atlas' property");
            }
            var18_18 = AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, (String)var17_17);
            var18_18 = this.resolve(var18_18.path());
            var19_19 = resolver.getAtlas(var18_18.path());
            var20_20 = var5_5;
            for (Object var21_22 : var19_19.getTextures()) {
                this.trackedTextures.add((Texture)var21_22);
            }
            var21_22 = new TiledMapTileSet();
            var22_21 = var21_22.getProperties();
            var21_22.setName(var5_5);
            var22_21.put("firstgid", var6_6);
            var22_21.put("imagesource", var14_14);
            var22_21.put("imagewidth", var15_15);
            var22_21.put("imageheight", var16_16);
            var22_21.put("tilewidth", var7_7);
            var22_21.put("tileheight", var8_8);
            var22_21.put("margin", var10_10);
            var22_21.put("spacing", var9_9);
            if (var14_14 != null && var14_14.length() > 0) {
                var23_23 = var6_6 + var15_15 / var7_7 * (var16_16 / var8_8) - 1;
                for (Object var24_28 : var19_19.findRegions(var20_20)) {
                    if (var24_28 == null || (var26_29 = var24_28.index + 1) < var6_6 || var26_29 > var23_23) continue;
                    var27_32 = new StaticTiledMapTile(new lgTextureAtlasRegion((TextureAtlas.AtlasRegion)var24_28));
                    var27_32.setId(var26_29);
                    var27_32.setOffsetX(var12_12);
                    var27_32.setOffsetY(-var13_13);
                    var21_22.putTile(var26_29, (TiledMapTile)var27_32);
                }
            }
            for (XmlReader.Element var23_24 : element.getChildrenByName("tile")) {
                var25_27 = var6_6 + var23_24.getIntAttribute("id", 0);
                var26_30 = var21_22.getTile(var25_27);
                if (var26_30 == null && (var27_32 = var23_24.getChildByName("image")) != null) {
                    var28_34 = var27_32.getAttribute("source");
                    var29_35 = var19_19.findRegion((String)(var28_34 = var28_34.substring(0, var28_34.lastIndexOf(46))));
                    if (var29_35 == null) {
                        throw new GdxRuntimeException("Tileset region not found: ".concat(String.valueOf(var28_34)));
                    }
                    var26_30 = new StaticTiledMapTile(new lgTextureAtlasRegion((TextureAtlas.AtlasRegion)var29_35));
                    var26_30.setId(var25_27);
                    var26_30.setOffsetX(var12_12);
                    var26_30.setOffsetY(-var13_13);
                    var21_22.putTile(var25_27, var26_30);
                }
                if (var26_30 == null) continue;
                var27_32 = var23_24.getAttribute("terrain", null);
                if (var27_32 != null) {
                    var26_30.getProperties().put("terrain", var27_32);
                }
                if ((var28_34 = var23_24.getAttribute("probability", null)) != null) {
                    var26_30.getProperties().put("probability", var28_34);
                }
                if ((var29_35 = var23_24.getChildByName("properties")) == null) continue;
                this.loadProperties(var26_30.getProperties(), (XmlReader.Element)var29_35);
            }
            var23_25 = element.getChildrenByName("tile");
            var24_28 = new Array<T>();
            for (Object var25_26 : var23_25) {
                var27_33 = var25_26.getIntAttribute("id", 0);
                var28_34 = var21_22.getTile(var6_6 + var27_33);
                if (var28_34 == null) continue;
                var29_35 = var25_26.getChildByName("animation");
                if (var29_35 != null) {
                    var30_36 = new Array<T>();
                    var31_37 = new IntArray();
                    for (Object var32_38 : var29_35.getChildrenByName("frame")) {
                        var30_36.add((StaticTiledMapTile)var21_22.getTile(var6_6 + var32_38.getIntAttribute("tileid")));
                        var31_37.add(var32_38.getIntAttribute("duration"));
                    }
                    var32_38 = new AnimatedTiledMapTile((IntArray)var31_37, (Array<StaticTiledMapTile>)var30_36);
                    var32_38.setId(var28_34.getId());
                    var24_28.add(var32_38);
                    var28_34 = var32_38;
                }
                if ((var30_36 = var25_26.getAttribute("terrain", null)) != null) {
                    var28_34.getProperties().put("terrain", var30_36);
                }
                if ((var31_37 = var25_26.getAttribute("probability", null)) != null) {
                    var28_34.getProperties().put("probability", var31_37);
                }
                if ((var32_38 = var25_26.getChildByName("properties")) == null) continue;
                this.loadProperties(var28_34.getProperties(), (XmlReader.Element)var32_38);
            }
            var26_31 = var24_28.iterator();
            while (var26_31.hasNext()) {
                var25_26 = (AnimatedTiledMapTile)var26_31.next();
                var21_22.putTile(var25_26.getId(), (TiledMapTile)var25_26);
            }
            var25_26 = element.getChildByName("properties");
            if (var25_26 != null) {
                this.loadProperties(var21_22.getProperties(), (XmlReader.Element)var25_26);
            }
            map.getTileSets().addTileSet((TiledMapTileSet)var21_22);
        }
    }

    static interface AtlasResolver {
        public TextureAtlas getAtlas(String var1);

        public static class AssetManagerAtlasResolver
        implements AtlasResolver {
            private final AssetManager a;

            public AssetManagerAtlasResolver(AssetManager assetManager) {
                this.a = assetManager;
            }

            @Override
            public TextureAtlas getAtlas(String name) {
                return this.a.get(name, TextureAtlas.class);
            }
        }

        public static class DirectAtlasResolver
        implements AtlasResolver {
            private final ObjectMap<String, TextureAtlas> a;

            public DirectAtlasResolver(ObjectMap<String, TextureAtlas> atlases) {
                this.a = atlases;
            }

            @Override
            public TextureAtlas getAtlas(String name) {
                return this.a.get(name);
            }
        }
    }

    @BA.ShortName(value="lgMapAtlasTmxMapLoaderParameters")
    public static class AtlasTiledMapLoaderParameters
    extends BaseTmxMapLoader.Parameters {
        public boolean forceTextureFilters = false;
    }
}

