/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import anywheresoftware.b4a.libgdx.maps.lgMapObjects;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.objects.TextureMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapImageLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.XmlReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

@BA.Hide
public abstract class BaseTmxMapLoader<P extends AssetLoaderParameters<TiledMap>>
extends AsynchronousAssetLoader<TiledMap, P> {
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int MASK_CLEAR = -536870912;
    protected XmlReader xml = new XmlReader();
    protected XmlReader.Element root;
    protected boolean convertObjectToTileSpace;
    protected int mapTileWidth;
    protected int mapTileHeight;
    protected int mapWidthInPixels;
    protected int mapHeightInPixels;
    protected TiledMap map;

    public BaseTmxMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    protected void loadTileLayer(TiledMap map, XmlReader.Element element) {
        if (element.getName().equals("layer")) {
            int n = element.getIntAttribute("width", 0);
            int n2 = element.getIntAttribute("height", 0);
            int n3 = element.getParent().getIntAttribute("tilewidth", 0);
            int n4 = element.getParent().getIntAttribute("tileheight", 0);
            TiledMapTileLayer tiledMapTileLayer = new TiledMapTileLayer(n, n2, n3, n4);
            this.loadBasicLayerInfo(tiledMapTileLayer, element);
            int[] nArray = BaseTmxMapLoader.getTileIds(element, n, n2);
            TiledMapTileSets tiledMapTileSets = map.getTileSets();
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    int n7 = nArray[n5 * n + n6];
                    boolean bl = (n7 & Integer.MIN_VALUE) != 0;
                    boolean bl2 = (n7 & 0x40000000) != 0;
                    boolean bl3 = (n7 & 0x20000000) != 0;
                    TiledMapTile tiledMapTile = tiledMapTileSets.getTile(n7 & 0x1FFFFFFF);
                    if (tiledMapTile != null) {
                        TiledMapTileLayer.Cell cell = this.createTileLayerCell(bl, bl2, bl3);
                        cell.setTile(tiledMapTile);
                        tiledMapTileLayer.setCell(n6, n2 - 1 - n5, cell);
                    }
                    ++n6;
                }
                ++n5;
            }
            XmlReader.Element element2 = element.getChildByName("properties");
            if (element2 != null) {
                this.loadProperties(tiledMapTileLayer.getProperties(), element2);
            }
            map.getLayers().add(tiledMapTileLayer);
        }
    }

    protected void loadObjectGroup(TiledMap map, XmlReader.Element element) {
        if (element.getName().equals("objectgroup")) {
            String string = element.getAttribute("name", null);
            MapLayer mapLayer = new MapLayer();
            mapLayer.setName(string);
            XmlReader.Element element2 = element.getChildByName("properties");
            if (element2 != null) {
                this.loadProperties(mapLayer.getProperties(), element2);
            }
            for (XmlReader.Element element3 : element.getChildrenByName("object")) {
                this.loadObject(map, mapLayer.getObjects(), element3);
            }
            map.getLayers().add(mapLayer);
        }
    }

    protected void loadImageLayer(TiledMap map, XmlReader.Element element, FileHandle tmxFile, ImageResolver imageResolver) {
        if (element.getName().equals("imagelayer")) {
            Object object;
            Object object2;
            int n = Integer.parseInt(element.getAttribute("x", "0"));
            int n2 = Integer.parseInt(element.getAttribute("y", "0"));
            n2 = this.mapHeightInPixels - n2;
            TextureRegion textureRegion = null;
            XmlReader.Element element2 = element.getChildByName("image");
            if (element2 != null) {
                object2 = element2.getAttribute("source");
                object = BaseTmxMapLoader.getRelativeFileHandle(tmxFile, (String)object2);
                textureRegion = imageResolver.getImage(((FileHandle)object).path());
                n2 -= textureRegion.getRegionHeight();
            }
            object2 = new TiledMapImageLayer(textureRegion, n, n2);
            this.loadBasicLayerInfo((MapLayer)object2, element);
            object = element.getChildByName("properties");
            if (object != null) {
                this.loadProperties(((MapLayer)object2).getProperties(), (XmlReader.Element)object);
            }
            map.getLayers().add((MapLayer)object2);
        }
    }

    protected void loadBasicLayerInfo(MapLayer layer, XmlReader.Element element) {
        String string = element.getAttribute("name", null);
        float f = Float.parseFloat(element.getAttribute("opacity", "1.0"));
        boolean bl = element.getIntAttribute("visible", 1) == 1;
        layer.setName(string);
        layer.setOpacity(f);
        layer.setVisible(bl);
    }

    protected void loadObject(TiledMap map, lgMapObjects mapObj, XmlReader.Element element) {
        if (element.getName().equals("object")) {
            int n;
            String string;
            Object object;
            Object object2;
            MapObject mapObject = null;
            float f = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileWidth : 1.0f;
            float f2 = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileHeight : 1.0f;
            float f3 = element.getFloatAttribute("x", 0.0f) * f;
            float f4 = ((float)this.mapHeightInPixels - element.getFloatAttribute("y", 0.0f)) * f2;
            float f5 = element.getFloatAttribute("width", 0.0f) * f;
            float f6 = element.getFloatAttribute("height", 0.0f) * f2;
            if (element.getChildCount() > 0) {
                Object object3;
                float[] fArray;
                String[] stringArray;
                object2 = element.getChildByName("polygon");
                if (object2 != null) {
                    stringArray = ((XmlReader.Element)object2).getAttribute("points").split(" ");
                    fArray = new float[stringArray.length * 2];
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        object = stringArray[n2].split(",");
                        fArray[n2 * 2] = Float.parseFloat((String)object[0]) * f;
                        fArray[n2 * 2 + 1] = Float.parseFloat((String)object[1]) * -f2;
                        ++n2;
                    }
                    object3 = new Polygon(fArray);
                    ((Polygon)object3).setPosition(f3, f4);
                    mapObject = new PolygonMapObject((Polygon)object3);
                } else {
                    object2 = element.getChildByName("polyline");
                    if (object2 != null) {
                        stringArray = ((XmlReader.Element)object2).getAttribute("points").split(" ");
                        fArray = new float[stringArray.length * 2];
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            object = stringArray[n3].split(",");
                            fArray[n3 * 2] = Float.parseFloat((String)object[0]) * f;
                            fArray[n3 * 2 + 1] = Float.parseFloat((String)object[1]) * -f2;
                            ++n3;
                        }
                        object3 = new Polyline(fArray);
                        ((Polyline)object3).setPosition(f3, f4);
                        mapObject = new PolylineMapObject((Polyline)object3);
                    } else if (element.getChildByName("ellipse") != null) {
                        mapObject = new EllipseMapObject(f3, f4 - f6, f5, f6);
                    }
                }
            }
            if (mapObject == null) {
                object2 = element.getAttribute("gid", null);
                if (object2 != null) {
                    int n4 = (int)Long.parseLong((String)object2);
                    boolean bl = (n4 & Integer.MIN_VALUE) != 0;
                    boolean bl2 = (n4 & 0x40000000) != 0;
                    object = map.getTileSets().getTile(n4 & 0x1FFFFFFF);
                    TextureRegion textureRegion = new TextureRegion(object.getTextureRegion().getInternalObject());
                    textureRegion.flip(bl, bl2);
                    TextureMapObject textureMapObject = new TextureMapObject(new lgTextureRegion(textureRegion));
                    textureMapObject.getProperties().put("gid", n4);
                    textureMapObject.setX(f3);
                    textureMapObject.setY(f4);
                    float f7 = element.getFloatAttribute("width", textureRegion.getRegionWidth());
                    float f8 = element.getFloatAttribute("height", textureRegion.getRegionHeight());
                    textureMapObject.setScaleX(f * (f7 / (float)textureRegion.getRegionWidth()));
                    textureMapObject.setScaleY(f2 * (f8 / (float)textureRegion.getRegionHeight()));
                    textureMapObject.setRotation(element.getFloatAttribute("rotation", 0.0f));
                    mapObject = textureMapObject;
                } else {
                    mapObject = new RectangleMapObject(f3, f4 - f6, f5, f6);
                }
            }
            mapObject.setName(element.getAttribute("name", null));
            object2 = element.getAttribute("rotation", null);
            if (object2 != null) {
                mapObject.getProperties().put("rotation", Float.valueOf(Float.parseFloat((String)object2)));
            }
            if ((string = element.getAttribute("type", null)) != null) {
                mapObject.getProperties().put("type", string);
            }
            if ((n = element.getIntAttribute("id", 0)) != 0) {
                mapObject.getProperties().put("id", n);
            }
            mapObject.getProperties().put("x", Float.valueOf(f3 * f));
            mapObject.getProperties().put("y", Float.valueOf((f4 - f6) * f2));
            mapObject.getProperties().put("raw_y", Float.valueOf(element.getFloatAttribute("y", 0.0f)));
            mapObject.getProperties().put("width", Float.valueOf(f5));
            mapObject.getProperties().put("height", Float.valueOf(f6));
            mapObject.setVisible(element.getIntAttribute("visible", 1) == 1);
            XmlReader.Element element2 = element.getChildByName("properties");
            if (element2 != null) {
                this.loadProperties(mapObject.getProperties(), element2);
            }
            mapObj.add(mapObject);
        }
    }

    protected void loadProperties(MapProperties properties, XmlReader.Element element) {
        if (element == null) {
            return;
        }
        if (element.getName().equals("properties")) {
            for (XmlReader.Element element2 : element.getChildrenByName("property")) {
                String string = element2.getAttribute("name", null);
                String string2 = element2.getAttribute("value", null);
                if (string2 == null) {
                    string2 = element2.getText();
                }
                properties.put(string, string2);
            }
        }
    }

    protected TiledMapTileLayer.Cell createTileLayerCell(boolean flipHorizontally, boolean flipVertically, boolean flipDiagonally) {
        TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
        if (flipDiagonally) {
            if (flipHorizontally && flipVertically) {
                cell.setFlipHorizontally(true);
                cell.setRotation(3);
            } else if (flipHorizontally) {
                cell.setRotation(3);
            } else if (flipVertically) {
                cell.setRotation(1);
            } else {
                cell.setFlipVertically(true);
                cell.setRotation(3);
            }
        } else {
            cell.setFlipHorizontally(flipHorizontally);
            cell.setFlipVertically(flipVertically);
        }
        return cell;
    }

    public static int[] getTileIds(XmlReader.Element element, int width, int height) {
        XmlReader.Element element2 = element.getChildByName("data");
        String string = element2.getAttribute("encoding", null);
        if (string == null) {
            throw new GdxRuntimeException("Unsupported encoding (XML) for TMX Layer Data");
        }
        int[] nArray = new int[width * height];
        if (string.equals("csv")) {
            String[] stringArray = element2.getText().split(",");
            int n = 0;
            while (n < stringArray.length) {
                nArray[n] = (int)Long.parseLong(stringArray[n].trim());
                ++n;
            }
        } else if (string.equals("base64")) {
            InputStream inputStream = null;
            try {
                try {
                    String string2 = element2.getAttribute("compression", null);
                    byte[] byArray = Base64Coder.decode(element2.getText());
                    if (string2 == null) {
                        inputStream = new ByteArrayInputStream(byArray);
                    } else if (string2.equals("gzip")) {
                        inputStream = new BufferedInputStream(new GZIPInputStream((InputStream)new ByteArrayInputStream(byArray), byArray.length));
                    } else if (string2.equals("zlib")) {
                        inputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
                    } else {
                        throw new GdxRuntimeException("Unrecognised compression (" + string2 + ") for TMX Layer Data");
                    }
                    byte[] byArray2 = new byte[4];
                    int n = 0;
                    while (n < height) {
                        int n2 = 0;
                        while (n2 < width) {
                            int n3 = inputStream.read(byArray2);
                            while (n3 < 4) {
                                int n4 = inputStream.read(byArray2, n3, 4 - n3);
                                if (n4 == -1) break;
                                n3 += n4;
                            }
                            if (n3 != 4) {
                                throw new GdxRuntimeException("Error Reading TMX Layer Data: Premature end of tile data");
                            }
                            nArray[n * width + n2] = BaseTmxMapLoader.unsignedByteToInt(byArray2[0]) | BaseTmxMapLoader.unsignedByteToInt(byArray2[1]) << 8 | BaseTmxMapLoader.unsignedByteToInt(byArray2[2]) << 16 | BaseTmxMapLoader.unsignedByteToInt(byArray2[3]) << 24;
                            ++n2;
                        }
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    throw new GdxRuntimeException("Error Reading TMX Layer Data - IOException: " + iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(inputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(inputStream);
        } else {
            throw new GdxRuntimeException("Unrecognised encoding (" + string + ") for TMX Layer Data");
        }
        return nArray;
    }

    protected static int unsignedByteToInt(byte b2) {
        return b2 & 0xFF;
    }

    protected static FileHandle getRelativeFileHandle(FileHandle file, String path) {
        StringTokenizer stringTokenizer = new StringTokenizer(path, "\\/");
        FileHandle fileHandle = file.parent();
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            fileHandle = string.equals("..") ? fileHandle.parent() : fileHandle.child(string);
        }
        return fileHandle;
    }

    @BA.Hide
    public static class Parameters
    extends AssetLoaderParameters<TiledMap> {
        public boolean generateMipMaps = false;
        public Texture.TextureFilter textureMinFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter textureMagFilter = Texture.TextureFilter.Nearest;
        public boolean convertObjectToTileSpace = false;
    }
}

