/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;

@BA.Hide
public class TideMapLoader
extends SynchronousAssetLoader<TiledMap, Parameters> {
    private XmlReader a = new XmlReader();
    private XmlReader.Element b;

    public TideMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TideMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public TiledMap load(String fileName) {
        try {
            FileHandle fileHandle = this.resolve(fileName);
            this.b = this.a.parse(fileHandle);
            ObjectMap<String, Texture> objectMap = new ObjectMap<String, Texture>();
            for (FileHandle object2 : TideMapLoader.a(this.b, fileHandle)) {
                objectMap.put(object2.path(), new Texture(object2));
            }
            ImageResolver.DirectImageResolver directImageResolver = new ImageResolver.DirectImageResolver(objectMap);
            TiledMap tiledMap = TideMapLoader.a(this.b, fileHandle, directImageResolver);
            tiledMap.setOwnedResources(objectMap.values().toArray());
            return tiledMap;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", iOException);
        }
    }

    @Override
    public TiledMap load(AssetManager assetManager, String fileName, FileHandle tideFile, Parameters parameter) {
        try {
            return TideMapLoader.a(this.b, tideFile, new ImageResolver.AssetManagerImageResolver(assetManager));
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", exception);
        }
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle tmxFile, Parameters parameter) {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        try {
            this.b = this.a.parse(tmxFile);
            for (FileHandle fileHandle : TideMapLoader.a(this.b, tmxFile)) {
                array.add(new AssetDescriptor<Texture>(fileHandle.path(), Texture.class));
            }
            return array;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", iOException);
        }
    }

    private static TiledMap a(XmlReader.Element element, FileHandle fileHandle, ImageResolver imageResolver) {
        TiledMap tiledMap = new TiledMap();
        XmlReader.Element element2 = element.getChildByName("Properties");
        if (element2 != null) {
            TideMapLoader.a(tiledMap.getProperties(), element2);
        }
        for (XmlReader.Element element3 : element.getChildByName("TileSheets").getChildrenByName("TileSheet")) {
            TideMapLoader.a(tiledMap, element3, fileHandle, imageResolver);
        }
        for (XmlReader.Element element4 : element.getChildByName("Layers").getChildrenByName("Layer")) {
            TideMapLoader.a(tiledMap, element4);
        }
        return tiledMap;
    }

    private static Array<FileHandle> a(XmlReader.Element element, FileHandle fileHandle) throws IOException {
        Array<FileHandle> array = new Array<FileHandle>();
        Iterator<XmlReader.Element> iterator = element.getChildByName("TileSheets").getChildrenByName("TileSheet").iterator();
        while (iterator.hasNext()) {
            XmlReader.Element element2 = iterator.next().getChildByName("ImageSource");
            FileHandle fileHandle2 = TideMapLoader.a(fileHandle, element2.getText());
            array.add(fileHandle2);
        }
        return array;
    }

    private static void a(TiledMap tiledMap, XmlReader.Element element, FileHandle fileHandle, ImageResolver imageResolver) {
        if (element.getName().equals("TileSheet")) {
            TiledMapTileSet tiledMapTileSet2;
            String string = element.getAttribute("Id");
            element.getChildByName("Description").getText();
            String string2 = element.getChildByName("ImageSource").getText();
            XmlReader.Element element2 = element.getChildByName("Alignment");
            String string3 = element2.getAttribute("SheetSize");
            String string4 = element2.getAttribute("TileSize");
            String string5 = element2.getAttribute("Margin");
            element2.getAttribute("Spacing");
            String[] stringArray = string3.split(" x ");
            Integer.parseInt(stringArray[0]);
            Integer.parseInt(stringArray[1]);
            String[] stringArray2 = string4.split(" x ");
            int n = Integer.parseInt(stringArray2[0]);
            int n2 = Integer.parseInt(stringArray2[1]);
            String[] stringArray3 = string5.split(" x ");
            int n3 = Integer.parseInt(stringArray3[0]);
            int n4 = Integer.parseInt(stringArray3[1]);
            String[] stringArray4 = string5.split(" x ");
            int n5 = Integer.parseInt(stringArray4[0]);
            int n6 = Integer.parseInt(stringArray4[1]);
            FileHandle fileHandle2 = TideMapLoader.a(fileHandle, string2);
            TextureRegion textureRegion = imageResolver.getImage(fileHandle2.path());
            TiledMapTileSets tiledMapTileSets = tiledMap.getTileSets();
            int n7 = 1;
            for (TiledMapTileSet tiledMapTileSet2 : tiledMapTileSets) {
                n7 += tiledMapTileSet2.size();
            }
            tiledMapTileSet2 = new TiledMapTileSet();
            tiledMapTileSet2.setName(string);
            tiledMapTileSet2.getProperties().put("firstgid", n7);
            int n8 = n7;
            int n9 = textureRegion.getRegionWidth() - n;
            int n10 = textureRegion.getRegionHeight() - n2;
            int n11 = n4;
            while (n11 <= n10) {
                int n12 = n3;
                while (n12 <= n9) {
                    lgTextureRegion lgTextureRegion2 = new lgTextureRegion(new TextureRegion(textureRegion, n12, n11, n, n2));
                    StaticTiledMapTile staticTiledMapTile = new StaticTiledMapTile(lgTextureRegion2);
                    staticTiledMapTile.setId(n8);
                    tiledMapTileSet2.putTile(n8++, staticTiledMapTile);
                    n12 += n + n5;
                }
                n11 += n2 + n6;
            }
            XmlReader.Element element3 = element.getChildByName("Properties");
            if (element3 != null) {
                TideMapLoader.a(tiledMapTileSet2.getProperties(), element3);
            }
            tiledMapTileSets.addTileSet(tiledMapTileSet2);
        }
    }

    private static void a(TiledMap tiledMap, XmlReader.Element element) {
        if (element.getName().equals("Layer")) {
            String string = element.getAttribute("Id");
            String string2 = element.getAttribute("Visible");
            XmlReader.Element element2 = element.getChildByName("Dimensions");
            String string3 = element2.getAttribute("LayerSize");
            String string4 = element2.getAttribute("TileSize");
            String[] stringArray = string3.split(" x ");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            String[] stringArray2 = string4.split(" x ");
            int n3 = Integer.parseInt(stringArray2[0]);
            int n4 = Integer.parseInt(stringArray2[1]);
            TiledMapTileLayer tiledMapTileLayer = new TiledMapTileLayer(n, n2, n3, n4);
            tiledMapTileLayer.setName(string);
            tiledMapTileLayer.setVisible(string2.equalsIgnoreCase("True"));
            Array<XmlReader.Element> array = element.getChildByName("TileArray").getChildrenByName("Row");
            TiledMapTileSets tiledMapTileSets = tiledMap.getTileSets();
            TiledMapTileSet tiledMapTileSet = null;
            int n5 = 0;
            int n6 = 0;
            int n7 = array.size;
            while (n6 < n7) {
                XmlReader.Element element3 = array.get(n6);
                int n8 = n7 - 1 - n6;
                int n9 = 0;
                int n10 = 0;
                int n11 = element3.getChildCount();
                while (n10 < n11) {
                    XmlReader.Element element4 = element3.getChild(n10);
                    String string5 = element4.getName();
                    if (string5.equals("TileSheet")) {
                        tiledMapTileSet = tiledMapTileSets.getTileSet(element4.getAttribute("Ref"));
                        n5 = tiledMapTileSet.getProperties().get("firstgid", Integer.class);
                    } else if (string5.equals("Null")) {
                        n9 += element4.getIntAttribute("Count");
                    } else if (string5.equals("Static")) {
                        TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
                        cell.setTile(tiledMapTileSet.getTile(n5 + element4.getIntAttribute("Index")));
                        tiledMapTileLayer.setCell(n9++, n8, cell);
                    } else if (string5.equals("Animated")) {
                        int n12 = element4.getInt("Interval");
                        XmlReader.Element element5 = element4.getChildByName("Frames");
                        Array<StaticTiledMapTile> array2 = new Array<StaticTiledMapTile>();
                        int n13 = 0;
                        int n14 = element5.getChildCount();
                        while (n13 < n14) {
                            XmlReader.Element element6 = element5.getChild(n13);
                            String string6 = element6.getName();
                            if (string6.equals("TileSheet")) {
                                tiledMapTileSet = tiledMapTileSets.getTileSet(element6.getAttribute("Ref"));
                                n5 = tiledMapTileSet.getProperties().get("firstgid", Integer.class);
                            } else if (string6.equals("Static")) {
                                array2.add((StaticTiledMapTile)tiledMapTileSet.getTile(n5 + element6.getIntAttribute("Index")));
                            }
                            ++n13;
                        }
                        TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
                        cell.setTile(new AnimatedTiledMapTile((float)n12 / 1000.0f, array2));
                        tiledMapTileLayer.setCell(n9++, n8, cell);
                    }
                    ++n10;
                }
                ++n6;
            }
            XmlReader.Element element7 = element.getChildByName("Properties");
            if (element7 != null) {
                TideMapLoader.a(tiledMapTileLayer.getProperties(), element7);
            }
            tiledMap.getLayers().add(tiledMapTileLayer);
        }
    }

    private static void a(MapProperties mapProperties, XmlReader.Element element) {
        if (element.getName().equals("Properties")) {
            for (XmlReader.Element element2 : element.getChildrenByName("Property")) {
                String string = element2.getAttribute("Key", null);
                String string2 = element2.getAttribute("Type", null);
                String string3 = element2.getText();
                if (string2.equals("Int32")) {
                    mapProperties.put(string, Integer.parseInt(string3));
                    continue;
                }
                if (!string2.equals("String") && string2.equals("Boolean")) {
                    mapProperties.put(string, string3.equalsIgnoreCase("true"));
                    continue;
                }
                mapProperties.put(string, string3);
            }
        }
    }

    private static FileHandle a(FileHandle fileHandle, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
        FileHandle fileHandle2 = fileHandle.parent();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            fileHandle2 = string2.equals("..") ? fileHandle2.parent() : fileHandle2.child(string2);
        }
        return fileHandle2;
    }

    @BA.Hide
    public static class Parameters
    extends AssetLoaderParameters<TiledMap> {
    }
}

