/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import anywheresoftware.b4a.libgdx.maps.lgMapProperties;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.XmlReader;
import java.io.IOException;
import java.util.Iterator;

@BA.Hide
public class TmxMapLoader
extends BaseTmxMapLoader<Parameters> {
    public TmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TmxMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public TiledMap load(String fileName) {
        return this.load(fileName, new Parameters());
    }

    public TiledMap load(String fileName, Parameters parameters) {
        try {
            this.convertObjectToTileSpace = parameters.convertObjectToTileSpace;
            FileHandle fileHandle = this.resolve(fileName);
            this.root = this.xml.parse(fileHandle);
            ObjectMap<String, Texture> objectMap = new ObjectMap<String, Texture>();
            TmxMapLoader tmxMapLoader = this;
            Array<FileHandle> array = tmxMapLoader.loadTilesets(tmxMapLoader.root, fileHandle);
            TmxMapLoader tmxMapLoader2 = this;
            array.addAll(tmxMapLoader2.loadImages(tmxMapLoader2.root, fileHandle));
            for (FileHandle object2 : array) {
                Texture texture = new Texture(object2, parameters.generateMipMaps);
                texture.setFilter(parameters.textureMinFilter, parameters.textureMagFilter);
                objectMap.put(object2.path(), texture);
            }
            ImageResolver.DirectImageResolver directImageResolver = new ImageResolver.DirectImageResolver(objectMap);
            TmxMapLoader tmxMapLoader3 = this;
            TiledMap tiledMap = tmxMapLoader3.loadTilemap(tmxMapLoader3.root, fileHandle, directImageResolver);
            tiledMap.setOwnedResources(objectMap.values().toArray());
            return tiledMap;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", iOException);
        }
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle tmxFile, Parameters parameter) {
        this.map = null;
        this.convertObjectToTileSpace = parameter != null ? parameter.convertObjectToTileSpace : false;
        try {
            this.map = this.loadTilemap(this.root, tmxFile, new ImageResolver.AssetManagerImageResolver(manager));
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", exception);
        }
    }

    @Override
    public TiledMap loadSync(AssetManager manager, String fileName, FileHandle file, Parameters parameter) {
        return this.map;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle tmxFile, Parameters parameter) {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        try {
            this.root = this.xml.parse(tmxFile);
            boolean bl = parameter != null ? parameter.generateMipMaps : false;
            TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
            new TextureLoader.TextureParameter().genMipMaps = bl;
            if (parameter != null) {
                textureParameter.minFilter = parameter.textureMinFilter;
                textureParameter.magFilter = parameter.textureMagFilter;
            }
            TmxMapLoader tmxMapLoader = this;
            for (FileHandle fileHandle : tmxMapLoader.loadTilesets(tmxMapLoader.root, tmxFile)) {
                array.add(new AssetDescriptor<Texture>(fileHandle, Texture.class, textureParameter));
            }
            TmxMapLoader tmxMapLoader2 = this;
            for (FileHandle fileHandle : tmxMapLoader2.loadImages(tmxMapLoader2.root, tmxFile)) {
                array.add(new AssetDescriptor<Texture>(fileHandle, Texture.class, textureParameter));
            }
            return array;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load tilemap '" + fileName + "'", iOException);
        }
    }

    protected TiledMap loadTilemap(XmlReader.Element root, FileHandle tmxFile, ImageResolver imageResolver) {
        XmlReader.Element element;
        TiledMap tiledMap = new TiledMap();
        String string = root.getAttribute("orientation", null);
        int n = root.getIntAttribute("width", 0);
        int n2 = root.getIntAttribute("height", 0);
        int n3 = root.getIntAttribute("tilewidth", 0);
        int n4 = root.getIntAttribute("tileheight", 0);
        String string2 = root.getAttribute("backgroundcolor", null);
        lgMapProperties lgMapProperties2 = tiledMap.getProperties();
        if (string != null) {
            lgMapProperties2.put("orientation", string);
        }
        lgMapProperties2.put("width", n);
        lgMapProperties2.put("height", n2);
        lgMapProperties2.put("tilewidth", n3);
        lgMapProperties2.put("tileheight", n4);
        if (string2 != null) {
            lgMapProperties2.put("backgroundcolor", string2);
        }
        this.mapTileWidth = n3;
        this.mapTileHeight = n4;
        this.mapWidthInPixels = n * n3;
        this.mapHeightInPixels = n2 * n4;
        if (string != null && "staggered".equals(string) && n2 > 1) {
            this.mapWidthInPixels += n3 / 2;
            this.mapHeightInPixels = this.mapHeightInPixels / 2 + n4 / 2;
        }
        if ((element = root.getChildByName("properties")) != null) {
            this.loadProperties(tiledMap.getProperties(), element);
        }
        for (XmlReader.Element element2 : root.getChildrenByName("tileset")) {
            this.loadTileSet(tiledMap, element2, tmxFile, imageResolver);
            root.removeChild(element2);
        }
        int n5 = 0;
        int n6 = root.getChildCount();
        while (n5 < n6) {
            XmlReader.Element element3 = root.getChild(n5);
            String string3 = element3.getName();
            if (string3.equals("layer")) {
                this.loadTileLayer(tiledMap, element3);
            } else if (string3.equals("objectgroup")) {
                this.loadObjectGroup(tiledMap, element3);
            } else if (string3.equals("imagelayer")) {
                this.loadImageLayer(tiledMap, element3, tmxFile, imageResolver);
            }
            ++n5;
        }
        return tiledMap;
    }

    protected Array<FileHandle> loadTilesets(XmlReader.Element root, FileHandle tmxFile) throws IOException {
        Array<FileHandle> array = new Array<FileHandle>();
        for (XmlReader.Element element : root.getChildrenByName("tileset")) {
            Object object;
            Object object2;
            Object object3;
            String string = element.getAttribute("source", null);
            if (string != null) {
                FileHandle fileHandle = TmxMapLoader.getRelativeFileHandle(tmxFile, string);
                element = this.xml.parse(fileHandle);
                if (element.getChildByName("image") != null) {
                    object3 = element.getChildByName("image").getAttribute("source");
                    object2 = TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object3);
                    array.add((FileHandle)object2);
                    continue;
                }
                object2 = element.getChildrenByName("tile").iterator();
                while (object2.hasNext()) {
                    object = ((XmlReader.Element)object2.next()).getChildByName("image").getAttribute("source");
                    FileHandle fileHandle2 = TmxMapLoader.getRelativeFileHandle(fileHandle, (String)object);
                    array.add(fileHandle2);
                }
                continue;
            }
            if (element.getChildByName("image") != null) {
                String string2 = element.getChildByName("image").getAttribute("source");
                object3 = TmxMapLoader.getRelativeFileHandle(tmxFile, string2);
                array.add((FileHandle)object3);
                continue;
            }
            object3 = element.getChildrenByName("tile").iterator();
            while (object3.hasNext()) {
                object2 = ((XmlReader.Element)object3.next()).getChildByName("image").getAttribute("source");
                object = TmxMapLoader.getRelativeFileHandle(tmxFile, (String)object2);
                array.add((FileHandle)object);
            }
        }
        return array;
    }

    protected Array<FileHandle> loadImages(XmlReader.Element root, FileHandle tmxFile) throws IOException {
        Array<FileHandle> array = new Array<FileHandle>();
        Iterator<XmlReader.Element> iterator = root.getChildrenByName("imagelayer").iterator();
        while (iterator.hasNext()) {
            FileHandle fileHandle;
            String string = iterator.next().getChildByName("image").getAttribute("source", null);
            if (string == null || array.contains(fileHandle = TmxMapLoader.getRelativeFileHandle(tmxFile, string), false)) continue;
            array.add(fileHandle);
        }
        return array;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void loadTileSet(TiledMap map, XmlReader.Element element, FileHandle tmxFile, ImageResolver imageResolver) {
        if (element.getName().equals("tileset")) {
            var5_5 = element.get("name", null);
            var6_6 = element.getIntAttribute("firstgid", 1);
            var7_7 = element.getIntAttribute("tilewidth", 0);
            var8_8 = element.getIntAttribute("tileheight", 0);
            var9_9 = element.getIntAttribute("spacing", 0);
            var10_10 = element.getIntAttribute("margin", 0);
            var11_11 = element.getAttribute("source", null);
            var12_12 = 0;
            var13_13 = 0;
            var14_14 = "";
            var15_15 = 0;
            var16_16 = 0;
            var17_17 = null;
            if (var11_11 != null) {
                var18_18 = TmxMapLoader.getRelativeFileHandle(tmxFile, var11_11);
                try {
                    element = this.xml.parse((FileHandle)var18_18);
                    var5_5 = element.get("name", null);
                    var7_7 = element.getIntAttribute("tilewidth", 0);
                    var8_8 = element.getIntAttribute("tileheight", 0);
                    var9_9 = element.getIntAttribute("spacing", 0);
                    var10_10 = element.getIntAttribute("margin", 0);
                    var19_19 = element.getChildByName("tileoffset");
                    if (var19_19 != null) {
                        var12_12 = var19_19.getIntAttribute("x", 0);
                        var13_13 = var19_19.getIntAttribute("y", 0);
                    }
                    if ((var20_20 = element.getChildByName("image")) == null) ** GOTO lbl45
                    var14_14 = var20_20.getAttribute("source");
                    var15_15 = var20_20.getIntAttribute("width", 0);
                    var16_16 = var20_20.getIntAttribute("height", 0);
                    var17_17 = TmxMapLoader.getRelativeFileHandle((FileHandle)var18_18, var14_14);
                }
                catch (IOException v0) {
                    throw new GdxRuntimeException("Error parsing external tileset.");
                }
            } else {
                var18_18 = element.getChildByName("tileoffset");
                if (var18_18 != null) {
                    var12_12 = var18_18.getIntAttribute("x", 0);
                    var13_13 = var18_18.getIntAttribute("y", 0);
                }
                if ((var19_19 = element.getChildByName("image")) != null) {
                    var14_14 = var19_19.getAttribute("source");
                    var15_15 = var19_19.getIntAttribute("width", 0);
                    var16_16 = var19_19.getIntAttribute("height", 0);
                    var17_17 = TmxMapLoader.getRelativeFileHandle(tmxFile, var14_14);
                }
            }
lbl45:
            // 5 sources

            var18_18 = new TiledMapTileSet();
            var18_18.setName(var5_5);
            var18_18.getProperties().put("firstgid", var6_6);
            if (var17_17 != null) {
                var19_19 = imageResolver.getImage(var17_17.path());
                var20_20 = var18_18.getProperties();
                var20_20.put("imagesource", var14_14);
                var20_20.put("imagewidth", var15_15);
                var20_20.put("imageheight", var16_16);
                var20_20.put("tilewidth", var7_7);
                var20_20.put("tileheight", var8_8);
                var20_20.put("margin", var10_10);
                var20_20.put("spacing", var9_9);
                var21_21 = var19_19.getRegionWidth() - var7_7;
                var22_26 = var19_19.getRegionHeight() - var8_8;
                var23_29 = var6_6;
                var24_32 = var10_10;
                while (var24_32 <= var22_26) {
                    var25_35 = var10_10;
                    while (var25_35 <= var21_21) {
                        var26_38 = new TextureRegion((TextureRegion)var19_19, var25_35, var24_32, var7_7, var8_8);
                        var27_39 = new StaticTiledMapTile(new lgTextureRegion((TextureRegion)var26_38));
                        var27_39.setId(var23_29);
                        var27_39.setOffsetX(var12_12);
                        var27_39.setOffsetY(-var13_13);
                        var18_18.putTile(var23_29++, (TiledMapTile)var27_39);
                        var25_35 += var7_7 + var9_9;
                    }
                    var24_32 += var8_8 + var9_9;
                }
            } else {
                for (Object var20_20 : element.getChildrenByName("tile")) {
                    var22_27 = var20_20.getChildByName("image");
                    if (var22_27 != null) {
                        var14_14 = var22_27.getAttribute("source");
                        var22_27.getIntAttribute("width", 0);
                        var22_27.getIntAttribute("height", 0);
                        var17_17 = TmxMapLoader.getRelativeFileHandle(tmxFile, var14_14);
                    }
                    var23_30 = imageResolver.getImage(var17_17.path());
                    var24_33 = new StaticTiledMapTile(new lgTextureRegion(var23_30));
                    var24_33.setId(var6_6 + var20_20.getIntAttribute("id"));
                    var24_33.setOffsetX(var12_12);
                    var24_33.setOffsetY(-var13_13);
                    var18_18.putTile(var24_33.getId(), var24_33);
                }
            }
            var19_19 = element.getChildrenByName("tile");
            var20_20 = new Array<T>();
            for (XmlReader.Element var21_23 : var19_19) {
                var23_31 = var21_23.getIntAttribute("id", 0);
                var24_34 = var18_18.getTile(var6_6 + var23_31);
                if (var24_34 == null) continue;
                var25_37 = var21_23.getChildByName("animation");
                if (var25_37 != null) {
                    var26_38 = new Array<T>();
                    var27_39 = new IntArray();
                    var29_41 = var25_37.getChildrenByName("frame").iterator();
                    while (var29_41.hasNext()) {
                        var28_40 = var29_41.next();
                        var26_38.add((StaticTiledMapTile)var18_18.getTile(var6_6 + var28_40.getIntAttribute("tileid")));
                        var27_39.add(var28_40.getIntAttribute("duration"));
                    }
                    var28_40 = new AnimatedTiledMapTile((IntArray)var27_39, (Array<StaticTiledMapTile>)var26_38);
                    var28_40.setId(var24_34.getId());
                    var20_20.add(var28_40);
                    var24_34 = var28_40;
                }
                if ((var26_38 = var21_23.getChildByName("objectgroup")) != null) {
                    var28_40 = var26_38.getChildrenByName("object").iterator();
                    while (var28_40.hasNext()) {
                        var27_39 = var28_40.next();
                        this.loadObject(map, var24_34.getObjects(), (XmlReader.Element)var27_39);
                    }
                }
                if ((var27_39 = var21_23.getAttribute("terrain", null)) != null) {
                    var24_34.getProperties().put("terrain", var27_39);
                }
                if ((var28_40 = var21_23.getAttribute("probability", null)) != null) {
                    var24_34.getProperties().put("probability", var28_40);
                }
                if ((var29_41 = var21_23.getChildByName("properties")) == null) continue;
                this.loadProperties(var24_34.getProperties(), (XmlReader.Element)var29_41);
            }
            var22_28 = var20_20.iterator();
            while (var22_28.hasNext()) {
                var21_24 = (AnimatedTiledMapTile)var22_28.next();
                var18_18.putTile(var21_24.getId(), var21_24);
            }
            var21_25 = element.getChildByName("properties");
            if (var21_25 != null) {
                this.loadProperties(var18_18.getProperties(), var21_25);
            }
            map.getTileSets().addTileSet((TiledMapTileSet)var18_18);
        }
    }

    public FileHandleResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(FileHandleResolver Resolver) {
        this.resolver = Resolver;
    }

    @BA.ShortName(value="lgMapTmxMapLoaderParameters")
    public static class Parameters
    extends BaseTmxMapLoader.Parameters {
    }
}

