/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapImageLayer;
import com.badlogic.gdx.maps.tiled.TiledMapRenderer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Disposable;

@BA.Hide
public abstract class BatchTiledMapRenderer
implements TiledMapRenderer,
Disposable {
    protected static final int NUM_VERTICES = 20;
    protected TiledMap map;
    protected float unitScale;
    protected Batch batch;
    protected Rectangle viewBounds;
    protected Rectangle imageBounds = new Rectangle();
    protected boolean ownsBatch;
    protected float[] vertices = new float[20];

    public TiledMap getMap() {
        return this.map;
    }

    public void setMap(TiledMap map) {
        this.map = map;
    }

    public float getUnitScale() {
        return this.unitScale;
    }

    public Rectangle getViewBounds() {
        return this.viewBounds;
    }

    public BatchTiledMapRenderer() {
        this.viewBounds = new Rectangle();
    }

    public BatchTiledMapRenderer(TiledMap map) {
        this(map, 1.0f);
    }

    public BatchTiledMapRenderer(TiledMap map, float unitScale) {
        this.map = map;
        this.unitScale = unitScale;
        this.viewBounds = new Rectangle();
        this.batch = new SpriteBatch();
        this.ownsBatch = true;
    }

    public BatchTiledMapRenderer(TiledMap map, Batch batch) {
        this(map, 1.0f, batch);
    }

    public BatchTiledMapRenderer(TiledMap map, float unitScale, Batch batch) {
        this.map = map;
        this.unitScale = unitScale;
        this.viewBounds = new Rectangle();
        this.batch = batch;
        this.ownsBatch = false;
    }

    @Override
    @BA.Hide
    public void setView(OrthographicCamera camera) {
        this.batch.setProjectionMatrix(camera.combined);
        float f = camera.viewportWidth * camera.zoom;
        float f2 = camera.viewportHeight * camera.zoom;
        this.viewBounds.Set(camera.position.x - f / 2.0f, camera.position.y - f2 / 2.0f, f, f2);
    }

    @Override
    public void setView(Matrix4 projection, float x, float y, float width, float height) {
        this.batch.setProjectionMatrix(projection);
        this.viewBounds.Set(x, y, width, height);
    }

    @Override
    public void Render() {
        this.beginRender();
        for (MapLayer mapLayer : this.map.getLayers()) {
            if (!mapLayer.isVisible()) continue;
            if (mapLayer instanceof TiledMapTileLayer) {
                this.renderTileLayer((TiledMapTileLayer)mapLayer);
            }
            if (mapLayer instanceof TiledMapImageLayer) {
                this.renderImageLayer((TiledMapImageLayer)mapLayer);
                continue;
            }
            this.renderObjects(mapLayer);
        }
        this.endRender();
    }

    @Override
    public void Render2(int[] layers) {
        this.beginRender();
        int[] nArray = layers;
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            MapLayer mapLayer = this.map.getLayers().get(n3);
            if (mapLayer.isVisible()) {
                if (mapLayer instanceof TiledMapTileLayer) {
                    this.renderTileLayer((TiledMapTileLayer)mapLayer);
                } else if (mapLayer instanceof TiledMapImageLayer) {
                    this.renderImageLayer((TiledMapImageLayer)mapLayer);
                } else {
                    this.renderObjects(mapLayer);
                }
            }
            ++n2;
        }
        this.endRender();
    }

    @Override
    @BA.Hide
    public void renderObjects(MapLayer layer) {
        for (MapObject mapObject : layer.getObjects()) {
            this.renderObject(mapObject);
        }
    }

    @Override
    @BA.Hide
    public void renderObject(MapObject object) {
    }

    @Override
    public void renderImageLayer(TiledMapImageLayer layer) {
        this.renderImageLayerAt(layer, 0.0f, 0.0f);
    }

    public void renderImageLayerAt(TiledMapImageLayer layer, float PosX, float PosY) {
        Color color = this.batch.getColor();
        float f = Color.toFloatBits(color.r, color.g, color.b, color.a * layer.getOpacity());
        float[] fArray = this.vertices;
        lgTextureRegion lgTextureRegion2 = layer.getTextureRegion();
        if (lgTextureRegion2 == null) {
            return;
        }
        float f2 = layer.getX();
        float f3 = layer.getY();
        float f4 = f2 * this.unitScale + PosX;
        float f5 = f3 * this.unitScale + PosY;
        float f6 = f4 + (float)lgTextureRegion2.getRegionWidth() * this.unitScale;
        float f7 = f5 + (float)lgTextureRegion2.getRegionHeight() * this.unitScale;
        this.imageBounds.Set(f4, f5, f6 - f4, f7 - f5);
        if (this.viewBounds.contains(this.imageBounds) || this.viewBounds.overlaps(this.imageBounds)) {
            float f8 = lgTextureRegion2.getU();
            float f9 = lgTextureRegion2.getV2();
            float f10 = lgTextureRegion2.getU2();
            float f11 = lgTextureRegion2.getV();
            fArray[0] = f4;
            fArray[1] = f5;
            fArray[2] = f;
            fArray[3] = f8;
            fArray[4] = f9;
            fArray[5] = f4;
            fArray[6] = f7;
            fArray[7] = f;
            fArray[8] = f8;
            fArray[9] = f11;
            fArray[10] = f6;
            fArray[11] = f7;
            fArray[12] = f;
            fArray[13] = f10;
            fArray[14] = f11;
            fArray[15] = f6;
            fArray[16] = f5;
            fArray[17] = f;
            fArray[18] = f10;
            fArray[19] = f9;
            this.batch.draw(lgTextureRegion2.getTexture().getInternalObject(), fArray, 0, 20);
        }
    }

    protected void beginRender() {
        AnimatedTiledMapTile.updateAnimationBaseTime();
        this.batch.begin();
    }

    protected void endRender() {
        this.batch.end();
    }

    public boolean IsInitialized() {
        return this.batch != null;
    }

    @Override
    public void dispose() {
        if (this.ownsBatch) {
            this.batch.dispose();
        }
        this.batch = null;
        this.map = null;
    }
}

