/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;

@BA.Hide
public class HexagonalTiledMapRenderer
extends BatchTiledMapRenderer {
    public HexagonalTiledMapRenderer() {
    }

    public HexagonalTiledMapRenderer(TiledMap map) {
        super(map);
    }

    public HexagonalTiledMapRenderer(TiledMap map, float unitScale) {
        super(map, unitScale);
    }

    public HexagonalTiledMapRenderer(TiledMap map, Batch batch) {
        super(map, batch);
    }

    public HexagonalTiledMapRenderer(TiledMap map, float unitScale, Batch batch) {
        super(map, unitScale, batch);
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer layer) {
        Color color = this.batch.getColor();
        float f = Color.toFloatBits(color.r, color.g, color.b, color.a * layer.getOpacity());
        int n = layer.getWidth();
        int n2 = layer.getHeight();
        int n3 = n * (layer.getRepeatX() + 1);
        int n4 = n2 * (layer.getRepeatY() + 1);
        float f2 = layer.getTileWidth() * this.unitScale;
        float f3 = layer.getTileHeight() * this.unitScale;
        float f4 = f2 * 0.25f;
        float f5 = f2 * 0.75f;
        float f6 = f3 * 0.5f;
        float f7 = f3 * 1.5f;
        int n5 = Math.max(0, (int)((this.viewBounds.x - f4) / f5));
        int n6 = Math.min(n3, (int)((this.viewBounds.x + this.viewBounds.width + f5) / f5));
        int n7 = Math.max(0, (int)(this.viewBounds.y / f7));
        int n8 = Math.min(n4, (int)((this.viewBounds.y + this.viewBounds.height + f7) / f3));
        float[] fArray = this.vertices;
        int n9 = n7;
        while (n9 < n8) {
            int n10 = n9 < n2 ? n9 : n9 % n2;
            int n11 = n5;
            while (n11 < n6) {
                TiledMapTile tiledMapTile;
                float f8 = f5 * (float)n11;
                float f9 = (n11 % 2 == 1 ? 0.0f : f6) + f3 * (float)n9;
                int n12 = n11 < n ? n11 : n11 % n;
                TiledMapTileLayer.Cell cell = layer.getCell(n12, n10);
                if (cell != null && (tiledMapTile = cell.getTile()) != null && !(tiledMapTile instanceof AnimatedTiledMapTile)) {
                    float f10;
                    boolean bl = cell.getFlipHorizontally();
                    boolean bl2 = cell.getFlipVertically();
                    int n13 = cell.getRotation();
                    lgTextureRegion lgTextureRegion2 = tiledMapTile.getTextureRegion();
                    float f11 = f8 + tiledMapTile.getOffsetX() * this.unitScale;
                    float f12 = f9 + tiledMapTile.getOffsetY() * this.unitScale;
                    float f13 = f11 + (float)lgTextureRegion2.getRegionWidth() * this.unitScale;
                    float f14 = f12 + (float)lgTextureRegion2.getRegionHeight() * this.unitScale;
                    float f15 = lgTextureRegion2.getU();
                    float f16 = lgTextureRegion2.getV2();
                    float f17 = lgTextureRegion2.getU2();
                    float f18 = lgTextureRegion2.getV();
                    fArray[0] = f11;
                    fArray[1] = f12;
                    fArray[2] = f;
                    fArray[3] = f15;
                    fArray[4] = f16;
                    fArray[5] = f11;
                    fArray[6] = f14;
                    fArray[7] = f;
                    fArray[8] = f15;
                    fArray[9] = f18;
                    fArray[10] = f13;
                    fArray[11] = f14;
                    fArray[12] = f;
                    fArray[13] = f17;
                    fArray[14] = f18;
                    fArray[15] = f13;
                    fArray[16] = f12;
                    fArray[17] = f;
                    fArray[18] = f17;
                    fArray[19] = f16;
                    if (bl) {
                        f10 = fArray[3];
                        fArray[3] = fArray[13];
                        fArray[13] = f10;
                        f10 = fArray[8];
                        fArray[8] = fArray[18];
                        fArray[18] = f10;
                    }
                    if (bl2) {
                        f10 = fArray[4];
                        fArray[4] = fArray[14];
                        fArray[14] = f10;
                        f10 = fArray[9];
                        fArray[9] = fArray[19];
                        fArray[19] = f10;
                    }
                    if (n13 == 2) {
                        f10 = fArray[3];
                        fArray[3] = fArray[13];
                        fArray[13] = f10;
                        f10 = fArray[8];
                        fArray[8] = fArray[18];
                        fArray[18] = f10;
                        float f19 = fArray[4];
                        fArray[4] = fArray[14];
                        fArray[14] = f19;
                        f19 = fArray[9];
                        fArray[9] = fArray[19];
                        fArray[19] = f19;
                        break;
                    }
                    this.batch.draw(lgTextureRegion2.getInternalObject().getTexture(), fArray, 0, 20);
                }
                ++n11;
            }
            ++n9;
        }
    }
}

