/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;

@BA.Hide
public class IsometricStaggeredTiledMapRenderer
extends BatchTiledMapRenderer {
    public IsometricStaggeredTiledMapRenderer() {
    }

    public IsometricStaggeredTiledMapRenderer(TiledMap map) {
        super(map);
    }

    public IsometricStaggeredTiledMapRenderer(TiledMap map, Batch batch) {
        super(map, batch);
    }

    public IsometricStaggeredTiledMapRenderer(TiledMap map, float unitScale) {
        super(map, unitScale);
    }

    public IsometricStaggeredTiledMapRenderer(TiledMap map, float unitScale, Batch batch) {
        super(map, unitScale, batch);
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer layer) {
        Color color = this.batch.getColor();
        float f = Color.toFloatBits(color.r, color.g, color.b, color.a * layer.getOpacity());
        int n = layer.getWidth();
        int n2 = layer.getHeight();
        int n3 = n * (layer.getRepeatX() + 1);
        int n4 = n2 * (layer.getRepeatY() + 1);
        float f2 = layer.getTileWidth() * this.unitScale;
        float f3 = layer.getTileHeight() * this.unitScale;
        float f4 = f2 * 0.5f;
        float f5 = f3 * 0.5f;
        int n5 = Math.max(0, (int)((this.viewBounds.x - f4) / f2));
        int n6 = Math.min(n3, (int)((this.viewBounds.x + this.viewBounds.width + f2 + f4) / f2));
        int n7 = Math.max(0, (int)((this.viewBounds.y - f3) / f3));
        int n8 = Math.min(n4, (int)((this.viewBounds.y + this.viewBounds.height + f3) / f5)) - 1;
        while (n8 >= n7) {
            int n9 = n8 < n2 ? n8 : n8 % n2;
            float f6 = n8 % 2 == 1 ? f4 : 0.0f;
            int n10 = n6 - 1;
            while (n10 >= n5) {
                TiledMapTile tiledMapTile;
                int n11 = n10 < n ? n10 : n10 % n;
                TiledMapTileLayer.Cell cell = layer.getCell(n11, n9);
                if (cell != null && (tiledMapTile = cell.getTile()) != null) {
                    float f7;
                    boolean bl = cell.getFlipHorizontally();
                    boolean bl2 = cell.getFlipVertically();
                    int n12 = cell.getRotation();
                    lgTextureRegion lgTextureRegion2 = tiledMapTile.getTextureRegion();
                    float f8 = (float)n10 * f2 - f6;
                    float f9 = (float)n8 * f5;
                    float f10 = f8 + (float)lgTextureRegion2.getRegionWidth() * this.unitScale;
                    float f11 = f9 + (float)lgTextureRegion2.getRegionHeight() * this.unitScale;
                    float f12 = lgTextureRegion2.getU();
                    float f13 = lgTextureRegion2.getV2();
                    float f14 = lgTextureRegion2.getU2();
                    float f15 = lgTextureRegion2.getV();
                    this.vertices[0] = f8;
                    this.vertices[1] = f9;
                    this.vertices[2] = f;
                    this.vertices[3] = f12;
                    this.vertices[4] = f13;
                    this.vertices[5] = f8;
                    this.vertices[6] = f11;
                    this.vertices[7] = f;
                    this.vertices[8] = f12;
                    this.vertices[9] = f15;
                    this.vertices[10] = f10;
                    this.vertices[11] = f11;
                    this.vertices[12] = f;
                    this.vertices[13] = f14;
                    this.vertices[14] = f15;
                    this.vertices[15] = f10;
                    this.vertices[16] = f9;
                    this.vertices[17] = f;
                    this.vertices[18] = f14;
                    this.vertices[19] = f13;
                    if (bl) {
                        f7 = this.vertices[3];
                        this.vertices[3] = this.vertices[13];
                        this.vertices[13] = f7;
                        f7 = this.vertices[8];
                        this.vertices[8] = this.vertices[18];
                        this.vertices[18] = f7;
                    }
                    if (bl2) {
                        f7 = this.vertices[4];
                        this.vertices[4] = this.vertices[14];
                        this.vertices[14] = f7;
                        f7 = this.vertices[9];
                        this.vertices[9] = this.vertices[19];
                        this.vertices[19] = f7;
                    }
                    if (n12 != 0) {
                        switch (n12) {
                            case 1: {
                                f7 = this.vertices[4];
                                this.vertices[4] = this.vertices[9];
                                this.vertices[9] = this.vertices[14];
                                this.vertices[14] = this.vertices[19];
                                this.vertices[19] = f7;
                                float f16 = this.vertices[3];
                                this.vertices[3] = this.vertices[8];
                                this.vertices[8] = this.vertices[13];
                                this.vertices[13] = this.vertices[18];
                                this.vertices[18] = f16;
                                break;
                            }
                            case 2: {
                                f7 = this.vertices[3];
                                this.vertices[3] = this.vertices[13];
                                this.vertices[13] = f7;
                                f7 = this.vertices[8];
                                this.vertices[8] = this.vertices[18];
                                this.vertices[18] = f7;
                                float f16 = this.vertices[4];
                                this.vertices[4] = this.vertices[14];
                                this.vertices[14] = f16;
                                f16 = this.vertices[9];
                                this.vertices[9] = this.vertices[19];
                                this.vertices[19] = f16;
                                break;
                            }
                            case 3: {
                                f7 = this.vertices[4];
                                this.vertices[4] = this.vertices[19];
                                this.vertices[19] = this.vertices[14];
                                this.vertices[14] = this.vertices[9];
                                this.vertices[9] = f7;
                                float f16 = this.vertices[3];
                                this.vertices[3] = this.vertices[18];
                                this.vertices[18] = this.vertices[13];
                                this.vertices[13] = this.vertices[8];
                                this.vertices[8] = f16;
                            }
                        }
                    }
                    this.batch.draw(lgTextureRegion2.getInternalObject().getTexture(), this.vertices, 0, 20);
                }
                --n10;
            }
            --n8;
        }
    }
}

