/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgTextureRegion;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;

@BA.Hide
public class IsometricTiledMapRenderer
extends BatchTiledMapRenderer {
    public IsometricTiledMapRenderer() {
    }

    public IsometricTiledMapRenderer(TiledMap map) {
        super(map);
    }

    public IsometricTiledMapRenderer(TiledMap map, Batch batch) {
        super(map, batch);
    }

    public IsometricTiledMapRenderer(TiledMap map, float unitScale) {
        super(map, unitScale);
    }

    public IsometricTiledMapRenderer(TiledMap map, float unitScale, Batch batch) {
        super(map, unitScale, batch);
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer layer) {
        Color color = this.batch.getColor();
        float f = Color.toFloatBits(color.r, color.g, color.b, color.a * layer.getOpacity());
        int n = layer.getWidth();
        int n2 = layer.getHeight();
        int n3 = n * (layer.getRepeatX() + 1) - 1;
        int n4 = n2 * (layer.getRepeatY() + 1) - 1;
        float f2 = layer.getTileWidth() * this.unitScale;
        float f3 = layer.getTileHeight() * this.unitScale;
        float f4 = f2 * 0.5f;
        float f5 = f3 * 0.5f;
        int n5 = n4;
        while (n5 >= 0) {
            int n6 = n5 < n2 ? n5 : n5 % n2;
            int n7 = 0;
            while (n7 <= n3) {
                TiledMapTile tiledMapTile;
                float f6 = (float)n7 * f4 + (float)n5 * f4;
                float f7 = (float)n5 * f5 - (float)n7 * f5;
                int n8 = n7 < n ? n7 : n7 % n;
                TiledMapTileLayer.Cell cell = layer.getCell(n8, n6);
                if (cell != null && (tiledMapTile = cell.getTile()) != null) {
                    float f8;
                    boolean bl = cell.getFlipHorizontally();
                    boolean bl2 = cell.getFlipVertically();
                    int n9 = cell.getRotation();
                    lgTextureRegion lgTextureRegion2 = tiledMapTile.getTextureRegion();
                    float f9 = f6;
                    float f10 = f7;
                    float f11 = f9 + (float)lgTextureRegion2.getRegionWidth() * this.unitScale;
                    float f12 = f10 + (float)lgTextureRegion2.getRegionHeight() * this.unitScale;
                    float f13 = lgTextureRegion2.getU();
                    float f14 = lgTextureRegion2.getV2();
                    float f15 = lgTextureRegion2.getU2();
                    float f16 = lgTextureRegion2.getV();
                    this.vertices[0] = f9;
                    this.vertices[1] = f10;
                    this.vertices[2] = f;
                    this.vertices[3] = f13;
                    this.vertices[4] = f14;
                    this.vertices[5] = f9;
                    this.vertices[6] = f12;
                    this.vertices[7] = f;
                    this.vertices[8] = f13;
                    this.vertices[9] = f16;
                    this.vertices[10] = f11;
                    this.vertices[11] = f12;
                    this.vertices[12] = f;
                    this.vertices[13] = f15;
                    this.vertices[14] = f16;
                    this.vertices[15] = f11;
                    this.vertices[16] = f10;
                    this.vertices[17] = f;
                    this.vertices[18] = f15;
                    this.vertices[19] = f14;
                    if (bl) {
                        f8 = this.vertices[3];
                        this.vertices[3] = this.vertices[13];
                        this.vertices[13] = f8;
                        f8 = this.vertices[8];
                        this.vertices[8] = this.vertices[18];
                        this.vertices[18] = f8;
                    }
                    if (bl2) {
                        f8 = this.vertices[4];
                        this.vertices[4] = this.vertices[14];
                        this.vertices[14] = f8;
                        f8 = this.vertices[9];
                        this.vertices[9] = this.vertices[19];
                        this.vertices[19] = f8;
                    }
                    if (n9 != 0) {
                        switch (n9) {
                            case 1: {
                                f8 = this.vertices[4];
                                this.vertices[4] = this.vertices[9];
                                this.vertices[9] = this.vertices[14];
                                this.vertices[14] = this.vertices[19];
                                this.vertices[19] = f8;
                                float f17 = this.vertices[3];
                                this.vertices[3] = this.vertices[8];
                                this.vertices[8] = this.vertices[13];
                                this.vertices[13] = this.vertices[18];
                                this.vertices[18] = f17;
                                break;
                            }
                            case 2: {
                                f8 = this.vertices[3];
                                this.vertices[3] = this.vertices[13];
                                this.vertices[13] = f8;
                                f8 = this.vertices[8];
                                this.vertices[8] = this.vertices[18];
                                this.vertices[18] = f8;
                                float f17 = this.vertices[4];
                                this.vertices[4] = this.vertices[14];
                                this.vertices[14] = f17;
                                f17 = this.vertices[9];
                                this.vertices[9] = this.vertices[19];
                                this.vertices[19] = f17;
                                break;
                            }
                            case 3: {
                                f8 = this.vertices[4];
                                this.vertices[4] = this.vertices[19];
                                this.vertices[19] = this.vertices[14];
                                this.vertices[14] = this.vertices[9];
                                this.vertices[9] = f8;
                                float f17 = this.vertices[3];
                                this.vertices[3] = this.vertices[18];
                                this.vertices[18] = this.vertices[13];
                                this.vertices[13] = this.vertices[8];
                                this.vertices[8] = f17;
                            }
                        }
                    }
                    this.batch.draw(lgTextureRegion2.getInternalObject().getTexture(), this.vertices, 0, 20);
                }
                ++n7;
            }
            --n5;
        }
    }
}

